/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.sg.prism.NGExternalNode$$Lambda$1;
import com.sun.javafx.sg.prism.NGExternalNode$$Lambda$2;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.prism.Graphics;
import com.sun.prism.PixelFormat;
import com.sun.prism.ResourceFactory;
import com.sun.prism.Texture;
import java.nio.Buffer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;

public class NGExternalNode
extends NGNode {
    private Texture dsttexture;
    private BufferData bufferData;
    private final AtomicReference<RenderData> renderData = new AtomicReference<Object>(null);
    private RenderData rd;
    private volatile ReentrantLock bufferLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderContent(Graphics g) {
        RenderData curRenderData = this.renderData.getAndSet(null);
        if (curRenderData != null) {
            this.rd = curRenderData;
        }
        if (this.rd == null) {
            return;
        }
        int x = this.rd.bdata.srcbounds.x;
        int y = this.rd.bdata.srcbounds.y;
        int w = this.rd.bdata.srcbounds.width;
        int h = this.rd.bdata.srcbounds.height;
        if (this.dsttexture != null) {
            this.dsttexture.lock();
            if (this.dsttexture.isSurfaceLost() || this.dsttexture.getContentWidth() != w || this.dsttexture.getContentHeight() != h) {
                this.dsttexture.unlock();
                this.dsttexture.dispose();
                this.rd = this.rd.copyAddDirtyRect(0, 0, w, h);
                this.dsttexture = this.createTexture(g, this.rd);
            }
        } else {
            this.dsttexture = this.createTexture(g, this.rd);
        }
        if (this.dsttexture == null) {
            return;
        }
        try {
            if (curRenderData != null) {
                this.bufferLock.lock();
                try {
                    this.dsttexture.update(this.rd.bdata.srcbuffer, PixelFormat.INT_ARGB_PRE, this.rd.dirtyRect.x, this.rd.dirtyRect.y, x + this.rd.dirtyRect.x, y + this.rd.dirtyRect.y, this.rd.dirtyRect.width, this.rd.dirtyRect.height, this.rd.bdata.linestride * 4, false);
                }
                finally {
                    this.bufferLock.unlock();
                }
                if (this.rd.clearTarget) {
                    g.clearQuad(0.0f, 0.0f, this.rd.bdata.usrwidth, this.rd.bdata.usrheight);
                }
            }
            g.drawTexture(this.dsttexture, 0.0f, 0.0f, this.rd.bdata.usrwidth, this.rd.bdata.usrheight, 0.0f, 0.0f, w, h);
        }
        finally {
            this.dsttexture.unlock();
        }
    }

    private Texture createTexture(Graphics g, RenderData rd) {
        ResourceFactory factory = g.getResourceFactory();
        if (!factory.isDeviceReady()) {
            return null;
        }
        Texture txt = factory.createTexture(PixelFormat.INT_ARGB_PRE, Texture.Usage.DYNAMIC, Texture.WrapMode.CLAMP_NOT_NEEDED, rd.bdata.srcbounds.width, rd.bdata.srcbounds.height);
        if (txt != null) {
            txt.contentsUseful();
        } else {
            System.err.println("NGExternalNode: failed to create a texture");
        }
        return txt;
    }

    public void setLock(ReentrantLock lock) {
        this.bufferLock = lock;
    }

    public void setImageBuffer(Buffer buffer, int x, int y, int width, int height, int linestride, int scale) {
        this.bufferData = new BufferData(buffer, linestride, x, y, width, height, scale);
        this.renderData.set(new RenderData(this.bufferData, x, y, width, height, true));
    }

    public void setImageBounds(int x, int y, int width, int height) {
        boolean shrinked = width < this.bufferData.usrwidth || height < this.bufferData.usrheight;
        this.bufferData = this.bufferData.copyWithBounds(x, y, width, height);
        this.renderData.updateAndGet(NGExternalNode$$Lambda$1.lambdaFactory$(this, x, y, width, height, shrinked));
    }

    public void repaintDirtyRegion(int dirtyX, int dirtyY, int dirtyWidth, int dirtyHeight) {
        this.renderData.updateAndGet(NGExternalNode$$Lambda$2.lambdaFactory$(this, dirtyX, dirtyY, dirtyWidth, dirtyHeight));
    }

    public void markContentDirty() {
        this.visualsChanged();
    }

    @Override
    protected boolean hasOverlappingContents() {
        return false;
    }

    /* synthetic */ RenderData lambda$repaintDirtyRegion$266(int n, int n2, int n3, int n4, RenderData prev) {
        if (prev != null) {
            return prev.copyAddDirtyRect(n, n2, n3, n4);
        }
        return new RenderData(this.bufferData, n, n2, n3, n4, false);
    }

    /* synthetic */ RenderData lambda$setImageBounds$265(int n, int n2, int n3, int n4, boolean bl, RenderData prev) {
        boolean clearTarget = prev != null ? prev.clearTarget : false;
        return new RenderData(this.bufferData, n, n2, n3, n4, clearTarget | bl);
    }

    private static class RenderData {
        final BufferData bdata;
        final Rectangle dirtyRect;
        final boolean clearTarget;

        RenderData(BufferData bdata, int dirtyX, int dirtyY, int dirtyWidth, int dirtyHeight, boolean clearTarget) {
            this(bdata, dirtyX, dirtyY, dirtyWidth, dirtyHeight, clearTarget, true);
        }

        RenderData(BufferData bdata, int dirtyX, int dirtyY, int dirtyWidth, int dirtyHeight, boolean clearTarget, boolean applyScale) {
            this.bdata = bdata;
            Rectangle r = new Rectangle(dirtyX, dirtyY, dirtyWidth, dirtyHeight);
            this.dirtyRect = applyScale ? bdata.scale(r) : r;
            this.dirtyRect.intersectWith(bdata.srcbounds);
            this.clearTarget = clearTarget;
        }

        RenderData copyAddDirtyRect(int dirtyX, int dirtyY, int dirtyWidth, int dirtyHeight) {
            Rectangle r = this.bdata.scale(new Rectangle(dirtyX, dirtyY, dirtyWidth, dirtyHeight));
            r.add(this.dirtyRect);
            return new RenderData(this.bdata, r.x, r.y, r.width, r.height, this.clearTarget, false);
        }
    }

    private static class BufferData {
        final Buffer srcbuffer;
        final int linestride;
        final Rectangle srcbounds;
        final int usrwidth;
        final int usrheight;
        final int scale;

        BufferData(Buffer srcbuffer, int linestride, int x, int y, int width, int height, int scale) {
            this.srcbuffer = srcbuffer;
            this.scale = scale;
            this.linestride = linestride;
            this.srcbounds = this.scale(new Rectangle(x, y, width, height));
            this.usrwidth = width;
            this.usrheight = height;
        }

        Rectangle scale(Rectangle r) {
            r.x *= this.scale;
            r.y *= this.scale;
            r.width *= this.scale;
            r.height *= this.scale;
            return r;
        }

        BufferData copyWithBounds(int x, int y, int width, int height) {
            return new BufferData(this.srcbuffer, this.linestride, x, y, width, height, this.scale);
        }
    }
}

