/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webkit;

import com.oracle.dalvik.InternalWebView;
import com.sun.webkit.Invoker;
import com.sun.webkit.WebPage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NativeWebView {
    private static List<NativeWebView> views = new ArrayList<NativeWebView>();
    private int id = this._createAndroidWebView();
    private WebPage page;
    static Map<Integer, InternalWebView> webViews = new HashMap<Integer, InternalWebView>();

    public NativeWebView(WebPage page) {
        this.page = page;
        views.add(this);
    }

    public void moveToTop() {
        this._moveToTop(this.id);
    }

    public void moveAndResize(int x, int y, int width, int height) {
        this._moveAndResize(this.id, x, y, width, height);
    }

    public void setVisible(boolean visible) {
        this._setVisible(this.id, visible);
    }

    void loadUrl(String url) {
        this._loadUrl(this.id, url);
    }

    void loadContent(String content, String contentType) {
        this._loadContent(this.id, content, contentType);
    }

    void setEncoding(String encoding) {
        this._setEncoding(this.id, encoding);
    }

    void dispose() {
        this._dispose(this.id);
        views.remove(this);
    }

    String getHtmlContent() {
        return InternalWebView.getHtmlContent((int)this.id);
    }

    private static NativeWebView getViewByID(int id) {
        for (NativeWebView wvp : views) {
            if (id != wvp.id) continue;
            return wvp;
        }
        System.err.println("Accesing nonexisting/disposed NativewWebView id: " + id);
        return null;
    }

    public static void fire_load_event(int id, final int frameID, final int state, final String url, final String contenType, final int progress, final int errorCode) {
        final NativeWebView nwv = NativeWebView.getViewByID(id);
        if (nwv == null) {
            return;
        }
        Invoker.getInvoker().invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                double dprogress = (double)progress / 100.0;
                nwv.page.fireLoadEvent(frameID, state, url, contenType, dprogress, errorCode);
            }
        });
    }

    private void _moveAndResize(int id, int x, int y, int width, int height) {
        InternalWebView.moveAndResize((int)id, (int)x, (int)y, (int)width, (int)height);
    }

    private void _setVisible(int id, boolean visible) {
        InternalWebView.setVisible((int)id, (boolean)visible);
    }

    private int _createAndroidWebView() {
        InternalWebView internalWebView = new InternalWebView();
        int id = internalWebView.getInternalID();
        webViews.put(id, internalWebView);
        return id;
    }

    private void _moveToTop(int id) {
    }

    private void _loadUrl(int id, String url) {
        InternalWebView.loadUrl((int)id, (String)url);
    }

    private void _dispose(int id) {
        InternalWebView.dispose((int)id);
    }

    private void _loadContent(int id, String content, String contentType) {
        InternalWebView.loadContent((int)id, (String)content, (String)contentType);
    }

    private native void _setEncoding(int var1, String var2);
}

