/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.FloatExpression;
import javafx.beans.property.ReadOnlyFloatProperty$1$$Lambda$1;
import javafx.beans.property.ReadOnlyFloatProperty$2$$Lambda$1;
import javafx.beans.property.ReadOnlyFloatPropertyBase;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.property.ReadOnlyProperty;

public abstract class ReadOnlyFloatProperty
extends FloatExpression
implements ReadOnlyProperty<Number> {
    public String toString() {
        Object bean = this.getBean();
        String name = this.getName();
        StringBuilder result = new StringBuilder("ReadOnlyFloatProperty [");
        if (bean != null) {
            result.append("bean: ").append(bean).append(", ");
        }
        if (name != null && !name.equals("")) {
            result.append("name: ").append(name).append(", ");
        }
        result.append("value: ").append(this.get()).append("]");
        return result.toString();
    }

    public static <T extends Number> ReadOnlyFloatProperty readOnlyFloatProperty(final ReadOnlyProperty<T> property) {
        if (property == null) {
            throw new NullPointerException("Property cannot be null");
        }
        return property instanceof ReadOnlyFloatProperty ? (ReadOnlyFloatProperty)property : new ReadOnlyFloatPropertyBase(){
            private boolean valid = true;
            private final InvalidationListener listener = ReadOnlyFloatProperty$1$$Lambda$1.lambdaFactory$(this);
            {
                property.addListener(new WeakInvalidationListener(this.listener));
            }

            @Override
            public float get() {
                this.valid = true;
                Number value = (Number)property.getValue();
                return value == null ? 0.0f : value.floatValue();
            }

            @Override
            public Object getBean() {
                return null;
            }

            @Override
            public String getName() {
                return property.getName();
            }

            /* synthetic */ void lambda$$11(Observable observable) {
                if (this.valid) {
                    this.valid = false;
                    this.fireValueChangedEvent();
                }
            }
        };
    }

    public ReadOnlyObjectProperty<Float> asObject() {
        return new ReadOnlyObjectPropertyBase<Float>(){
            private boolean valid = true;
            private final InvalidationListener listener = ReadOnlyFloatProperty$2$$Lambda$1.lambdaFactory$(this);
            {
                ReadOnlyFloatProperty.this.addListener(new WeakInvalidationListener(this.listener));
            }

            @Override
            public Object getBean() {
                return null;
            }

            @Override
            public String getName() {
                return ReadOnlyFloatProperty.this.getName();
            }

            @Override
            public Float get() {
                this.valid = true;
                return ReadOnlyFloatProperty.this.getValue();
            }

            /* synthetic */ void lambda$$12(Observable observable) {
                if (this.valid) {
                    this.valid = false;
                    this.fireValueChangedEvent();
                }
            }
        };
    }
}

