/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections.transformation;

import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.collections.SortHelper;
import com.sun.javafx.collections.SourceAdapterChange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;

public final class SortedList<E>
extends TransformationList<E, E> {
    private Comparator<Element<E>> elementComparator;
    private Element<E>[] sorted;
    private int size;
    private final SortHelper helper = new SortHelper();
    private final Element<E> tempElement = new Element<Object>(null, -1);
    private ObjectProperty<Comparator<? super E>> comparator;

    public SortedList(@NamedArg(value="source") ObservableList<? extends E> source, @NamedArg(value="comparator") Comparator<? super E> comparator) {
        super(source);
        this.sorted = new Element[source.size() * 3 / 2 + 1];
        this.size = source.size();
        for (int i = 0; i < this.size; ++i) {
            this.sorted[i] = new Element(source.get(i), i);
        }
        if (comparator != null) {
            this.setComparator(comparator);
        }
    }

    public SortedList(@NamedArg(value="source") ObservableList<? extends E> source) {
        this(source, null);
    }

    @Override
    protected void sourceChanged(ListChangeListener.Change<? extends E> c) {
        if (this.elementComparator != null) {
            this.beginChange();
            while (c.next()) {
                if (c.wasPermutated()) {
                    this.updatePermutationIndexes(c);
                    continue;
                }
                if (c.wasUpdated()) {
                    this.update(c);
                    continue;
                }
                this.addRemove(c);
            }
            this.endChange();
        } else {
            this.updateUnsorted(c);
            this.fireChange(new SourceAdapterChange<E>(this, c));
        }
    }

    public final ObjectProperty<Comparator<? super E>> comparatorProperty() {
        if (this.comparator == null) {
            this.comparator = new ObjectPropertyBase<Comparator<? super E>>(){

                @Override
                protected void invalidated() {
                    Comparator current = (Comparator)this.get();
                    SortedList.this.elementComparator = current != null ? new ElementComparator(current) : null;
                    SortedList.this.doSortWithPermutationChange();
                }

                @Override
                public Object getBean() {
                    return SortedList.this;
                }

                @Override
                public String getName() {
                    return "comparator";
                }
            };
        }
        return this.comparator;
    }

    public final Comparator<? super E> getComparator() {
        return this.comparator == null ? null : (Comparator)this.comparator.get();
    }

    public final void setComparator(Comparator<? super E> comparator) {
        this.comparatorProperty().set(comparator);
    }

    @Override
    public E get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return (E)((Element)this.sorted[index]).e;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void doSortWithPermutationChange() {
        if (this.elementComparator != null) {
            int[] perm = this.helper.sort(this.sorted, 0, this.size, this.elementComparator);
            this.fireChange(new NonIterableChange.SimplePermutationChange(0, this.size, perm, this));
        } else {
            int[] perm = new int[this.size];
            int[] rperm = new int[this.size];
            for (int i = 0; i < this.size; ++i) {
                perm[i] = rperm[i] = i;
            }
            boolean changed = false;
            int idx = 0;
            while (idx < this.size) {
                int otherIdx = ((Element)this.sorted[idx]).index;
                if (otherIdx == idx) {
                    ++idx;
                    continue;
                }
                Element<E> other = this.sorted[otherIdx];
                this.sorted[otherIdx] = this.sorted[idx];
                this.sorted[idx] = other;
                perm[rperm[idx]] = otherIdx;
                perm[rperm[otherIdx]] = idx;
                int tp = rperm[idx];
                rperm[idx] = rperm[otherIdx];
                rperm[otherIdx] = tp;
                changed = true;
            }
            if (changed) {
                this.fireChange(new NonIterableChange.SimplePermutationChange(0, this.size, perm, this));
            }
        }
    }

    @Override
    public int getSourceIndex(int index) {
        return ((Element)this.sorted[index]).index;
    }

    private void updatePermutationIndexes(ListChangeListener.Change<? extends E> change) {
        for (int i = 0; i < this.size; ++i) {
            ((Element)this.sorted[i]).index = change.getPermutation(((Element)this.sorted[i]).index);
        }
    }

    private void updateUnsorted(ListChangeListener.Change<? extends E> c) {
        while (c.next()) {
            if (c.wasPermutated()) {
                Element[] sortedTmp = new Element[this.sorted.length];
                for (int i = 0; i < this.size; ++i) {
                    if (i >= c.getFrom() && i < c.getTo()) {
                        sortedTmp[c.getPermutation((int)i)] = this.sorted[i];
                        continue;
                    }
                    sortedTmp[i] = this.sorted[i];
                }
                this.sorted = sortedTmp;
            }
            if (c.wasRemoved()) {
                int removedTo = c.getFrom() + c.getRemovedSize();
                System.arraycopy(this.sorted, removedTo, this.sorted, c.getFrom(), this.size - removedTo);
                this.size -= c.getRemovedSize();
                this.updateIndices(removedTo, -c.getRemovedSize());
            }
            if (!c.wasAdded()) continue;
            this.ensureSize(this.size + c.getAddedSize());
            this.updateIndices(c.getFrom(), c.getAddedSize());
            System.arraycopy(this.sorted, c.getFrom(), this.sorted, c.getTo(), this.size - c.getFrom());
            this.size += c.getAddedSize();
            for (int i = c.getFrom(); i < c.getTo(); ++i) {
                this.sorted[i] = new Element(c.getList().get(i), i);
            }
        }
    }

    private void ensureSize(int size) {
        if (this.sorted.length < size) {
            Element[] replacement = new Element[size * 3 / 2 + 1];
            System.arraycopy(this.sorted, 0, replacement, 0, this.size);
            this.sorted = replacement;
        }
    }

    private void updateIndices(int from, int difference) {
        for (int i = 0; i < this.size; ++i) {
            if (((Element)this.sorted[i]).index < from) continue;
            Element<E> element = this.sorted[i];
            ((Element)element).index = ((Element)element).index + difference;
        }
    }

    private int findPosition(E e) {
        if (this.sorted.length == 0) {
            return 0;
        }
        ((Element)this.tempElement).e = e;
        int pos = Arrays.binarySearch(this.sorted, 0, this.size, this.tempElement, this.elementComparator);
        return pos;
    }

    private int compare(E e1, E e2) {
        Comparator<E> comp = this.getComparator();
        return comp == null ? ((Comparable)e1).compareTo(e2) : comp.compare(e1, e2);
    }

    private int findPosition(int idx, E e) {
        int pos = this.findPosition(e);
        if (((Element)this.sorted[pos]).index == idx) {
            return pos;
        }
        int tmp = pos;
        while (tmp != 0 && ((Element)this.sorted[--tmp]).index != idx && this.compare(((Element)this.sorted[tmp]).e, e) == 0) {
        }
        if (((Element)this.sorted[tmp]).index == idx) {
            return tmp;
        }
        tmp = pos;
        while (tmp != this.size - 1 && ((Element)this.sorted[++tmp]).index != idx && this.compare(((Element)this.sorted[tmp]).e, e) == 0) {
        }
        if (((Element)this.sorted[tmp]).index == idx) {
            return tmp;
        }
        return -1;
    }

    private void insertToMapping(E e, int idx) {
        int pos = this.findPosition(e);
        if (pos < 0) {
            pos ^= 0xFFFFFFFF;
        }
        this.ensureSize(this.size + 1);
        this.updateIndices(idx, 1);
        System.arraycopy(this.sorted, pos, this.sorted, pos + 1, this.size - pos);
        this.sorted[pos] = new Element<E>(e, idx);
        ++this.size;
        this.nextAdd(pos, pos + 1);
    }

    private void setAllToMapping(List<? extends E> list, int to) {
        this.ensureSize(to);
        this.size = to;
        for (int i = 0; i < to; ++i) {
            this.sorted[i] = new Element<E>(list.get(i), i);
        }
        Arrays.sort(this.sorted, 0, this.size, this.elementComparator);
        this.nextAdd(0, this.size);
    }

    private void removeFromMapping(int idx, E e) {
        int pos = this.findPosition(idx, e);
        System.arraycopy(this.sorted, pos + 1, this.sorted, pos, this.size - pos - 1);
        --this.size;
        this.sorted[this.size] = null;
        this.updateIndices(idx + 1, -1);
        this.nextRemove(pos, e);
    }

    private void removeAllFromMapping() {
        ArrayList removed = new ArrayList(this);
        for (int i = 0; i < this.size; ++i) {
            this.sorted[i] = null;
        }
        this.size = 0;
        this.nextRemove(0, removed);
    }

    private void update(ListChangeListener.Change<? extends E> c) {
        int[] perm = this.helper.sort(this.sorted, 0, this.size, this.elementComparator);
        this.nextPermutation(0, this.size, perm);
        int to = c.getTo();
        for (int i = c.getFrom(); i < to; ++i) {
            this.nextUpdate(this.findPosition(i, c.getList().get(i)));
        }
    }

    private void addRemove(ListChangeListener.Change<? extends E> c) {
        int i;
        if (c.getFrom() == 0 && c.getRemovedSize() == this.size) {
            this.removeAllFromMapping();
        } else {
            int sz = c.getRemovedSize();
            for (i = 0; i < sz; ++i) {
                this.removeFromMapping(c.getFrom(), c.getRemoved().get(i));
            }
        }
        if (this.size == 0) {
            this.setAllToMapping(c.getList(), c.getTo());
        } else {
            int to = c.getTo();
            for (i = c.getFrom(); i < to; ++i) {
                this.insertToMapping(c.getList().get(i), i);
            }
        }
    }

    private static class ElementComparator<E>
    implements Comparator<Element<E>> {
        private final Comparator<? super E> comparator;

        public ElementComparator(Comparator<? super E> comparator) {
            this.comparator = comparator;
        }

        @Override
        public int compare(Element<E> o1, Element<E> o2) {
            return this.comparator.compare(((Element)o1).e, ((Element)o2).e);
        }
    }

    private static class Element<E> {
        private E e;
        private int index;

        public Element(E e, int index) {
            this.e = e;
            this.index = index;
        }
    }
}

