/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.collections.MappingChange;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.scene.control.ReadOnlyUnbackedObservableList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import javafx.beans.Observable;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.ControlUtils;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.MultipleSelectionModelBase$$Lambda$1;
import javafx.scene.control.MultipleSelectionModelBase$$Lambda$2;
import javafx.scene.control.SelectionMode;
import javafx.util.Callback;

abstract class MultipleSelectionModelBase<T>
extends MultipleSelectionModel<T> {
    final BitSet selectedIndices;
    final ReadOnlyUnbackedObservableList<Integer> selectedIndicesSeq;
    private final ReadOnlyUnbackedObservableList<T> selectedItemsSeq;
    ListChangeListener.Change selectedItemChange;
    private int atomicityCount = 0;

    public MultipleSelectionModelBase() {
        this.selectedIndexProperty().addListener(MultipleSelectionModelBase$$Lambda$1.lambdaFactory$(this));
        this.selectedIndices = new BitSet();
        this.selectedIndicesSeq = this.createListFromBitSet(this.selectedIndices);
        final MappingChange.Map map = MultipleSelectionModelBase$$Lambda$2.lambdaFactory$(this);
        this.selectedIndicesSeq.addListener(new ListChangeListener<Integer>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Integer> c) {
                boolean hasRealChangeOccurred = false;
                while (c.next() && !hasRealChangeOccurred) {
                    hasRealChangeOccurred = c.wasAdded() || c.wasRemoved();
                }
                if (hasRealChangeOccurred) {
                    if (MultipleSelectionModelBase.this.selectedItemChange != null) {
                        MultipleSelectionModelBase.this.selectedItemsSeq.callObservers(MultipleSelectionModelBase.this.selectedItemChange);
                    } else {
                        c.reset();
                        MultipleSelectionModelBase.this.selectedItemsSeq.callObservers(new MappingChange(c, map, MultipleSelectionModelBase.this.selectedItemsSeq));
                    }
                }
                c.reset();
            }
        });
        this.selectedItemsSeq = new ReadOnlyUnbackedObservableList<T>(){

            @Override
            public T get(int i) {
                int pos = MultipleSelectionModelBase.this.selectedIndicesSeq.get(i);
                return MultipleSelectionModelBase.this.getModelItem(pos);
            }

            @Override
            public int size() {
                return MultipleSelectionModelBase.this.selectedIndices.cardinality();
            }
        };
    }

    @Override
    public ObservableList<Integer> getSelectedIndices() {
        return this.selectedIndicesSeq;
    }

    @Override
    public ObservableList<T> getSelectedItems() {
        return this.selectedItemsSeq;
    }

    boolean isAtomic() {
        return this.atomicityCount > 0;
    }

    void startAtomic() {
        ++this.atomicityCount;
    }

    void stopAtomic() {
        this.atomicityCount = Math.max(0, --this.atomicityCount);
    }

    protected abstract int getItemCount();

    protected abstract T getModelItem(int var1);

    protected abstract void focus(int var1);

    protected abstract int getFocusedIndex();

    void shiftSelection(int position, int shift, Callback<ShiftParams, Void> callback) {
        boolean selected;
        int i;
        if (position < 0) {
            return;
        }
        if (shift == 0) {
            return;
        }
        int selectedIndicesCardinality = this.selectedIndices.cardinality();
        if (selectedIndicesCardinality == 0) {
            return;
        }
        int selectedIndicesSize = this.selectedIndices.size();
        int[] perm = new int[selectedIndicesSize];
        int idx = 0;
        boolean hasPermutated = false;
        if (shift > 0) {
            for (i = selectedIndicesSize - 1; i >= position && i >= 0; --i) {
                selected = this.selectedIndices.get(i);
                if (callback == null) {
                    this.selectedIndices.clear(i);
                    this.selectedIndices.set(i + shift, selected);
                } else {
                    callback.call(new ShiftParams(i, i + shift, selected));
                }
                if (!selected) continue;
                perm[idx++] = i + 1;
                hasPermutated = true;
            }
            this.selectedIndices.clear(position);
        } else if (shift < 0) {
            for (i = position; i < selectedIndicesSize; ++i) {
                if (i + shift < 0 || i + 1 + shift < position) continue;
                selected = this.selectedIndices.get(i + 1);
                if (callback == null) {
                    this.selectedIndices.clear(i + 1);
                    this.selectedIndices.set(i + 1 + shift, selected);
                } else {
                    callback.call(new ShiftParams(i + 1, i + 1 + shift, selected));
                }
                if (!selected) continue;
                perm[idx++] = i;
                hasPermutated = true;
            }
        }
        int selectedIndex = this.getSelectedIndex();
        if (selectedIndex >= position && selectedIndex > -1) {
            int newSelectionLead = Math.max(0, selectedIndex + shift);
            this.setSelectedIndex(newSelectionLead);
            if (hasPermutated) {
                this.selectedIndices.set(newSelectionLead, true);
            } else {
                this.select(newSelectionLead);
            }
        }
        if (hasPermutated) {
            this.selectedIndicesSeq.callObservers(new NonIterableChange.SimplePermutationChange<Integer>(0, selectedIndicesCardinality, perm, this.selectedIndicesSeq));
        }
    }

    @Override
    public void clearAndSelect(int row) {
        ListChangeListener.Change<Integer> change;
        if (row < 0 || row >= this.getItemCount()) {
            this.clearSelection();
            return;
        }
        boolean wasSelected = this.isSelected(row);
        if (wasSelected && this.getSelectedIndices().size() == 1 && this.getSelectedItem() == this.getModelItem(row)) {
            return;
        }
        BitSet selectedIndicesCopy = new BitSet();
        selectedIndicesCopy.or(this.selectedIndices);
        selectedIndicesCopy.clear(row);
        ReadOnlyUnbackedObservableList<Integer> previousSelectedIndices = this.createListFromBitSet(selectedIndicesCopy);
        this.startAtomic();
        this.clearSelection();
        this.select(row);
        this.stopAtomic();
        if (wasSelected) {
            change = ControlUtils.buildClearAndSelectChange(this.selectedIndicesSeq, previousSelectedIndices, row);
        } else {
            int changeIndex = this.selectedIndicesSeq.indexOf(row);
            change = new NonIterableChange.GenericAddRemoveChange<Integer>(changeIndex, changeIndex + 1, previousSelectedIndices, this.selectedIndicesSeq);
        }
        this.selectedIndicesSeq.callObservers(change);
    }

    @Override
    public void select(int row) {
        if (row == -1) {
            this.clearSelection();
            return;
        }
        if (row < 0 || row >= this.getItemCount()) {
            return;
        }
        boolean isSameRow = row == this.getSelectedIndex();
        Object currentItem = this.getSelectedItem();
        T newItem = this.getModelItem(row);
        boolean isSameItem = newItem != null && newItem.equals(currentItem);
        boolean fireUpdatedItemEvent = isSameRow && !isSameItem;
        this.startAtomic();
        if (!this.selectedIndices.get(row)) {
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            this.selectedIndices.set(row);
        }
        this.setSelectedIndex(row);
        this.focus(row);
        this.stopAtomic();
        if (!this.isAtomic()) {
            int changeIndex = this.selectedIndicesSeq.indexOf(row);
            this.selectedIndicesSeq.callObservers(new NonIterableChange.SimpleAddChange<Integer>(changeIndex, changeIndex + 1, this.selectedIndicesSeq));
        }
        if (fireUpdatedItemEvent) {
            this.setSelectedItem(newItem);
        }
    }

    @Override
    public void select(T obj) {
        if (obj == null && this.getSelectionMode() == SelectionMode.SINGLE) {
            this.clearSelection();
            return;
        }
        Object rowObj = null;
        int max = this.getItemCount();
        for (int i = 0; i < max; ++i) {
            rowObj = this.getModelItem(i);
            if (rowObj == null || !rowObj.equals(obj)) continue;
            if (this.isSelected(i)) {
                return;
            }
            if (this.getSelectionMode() == SelectionMode.SINGLE) {
                this.quietClearSelection();
            }
            this.select(i);
            return;
        }
        this.setSelectedIndex(-1);
        this.setSelectedItem(obj);
    }

    @Override
    public void selectIndices(int row, int ... rows) {
        if (rows == null || rows.length == 0) {
            this.select(row);
            return;
        }
        int rowCount = this.getItemCount();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
            for (int i = rows.length - 1; i >= 0; --i) {
                int index = rows[i];
                if (index < 0 || index >= rowCount) continue;
                this.selectedIndices.set(index);
                this.select(index);
                break;
            }
            if (this.selectedIndices.isEmpty() && row > 0 && row < rowCount) {
                this.selectedIndices.set(row);
                this.select(row);
            }
            this.selectedIndicesSeq.callObservers(new NonIterableChange.SimpleAddChange<Integer>(0, 1, this.selectedIndicesSeq));
        } else {
            ArrayList<Integer> actualSelectedRows = new ArrayList<Integer>();
            int lastIndex = -1;
            if (row >= 0 && row < rowCount) {
                lastIndex = row;
                if (!this.selectedIndices.get(row)) {
                    this.selectedIndices.set(row);
                    actualSelectedRows.add(row);
                }
            }
            for (int i = 0; i < rows.length; ++i) {
                int index = rows[i];
                if (index < 0 || index >= rowCount) continue;
                lastIndex = index;
                if (this.selectedIndices.get(index)) continue;
                this.selectedIndices.set(index);
                actualSelectedRows.add(index);
            }
            if (lastIndex != -1) {
                this.setSelectedIndex(lastIndex);
                this.focus(lastIndex);
                this.setSelectedItem(this.getModelItem(lastIndex));
            }
            Collections.sort(actualSelectedRows);
            ListChangeListener.Change<Integer> change = MultipleSelectionModelBase.createRangeChange(this.selectedIndicesSeq, actualSelectedRows, false);
            this.selectedIndicesSeq.callObservers(change);
        }
    }

    static ListChangeListener.Change<Integer> createRangeChange(final ObservableList<Integer> list, final List<Integer> addedItems, final boolean splitChanges) {
        ListChangeListener.Change<Integer> change = new ListChangeListener.Change<Integer>(list){
            private final int[] EMPTY_PERM;
            private final int addedSize;
            private boolean invalid;
            private int pos;
            private int from;
            private int to;
            {
                super(x0);
                this.EMPTY_PERM = new int[0];
                this.addedSize = addedItems.size();
                this.invalid = true;
                this.from = this.pos = 0;
                this.to = this.pos;
            }

            @Override
            public int getFrom() {
                this.checkState();
                return this.from;
            }

            @Override
            public int getTo() {
                this.checkState();
                return this.to;
            }

            @Override
            public List<Integer> getRemoved() {
                this.checkState();
                return Collections.emptyList();
            }

            @Override
            protected int[] getPermutation() {
                this.checkState();
                return this.EMPTY_PERM;
            }

            @Override
            public int getAddedSize() {
                return this.to - this.from;
            }

            @Override
            public boolean next() {
                if (this.pos >= this.addedSize) {
                    return false;
                }
                int startValue = (Integer)addedItems.get(this.pos++);
                this.from = list.indexOf(startValue);
                this.to = this.from + 1;
                int endValue = startValue;
                while (this.pos < this.addedSize) {
                    int previousEndValue = endValue;
                    endValue = (Integer)addedItems.get(this.pos++);
                    ++this.to;
                    if (!splitChanges || previousEndValue == endValue - 1) continue;
                    break;
                }
                if (this.invalid) {
                    this.invalid = false;
                    return true;
                }
                return splitChanges && this.pos < this.addedSize;
            }

            @Override
            public void reset() {
                this.invalid = true;
                this.pos = 0;
                this.to = 0;
                this.from = 0;
            }

            private void checkState() {
                if (this.invalid) {
                    throw new IllegalStateException("Invalid Change state: next() must be called before inspecting the Change.");
                }
            }
        };
        return change;
    }

    @Override
    public void selectAll() {
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            return;
        }
        if (this.getItemCount() <= 0) {
            return;
        }
        int rowCount = this.getItemCount();
        int focusedIndex = this.getFocusedIndex();
        this.clearSelection();
        this.selectedIndices.set(0, rowCount, true);
        this.selectedIndicesSeq.callObservers(new NonIterableChange.SimpleAddChange<Integer>(0, rowCount, this.selectedIndicesSeq));
        if (focusedIndex == -1) {
            this.setSelectedIndex(rowCount - 1);
            this.focus(rowCount - 1);
        } else {
            this.setSelectedIndex(focusedIndex);
            this.focus(focusedIndex);
        }
    }

    @Override
    public void selectFirst() {
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (this.getItemCount() > 0) {
            this.select(0);
        }
    }

    @Override
    public void selectLast() {
        int numItems;
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if ((numItems = this.getItemCount()) > 0 && this.getSelectedIndex() < numItems - 1) {
            this.select(numItems - 1);
        }
    }

    @Override
    public void clearSelection(int index) {
        if (index < 0) {
            return;
        }
        boolean wasEmpty = this.selectedIndices.isEmpty();
        this.selectedIndices.clear(index);
        if (!wasEmpty && this.selectedIndices.isEmpty()) {
            this.clearSelection();
        }
        if (!this.isAtomic()) {
            this.selectedIndicesSeq.callObservers(new NonIterableChange.GenericAddRemoveChange<Integer>(index, index, Collections.singletonList(index), this.selectedIndicesSeq));
        }
    }

    @Override
    public void clearSelection() {
        ReadOnlyUnbackedObservableList<Integer> removed = this.createListFromBitSet((BitSet)this.selectedIndices.clone());
        this.quietClearSelection();
        if (!this.isAtomic()) {
            this.setSelectedIndex(-1);
            this.focus(-1);
            this.selectedIndicesSeq.callObservers(new NonIterableChange.GenericAddRemoveChange<Integer>(0, 0, removed, this.selectedIndicesSeq));
        }
    }

    private void quietClearSelection() {
        this.selectedIndices.clear();
    }

    @Override
    public boolean isSelected(int index) {
        if (index >= 0 && index < this.selectedIndices.length()) {
            return this.selectedIndices.get(index);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.selectedIndices.isEmpty();
    }

    @Override
    public void selectPrevious() {
        int focusIndex = this.getFocusedIndex();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (focusIndex == -1) {
            this.select(this.getItemCount() - 1);
        } else if (focusIndex > 0) {
            this.select(focusIndex - 1);
        }
    }

    @Override
    public void selectNext() {
        int focusIndex = this.getFocusedIndex();
        if (this.getSelectionMode() == SelectionMode.SINGLE) {
            this.quietClearSelection();
        }
        if (focusIndex == -1) {
            this.select(0);
        } else if (focusIndex != this.getItemCount() - 1) {
            this.select(focusIndex + 1);
        }
    }

    private ReadOnlyUnbackedObservableList<Integer> createListFromBitSet(final BitSet bitset) {
        return new ReadOnlyUnbackedObservableList<Integer>(){
            private int lastGetIndex = -1;
            private int lastGetValue = -1;

            @Override
            public Integer get(int index) {
                int itemCount = MultipleSelectionModelBase.this.getItemCount();
                if (index < 0 || index >= itemCount) {
                    return -1;
                }
                if (index == this.lastGetIndex + 1 && this.lastGetValue < itemCount) {
                    ++this.lastGetIndex;
                    this.lastGetValue = bitset.nextSetBit(this.lastGetValue + 1);
                    return this.lastGetValue;
                }
                if (index == this.lastGetIndex - 1 && this.lastGetValue > 0) {
                    --this.lastGetIndex;
                    this.lastGetValue = bitset.previousSetBit(this.lastGetValue - 1);
                    return this.lastGetValue;
                }
                this.lastGetIndex = 0;
                this.lastGetValue = bitset.nextSetBit(0);
                while (this.lastGetValue >= 0 || this.lastGetIndex == index) {
                    if (this.lastGetIndex == index) {
                        return this.lastGetValue;
                    }
                    ++this.lastGetIndex;
                    this.lastGetValue = bitset.nextSetBit(this.lastGetValue + 1);
                }
                return -1;
            }

            @Override
            public int size() {
                return bitset.cardinality();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Number) {
                    Number n = (Number)o;
                    int index = n.intValue();
                    return index >= 0 && index < bitset.length() && bitset.get(index);
                }
                return false;
            }
        };
    }

    /* synthetic */ Object lambda$new$35(Integer f) {
        return this.getModelItem(f);
    }

    /* synthetic */ void lambda$new$34(Observable valueModel) {
        this.setSelectedItem(this.getModelItem(this.getSelectedIndex()));
    }

    static class ShiftParams {
        private final int clearIndex;
        private final int setIndex;
        private final boolean selected;

        ShiftParams(int clearIndex, int setIndex, boolean selected) {
            this.clearIndex = clearIndex;
            this.setIndex = setIndex;
            this.selected = selected;
        }

        public final int getClearIndex() {
            return this.clearIndex;
        }

        public final int getSetIndex() {
            return this.setIndex;
        }

        public final boolean isSelected() {
            return this.selected;
        }
    }
}

