/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.beans.IDProperty;
import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.scene.control.ControlAcceleratorSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javafx.beans.DefaultProperty;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Tab$$Lambda$1;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;

@DefaultProperty(value="content")
@IDProperty(value="id")
public class Tab
implements EventTarget,
Styleable {
    private StringProperty id;
    private StringProperty style;
    private ReadOnlyBooleanWrapper selected;
    private ReadOnlyObjectWrapper<TabPane> tabPane;
    private final InvalidationListener parentDisabledChangedListener = Tab$$Lambda$1.lambdaFactory$(this);
    private StringProperty text;
    private ObjectProperty<Node> graphic;
    private ObjectProperty<Node> content;
    private ObjectProperty<ContextMenu> contextMenu;
    private BooleanProperty closable;
    public static final EventType<Event> SELECTION_CHANGED_EVENT = new EventType<Event>(Event.ANY, "SELECTION_CHANGED_EVENT");
    private ObjectProperty<EventHandler<Event>> onSelectionChanged;
    public static final EventType<Event> CLOSED_EVENT = new EventType<Event>(Event.ANY, "TAB_CLOSED");
    private ObjectProperty<EventHandler<Event>> onClosed;
    private ObjectProperty<Tooltip> tooltip;
    private final ObservableList<String> styleClass = FXCollections.observableArrayList();
    private BooleanProperty disable;
    private ReadOnlyBooleanWrapper disabled;
    public static final EventType<Event> TAB_CLOSE_REQUEST_EVENT = new EventType<Event>(Event.ANY, "TAB_CLOSE_REQUEST_EVENT");
    private ObjectProperty<EventHandler<Event>> onCloseRequest;
    private static final Object USER_DATA_KEY = new Object();
    private ObservableMap<Object, Object> properties;
    private final EventHandlerManager eventHandlerManager = new EventHandlerManager(this);
    private static final String DEFAULT_STYLE_CLASS = "tab";

    public Tab() {
        this(null);
    }

    public Tab(String text) {
        this(text, null);
    }

    public Tab(String text, Node content) {
        this.setText(text);
        this.setContent(content);
        this.styleClass.addAll((String[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public final void setId(String value) {
        this.idProperty().set(value);
    }

    @Override
    public final String getId() {
        return this.id == null ? null : (String)this.id.get();
    }

    public final StringProperty idProperty() {
        if (this.id == null) {
            this.id = new SimpleStringProperty(this, "id");
        }
        return this.id;
    }

    public final void setStyle(String value) {
        this.styleProperty().set(value);
    }

    @Override
    public final String getStyle() {
        return this.style == null ? null : (String)this.style.get();
    }

    public final StringProperty styleProperty() {
        if (this.style == null) {
            this.style = new SimpleStringProperty(this, "style");
        }
        return this.style;
    }

    final void setSelected(boolean value) {
        this.selectedPropertyImpl().set(value);
    }

    public final boolean isSelected() {
        return this.selected == null ? false : this.selected.get();
    }

    public final ReadOnlyBooleanProperty selectedProperty() {
        return this.selectedPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper selectedPropertyImpl() {
        if (this.selected == null) {
            this.selected = new ReadOnlyBooleanWrapper(){

                @Override
                protected void invalidated() {
                    if (Tab.this.getOnSelectionChanged() != null) {
                        Event.fireEvent(Tab.this, new Event(SELECTION_CHANGED_EVENT));
                    }
                }

                @Override
                public Object getBean() {
                    return Tab.this;
                }

                @Override
                public String getName() {
                    return "selected";
                }
            };
        }
        return this.selected;
    }

    final void setTabPane(TabPane value) {
        this.tabPanePropertyImpl().set(value);
    }

    public final TabPane getTabPane() {
        return this.tabPane == null ? null : (TabPane)this.tabPane.get();
    }

    public final ReadOnlyObjectProperty<TabPane> tabPaneProperty() {
        return this.tabPanePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TabPane> tabPanePropertyImpl() {
        if (this.tabPane == null) {
            this.tabPane = new ReadOnlyObjectWrapper<TabPane>((Object)this, "tabPane"){
                private WeakReference<TabPane> oldParent;

                @Override
                protected void invalidated() {
                    if (this.oldParent != null && this.oldParent.get() != null) {
                        ((TabPane)this.oldParent.get()).disabledProperty().removeListener(Tab.this.parentDisabledChangedListener);
                    }
                    Tab.this.updateDisabled();
                    TabPane newParent = (TabPane)this.get();
                    if (newParent != null) {
                        newParent.disabledProperty().addListener(Tab.this.parentDisabledChangedListener);
                    }
                    this.oldParent = new WeakReference<TabPane>(newParent);
                    super.invalidated();
                }
            };
        }
        return this.tabPane;
    }

    public final void setText(String value) {
        this.textProperty().set(value);
    }

    public final String getText() {
        return this.text == null ? null : (String)this.text.get();
    }

    public final StringProperty textProperty() {
        if (this.text == null) {
            this.text = new SimpleStringProperty(this, "text");
        }
        return this.text;
    }

    public final void setGraphic(Node value) {
        this.graphicProperty().set(value);
    }

    public final Node getGraphic() {
        return this.graphic == null ? null : (Node)this.graphic.get();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new SimpleObjectProperty<Node>(this, "graphic");
        }
        return this.graphic;
    }

    public final void setContent(Node value) {
        this.contentProperty().set(value);
    }

    public final Node getContent() {
        return this.content == null ? null : (Node)this.content.get();
    }

    public final ObjectProperty<Node> contentProperty() {
        if (this.content == null) {
            this.content = new SimpleObjectProperty<Node>(this, "content");
        }
        return this.content;
    }

    public final void setContextMenu(ContextMenu value) {
        this.contextMenuProperty().set(value);
    }

    public final ContextMenu getContextMenu() {
        return this.contextMenu == null ? null : (ContextMenu)this.contextMenu.get();
    }

    public final ObjectProperty<ContextMenu> contextMenuProperty() {
        if (this.contextMenu == null) {
            this.contextMenu = new SimpleObjectProperty<ContextMenu>((Object)this, "contextMenu"){
                private WeakReference<ContextMenu> contextMenuRef;

                @Override
                protected void invalidated() {
                    ContextMenu oldMenu;
                    ContextMenu contextMenu = oldMenu = this.contextMenuRef == null ? null : (ContextMenu)this.contextMenuRef.get();
                    if (oldMenu != null) {
                        ControlAcceleratorSupport.removeAcceleratorsFromScene(oldMenu.getItems(), Tab.this);
                    }
                    ContextMenu ctx = (ContextMenu)this.get();
                    this.contextMenuRef = new WeakReference<ContextMenu>(ctx);
                    if (ctx != null) {
                        ControlAcceleratorSupport.addAcceleratorsIntoScene(ctx.getItems(), Tab.this);
                    }
                }
            };
        }
        return this.contextMenu;
    }

    public final void setClosable(boolean value) {
        this.closableProperty().set(value);
    }

    public final boolean isClosable() {
        return this.closable == null ? true : this.closable.get();
    }

    public final BooleanProperty closableProperty() {
        if (this.closable == null) {
            this.closable = new SimpleBooleanProperty(this, "closable", true);
        }
        return this.closable;
    }

    public final void setOnSelectionChanged(EventHandler<Event> value) {
        this.onSelectionChangedProperty().set(value);
    }

    public final EventHandler<Event> getOnSelectionChanged() {
        return this.onSelectionChanged == null ? null : (EventHandler)this.onSelectionChanged.get();
    }

    public final ObjectProperty<EventHandler<Event>> onSelectionChangedProperty() {
        if (this.onSelectionChanged == null) {
            this.onSelectionChanged = new ObjectPropertyBase<EventHandler<Event>>(){

                @Override
                protected void invalidated() {
                    Tab.this.setEventHandler(SELECTION_CHANGED_EVENT, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Tab.this;
                }

                @Override
                public String getName() {
                    return "onSelectionChanged";
                }
            };
        }
        return this.onSelectionChanged;
    }

    public final void setOnClosed(EventHandler<Event> value) {
        this.onClosedProperty().set(value);
    }

    public final EventHandler<Event> getOnClosed() {
        return this.onClosed == null ? null : (EventHandler)this.onClosed.get();
    }

    public final ObjectProperty<EventHandler<Event>> onClosedProperty() {
        if (this.onClosed == null) {
            this.onClosed = new ObjectPropertyBase<EventHandler<Event>>(){

                @Override
                protected void invalidated() {
                    Tab.this.setEventHandler(CLOSED_EVENT, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Tab.this;
                }

                @Override
                public String getName() {
                    return "onClosed";
                }
            };
        }
        return this.onClosed;
    }

    public final void setTooltip(Tooltip value) {
        this.tooltipProperty().setValue(value);
    }

    public final Tooltip getTooltip() {
        return this.tooltip == null ? null : (Tooltip)this.tooltip.getValue();
    }

    public final ObjectProperty<Tooltip> tooltipProperty() {
        if (this.tooltip == null) {
            this.tooltip = new SimpleObjectProperty<Tooltip>(this, "tooltip");
        }
        return this.tooltip;
    }

    public final void setDisable(boolean value) {
        this.disableProperty().set(value);
    }

    public final boolean isDisable() {
        return this.disable == null ? false : this.disable.get();
    }

    public final BooleanProperty disableProperty() {
        if (this.disable == null) {
            this.disable = new BooleanPropertyBase(false){

                @Override
                protected void invalidated() {
                    Tab.this.updateDisabled();
                }

                @Override
                public Object getBean() {
                    return Tab.this;
                }

                @Override
                public String getName() {
                    return "disable";
                }
            };
        }
        return this.disable;
    }

    private final void setDisabled(boolean value) {
        this.disabledPropertyImpl().set(value);
    }

    public final boolean isDisabled() {
        return this.disabled == null ? false : this.disabled.get();
    }

    public final ReadOnlyBooleanProperty disabledProperty() {
        return this.disabledPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper disabledPropertyImpl() {
        if (this.disabled == null) {
            this.disabled = new ReadOnlyBooleanWrapper(){

                @Override
                public Object getBean() {
                    return Tab.this;
                }

                @Override
                public String getName() {
                    return "disabled";
                }
            };
        }
        return this.disabled;
    }

    private void updateDisabled() {
        boolean disabled = this.isDisable() || this.getTabPane() != null && this.getTabPane().isDisabled();
        this.setDisabled(disabled);
        Node content = this.getContent();
        if (content != null) {
            content.setDisable(disabled);
        }
    }

    public final ObjectProperty<EventHandler<Event>> onCloseRequestProperty() {
        if (this.onCloseRequest == null) {
            this.onCloseRequest = new ObjectPropertyBase<EventHandler<Event>>(){

                @Override
                protected void invalidated() {
                    Tab.this.setEventHandler(TAB_CLOSE_REQUEST_EVENT, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Tab.this;
                }

                @Override
                public String getName() {
                    return "onCloseRequest";
                }
            };
        }
        return this.onCloseRequest;
    }

    public EventHandler<Event> getOnCloseRequest() {
        if (this.onCloseRequest == null) {
            return null;
        }
        return (EventHandler)this.onCloseRequest.get();
    }

    public void setOnCloseRequest(EventHandler<Event> value) {
        this.onCloseRequestProperty().set(value);
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public void setUserData(Object value) {
        this.getProperties().put(USER_DATA_KEY, value);
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }

    @Override
    public ObservableList<String> getStyleClass() {
        return this.styleClass;
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return tail.prepend(this.eventHandlerManager);
    }

    protected <E extends Event> void setEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.setEventHandler(eventType, eventHandler);
    }

    Node lookup(String selector) {
        if (selector == null) {
            return null;
        }
        Node n = null;
        if (this.getContent() != null) {
            n = this.getContent().lookup(selector);
        }
        if (n == null && this.getGraphic() != null) {
            n = this.getGraphic().lookup(selector);
        }
        return n;
    }

    List<Node> lookupAll(String selector) {
        Set<Node> set;
        ArrayList<Node> results = new ArrayList<Node>();
        if (this.getContent() != null && !(set = this.getContent().lookupAll(selector)).isEmpty()) {
            results.addAll(set);
        }
        if (this.getGraphic() != null && !(set = this.getGraphic().lookupAll(selector)).isEmpty()) {
            results.addAll(set);
        }
        return results;
    }

    @Override
    public String getTypeSelector() {
        return "Tab";
    }

    @Override
    public Styleable getStyleableParent() {
        return this.getTabPane();
    }

    @Override
    public final ObservableSet<PseudoClass> getPseudoClassStates() {
        return FXCollections.emptyObservableSet();
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return Tab.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return Collections.emptyList();
    }

    /* synthetic */ void lambda$new$14(Observable valueModel) {
        this.updateDisabled();
    }
}

