/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.cell.CellUtils;
import javafx.scene.control.cell.ComboBoxListCell$$Lambda$1;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class ComboBoxListCell<T>
extends ListCell<T> {
    private final ObservableList<T> items;
    private ComboBox<T> comboBox;
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<StringConverter<T>>(this, "converter");
    private BooleanProperty comboBoxEditable = new SimpleBooleanProperty(this, "comboBoxEditable");

    @SafeVarargs
    public static <T> Callback<ListView<T>, ListCell<T>> forListView(T ... items) {
        return ComboBoxListCell.forListView(FXCollections.observableArrayList(items));
    }

    @SafeVarargs
    public static <T> Callback<ListView<T>, ListCell<T>> forListView(StringConverter<T> converter, T ... items) {
        return ComboBoxListCell.forListView(converter, FXCollections.observableArrayList(items));
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(ObservableList<T> items) {
        return ComboBoxListCell.forListView(null, items);
    }

    public static <T> Callback<ListView<T>, ListCell<T>> forListView(StringConverter<T> converter, ObservableList<T> items) {
        return ComboBoxListCell$$Lambda$1.lambdaFactory$(converter, items);
    }

    public ComboBoxListCell() {
        this(FXCollections.observableArrayList());
    }

    @SafeVarargs
    public ComboBoxListCell(T ... items) {
        this(FXCollections.observableArrayList(items));
    }

    @SafeVarargs
    public ComboBoxListCell(StringConverter<T> converter, T ... items) {
        this(converter, FXCollections.observableArrayList(items));
    }

    public ComboBoxListCell(ObservableList<T> items) {
        this((StringConverter<T>)null, items);
    }

    public ComboBoxListCell(StringConverter<T> converter, ObservableList<T> items) {
        this.getStyleClass().add("combo-box-list-cell");
        this.items = items;
        this.setConverter(converter != null ? converter : CellUtils.defaultStringConverter());
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public final BooleanProperty comboBoxEditableProperty() {
        return this.comboBoxEditable;
    }

    public final void setComboBoxEditable(boolean value) {
        this.comboBoxEditableProperty().set(value);
    }

    public final boolean isComboBoxEditable() {
        return this.comboBoxEditableProperty().get();
    }

    public ObservableList<T> getItems() {
        return this.items;
    }

    @Override
    public void startEdit() {
        if (!this.isEditable() || !this.getListView().isEditable()) {
            return;
        }
        if (this.comboBox == null) {
            this.comboBox = CellUtils.createComboBox(this, this.items, this.converterProperty());
            this.comboBox.editableProperty().bind(this.comboBoxEditableProperty());
        }
        this.comboBox.getSelectionModel().select(this.getItem());
        super.startEdit();
        if (this.isEditing()) {
            this.setText(null);
            this.setGraphic(this.comboBox);
        }
    }

    @Override
    public void cancelEdit() {
        super.cancelEdit();
        this.setText(this.getConverter().toString(this.getItem()));
        this.setGraphic(null);
    }

    @Override
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        CellUtils.updateItem(this, this.getConverter(), null, null, this.comboBox);
    }

    static /* synthetic */ ListCell lambda$forListView$633(StringConverter stringConverter, ObservableList observableList, ListView list) {
        return new ComboBoxListCell(stringConverter, observableList);
    }
}

