/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control.cell;

import javafx.beans.value.ObservableValue;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.ProgressBarTableCell$$Lambda$1;
import javafx.util.Callback;

public class ProgressBarTableCell<S>
extends TableCell<S, Double> {
    private final ProgressBar progressBar;
    private ObservableValue<Double> observable;

    public static <S> Callback<TableColumn<S, Double>, TableCell<S, Double>> forTableColumn() {
        return ProgressBarTableCell$$Lambda$1.lambdaFactory$();
    }

    public ProgressBarTableCell() {
        this.getStyleClass().add("progress-bar-table-cell");
        this.progressBar = new ProgressBar();
        this.progressBar.setMaxWidth(Double.MAX_VALUE);
    }

    @Override
    public void updateItem(Double item, boolean empty) {
        super.updateItem(item, empty);
        if (empty) {
            this.setGraphic(null);
        } else {
            this.progressBar.progressProperty().unbind();
            TableColumn column = this.getTableColumn();
            ObservableValue<Object> observableValue = this.observable = column == null ? null : column.getCellObservableValue(this.getIndex());
            if (this.observable != null) {
                this.progressBar.progressProperty().bind(this.observable);
            } else if (item != null) {
                this.progressBar.setProgress(item);
            }
            this.setGraphic(this.progressBar);
        }
    }

    static /* synthetic */ TableCell lambda$forTableColumn$637(TableColumn param) {
        return new ProgressBarTableCell();
    }
}

