/*
 * Decompiled with CFR 0.152.
 */
package javafxports.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Debug;
import android.os.Process;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import javafxports.android.FXDalvikEntity;
import javafxports.android.IntentHandler;
import javafxports.android.Launcher;

public class FXActivity
extends Activity {
    private static final String TAG = "FXActivity";
    private static final String JFX_BUILD = "8.60.9-SNAPSHOT";
    private static final String ACTIVITY_LIB = "activity";
    private static final String META_DATA_DEBUG_PORT = "debug.port";
    public static String dexClassPath = new String();
    private static FXActivity instance;
    private static Launcher launcher;
    private static FrameLayout mViewGroup;
    private static String appDataDir;
    private static IntentHandler intentHandler;
    private static final Bundle metadata;
    private FXDalvikEntity fxDalvikEntity;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        try {
            ApplicationInfo appi = this.getPackageManager().getApplicationInfo(this.getPackageName(), 128);
            if (appi != null && appi.metaData != null) {
                metadata.putAll(appi.metaData);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)TAG, (String)"Error getting Application info.");
        }
        try {
            ActivityInfo ai = this.getPackageManager().getActivityInfo(this.getIntent().getComponent(), 128);
            if (ai != null && ai.metaData != null) {
                metadata.putAll(ai.metaData);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)TAG, (String)"Error getting Activity info.");
        }
        this.fxDalvikEntity = new FXDalvikEntity(metadata, this);
        Log.v((String)TAG, (String)"onCreate called, using 8.60.9-SNAPSHOT");
        if (launcher != null) {
            Log.v((String)TAG, (String)"JavaFX application is already running");
            return;
        }
        this.getWindow().requestFeature(1);
        this.getWindow().setSoftInputMode(0);
        this.getWindow().setFormat(1);
        View myView = this.fxDalvikEntity.createView();
        mViewGroup = new FrameLayout((Context)this);
        mViewGroup.addView(myView);
        this.setContentView((View)mViewGroup);
        instance = this;
        appDataDir = this.getApplicationInfo().dataDir;
        instance = this;
        this._setDataDir(appDataDir);
        int dport = metadata.getInt(META_DATA_DEBUG_PORT);
        if (dport > 0) {
            Debug.waitForDebugger();
        }
    }

    protected void onDestroy() {
        Log.v((String)TAG, (String)"onDestroy");
        super.onDestroy();
        Process.killProcess((int)Process.myPid());
    }

    protected void onPause() {
        Log.v((String)TAG, (String)"onPause");
        super.onPause();
    }

    protected void onResume() {
        Log.v((String)TAG, (String)"onResume");
        super.onResume();
    }

    protected void onStart() {
        Log.v((String)TAG, (String)"onStart");
        super.onStart();
    }

    protected void onRestart() {
        Log.v((String)TAG, (String)"onRestart");
        super.onRestart();
    }

    protected void onStop() {
        Log.v((String)TAG, (String)"onStop");
        super.onStop();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        Log.v((String)TAG, (String)("onActivityResult with requestCode " + requestCode + " and resultCode = " + resultCode + " and intent = " + intent));
        if (intentHandler != null) {
            intentHandler.gotActivityResult(requestCode, resultCode, intent);
        }
    }

    public void setOnActivityResultHandler(IntentHandler handler) {
        intentHandler = handler;
    }

    public static FXActivity getInstance() {
        return instance;
    }

    public static ViewGroup getViewGroup() {
        return mViewGroup;
    }

    public static String getMyDataDir() {
        return appDataDir;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Log.v((String)TAG, (String)"Called onConfigurationChanged");
    }

    private native void _setDataDir(String var1);

    static {
        metadata = new Bundle();
        Log.v((String)TAG, (String)"Initializing JavaFX Platform, using 8.60.9-SNAPSHOT");
        System.loadLibrary(ACTIVITY_LIB);
    }
}

