/*
 * Decompiled with CFR 0.152.
 */
package javafxports.android;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.os.Bundle;
import android.os.SystemClock;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import com.sun.glass.ui.android.SoftwareKeyboard;
import com.sun.javafx.tk.Toolkit;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import javafxports.android.FXInputConnection;
import javafxports.android.KeyEventProcessor;
import javafxports.android.Launcher;

public class FXDalvikEntity
implements TextureView.SurfaceTextureListener,
ViewTreeObserver.OnGlobalLayoutListener,
SurfaceHolder.Callback,
SurfaceHolder.Callback2 {
    private static final String ACTIVITY_LIB = "activity";
    private static final String META_DATA_LAUNCHER_CLASS = "launcher.class";
    private static final String DEFAULT_LAUNCHER_CLASS = "javafxports.android.DalvikLauncher";
    public static final String META_DATA_MAIN_CLASS = "main.class";
    private static final String META_DATA_PRELOADER_CLASS = "preloader.class";
    private static final String META_DATA_DEBUG_PORT = "debug.port";
    private static final String META_DATA_TEXTUREVIEW = "textureview";
    private static final String META_DATA_SWIPEKEYBOARD = "swipekeyboard";
    private static final String META_DATA_RESTOREKEYBOARD = "restorekeyboard";
    private static final String META_DATA_JAVA_ARGS = "java.args";
    private static final String APPLICATION_DEX_NAME = "Application_dex.jar";
    private static final String APPLICATION_RESOURCES_NAME = "Application_resources.jar";
    private static final String CLASSLOADER_PROPERTIES_NAME = "classloader.properties";
    private int SCREEN_ORIENTATION = 1;
    private String launcherClassName;
    private String mainClassName;
    private String preloaderClassName;
    private static final String TAG = "FXEntity";
    private SurfaceDetails surfaceDetails;
    private static Launcher launcher;
    private final Bundle metadata;
    private static Activity activity;
    private static boolean glassHasStarted;
    private static Method onMultiTouchEventMethod;
    private static Method onSurfaceCreatedMethod;
    private static Method onSurfaceChangedNativeMethod1;
    private static Method onSurfaceChangedNativeMethod2;
    private static Method onSurfaceRedrawNeededNativeMethod;
    private static Method onConfigurationChangedNativeMethod;
    private static Method initializeMonocleMethod;
    private static Method keyboardSizeMethod;
    private static InputMethodManager imm;
    static View myView;
    private static CountDownLatch cdlEvLoopFinished;
    private static float originalHeight;
    public static float keyboardHeight;
    private float density;
    private SurfaceTexture surfaceTexture;
    private static final int ACTION_POINTER_STILL = -1;
    boolean useTextureView = false;
    boolean useSwipeKeyboard = false;
    boolean useRestoreKeyboard = false;
    private static long softInput;
    private String[] javaArgs = new String[0];

    public FXDalvikEntity(Bundle metadata, Activity fxActivity) {
        this.metadata = metadata;
        activity = fxActivity;
        this.createJavaArgs();
        this.useTextureView = metadata.containsKey(META_DATA_TEXTUREVIEW);
        this.useSwipeKeyboard = metadata.containsKey(META_DATA_SWIPEKEYBOARD);
        this.useRestoreKeyboard = metadata.containsKey(META_DATA_RESTOREKEYBOARD);
        System.out.println("usetextureview = " + this.useTextureView + ", useswipekeyboard = " + this.useSwipeKeyboard);
        imm = (InputMethodManager)activity.getSystemService("input_method");
        this.jfxEventsLoop();
    }

    private void createJavaArgs() {
        String extraVal;
        Bundle b;
        String extraKey = this.metadata.getString(META_DATA_JAVA_ARGS);
        if (extraKey != null && !extraKey.isEmpty() && (b = activity.getIntent().getExtras()) != null && (extraVal = b.getString(extraKey)) != null && !extraVal.isEmpty()) {
            this.javaArgs = new String[]{"--" + extraKey + "=" + extraVal};
            System.setProperty(extraKey, extraVal);
        }
    }

    public static Activity getActivity() {
        return activity;
    }

    public void getLauncherAndLaunchApplication() {
        this.launcherClassName = this.metadata.containsKey(META_DATA_LAUNCHER_CLASS) ? this.metadata.getString(META_DATA_LAUNCHER_CLASS) : DEFAULT_LAUNCHER_CLASS;
        this.mainClassName = this.metadata.containsKey(META_DATA_MAIN_CLASS) ? this.metadata.getString(META_DATA_MAIN_CLASS) : null;
        String string = this.preloaderClassName = this.metadata.containsKey(META_DATA_PRELOADER_CLASS) ? this.metadata.getString(META_DATA_PRELOADER_CLASS) : null;
        if (this.mainClassName == null || this.mainClassName.length() == 0) {
            throw new RuntimeException("Main application class must be defined.\nUse <meta-data android.name=\"main.class\" android.value=\"your.package.YourMainClass\"/>");
        }
        if (this.preloaderClassName != null && this.preloaderClassName.length() == 0) {
            this.preloaderClassName = null;
        }
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.launcherClassName);
            launcher = (Launcher)clazz.newInstance();
            launcher.launchApp(this, this.mainClassName, this.preloaderClassName, this.javaArgs);
        }
        catch (Exception ex) {
            throw new RuntimeException("Did not create correct launcher.", ex);
        }
    }

    public View createView() {
        return this.useTextureView ? this.createTextureView() : this.createSurfaceView();
    }

    public View createTextureView() {
        InternalTextureView answer = new InternalTextureView((Context)activity);
        answer.setSurfaceTextureListener(this);
        answer.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        myView = answer;
        return answer;
    }

    public View createSurfaceView() {
        InternalSurfaceView answer = new InternalSurfaceView((Context)activity);
        answer.getHolder().addCallback((SurfaceHolder.Callback)this);
        answer.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        myView = answer;
        return answer;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture st, int width, int height) {
        Log.v((String)TAG, (String)"Surface created.");
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        Log.v((String)TAG, (String)("metrics = " + metrics));
        this.surfaceTexture = st;
        Surface surface = new Surface(st);
        this.surfaceDetails = new SurfaceDetails(surface, metrics.density);
        this._setSurface(this.surfaceDetails.surface);
        this.density = metrics.density;
        this._setDensity(this.surfaceDetails.density);
        Rect currentBounds = new Rect();
        myView.getRootView().getWindowVisibleDisplayFrame(currentBounds);
        originalHeight = (float)currentBounds.height() / this.density;
        if (launcher == null) {
            this.getLauncherAndLaunchApplication();
        } else {
            try {
                Log.v((String)TAG, (String)"Surface created, application was already launched and we will recreate eglSurface now");
                onSurfaceCreatedMethod.invoke(null, new Object[0]);
                Log.v((String)TAG, (String)("Surface created, application was already launched and we will invoke native surface changed method: " + onSurfaceChangedNativeMethod1));
                onSurfaceChangedNativeMethod1.invoke(null, new Object[0]);
                Toolkit.getToolkit().resumeRenderer();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke com.sun.glass.ui.android.DalvikInput.onSurfaceChangedNative1 method by reflection", e);
            }
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture st, int width, int height) {
        Log.v((String)TAG, (String)String.format("Called Surface changed [%d, %d]", width, height));
        Surface surface = new Surface(st);
        this.surfaceDetails = new SurfaceDetails(surface, width, height);
        this._setSurface(this.surfaceDetails.surface);
        if (glassHasStarted) {
            try {
                onSurfaceChangedNativeMethod2.invoke(null, this.surfaceDetails.format, this.surfaceDetails.width, this.surfaceDetails.height);
                Thread.sleep(500L);
                onSurfaceChangedNativeMethod2.invoke(null, this.surfaceDetails.format, this.surfaceDetails.width, this.surfaceDetails.height);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke com.sun.glass.ui.android.DalvikInput.onSurfaceChangedNative2 method by reflection", e);
            }
        }
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture st) {
        Log.v((String)TAG, (String)"Called Surface destroyed");
        Toolkit.getToolkit().pauseRenderer();
        this.surfaceDetails = new SurfaceDetails();
        this._setSurface(this.surfaceDetails.surface);
        if (glassHasStarted) {
            try {
                onSurfaceChangedNativeMethod1.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke com.sun.glass.ui.android.DalvikInput.onSurfaceChangedNative1 method by reflection", e);
            }
        }
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture st) {
        Log.v((String)TAG, (String)"surfacetextureupdated...");
    }

    private void storeDensity() {
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        this.density = metrics.density;
        this._setDensity(this.density);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        Log.v((String)TAG, (String)"Surface created.");
        this.surfaceDetails = new SurfaceDetails(holder.getSurface());
        this._setSurface(this.surfaceDetails.surface);
        this.storeDensity();
        Rect currentBounds = new Rect();
        myView.getRootView().getWindowVisibleDisplayFrame(currentBounds);
        originalHeight = (float)currentBounds.height() / this.density;
        if (launcher == null) {
            this.getLauncherAndLaunchApplication();
        } else {
            try {
                onSurfaceCreatedMethod.invoke(null, new Object[0]);
                onSurfaceChangedNativeMethod1.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke com.sun.glass.ui.android.DalvikInput.onSurfaceChangedNative1 method by reflection", e);
            }
        }
        if (this.useRestoreKeyboard && softInput > 0L) {
            SoftwareKeyboard.delayShow();
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log.v((String)TAG, (String)String.format("Called Surface changed [%d, %d], format %d", width, height, format));
        if (glassHasStarted) {
            // empty if block
        }
        this.surfaceDetails = new SurfaceDetails(holder.getSurface(), format, width, height);
        this._setSurface(this.surfaceDetails.surface);
        this.storeDensity();
        if (glassHasStarted) {
            try {
                onSurfaceChangedNativeMethod2.invoke(null, this.surfaceDetails.format, this.surfaceDetails.width, this.surfaceDetails.height);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke com.sun.glass.ui.android.DalvikInput.onSurfaceChangedNative2 method by reflection", e);
            }
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        Log.v((String)TAG, (String)"Called Surface destroyed");
        this.surfaceDetails = new SurfaceDetails();
        this._setSurface(this.surfaceDetails.surface);
        if (glassHasStarted) {
            try {
                onSurfaceChangedNativeMethod1.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke com.sun.glass.ui.android.DalvikInput.onSurfaceChangedNative1 method by reflection", e);
            }
        }
    }

    public void surfaceRedrawNeeded(SurfaceHolder holder) {
        Log.v((String)TAG, (String)"Called Surface redraw needed");
        if (holder.getSurface() != this.surfaceDetails.surface) {
            this.surfaceDetails = new SurfaceDetails(holder.getSurface());
            this._setSurface(this.surfaceDetails.surface);
            this.storeDensity();
        }
        if (glassHasStarted) {
            try {
                Log.v((String)TAG, (String)"Redraw...");
                onSurfaceRedrawNeededNativeMethod.invoke(null, new Object[0]);
                Log.v((String)TAG, (String)"Wait a while before doing this again...");
                Thread.currentThread();
                Thread.sleep(200L);
                Log.v((String)TAG, (String)"Redraw again...");
                onSurfaceRedrawNeededNativeMethod.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to invoke com.sun.glass.ui.android.DalvikInput.onSurfaceRedrawNeededNative method by reflection", e);
            }
        }
    }

    public void onGlobalLayout() {
        Rect currentBounds = new Rect();
        myView.getRootView().getWindowVisibleDisplayFrame(currentBounds);
        float newHeight = (float)currentBounds.height() / this.density;
        keyboardHeight = originalHeight - newHeight;
        if (keyboardSizeMethod != null) {
            try {
                keyboardSizeMethod.invoke(null, Float.valueOf(keyboardHeight));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void setInitializeMonocleMethod(Method v) {
        initializeMonocleMethod = v;
    }

    protected void setKeyboardSizeMethod(Method v) {
        keyboardSizeMethod = v;
    }

    protected void setOnMultiTouchEventMethod(Method onMultiTouchEventMethod) {
        FXDalvikEntity.onMultiTouchEventMethod = onMultiTouchEventMethod;
    }

    protected void setOnSurfaceCreatedMethod(Method method) {
        onSurfaceCreatedMethod = method;
    }

    protected void setOnSurfaceChangedNativeMethod1(Method onSurfaceChangedNativeMethod1) {
        FXDalvikEntity.onSurfaceChangedNativeMethod1 = onSurfaceChangedNativeMethod1;
    }

    protected void setOnSurfaceChangedNativeMethod2(Method onSurfaceChangedNativeMethod2) {
        FXDalvikEntity.onSurfaceChangedNativeMethod2 = onSurfaceChangedNativeMethod2;
    }

    protected void setOnSurfaceRedrawNeededNativeMethod(Method onSurfaceRedrawNeededNativeMethod) {
        FXDalvikEntity.onSurfaceRedrawNeededNativeMethod = onSurfaceRedrawNeededNativeMethod;
    }

    protected void setOnConfigurationChangedNativeMethod(Method onConfigurationChangedNativeMethod) {
        FXDalvikEntity.onConfigurationChangedNativeMethod = onConfigurationChangedNativeMethod;
    }

    public static void notify_glassHasStarted() {
        Log.v((String)TAG, (String)"notify_glassHasStarted called in FXActivity. register device now.");
        glassHasStarted = true;
        try {
            initializeMonocleMethod.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            System.out.println("throwable: " + t);
            t.printStackTrace();
        }
        System.out.println("register device done");
    }

    private static void notify_glassShutdown() {
        Log.v((String)TAG, (String)"notify_glassShutdown");
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    cdlEvLoopFinished.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }).start();
    }

    private static void notify_showIME() {
        Log.v((String)TAG, (String)"Called notify_showIME");
        imm.showSoftInput(myView, 0);
        softInput = System.currentTimeMillis();
        Log.v((String)TAG, (String)"Done calling notify_showIME");
    }

    private static void notify_hideIME() {
        Log.v((String)TAG, (String)"Called notify_hideIME");
        imm.hideSoftInputFromWindow(myView.getWindowToken(), 0);
        softInput = 0L;
        Log.v((String)TAG, (String)"Done Calling notify_hideIME");
    }

    public void jfxEventsLoop() {
        cdlEvLoopFinished = new CountDownLatch(1);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                FXDalvikEntity.this._jfxEventsLoop();
                Log.v((String)FXDalvikEntity.TAG, (String)"FXActivityEventsLoop finished.");
                cdlEvLoopFinished.countDown();
            }
        }, "FXActivityEventsLoop");
        t.setDaemon(true);
        t.start();
    }

    private native void _jfxEventsLoop();

    private native void _setDataDir(String var1);

    private native void _setSurface(Surface var1);

    private native void _setDensity(float var1);

    private boolean internalDispatchTouchEvent(MotionEvent event) {
        if (!glassHasStarted) {
            return false;
        }
        int action = event.getAction();
        int actionCode = action & 0xFF;
        int pcount = event.getPointerCount();
        int[] actions = new int[pcount];
        int[] ids = new int[pcount];
        int[] touchXs = new int[pcount];
        int[] touchYs = new int[pcount];
        if (pcount > 1) {
            if (actionCode == 5 || actionCode == 6) {
                int pointerIndex = event.getActionIndex();
                for (int i = 0; i < pcount; ++i) {
                    actions[i] = pointerIndex == i ? actionCode : -1;
                    ids[i] = event.getPointerId(i);
                    touchXs[i] = (int)event.getX(i);
                    touchYs[i] = (int)event.getY(i);
                }
            } else if (actionCode == 2) {
                for (int i = 0; i < pcount; ++i) {
                    touchXs[i] = (int)event.getX(i);
                    touchYs[i] = (int)event.getY(i);
                    actions[i] = 2;
                    ids[i] = event.getPointerId(i);
                }
            }
        } else {
            actions[0] = actionCode;
            ids[0] = event.getPointerId(0);
            touchXs[0] = (int)event.getX();
            touchYs[0] = (int)event.getY();
        }
        Log.e((String)TAG, (String)("call native MultitouchEvent, density = " + this.density + ", touchXs0 = " + touchXs[0]));
        try {
            if (!myView.isFocused()) {
                Log.v((String)TAG, (String)"view wasn't focused");
                myView.requestFocus();
            }
            onMultiTouchEventMethod.invoke(null, pcount, actions, ids, touchXs, touchYs);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to invoke com.sun.glass.ui.android.DalvikInput.onMultiTouchEvent method by reflection", e);
        }
        return true;
    }

    private void setSurface(Surface surface) {
        this._setSurface(surface);
    }

    static {
        glassHasStarted = false;
        keyboardHeight = 0.0f;
        softInput = 0L;
    }

    class SurfaceDetails {
        Surface surface;
        int format;
        int width;
        int height;
        float density;

        SurfaceDetails() {
        }

        SurfaceDetails(Surface surface) {
            this.surface = surface;
        }

        SurfaceDetails(Surface surface, float density) {
            this.surface = surface;
            this.density = density;
        }

        SurfaceDetails(Surface surface, int width, int height) {
            this.surface = surface;
            this.width = width;
            this.height = height;
        }

        SurfaceDetails(Surface surface, int format, int width, int height) {
            this.surface = surface;
            this.format = format;
            this.width = width;
            this.height = height;
        }
    }

    class DeviceConfiguration {
        private static final int ORIENTATION_CHANGE = 1;
        private int change = 0;
        private int orientation;

        DeviceConfiguration() {
        }

        void setConfiguration(Configuration config) {
            if (this.orientation != config.orientation) {
                this.orientation = config.orientation;
                this.change |= 1;
            }
        }

        int getOrientation() {
            return this.orientation;
        }

        boolean isChanged() {
            return this.change > 0;
        }

        void dispatch() {
            if ((this.change & 1) > 0) {
                Log.v((String)FXDalvikEntity.TAG, (String)"Dispatching orientation change to");
                try {
                    onConfigurationChangedNativeMethod.invoke(null, FXDalvikEntity.this.SCREEN_ORIENTATION);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to invoke com.sun.glass.ui.android.DalvikInput.onConfigurationChangedNative method by reflection", e);
                }
            }
            this.change = 0;
        }
    }

    class InternalSurfaceView
    extends SurfaceView {
        public InternalSurfaceView(Context context) {
            super(context);
            this.setFocusableInTouchMode(true);
            this.setFocusable(true);
        }

        public boolean dispatchTouchEvent(MotionEvent event) {
            return FXDalvikEntity.this.internalDispatchTouchEvent(event);
        }

        public boolean dispatchKeyEvent(KeyEvent event) {
            if (!glassHasStarted) {
                return false;
            }
            KeyEventProcessor.getInstance().process(event);
            return true;
        }

        public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
            if (!FXDalvikEntity.this.useSwipeKeyboard) {
                return super.onCreateInputConnection(outAttrs);
            }
            Log.w((String)FXDalvikEntity.TAG, (String)"onCreateInputConnection called...!!");
            outAttrs.actionLabel = null;
            outAttrs.label = "Placeholder";
            outAttrs.inputType = 1;
            FXInputConnection ic = new FXInputConnection((View)this, true);
            return ic;
        }

        public void backSpace() {
            KeyEvent k1 = new KeyEvent(0, 67);
            KeyEventProcessor.getInstance().process(k1);
            KeyEvent k2 = new KeyEvent(1, 67);
            KeyEventProcessor.getInstance().process(k2);
        }

        public void setText(CharSequence text) {
            KeyEvent keyEvent = new KeyEvent(SystemClock.elapsedRealtimeNanos(), text.toString(), 0, 2);
            Log.e((String)FXDalvikEntity.TAG, (String)("TEXT setText will call with text: '" + text + "'"));
            KeyEventProcessor.getInstance().process(keyEvent);
            Log.e((String)FXDalvikEntity.TAG, (String)("TEXT setText called with text: '" + text + "'"));
        }
    }

    class InternalTextureView
    extends TextureView {
        public InternalTextureView(Context context) {
            super(context);
            this.setFocusableInTouchMode(true);
            this.setFocusable(true);
        }

        public boolean dispatchTouchEvent(MotionEvent event) {
            return FXDalvikEntity.this.internalDispatchTouchEvent(event);
        }

        public boolean dispatchKeyEvent(KeyEvent event) {
            if (!glassHasStarted) {
                return false;
            }
            KeyEventProcessor.getInstance().process(event);
            return true;
        }
    }
}

