/*
 * Decompiled with CFR 0.152.
 */
package javafxports.android;

import android.text.Editable;
import android.text.Selection;
import android.text.Spannable;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.BaseInputConnection;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.CorrectionInfo;
import javafxports.android.FXDalvikEntity;

public class FXInputConnection
extends BaseInputConnection {
    private Editable editable;
    private FXDalvikEntity.InternalSurfaceView surfaceView;
    private String workText = "";

    public FXInputConnection(View targetView, boolean fullEditor) {
        super(targetView, fullEditor);
        this.surfaceView = (FXDalvikEntity.InternalSurfaceView)targetView;
    }

    public Editable getEditable() {
        if (this.editable == null) {
            this.editable = Editable.Factory.getInstance().newEditable((CharSequence)"");
            Selection.setSelection((Spannable)this.editable, (int)0);
        }
        return this.editable;
    }

    public boolean setComposingText(CharSequence text, int newCursorPosition) {
        System.out.println("[JVDBG] TEXT setComposingText-Before: text = '" + text + "', workText = '" + this.workText + "', editable = '" + this.editable + "'");
        if (!text.toString().equals(this.workText.toString())) {
            int i;
            if (text.length() == 0) {
                for (i = 0; i < this.workText.length(); ++i) {
                    this.surfaceView.backSpace();
                }
            } else if (this.editable.toString().startsWith(text.toString())) {
                for (i = this.editable.length() - text.length(); i > 0; --i) {
                    this.surfaceView.backSpace();
                }
            } else {
                this.surfaceView.setText(text);
            }
            this.workText = text.toString();
        }
        System.out.println("[JVDBG] TEXT setComposingText-BeforeSuper: text = '" + text + "', workText = '" + this.workText + "', editable = '" + this.editable + "'");
        boolean result = super.setComposingText(text, newCursorPosition);
        System.out.println("[JVDBG] TEXT setComposingText-After: text = '" + text + "', workText = '" + this.workText + "', editable = '" + this.editable + "'");
        return result;
    }

    public boolean finishComposingText() {
        System.out.println("[JVDBG] TEXT finishComposingText-Before: workText = '" + this.workText + "', editable = '" + this.editable + "'");
        this.workText = "";
        System.out.println("[JVDBG] TEXT finishComposingText-BeforeSuper: workText = '" + this.workText + "', editable = '" + this.editable + "'");
        boolean result = super.finishComposingText();
        System.out.println("[JVDBG] TEXT finishComposingText-After: workText = '" + this.workText + "', editable = '" + this.editable + "'");
        return result;
    }

    public boolean commitText(CharSequence text, int newCursorPosition) {
        System.out.println("[JVDBG] TEXT commitText-Before: '" + text + "', workText: '" + this.workText + "', editable = '" + this.editable + "'");
        if (!text.toString().equals(this.workText)) {
            int commonSize = this.commonSize(text, this.workText);
            for (int i = this.workText.length() - commonSize; i > 0; --i) {
                this.surfaceView.backSpace();
            }
            this.surfaceView.setText(text.subSequence(commonSize, text.length()));
        }
        this.workText = "";
        this.editable.clear();
        System.out.println("[JVDBG] TEXT commitText-BeforeSuper: '" + text + "', workText: '" + this.workText + "', editable = '" + this.editable + "'");
        boolean result = super.commitText(text, newCursorPosition);
        System.out.println("[JVDBG] TEXT commitText-After: '" + text + "', workText: '" + this.workText + "', editable = '" + this.editable + "'");
        return result;
    }

    public boolean commitCompletion(CompletionInfo info) {
        System.out.println("[JVDBG] TEXT commitCompletion: info = " + info);
        return super.commitCompletion(info);
    }

    public boolean commitCorrection(CorrectionInfo info) {
        System.out.println("[JVDBG] TEXT commitCorrection: info = " + info);
        return super.commitCorrection(info);
    }

    public boolean sendKeyEvent(KeyEvent event) {
        System.out.println("[JVDBG] TEXT sendKeyEvent: event = " + event);
        return super.sendKeyEvent(event);
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        System.out.println("[JVDBG] TEXT deleteSurroundingText: beforeLength = " + beforeLength + ", afterLength = " + afterLength);
        if (beforeLength == 1 && afterLength == 0) {
            this.editable.clear();
            this.surfaceView.backSpace();
        }
        return super.deleteSurroundingText(beforeLength, afterLength);
    }

    private int commonSize(CharSequence a, CharSequence b) {
        int idx;
        int la = a == null ? 0 : a.length();
        int lb = b == null ? 0 : b.length();
        int l = Math.min(la, lb);
        for (idx = 0; idx < l && a.charAt(idx) == b.charAt(idx); ++idx) {
        }
        return idx;
    }
}

