/*
 * Decompiled with CFR 0.152.
 */
package javafxports.android;

import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import com.sun.glass.ui.monocle.AndroidInputDeviceRegistry;
import javafx.application.Platform;
import javafx.scene.input.KeyCode;

public class KeyEventProcessor {
    private static KeyEventProcessor instance = new KeyEventProcessor();
    private int deadKey = 0;

    public static KeyEventProcessor getInstance() {
        return instance;
    }

    public void process(final KeyEvent event) {
        System.out.println("KeyEvent: " + event + " with action = " + event.getAction());
        final int jfxModifiers = KeyEventProcessor.mapAndroidModifierToJfx(event.getMetaState());
        switch (event.getAction()) {
            case 0: {
                final KeyCode jfxKeyCode = KeyEventProcessor.mapAndroidKeyCodeToJfx(event.getKeyCode());
                System.out.println("[JVDBG] eventkeycode = " + event.getKeyCode() + " and jfxkc = " + jfxKeyCode + " with code " + jfxKeyCode.impl_getCode());
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AndroidInputDeviceRegistry.dispatchKeyEvent((int)111, (int)jfxKeyCode.impl_getCode(), (char[])jfxKeyCode.impl_getChar().toCharArray(), (int)jfxModifiers);
                    }
                });
                break;
            }
            case 1: {
                final KeyCode jfxKeyCode = KeyEventProcessor.mapAndroidKeyCodeToJfx(event.getKeyCode());
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AndroidInputDeviceRegistry.dispatchKeyEvent((int)112, (int)jfxKeyCode.impl_getCode(), (char[])jfxKeyCode.impl_getChar().toCharArray(), (int)jfxModifiers);
                        int unicodeChar = event.getUnicodeChar();
                        if ((unicodeChar & Integer.MIN_VALUE) != 0) {
                            KeyEventProcessor.this.deadKey = unicodeChar & Integer.MAX_VALUE;
                            return;
                        }
                        if (KeyEventProcessor.this.deadKey != 0 && unicodeChar != 0) {
                            unicodeChar = KeyCharacterMap.getDeadChar((int)KeyEventProcessor.this.deadKey, (int)unicodeChar);
                            KeyEventProcessor.this.deadKey = 0;
                        }
                        if (unicodeChar != 0) {
                            AndroidInputDeviceRegistry.dispatchKeyEvent((int)113, (int)KeyCode.UNDEFINED.impl_getCode(), (char[])Character.toChars(unicodeChar), (int)jfxModifiers);
                        }
                    }
                });
                break;
            }
            case 2: {
                if (event.getKeyCode() == 0) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            AndroidInputDeviceRegistry.dispatchKeyEvent((int)113, (int)KeyCode.UNDEFINED.impl_getCode(), (char[])event.getCharacters().toCharArray(), (int)jfxModifiers);
                        }
                    });
                    break;
                }
                final KeyCode jfxKeyCode = KeyEventProcessor.mapAndroidKeyCodeToJfx(event.getKeyCode());
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (int i = 0; i < event.getRepeatCount(); ++i) {
                            AndroidInputDeviceRegistry.dispatchKeyEvent((int)111, (int)jfxKeyCode.impl_getCode(), null, (int)jfxModifiers);
                            AndroidInputDeviceRegistry.dispatchKeyEvent((int)112, (int)jfxKeyCode.impl_getCode(), null, (int)jfxModifiers);
                            AndroidInputDeviceRegistry.dispatchKeyEvent((int)113, (int)jfxKeyCode.impl_getCode(), null, (int)jfxModifiers);
                        }
                    }
                });
                break;
            }
            default: {
                System.err.println("DalvikInput.onKeyEvent Unknown Action " + event.getAction());
            }
        }
    }

    private static KeyCode mapAndroidKeyCodeToJfx(int keycode) {
        switch (keycode) {
            case 0: {
                return KeyCode.UNDEFINED;
            }
            case 3: {
                return KeyCode.HOME;
            }
            case 4: {
                return KeyCode.ESCAPE;
            }
            case 7: {
                return KeyCode.DIGIT0;
            }
            case 8: {
                return KeyCode.DIGIT1;
            }
            case 9: {
                return KeyCode.DIGIT2;
            }
            case 10: {
                return KeyCode.DIGIT3;
            }
            case 11: {
                return KeyCode.DIGIT4;
            }
            case 12: {
                return KeyCode.DIGIT5;
            }
            case 13: {
                return KeyCode.DIGIT6;
            }
            case 14: {
                return KeyCode.DIGIT7;
            }
            case 15: {
                return KeyCode.DIGIT8;
            }
            case 16: {
                return KeyCode.DIGIT9;
            }
            case 17: {
                return KeyCode.STAR;
            }
            case 18: {
                return KeyCode.POUND;
            }
            case 19: {
                return KeyCode.UP;
            }
            case 20: {
                return KeyCode.DOWN;
            }
            case 21: {
                return KeyCode.LEFT;
            }
            case 22: {
                return KeyCode.RIGHT;
            }
            case 24: {
                return KeyCode.VOLUME_UP;
            }
            case 25: {
                return KeyCode.VOLUME_DOWN;
            }
            case 26: {
                return KeyCode.POWER;
            }
            case 28: {
                return KeyCode.CLEAR;
            }
            case 29: {
                return KeyCode.A;
            }
            case 30: {
                return KeyCode.B;
            }
            case 31: {
                return KeyCode.C;
            }
            case 32: {
                return KeyCode.D;
            }
            case 33: {
                return KeyCode.E;
            }
            case 34: {
                return KeyCode.F;
            }
            case 35: {
                return KeyCode.G;
            }
            case 36: {
                return KeyCode.H;
            }
            case 37: {
                return KeyCode.I;
            }
            case 38: {
                return KeyCode.J;
            }
            case 39: {
                return KeyCode.K;
            }
            case 40: {
                return KeyCode.L;
            }
            case 41: {
                return KeyCode.M;
            }
            case 42: {
                return KeyCode.N;
            }
            case 43: {
                return KeyCode.O;
            }
            case 44: {
                return KeyCode.P;
            }
            case 45: {
                return KeyCode.Q;
            }
            case 46: {
                return KeyCode.R;
            }
            case 47: {
                return KeyCode.S;
            }
            case 48: {
                return KeyCode.T;
            }
            case 49: {
                return KeyCode.U;
            }
            case 50: {
                return KeyCode.V;
            }
            case 51: {
                return KeyCode.W;
            }
            case 52: {
                return KeyCode.X;
            }
            case 53: {
                return KeyCode.Y;
            }
            case 54: {
                return KeyCode.Z;
            }
            case 55: {
                return KeyCode.COMMA;
            }
            case 56: {
                return KeyCode.PERIOD;
            }
            case 57: {
                return KeyCode.ALT;
            }
            case 58: {
                return KeyCode.ALT;
            }
            case 59: {
                return KeyCode.SHIFT;
            }
            case 60: {
                return KeyCode.SHIFT;
            }
            case 61: {
                return KeyCode.TAB;
            }
            case 62: {
                return KeyCode.SPACE;
            }
            case 66: {
                return KeyCode.ENTER;
            }
            case 67: {
                return KeyCode.BACK_SPACE;
            }
            case 68: {
                return KeyCode.DEAD_GRAVE;
            }
            case 69: {
                return KeyCode.MINUS;
            }
            case 70: {
                return KeyCode.EQUALS;
            }
            case 71: {
                return KeyCode.BRACELEFT;
            }
            case 72: {
                return KeyCode.BRACERIGHT;
            }
            case 73: {
                return KeyCode.BACK_SLASH;
            }
            case 74: {
                return KeyCode.SEMICOLON;
            }
            case 76: {
                return KeyCode.SLASH;
            }
            case 77: {
                return KeyCode.AT;
            }
            case 81: {
                return KeyCode.PLUS;
            }
            case 82: {
                return KeyCode.CONTEXT_MENU;
            }
            case 84: {
                return KeyCode.FIND;
            }
            case 85: {
                return KeyCode.PLAY;
            }
            case 86: {
                return KeyCode.STOP;
            }
            case 87: {
                return KeyCode.TRACK_NEXT;
            }
            case 88: {
                return KeyCode.TRACK_PREV;
            }
            case 89: {
                return KeyCode.REWIND;
            }
            case 90: {
                return KeyCode.FAST_FWD;
            }
            case 91: {
                return KeyCode.MUTE;
            }
            case 92: {
                return KeyCode.PAGE_UP;
            }
            case 93: {
                return KeyCode.PAGE_DOWN;
            }
            case 96: {
                return KeyCode.GAME_A;
            }
            case 97: {
                return KeyCode.GAME_B;
            }
            case 98: {
                return KeyCode.GAME_C;
            }
            case 99: {
                return KeyCode.GAME_D;
            }
            case 110: {
                return KeyCode.MODECHANGE;
            }
            case 111: {
                return KeyCode.ESCAPE;
            }
            case 113: {
                return KeyCode.CONTROL;
            }
            case 114: {
                return KeyCode.CONTROL;
            }
            case 115: {
                return KeyCode.CAPS;
            }
            case 116: {
                return KeyCode.SCROLL_LOCK;
            }
            case 117: {
                return KeyCode.META;
            }
            case 118: {
                return KeyCode.META;
            }
            case 120: {
                return KeyCode.PRINTSCREEN;
            }
            case 121: {
                return KeyCode.PAUSE;
            }
            case 122: {
                return KeyCode.BEGIN;
            }
            case 123: {
                return KeyCode.END;
            }
            case 124: {
                return KeyCode.INSERT;
            }
            case 126: {
                return KeyCode.PLAY;
            }
            case 129: {
                return KeyCode.EJECT_TOGGLE;
            }
            case 130: {
                return KeyCode.RECORD;
            }
            case 131: {
                return KeyCode.F1;
            }
            case 132: {
                return KeyCode.F2;
            }
            case 133: {
                return KeyCode.F3;
            }
            case 134: {
                return KeyCode.F4;
            }
            case 135: {
                return KeyCode.F5;
            }
            case 136: {
                return KeyCode.F6;
            }
            case 137: {
                return KeyCode.F7;
            }
            case 138: {
                return KeyCode.F8;
            }
            case 139: {
                return KeyCode.F9;
            }
            case 140: {
                return KeyCode.F10;
            }
            case 141: {
                return KeyCode.F11;
            }
            case 142: {
                return KeyCode.F12;
            }
            case 143: {
                return KeyCode.NUM_LOCK;
            }
            case 144: {
                return KeyCode.NUMPAD0;
            }
            case 145: {
                return KeyCode.NUMPAD1;
            }
            case 146: {
                return KeyCode.NUMPAD2;
            }
            case 147: {
                return KeyCode.NUMPAD3;
            }
            case 148: {
                return KeyCode.NUMPAD4;
            }
            case 149: {
                return KeyCode.NUMPAD5;
            }
            case 150: {
                return KeyCode.NUMPAD6;
            }
            case 151: {
                return KeyCode.NUMPAD7;
            }
            case 152: {
                return KeyCode.NUMPAD8;
            }
            case 153: {
                return KeyCode.NUMPAD9;
            }
            case 154: {
                return KeyCode.DIVIDE;
            }
            case 155: {
                return KeyCode.MULTIPLY;
            }
            case 156: {
                return KeyCode.SUBTRACT;
            }
            case 157: {
                return KeyCode.ADD;
            }
            case 158: {
                return KeyCode.PERIOD;
            }
            case 159: {
                return KeyCode.COMMA;
            }
            case 160: {
                return KeyCode.ENTER;
            }
            case 161: {
                return KeyCode.EQUALS;
            }
            case 162: {
                return KeyCode.LEFT_PARENTHESIS;
            }
            case 163: {
                return KeyCode.RIGHT_PARENTHESIS;
            }
            case 164: {
                return KeyCode.MUTE;
            }
            case 165: {
                return KeyCode.INFO;
            }
            case 166: {
                return KeyCode.CHANNEL_UP;
            }
            case 167: {
                return KeyCode.CHANNEL_DOWN;
            }
            case 183: {
                return KeyCode.COLORED_KEY_0;
            }
            case 184: {
                return KeyCode.COLORED_KEY_1;
            }
            case 185: {
                return KeyCode.COLORED_KEY_2;
            }
            case 186: {
                return KeyCode.COLORED_KEY_3;
            }
            case 215: {
                return KeyCode.JAPANESE_HIRAGANA;
            }
            case 218: {
                return KeyCode.KANA;
            }
        }
        return KeyCode.UNDEFINED;
    }

    private static int mapAndroidModifierToJfx(int androidMetaStates) {
        int jfxModifiers = 0;
        if ((androidMetaStates & 0xC1) != 0) {
            ++jfxModifiers;
        }
        if ((androidMetaStates & 0x7000) != 0) {
            jfxModifiers += 4;
        }
        if ((androidMetaStates & 0x32) != 0) {
            jfxModifiers += 8;
        }
        if ((androidMetaStates & 0x10000) != 0) {
            jfxModifiers += 16;
        }
        return jfxModifiers;
    }
}

