/*
 * Decompiled with CFR 0.152.
 */
package javafxports.android;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Debug;
import android.os.Process;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javafxports.android.FXDalvikEntity;
import javafxports.android.Launcher;

public class FXActivity
extends Activity {
    private static final String TAG = "FXActivity";
    private static final String JFX_BUILD = "8u40-b2";
    private static final String ACTIVITY_LIB = "activity";
    private static final String META_DATA_LAUNCHER_CLASS = "launcher.class";
    private static final String DEFAULT_LAUNCHER_CLASS = "javafxports.android.DalvikLauncher";
    private static final String META_DATA_MAIN_CLASS = "main.class";
    private static final String META_DATA_PRELOADER_CLASS = "preloader.class";
    private static final String META_DATA_DEBUG_PORT = "debug.port";
    private static final String APPLICATION_DEX_NAME = "Application_dex.jar";
    private static final String APPLICATION_RESOURCES_NAME = "Application_resources.jar";
    private static final String CLASSLOADER_PROPERTIES_NAME = "classloader.properties";
    private static final String BUILD_TIME_NAME = "buildtime";
    private static final int BUF_SIZE = 8192;
    public static String dexClassPath = new String();
    private static FXActivity instance;
    private static Launcher launcher;
    private static FrameLayout mViewGroup;
    private static SurfaceView mView;
    private static boolean glassHasStarted;
    private static String appDataDir;
    private static DeviceConfiguration configuration;
    private Method onKeyEventMethod;
    private Method onSurfaceChangedNativeMethod1;
    private Method onSurfaceChangedNativeMethod2;
    private Method onSurfaceRedrawNeededNativeMethod;
    private Method onConfigurationChangedNativeMethod;
    private int SCREEN_ORIENTATION = 1;
    private String launcherClassName;
    private String mainClassName;
    private String preloaderClassName;
    private String currentBuildStamp;
    private Properties classLoaderProperties;
    private File dexInternalStoragePath;
    private static final Bundle metadata;
    private FXDalvikEntity fxDalvikEntity;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.fxDalvikEntity = new FXDalvikEntity(metadata, this);
        Log.v((String)TAG, (String)"onCreate called, Using 8u40-b2");
        if (launcher != null) {
            Log.v((String)TAG, (String)"JavaFX application is already running");
            return;
        }
        this.getWindow().requestFeature(1);
        this.getWindow().setSoftInputMode(0);
        this.getWindow().setFormat(1);
        mView = this.fxDalvikEntity.createView();
        mViewGroup = new FrameLayout((Context)this);
        mViewGroup.addView((View)mView);
        this.setContentView((View)mViewGroup);
        instance = this;
        this.dexInternalStoragePath = this.getDir("dex", 0);
        try {
            if (this.isUptodate()) {
                dexClassPath = (String)this.getClassLoaderProperties().get("classpath");
            } else {
                this.extractDexFiles(APPLICATION_DEX_NAME);
                this.copy(APPLICATION_RESOURCES_NAME);
                this.writeClassLoaderProperties();
            }
        }
        catch (FileNotFoundException e) {
            Log.v((String)TAG, (String)"Not found application dex and resources jars.", (Throwable)e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy a file.", e);
        }
        Log.v((String)TAG, (String)("Secondary dex file classpath " + dexClassPath));
        configuration = new DeviceConfiguration();
        configuration.setConfiguration(this.getResources().getConfiguration());
        Log.v((String)TAG, (String)String.format("Confiuration orientation: %s", configuration.orientation == 2 ? "LANDSCAPE" : (configuration.orientation == 1 ? "PORTRAIT" : "UNDEFINED")));
        appDataDir = this.getApplicationInfo().dataDir;
        instance = this;
        this._setDataDir(appDataDir);
        try {
            ApplicationInfo appi = this.getPackageManager().getApplicationInfo(this.getPackageName(), 128);
            if (appi != null && appi.metaData != null) {
                metadata.putAll(appi.metaData);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)TAG, (String)"Error getting Application info.");
        }
        try {
            ActivityInfo ai = this.getPackageManager().getActivityInfo(this.getIntent().getComponent(), 128);
            if (ai != null && ai.metaData != null) {
                metadata.putAll(ai.metaData);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)TAG, (String)"Error getting Activity info.");
        }
        int dport = metadata.getInt(META_DATA_DEBUG_PORT);
        if (dport > 0) {
            Debug.waitForDebugger();
        }
    }

    private boolean isUptodate() {
        try {
            String currentBuildTime = this.getCurrentBuildStamp();
            if (currentBuildTime == null) {
                return false;
            }
            Properties props = this.getClassLoaderProperties();
            if (props == null) {
                return false;
            }
            String extractedBuildTime = props.getProperty("buildStamp");
            return currentBuildTime.equals(extractedBuildTime);
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)("Failed to compare build timestamps. reason:" + e.getMessage()));
            return false;
        }
    }

    private String getCurrentBuildStamp() {
        if (this.currentBuildStamp == null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(this.getAssets().open(BUILD_TIME_NAME), "UTF-8"));
                this.currentBuildStamp = reader.readLine();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Failed to read build timestamp.", (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return this.currentBuildStamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getClassLoaderProperties() throws IOException {
        if (this.classLoaderProperties == null) {
            Properties props;
            BufferedReader reader = null;
            try {
                props = new Properties();
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(this.dexInternalStoragePath, CLASSLOADER_PROPERTIES_NAME)), "UTF-8"));
                props.load(reader);
            }
            catch (FileNotFoundException e) {
                Properties properties = null;
                return properties;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {}
                }
            }
            this.classLoaderProperties = props;
        }
        return this.classLoaderProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractDexFiles(String file) throws IOException {
        BufferedInputStream bis = null;
        ZipInputStream zis = null;
        try {
            ZipEntry ze;
            Log.v((String)TAG, (String)("extracting secondary dex files from '" + file + "' from asset resource to storage location"));
            bis = new BufferedInputStream(this.getAssets().open(file));
            zis = new ZipInputStream(bis);
            while ((ze = zis.getNextEntry()) != null) {
                if (!ze.getName().endsWith(".dex")) continue;
                OutputStream dexWriter = null;
                try {
                    int len;
                    File dexFile = new File(this.dexInternalStoragePath, ze.getName());
                    if (!dexClassPath.isEmpty()) {
                        dexClassPath = dexClassPath + File.pathSeparator;
                    }
                    dexClassPath = dexClassPath + dexFile.getAbsolutePath();
                    dexWriter = new BufferedOutputStream(new FileOutputStream(dexFile));
                    byte[] buf = new byte[8192];
                    while ((len = zis.read(buf, 0, 8192)) > 0) {
                        dexWriter.write(buf, 0, len);
                    }
                }
                finally {
                    if (dexWriter == null) continue;
                    dexWriter.close();
                }
            }
        }
        finally {
            try {
                if (zis != null) {
                    zis.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e2) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(String file) throws IOException, FileNotFoundException {
        FilterOutputStream writer = null;
        BufferedInputStream bis = null;
        Log.v((String)TAG, (String)("copy secondary resource file '" + file + "' from asset resource to storage location"));
        bis = new BufferedInputStream(this.getAssets().open(file));
        try {
            int len;
            File dexFile = new File(this.dexInternalStoragePath, file);
            if (!dexClassPath.isEmpty()) {
                dexClassPath = dexClassPath + File.pathSeparator;
            }
            dexClassPath = dexClassPath + dexFile.getAbsolutePath();
            writer = new BufferedOutputStream(new FileOutputStream(dexFile));
            byte[] buf = new byte[8192];
            while ((len = bis.read(buf, 0, 8192)) > 0) {
                ((BufferedOutputStream)writer).write(buf, 0, len);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeClassLoaderProperties() {
        Properties props = new Properties();
        props.put("classpath", dexClassPath);
        props.put("buildStamp", this.getCurrentBuildStamp());
        FilterOutputStream writer = null;
        File propertyFile = new File(this.dexInternalStoragePath, CLASSLOADER_PROPERTIES_NAME);
        Log.d((String)TAG, (String)("writing " + propertyFile.getAbsolutePath()));
        try {
            writer = new BufferedOutputStream(new FileOutputStream(propertyFile));
            props.store(writer, null);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("failed to write " + propertyFile.getAbsolutePath()), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void onDestroy() {
        Log.v((String)TAG, (String)"onDestroy");
        super.onDestroy();
        Process.killProcess((int)Process.myPid());
    }

    protected void onPause() {
        Log.v((String)TAG, (String)"onPause");
        super.onPause();
    }

    protected void onResume() {
        Log.v((String)TAG, (String)"onResume");
        super.onResume();
    }

    protected void onStart() {
        Log.v((String)TAG, (String)"onStart");
        super.onStart();
    }

    protected void onRestart() {
        Log.v((String)TAG, (String)"onRestart");
        super.onRestart();
    }

    protected void onStop() {
        Log.v((String)TAG, (String)"onStop");
        super.onStop();
    }

    public static FXActivity getInstance() {
        return instance;
    }

    public static ViewGroup getViewGroup() {
        return mViewGroup;
    }

    public static String getDataDir() {
        return appDataDir;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Log.v((String)TAG, (String)"Called onConfigurationChanged");
        configuration.setConfiguration(this.getResources().getConfiguration());
    }

    private native void _jfxEventsLoop();

    private native void _setDataDir(String var1);

    private native void _setSurface(Surface var1);

    static {
        glassHasStarted = false;
        metadata = new Bundle();
        System.loadLibrary(ACTIVITY_LIB);
    }

    class DeviceConfiguration {
        private static final int ORIENTATION_CHANGE = 1;
        private int change = 0;
        private int orientation;

        DeviceConfiguration() {
        }

        void setConfiguration(Configuration config) {
            if (this.orientation != config.orientation) {
                this.orientation = config.orientation;
                this.change |= 1;
            }
        }

        int getOrientation() {
            return this.orientation;
        }

        boolean isChanged() {
            return this.change > 0;
        }

        void dispatch() {
            if ((this.change & 1) > 0) {
                Log.v((String)FXActivity.TAG, (String)"Dispatching orientation change to");
                try {
                    FXActivity.this.onConfigurationChangedNativeMethod.invoke(null, FXActivity.this.SCREEN_ORIENTATION);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to invoke com.sun.glass.ui.android.DalvikInput.onConfigurationChangedNative method by reflection", e);
                }
            }
            this.change = 0;
        }
    }
}

