/*
 * Decompiled with CFR 0.152.
 */
package javafxports.android;

import android.app.Activity;
import android.content.pm.PackageManager;
import android.util.Log;
import com.sun.javafx.application.PlatformImpl;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import javafxports.android.FXDalvikEntity;
import javafxports.android.Launcher;

public class DalvikLauncher
implements Launcher {
    private static final String TAG = "DalvikLauncher";
    private static final String JAVAFX_APPLICATION_APPLICATION = "javafx.application.Application";
    private static final String COM_SUN_JAVAFX_APPLICATION_LAUNCHERIMPL = "com.sun.javafx.application.LauncherImpl";
    private static final String LAUNCH_APPLICATION_METHOD = "launchApplication";
    private static final String MAIN_METHOD = "main";
    private static final String ANDROID_PROPERTY_PREFIX = "android.";
    private static final String JAVAFX_PLATFORM_PROPERTIES = "javafx.platform.properties";
    private static final String JAVA_CUSTOM_PROPERTIES = "java.custom.properties";
    private static final Class[] LAUNCH_APPLICATION_ARGS = new Class[]{Class.class, Class.class, new String[0].getClass()};
    private static final Class[] MAIN_METHOD_ARGS = new Class[]{new String[0].getClass()};
    private static boolean fxApplicationLaunched = false;
    private static boolean fxApplicationLaunching = false;
    private Activity activity;
    private String preloaderClassName;
    private String mainClassName;
    private FXDalvikEntity fxDalvikEntity;
    private static ClassLoader applicationClassLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void launchApp(FXDalvikEntity fxDalvikEntity, String mainClassName, String preloaderClassName) {
        this.fxDalvikEntity = fxDalvikEntity;
        this.activity = fxDalvikEntity.getActivity();
        this.preloaderClassName = preloaderClassName;
        this.mainClassName = mainClassName;
        InputStream isJavafxPlatformProperties = null;
        try {
            isJavafxPlatformProperties = DalvikLauncher.class.getResourceAsStream("/javafx.platform.properties");
            if (isJavafxPlatformProperties == null) {
                throw new RuntimeException("Could not find /javafx.platform.properties on classpath.");
            }
            Properties javafxPlatformProperties = new Properties();
            javafxPlatformProperties.load(isJavafxPlatformProperties);
            for (Map.Entry<Object, Object> e : javafxPlatformProperties.entrySet()) {
                String string = (String)e.getKey();
                System.setProperty(string.startsWith(ANDROID_PROPERTY_PREFIX) ? string.substring(ANDROID_PROPERTY_PREFIX.length()) : string, (String)e.getValue());
            }
        }
        catch (IOException e) {
            Log.v((String)TAG, (String)"Can't load javafx.platform.properties");
            throw new RuntimeException("Can't load javafx.platform.properties", e);
        }
        finally {
            try {
                if (isJavafxPlatformProperties != null) {
                    isJavafxPlatformProperties.close();
                }
            }
            catch (Exception e) {
                Log.v((String)TAG, (String)"Exception closing javafx.platform.properties InputStream");
            }
        }
        InputStream isJavaCustomProperties = null;
        try {
            isJavaCustomProperties = DalvikLauncher.class.getResourceAsStream("/java.custom.properties");
            if (isJavaCustomProperties != null) {
                Properties javaCustomProperties = new Properties();
                javaCustomProperties.load(isJavaCustomProperties);
                for (Map.Entry entry : javaCustomProperties.entrySet()) {
                    System.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Can't load java.custom.properties", (Throwable)e);
        }
        finally {
            if (isJavaCustomProperties != null) {
                try {
                    isJavaCustomProperties.close();
                }
                catch (IOException e) {
                    Log.v((String)TAG, (String)"Exception closing java.custom.properties InputStream", (Throwable)e);
                }
            }
        }
        System.getProperties().list(System.out);
        Log.v((String)TAG, (String)"Launch JavaFX application on DALVIK vm.");
        try {
            this.initMethodHandles();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to init method handles", e);
        }
        try {
            final Class applicationClass = this.resolveApplicationClass();
            final Class preloaderClass = this.resolvePreloaderClass();
            final Class<?> clazz = this.getApplicationClassLoader().loadClass(JAVAFX_APPLICATION_APPLICATION);
            Class<?> javafxLauncherClass = this.getApplicationClassLoader().loadClass(COM_SUN_JAVAFX_APPLICATION_LAUNCHERIMPL);
            final Method launchMethod = javafxLauncherClass.getMethod(LAUNCH_APPLICATION_METHOD, LAUNCH_APPLICATION_ARGS);
            Log.v((String)TAG, (String)String.format("application class: [%s]\npreloader class: [%s]\njavafx application class: [%s]\njavafx launcher class: [%s]\nlaunch application method: [%s]", applicationClass, preloaderClass, clazz, javafxLauncherClass, launchMethod));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    fxApplicationLaunching = true;
                    try {
                        if (clazz.isAssignableFrom(applicationClass)) {
                            launchMethod.invoke(null, applicationClass, preloaderClass, new String[0]);
                        } else {
                            Method mainMethod = applicationClass.getMethod(DalvikLauncher.MAIN_METHOD, MAIN_METHOD_ARGS);
                            mainMethod.invoke(null, new Object[]{new String[0]});
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    fxApplicationLaunched = true;
                    fxApplicationLaunching = false;
                }
            }, "Prelauncher Thread").start();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Launch failed with exception.", (Throwable)e);
        }
    }

    private ClassLoader getApplicationClassLoader() {
        return this.getClass().getClassLoader();
    }

    private void initMethodHandles() throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        Class<?> androidInputDeviceRegistry = this.getApplicationClassLoader().loadClass("com.sun.glass.ui.monocle.AndroidInputDeviceRegistry");
        Method registerDevice = androidInputDeviceRegistry.getMethod("registerDevice", new Class[0]);
        this.fxDalvikEntity.setInitializeMonocleMethod(registerDevice);
        Class<?> dalvikInputClass = this.getApplicationClassLoader().loadClass("com.sun.glass.ui.android.DalvikInput");
        this.fxDalvikEntity.setOnMultiTouchEventMethod(dalvikInputClass.getMethod("onMultiTouchEvent", Integer.TYPE, int[].class, int[].class, int[].class, int[].class));
        this.fxDalvikEntity.setOnKeyEventMethod(dalvikInputClass.getMethod("onKeyEvent", Integer.TYPE, Integer.TYPE, String.class));
        this.fxDalvikEntity.setOnGlobalLayoutChangedMethod(dalvikInputClass.getMethod("onGlobalLayoutChanged", new Class[0]));
        this.fxDalvikEntity.setOnSurfaceChangedNativeMethod1(dalvikInputClass.getMethod("onSurfaceChangedNative", new Class[0]));
        this.fxDalvikEntity.setOnSurfaceChangedNativeMethod2(dalvikInputClass.getMethod("onSurfaceChangedNative", Integer.TYPE, Integer.TYPE, Integer.TYPE));
        this.fxDalvikEntity.setOnSurfaceRedrawNeededNativeMethod(dalvikInputClass.getMethod("onSurfaceRedrawNeededNative", new Class[0]));
        this.fxDalvikEntity.setOnConfigurationChangedNativeMethod(dalvikInputClass.getMethod("onConfigurationChangedNative", Integer.TYPE));
        Class<?> androidAcceleratedScreen = this.getApplicationClassLoader().loadClass("com.sun.glass.ui.monocle.AndroidAcceleratedScreen");
        this.fxDalvikEntity.setOnSurfaceCreatedMethod(androidAcceleratedScreen.getMethod("createEglSurface", new Class[0]));
        boolean hasAccessToFXClasses = false;
        try {
            this.registerExitListener();
            Log.v((String)TAG, (String)"We have JavaFX on our current (base) classpath, registered exit listener");
        }
        catch (Throwable t) {
            Log.v((String)TAG, (String)"No JavaFX on our current (base) classpath, don't register exit listener");
            t.printStackTrace();
        }
    }

    private void registerExitListener() {
        PlatformImpl.FinishListener l = new PlatformImpl.FinishListener(){

            public void idle(boolean implicitExit) {
                Log.v((String)DalvikLauncher.TAG, (String)("FinishListener idle called with exit = " + implicitExit));
                DalvikLauncher.this.activity.finish();
            }

            public void exitCalled() {
                Log.v((String)DalvikLauncher.TAG, (String)"FinishListener exit called");
                DalvikLauncher.this.activity.finish();
            }
        };
        PlatformImpl.addListener((PlatformImpl.FinishListener)l);
    }

    private Class resolveApplicationClass() throws PackageManager.NameNotFoundException, ClassNotFoundException {
        ClassLoader cl = this.getApplicationClassLoader();
        Class<?> clazz = null;
        if (this.mainClassName != null && this.mainClassName.length() > 0) {
            clazz = cl.loadClass(this.mainClassName);
        }
        Thread.currentThread().setContextClassLoader(cl);
        return clazz;
    }

    private Class resolvePreloaderClass() throws PackageManager.NameNotFoundException, ClassNotFoundException {
        ClassLoader cl = this.getApplicationClassLoader();
        Class<?> clazz = null;
        if (this.preloaderClassName != null && this.preloaderClassName.length() > 0) {
            clazz = cl.loadClass(this.preloaderClassName);
        }
        return clazz;
    }
}

