package org.ivoa.tap.schema;

/**
 * the column.
 *
 * <p>objectType: Column
 *
 * @author generated by https://github.com/ivoa/vo-dml tools
 */
@jakarta.persistence.Entity
@jakarta.persistence.Table(name = "columns")
@jakarta.persistence.NamedQueries({
  @jakarta.persistence.NamedQuery(
      name = "Column.findById",
      query = "SELECT o FROM Column o WHERE o.column_name = :id")
})
@jakarta.xml.bind.annotation.XmlAccessorType(jakarta.xml.bind.annotation.XmlAccessType.NONE)
@jakarta.xml.bind.annotation.XmlType(name = "column")
@com.fasterxml.jackson.annotation.JsonTypeInfo(
    use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NONE)
@com.fasterxml.jackson.annotation.JsonIdentityInfo(
    property = "column_name",
    generator = com.fasterxml.jackson.annotation.ObjectIdGenerators.PropertyGenerator.class,
    scope = org.ivoa.tap.schema.Column.class)
@org.ivoa.vodml.annotation.VoDml(
    id = "tapschema:column",
    role = org.ivoa.vodml.annotation.VodmlRole.objectType)
@org.eclipse.microprofile.openapi.annotations.media.Schema(description = "the column")
public class Column
    implements org.ivoa.vodml.jpa.JPAManipulationsForObjectType<String>,
        org.ivoa.vodml.jaxb.XmlIdManagement {

  /** name of the column. : Attribute column_name : multiplicity 1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:column.column_name",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:string",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "name of the column")
  @jakarta.xml.bind.annotation.XmlElement(
      name = "column_name",
      required = true,
      type = String.class)
  @jakarta.xml.bind.annotation.XmlID
  @jakarta.persistence.Id
  @jakarta.persistence.Basic(optional = false)
  @jakarta.persistence.Column(name = "column_name", nullable = false)
  protected String column_name;

  /** the type of the column (VOTable semantics). : Attribute datatype : multiplicity 1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:column.datatype",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "tapschema:TAPType",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.enumeration)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(
      description = "the type of the column (VOTable semantics)")
  @jakarta.xml.bind.annotation.XmlElement(
      name = "datatype",
      required = true,
      type = org.ivoa.tap.schema.TAPType.class)
  @jakarta.persistence.Basic(optional = false)
  @jakarta.persistence.Enumerated(jakarta.persistence.EnumType.STRING)
  @jakarta.persistence.Column(name = "datatype", nullable = false)
  protected org.ivoa.tap.schema.TAPType datatype;

  /** . : Attribute arraysize : multiplicity 0..1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:column.arraysize",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:string",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "")
  @jakarta.xml.bind.annotation.XmlElement(name = "arraysize", required = false, type = String.class)
  @jakarta.persistence.Basic(optional = true)
  @jakarta.persistence.Column(name = "arraysize", nullable = true)
  protected String arraysize;

  /** . : Attribute xtype : multiplicity 0..1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:column.xtype",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:string",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "")
  @jakarta.xml.bind.annotation.XmlElement(name = "xtype", required = false, type = String.class)
  @jakarta.persistence.Basic(optional = true)
  @jakarta.persistence.Column(name = "xtype", nullable = true)
  protected String xtype;

  /** . : Attribute description : multiplicity 0..1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:column.description",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:string",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "")
  @jakarta.xml.bind.annotation.XmlElement(
      name = "description",
      required = false,
      type = String.class)
  @jakarta.persistence.Basic(optional = true)
  @jakarta.persistence.Column(name = "description", nullable = true)
  protected String description;

  /** . : Attribute utype : multiplicity 0..1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:column.utype",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:string",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "")
  @jakarta.xml.bind.annotation.XmlElement(name = "utype", required = false, type = String.class)
  @jakarta.persistence.Basic(optional = true)
  @jakarta.persistence.Column(name = "utype", nullable = true)
  protected String utype;

  /** . : Attribute unit : multiplicity 0..1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:column.unit",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:string",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "")
  @jakarta.xml.bind.annotation.XmlElement(name = "unit", required = false, type = String.class)
  @jakarta.persistence.Basic(optional = true)
  @jakarta.persistence.Column(name = "unit", nullable = true)
  protected String unit;

  /** . : Attribute ucd : multiplicity 0..1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:column.ucd",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:string",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "")
  @jakarta.xml.bind.annotation.XmlElement(name = "ucd", required = false, type = String.class)
  @jakarta.persistence.Basic(optional = true)
  @jakarta.persistence.Column(name = "ucd", nullable = true)
  protected String ucd;

  /** does the column have an index. : Attribute indexed : multiplicity 1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:column.indexed",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:boolean",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(
      description = "does the column have an index")
  @jakarta.xml.bind.annotation.XmlElement(name = "indexed", required = true, type = Boolean.class)
  @jakarta.persistence.Basic(optional = false)
  @jakarta.persistence.Column(name = "indexed", nullable = false)
  protected Boolean indexed;

  /**
   * indicates that the column is considered a core part of the content; clients can use this hint
   * to make the principal column(s) visible, for example by selecting them by default in generating
   * an ADQL query. In cases where the service selects the columns to return (such as a query
   * language without an explicit output selection), the principal column indicates those columns
   * that are returned by default. : Attribute principal : multiplicity 1
   */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:column.principal",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:boolean",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(
      description =
          "indicates that the column is considered a core part of the content; clients can use this hint to make the principal column(s) visible, for example by selecting them by default in generating an ADQL query. In cases where the service selects the columns to return (such as a query language without an explicit output selection), the principal column indicates those columns that are returned by default")
  @jakarta.xml.bind.annotation.XmlElement(name = "principal", required = true, type = Boolean.class)
  @jakarta.persistence.Basic(optional = false)
  @jakarta.persistence.Column(name = "principal", nullable = false)
  protected Boolean principal;

  /** is the column defined by a standard. : Attribute std : multiplicity 1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:column.std",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:boolean",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(
      description = "is the column defined by a standard")
  @jakarta.xml.bind.annotation.XmlElement(name = "std", required = true, type = Boolean.class)
  @jakarta.persistence.Basic(optional = false)
  @jakarta.persistence.Column(name = "std", nullable = false)
  protected Boolean std;

  /**
   * used to recommend table ordering for clients. Clients may order by index (ascending) so lower
   * index items would appear earlier in a listing. : Attribute column_index : multiplicity 0..1
   */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:column.column_index",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:integer",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(
      description =
          "used to recommend table ordering for clients. Clients may order by index (ascending) so lower index items would appear earlier in a listing.")
  @jakarta.xml.bind.annotation.XmlElement(
      name = "column_index",
      required = false,
      type = Integer.class)
  @jakarta.persistence.Basic(optional = true)
  @jakarta.persistence.Column(name = "column_index", nullable = true)
  protected Integer column_index;

  /** Creates a new column */
  public Column() {
    super();
  }

  /**
   * full parameter constructor.
   *
   * @param column_name name of the column.
   * @param datatype the type of the column (VOTable semantics).
   * @param arraysize .
   * @param xtype .
   * @param description .
   * @param utype .
   * @param unit .
   * @param ucd .
   * @param indexed does the column have an index.
   * @param principal indicates that the column is considered a core part of the content; clients
   *     can use this hint to make the principal column(s) visible, for example by selecting them by
   *     default in generating an ADQL query. In cases where the service selects the columns to
   *     return (such as a query language without an explicit output selection), the principal
   *     column indicates those columns that are returned by default.
   * @param std is the column defined by a standard.
   * @param column_index used to recommend table ordering for clients. Clients may order by index
   *     (ascending) so lower index items would appear earlier in a listing.
   */
  public Column(
      final String column_name,
      final org.ivoa.tap.schema.TAPType datatype,
      final String arraysize,
      final String xtype,
      final String description,
      final String utype,
      final String unit,
      final String ucd,
      final Boolean indexed,
      final Boolean principal,
      final Boolean std,
      final Integer column_index) {
    super();

    this.column_name = column_name;

    this.datatype = datatype;

    this.arraysize = arraysize;

    this.xtype = xtype;

    this.description = description;

    this.utype = utype;

    this.unit = unit;

    this.ucd = ucd;

    this.indexed = indexed;

    this.principal = principal;

    this.std = std;

    this.column_index = column_index;
  }

  /**
   * Copy Constructor. Note that references will remain as is rather than be copied.
   *
   * @param other the object to be copied.
   */
  public Column(final Column other) {

    super();

    this.column_name = other.column_name;

    this.datatype = other.datatype;

    this.arraysize = other.arraysize;

    this.xtype = other.xtype;

    this.description = other.description;

    this.utype = other.utype;

    this.unit = other.unit;

    this.ucd = other.ucd;

    this.indexed = other.indexed;

    this.principal = other.principal;

    this.std = other.std;

    this.column_index = other.column_index;
  }

  /**
   * Update this object with the content of the given object. Note that references will remain as is
   * rather than be copied.
   *
   * @param other the object to be copied.
   */
  public void updateUsing(final Column other) {

    this.column_name = other.column_name;

    this.datatype = other.datatype;

    this.arraysize = other.arraysize;

    this.xtype = other.xtype;

    this.description = other.description;

    this.utype = other.utype;

    this.unit = other.unit;

    this.ucd = other.ucd;

    this.indexed = other.indexed;

    this.principal = other.principal;

    this.std = other.std;

    this.column_index = other.column_index;
  }

  /**
   * Returns column_name Attribute.
   *
   * @return column_name Attribute
   */
  public String getColumn_name() {
    return (String) this.column_name;
  }

  /**
   * Set column_name Attribute.
   *
   * @param pColumn_name value to set
   */
  public void setColumn_name(final String pColumn_name) {

    this.column_name = pColumn_name;
  }

  /**
   * fluent setter for column_name Attribute.
   *
   * @param pColumn_name value to set
   * @return column
   */
  public org.ivoa.tap.schema.Column withColumn_name(final String pColumn_name) {
    setColumn_name(pColumn_name);
    return this;
  }

  /**
   * Returns datatype Attribute.
   *
   * @return datatype Attribute
   */
  public org.ivoa.tap.schema.TAPType getDatatype() {
    return (org.ivoa.tap.schema.TAPType) this.datatype;
  }

  /**
   * Set datatype Attribute.
   *
   * @param pDatatype value to set
   */
  public void setDatatype(final org.ivoa.tap.schema.TAPType pDatatype) {

    this.datatype = pDatatype;
  }

  /**
   * fluent setter for datatype Attribute.
   *
   * @param pDatatype value to set
   * @return column
   */
  public org.ivoa.tap.schema.Column withDatatype(final org.ivoa.tap.schema.TAPType pDatatype) {
    setDatatype(pDatatype);
    return this;
  }

  /**
   * Returns arraysize Attribute.
   *
   * @return arraysize Attribute
   */
  public String getArraysize() {
    return (String) this.arraysize;
  }

  /**
   * Set arraysize Attribute.
   *
   * @param pArraysize value to set
   */
  public void setArraysize(final String pArraysize) {

    this.arraysize = pArraysize;
  }

  /**
   * fluent setter for arraysize Attribute.
   *
   * @param pArraysize value to set
   * @return column
   */
  public org.ivoa.tap.schema.Column withArraysize(final String pArraysize) {
    setArraysize(pArraysize);
    return this;
  }

  /**
   * Returns xtype Attribute.
   *
   * @return xtype Attribute
   */
  public String getXtype() {
    return (String) this.xtype;
  }

  /**
   * Set xtype Attribute.
   *
   * @param pXtype value to set
   */
  public void setXtype(final String pXtype) {

    this.xtype = pXtype;
  }

  /**
   * fluent setter for xtype Attribute.
   *
   * @param pXtype value to set
   * @return column
   */
  public org.ivoa.tap.schema.Column withXtype(final String pXtype) {
    setXtype(pXtype);
    return this;
  }

  /**
   * Returns description Attribute.
   *
   * @return description Attribute
   */
  public String getDescription() {
    return (String) this.description;
  }

  /**
   * Set description Attribute.
   *
   * @param pDescription value to set
   */
  public void setDescription(final String pDescription) {

    this.description = pDescription;
  }

  /**
   * fluent setter for description Attribute.
   *
   * @param pDescription value to set
   * @return column
   */
  public org.ivoa.tap.schema.Column withDescription(final String pDescription) {
    setDescription(pDescription);
    return this;
  }

  /**
   * Returns utype Attribute.
   *
   * @return utype Attribute
   */
  public String getUtype() {
    return (String) this.utype;
  }

  /**
   * Set utype Attribute.
   *
   * @param pUtype value to set
   */
  public void setUtype(final String pUtype) {

    this.utype = pUtype;
  }

  /**
   * fluent setter for utype Attribute.
   *
   * @param pUtype value to set
   * @return column
   */
  public org.ivoa.tap.schema.Column withUtype(final String pUtype) {
    setUtype(pUtype);
    return this;
  }

  /**
   * Returns unit Attribute.
   *
   * @return unit Attribute
   */
  public String getUnit() {
    return (String) this.unit;
  }

  /**
   * Set unit Attribute.
   *
   * @param pUnit value to set
   */
  public void setUnit(final String pUnit) {

    this.unit = pUnit;
  }

  /**
   * fluent setter for unit Attribute.
   *
   * @param pUnit value to set
   * @return column
   */
  public org.ivoa.tap.schema.Column withUnit(final String pUnit) {
    setUnit(pUnit);
    return this;
  }

  /**
   * Returns ucd Attribute.
   *
   * @return ucd Attribute
   */
  public String getUcd() {
    return (String) this.ucd;
  }

  /**
   * Set ucd Attribute.
   *
   * @param pUcd value to set
   */
  public void setUcd(final String pUcd) {

    this.ucd = pUcd;
  }

  /**
   * fluent setter for ucd Attribute.
   *
   * @param pUcd value to set
   * @return column
   */
  public org.ivoa.tap.schema.Column withUcd(final String pUcd) {
    setUcd(pUcd);
    return this;
  }

  /**
   * Returns indexed Attribute.
   *
   * @return indexed Attribute
   */
  public Boolean getIndexed() {
    return (Boolean) this.indexed;
  }

  /**
   * Set indexed Attribute.
   *
   * @param pIndexed value to set
   */
  public void setIndexed(final Boolean pIndexed) {

    this.indexed = pIndexed;
  }

  /**
   * fluent setter for indexed Attribute.
   *
   * @param pIndexed value to set
   * @return column
   */
  public org.ivoa.tap.schema.Column withIndexed(final Boolean pIndexed) {
    setIndexed(pIndexed);
    return this;
  }

  /**
   * Returns principal Attribute.
   *
   * @return principal Attribute
   */
  public Boolean getPrincipal() {
    return (Boolean) this.principal;
  }

  /**
   * Set principal Attribute.
   *
   * @param pPrincipal value to set
   */
  public void setPrincipal(final Boolean pPrincipal) {

    this.principal = pPrincipal;
  }

  /**
   * fluent setter for principal Attribute.
   *
   * @param pPrincipal value to set
   * @return column
   */
  public org.ivoa.tap.schema.Column withPrincipal(final Boolean pPrincipal) {
    setPrincipal(pPrincipal);
    return this;
  }

  /**
   * Returns std Attribute.
   *
   * @return std Attribute
   */
  public Boolean getStd() {
    return (Boolean) this.std;
  }

  /**
   * Set std Attribute.
   *
   * @param pStd value to set
   */
  public void setStd(final Boolean pStd) {

    this.std = pStd;
  }

  /**
   * fluent setter for std Attribute.
   *
   * @param pStd value to set
   * @return column
   */
  public org.ivoa.tap.schema.Column withStd(final Boolean pStd) {
    setStd(pStd);
    return this;
  }

  /**
   * Returns column_index Attribute.
   *
   * @return column_index Attribute
   */
  public Integer getColumn_index() {
    return (Integer) this.column_index;
  }

  /**
   * Set column_index Attribute.
   *
   * @param pColumn_index value to set
   */
  public void setColumn_index(final Integer pColumn_index) {

    this.column_index = pColumn_index;
  }

  /**
   * fluent setter for column_index Attribute.
   *
   * @param pColumn_index value to set
   * @return column
   */
  public org.ivoa.tap.schema.Column withColumn_index(final Integer pColumn_index) {
    setColumn_index(pColumn_index);
    return this;
  }

  @Override
  public String getXmlId() {
    return column_name;
  }

  @Override
  public void setXmlId(String id) {
    this.column_name = id;
  }

  @Override
  public boolean hasNaturalKey() {
    return true;
  }

  /**
   * return the database key id. Note that this is the same as attribute column_name.
   *
   * @return the id
   */
  @Override
  public String getId() {
    return column_name;
  }

  /** A builder class for column, mainly for use in the functional builder pattern. */
  public static class ColumnBuilder {

    /** name of the column. */
    public String column_name;

    /** the type of the column (VOTable semantics). */
    public org.ivoa.tap.schema.TAPType datatype;

    /** . */
    public String arraysize;

    /** . */
    public String xtype;

    /** . */
    public String description;

    /** . */
    public String utype;

    /** . */
    public String unit;

    /** . */
    public String ucd;

    /** does the column have an index. */
    public Boolean indexed;

    /**
     * indicates that the column is considered a core part of the content; clients can use this hint
     * to make the principal column(s) visible, for example by selecting them by default in
     * generating an ADQL query. In cases where the service selects the columns to return (such as a
     * query language without an explicit output selection), the principal column indicates those
     * columns that are returned by default.
     */
    public Boolean principal;

    /** is the column defined by a standard. */
    public Boolean std;

    /**
     * used to recommend table ordering for clients. Clients may order by index (ascending) so lower
     * index items would appear earlier in a listing.
     */
    public Integer column_index;

    private ColumnBuilder with(java.util.function.Consumer<ColumnBuilder> f) {
      f.accept(this);
      return this;
    }
    /**
     * create a column from this builder.
     *
     * @return an object initialized from the builder.
     */
    public Column create() {
      return new Column(
          column_name,
          datatype,
          arraysize,
          xtype,
          description,
          utype,
          unit,
          ucd,
          indexed,
          principal,
          std,
          column_index);
    }
  }
  /**
   * create a column in functional builder style.
   *
   * @param f the functional builder.
   * @return an object initialized from the builder.
   */
  public static Column createColumn(java.util.function.Consumer<ColumnBuilder> f) {
    return new ColumnBuilder().with(f).create();
  }

  @Override
  public void forceLoad() {}

  /**
   * {@inheritDoc}
   *
   * @deprecated generally better to use the model level reference persistence as only this can deal
   *     with "contained" references properly.
   */
  @Override
  @Deprecated
  public void persistRefs(jakarta.persistence.EntityManager _em) {

    _em.persist(this);
  }

  /** {@inheritDoc} */
  @Override
  public void delete(jakarta.persistence.EntityManager em) {

    em.remove(this); // nothing special to do
  }
}
