/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.tap.schema;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.ivoa.tap.schema.Column;
import org.ivoa.tap.schema.ForeignKey;
import org.ivoa.tap.schema.TableType;
import org.ivoa.vodml.ModelContext;
import org.ivoa.vodml.annotation.VoDml;
import org.ivoa.vodml.annotation.VodmlRole;
import org.ivoa.vodml.jaxb.XmlIdManagement;
import org.ivoa.vodml.jpa.JPAManipulationsForObjectType;
import org.ivoa.vodml.nav.ReferenceCache;

@Entity
@jakarta.persistence.Table(name="tables")
@NamedQueries(value={@NamedQuery(name="Table.findById", query="SELECT o FROM Table o WHERE o.table_name = :id")})
@NamedEntityGraph(name="Table_loadAll", attributeNodes={@NamedAttributeNode(value="columns"), @NamedAttributeNode(value="fkeys")})
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="table")
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
@JsonIdentityInfo(property="table_name", generator=ObjectIdGenerators.PropertyGenerator.class, scope=Table.class)
@VoDml(id="tapschema:table", role=VodmlRole.objectType)
@Schema(description="The table")
public class Table
implements JPAManipulationsForObjectType<String>,
XmlIdManagement {
    @VoDml(id="tapschema:table.table_name", role=VodmlRole.attribute, type="ivoa:string", typeRole=VodmlRole.primitiveType)
    @Schema(description="name of the table")
    @XmlElement(name="table_name", required=true, type=String.class)
    @XmlID
    @Id
    @Basic(optional=false)
    @jakarta.persistence.Column(name="table_name", nullable=false)
    protected String table_name;
    @VoDml(id="tapschema:table.table_type", role=VodmlRole.attribute, type="tapschema:TableType", typeRole=VodmlRole.enumeration)
    @Schema(description="the type of table")
    @XmlElement(name="table_type", required=true, type=TableType.class)
    @Basic(optional=false)
    @Enumerated(value=EnumType.STRING)
    @jakarta.persistence.Column(name="table_type", nullable=false)
    protected TableType table_type;
    @VoDml(id="tapschema:table.utype", role=VodmlRole.attribute, type="ivoa:string", typeRole=VodmlRole.primitiveType)
    @Schema(description="utype")
    @XmlElement(name="utype", required=false, type=String.class)
    @Basic(optional=true)
    @jakarta.persistence.Column(name="utype", nullable=true)
    protected String utype;
    @VoDml(id="tapschema:table.description", role=VodmlRole.attribute, type="ivoa:string", typeRole=VodmlRole.primitiveType)
    @Schema(description="description")
    @XmlElement(name="description", required=false, type=String.class)
    @Basic(optional=true)
    @jakarta.persistence.Column(name="description", nullable=true)
    protected String description;
    @VoDml(id="tapschema:table.table_index", role=VodmlRole.attribute, type="ivoa:integer", typeRole=VodmlRole.primitiveType)
    @Schema(description="used to recommend table ordering for clients. Clients may order by index (ascending) so lower index items would appear earlier in a listing.")
    @XmlElement(name="table_index", required=false, type=Integer.class)
    @Basic(optional=true)
    @jakarta.persistence.Column(name="table_index", nullable=true)
    protected Integer table_index;
    @XmlElementWrapper(name="columns")
    @XmlElement(name="column", required=true, type=Column.class)
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, targetEntity=Column.class)
    @JoinColumn(name="table_name")
    @Fetch(value=FetchMode.SUBSELECT)
    @VoDml(id="tapschema:table.columns", role=VodmlRole.composition, type="tapschema:column", typeRole=VodmlRole.objectType)
    @Schema(description="the columns that make up the table")
    protected List<Column> columns = new ArrayList<Column>();
    @XmlElementWrapper(name="fkeys")
    @XmlElement(name="foreignKey", required=false, type=ForeignKey.class)
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, targetEntity=ForeignKey.class)
    @JoinColumn(name="table_name")
    @Fetch(value=FetchMode.SUBSELECT)
    @VoDml(id="tapschema:table.fkeys", role=VodmlRole.composition, type="tapschema:ForeignKey", typeRole=VodmlRole.objectType)
    @Schema(description="the foreign keys for this table")
    protected List<ForeignKey> fkeys = new ArrayList<ForeignKey>();

    public Table() {
    }

    public Table(String table_name, TableType table_type, String utype, String description, Integer table_index, List<Column> columns, List<ForeignKey> fkeys) {
        this.table_name = table_name;
        this.table_type = table_type;
        this.utype = utype;
        this.description = description;
        this.table_index = table_index;
        this.columns = columns;
        this.fkeys = fkeys;
    }

    public void updateClonedReferences() {
        if (this.fkeys != null) {
            for (ForeignKey _x : this.fkeys) {
                _x.updateClonedReferences();
            }
        }
    }

    public Table(Table other) {
        this.table_name = other.table_name;
        this.table_type = other.table_type;
        this.utype = other.utype;
        this.description = other.description;
        this.table_index = other.table_index;
        if (other.columns != null) {
            ReferenceCache cache = ModelContext.current().cache(Column.class);
            List cloned = other.columns.stream().map(s -> new Column((Column)s)).collect(Collectors.toList());
            cache.setValues(other.columns, cloned);
            this.columns = cloned;
        }
        if (other.fkeys != null) {
            this.fkeys = other.fkeys.stream().map(s -> new ForeignKey((ForeignKey)s)).collect(Collectors.toList());
        }
    }

    public void updateUsing(Table other) {
        this.table_name = other.table_name;
        this.table_type = other.table_type;
        this.utype = other.utype;
        this.description = other.description;
        this.table_index = other.table_index;
        if (other.columns != null) {
            ReferenceCache cache = ModelContext.current().cache(Column.class);
            List cloned = other.columns.stream().map(s -> new Column((Column)s)).collect(Collectors.toList());
            cache.setValues(other.columns, cloned);
            this.columns = cloned;
        }
        if (other.fkeys != null) {
            this.fkeys = other.fkeys.stream().map(s -> new ForeignKey((ForeignKey)s)).collect(Collectors.toList());
        }
    }

    public String getTable_name() {
        return this.table_name;
    }

    public void setTable_name(String pTable_name) {
        this.table_name = pTable_name;
    }

    public Table withTable_name(String pTable_name) {
        this.setTable_name(pTable_name);
        return this;
    }

    public TableType getTable_type() {
        return this.table_type;
    }

    public void setTable_type(TableType pTable_type) {
        this.table_type = pTable_type;
    }

    public Table withTable_type(TableType pTable_type) {
        this.setTable_type(pTable_type);
        return this;
    }

    public String getUtype() {
        return this.utype;
    }

    public void setUtype(String pUtype) {
        this.utype = pUtype;
    }

    public Table withUtype(String pUtype) {
        this.setUtype(pUtype);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String pDescription) {
        this.description = pDescription;
    }

    public Table withDescription(String pDescription) {
        this.setDescription(pDescription);
        return this;
    }

    public Integer getTable_index() {
        return this.table_index;
    }

    public void setTable_index(Integer pTable_index) {
        this.table_index = pTable_index;
    }

    public Table withTable_index(Integer pTable_index) {
        this.setTable_index(pTable_index);
        return this;
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.columns != null ? this.columns : new ArrayList());
    }

    public void setColumns(List<Column> pColumns) {
        this.columns = pColumns;
    }

    public void addToColumns(Column p) {
        if (this.columns == null) {
            this.columns = new ArrayList<Column>();
        }
        this.columns.add(p);
    }

    public void removeFromColumns(Column p) {
        if (this.columns != null) {
            this.columns.remove(p);
        }
    }

    public void replaceInColumns(Column _p) {
        if (this.columns != null) {
            for (Column _l : this.columns) {
                if (!_l.getId().equals(_p.getId())) continue;
                _l.updateUsing(_p);
                return;
            }
            throw new IllegalArgumentException("entry not found in composition");
        }
        throw new IllegalStateException("there is no exiting entry in the composition");
    }

    public List<ForeignKey> getFkeys() {
        return Collections.unmodifiableList(this.fkeys != null ? this.fkeys : new ArrayList());
    }

    public void setFkeys(List<ForeignKey> pFkeys) {
        this.fkeys = pFkeys;
    }

    public void addToFkeys(ForeignKey p) {
        if (this.fkeys == null) {
            this.fkeys = new ArrayList<ForeignKey>();
        }
        this.fkeys.add(p);
    }

    public void removeFromFkeys(ForeignKey p) {
        if (this.fkeys != null) {
            this.fkeys.remove(p);
        }
    }

    public void replaceInFkeys(ForeignKey _p) {
        if (this.fkeys != null) {
            for (ForeignKey _l : this.fkeys) {
                if (!_l.getId().equals(_p.getId())) continue;
                _l.updateUsing(_p);
                return;
            }
            throw new IllegalArgumentException("entry not found in composition");
        }
        throw new IllegalStateException("there is no exiting entry in the composition");
    }

    public String getXmlId() {
        return this.table_name;
    }

    public void setXmlId(String id) {
        this.table_name = id;
    }

    public boolean hasNaturalKey() {
        return true;
    }

    public String getId() {
        return this.table_name;
    }

    public static Table createTable(Consumer<TableBuilder> f) {
        return new TableBuilder().with(f).create();
    }

    public void forceLoad() {
        if (this.columns != null) {
            for (Column column : this.columns) {
                column.forceLoad();
            }
        }
        if (this.fkeys != null) {
            for (ForeignKey foreignKey : this.fkeys) {
                foreignKey.forceLoad();
            }
        }
    }

    @Deprecated
    public void persistRefs(EntityManager _em) {
        if (this.columns != null) {
            for (Column column : this.columns) {
                column.persistRefs(_em);
            }
        }
        if (this.fkeys != null) {
            for (ForeignKey foreignKey : this.fkeys) {
                foreignKey.persistRefs(_em);
            }
        }
        _em.persist((Object)this);
    }

    public void delete(EntityManager em) {
        em.remove((Object)this);
    }

    public static class TableBuilder {
        public String table_name;
        public TableType table_type;
        public String utype;
        public String description;
        public Integer table_index;
        public List<Column> columns;
        public List<ForeignKey> fkeys;

        private TableBuilder with(Consumer<TableBuilder> f) {
            f.accept(this);
            return this;
        }

        public Table create() {
            return new Table(this.table_name, this.table_type, this.utype, this.description, this.table_index, this.columns, this.fkeys);
        }
    }
}

