package org.ivoa.dm.tapschema;

/**
 * the foreign key columns.
 *
 * <p>objectType: FKColumn
 *
 * @author generated by https://github.com/ivoa/vo-dml tools
 */
@jakarta.persistence.Entity
@jakarta.persistence.Table(name = "key_columns", schema = "TAP_SCHEMA")
@jakarta.persistence.NamedQueries({
  @jakarta.persistence.NamedQuery(
      name = "FKColumn.findById",
      query = "SELECT o FROM FKColumn o WHERE o._id = :id")
})
@jakarta.xml.bind.annotation.XmlAccessorType(jakarta.xml.bind.annotation.XmlAccessType.NONE)
@jakarta.xml.bind.annotation.XmlType(name = "FKColumn")
@com.fasterxml.jackson.annotation.JsonTypeInfo(
    use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NONE)
@org.ivoa.vodml.annotation.VoDml(
    id = "tapschema:FKColumn",
    role = org.ivoa.vodml.annotation.VodmlRole.objectType)
@org.eclipse.microprofile.openapi.annotations.media.Schema(description = "the foreign key columns")
public class FKColumn implements org.ivoa.vodml.jpa.JPAManipulationsForObjectType<Long> {

  /** inserted database key */
  @jakarta.persistence.Id
  @jakarta.persistence.GeneratedValue
  @jakarta.persistence.Column(name = "FKCOLUMN_ID")
  @jakarta.xml.bind.annotation.XmlTransient
  // @com.fasterxml.jackson.annotation.JsonIgnore

  protected Long _id = (long) 0;

  /**
   * @return the id
   */
  @Override
  public Long getId() {
    return _id;
  }

  /** ReferenceObject from_column : . ( Multiplicity : 1 ) */
  @jakarta.persistence.ManyToOne(cascade = {jakarta.persistence.CascadeType.REFRESH})
  @jakarta.persistence.JoinColumn(
      name = "from_column_table",
      referencedColumnName = "table_name",
      nullable = false)
  @jakarta.persistence.JoinColumn(
      name = "from_column",
      referencedColumnName = "column_name",
      nullable = false)
  @jakarta.xml.bind.annotation.XmlIDREF
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:FKColumn.from_column",
      role = org.ivoa.vodml.annotation.VodmlRole.reference,
      type = "tapschema:column",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.objectType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "A reference to - ")
  protected org.ivoa.dm.tapschema.Column from_column = null;

  /** ReferenceObject target_column : . ( Multiplicity : 1 ) */
  @jakarta.persistence.ManyToOne(cascade = {jakarta.persistence.CascadeType.REFRESH})
  @jakarta.persistence.JoinColumn(
      name = "target_column_table",
      referencedColumnName = "table_name",
      nullable = false)
  @jakarta.persistence.JoinColumn(
      name = "target_column",
      referencedColumnName = "column_name",
      nullable = false)
  @jakarta.xml.bind.annotation.XmlIDREF
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:FKColumn.target_column",
      role = org.ivoa.vodml.annotation.VodmlRole.reference,
      type = "tapschema:column",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.objectType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "A reference to - ")
  protected org.ivoa.dm.tapschema.Column target_column = null;

  /** Creates a new FKColumn */
  public FKColumn() {
    super();
  }

  /**
   * full parameter constructor.
   *
   * @param from_column .
   * @param target_column .
   */
  public FKColumn(
      final org.ivoa.dm.tapschema.Column from_column,
      final org.ivoa.dm.tapschema.Column target_column) {
    super();

    this.from_column = from_column;

    this.target_column = target_column;
  }

  /** updates any cloned references that are contained within the hierarchy. */
  public void updateClonedReferences() {

    this.from_column =
        org.ivoa.vodml.ModelContext.current()
            .cache(org.ivoa.dm.tapschema.Column.class)
            .get(this.from_column);
    this.target_column =
        org.ivoa.vodml.ModelContext.current()
            .cache(org.ivoa.dm.tapschema.Column.class)
            .get(this.target_column);
  }

  /**
   * Copy Constructor. Note that references will remain as is rather than be copied.
   *
   * @param other the object to be copied.
   */
  public FKColumn(final FKColumn other) {

    super();

    this.from_column = other.from_column;

    this.target_column = other.target_column;
  }

  /**
   * Update this object with the content of the given object. Note that references will remain as is
   * rather than be copied.
   *
   * @param other the object to be copied.
   */
  public void updateUsing(final FKColumn other) {

    this.from_column = other.from_column;

    this.target_column = other.target_column;
  }

  /**
   * Returns from_column Reference
   *
   * @return from_column Reference
   */
  public org.ivoa.dm.tapschema.Column getFrom_column() {
    return this.from_column;
  }

  /**
   * Defines from_column Reference
   *
   * @param pFrom_column reference to set
   */
  public void setFrom_column(final org.ivoa.dm.tapschema.Column pFrom_column) {
    this.from_column = pFrom_column;
  }

  /**
   * Returns target_column Reference
   *
   * @return target_column Reference
   */
  public org.ivoa.dm.tapschema.Column getTarget_column() {
    return this.target_column;
  }

  /**
   * Defines target_column Reference
   *
   * @param pTarget_column reference to set
   */
  public void setTarget_column(final org.ivoa.dm.tapschema.Column pTarget_column) {
    this.target_column = pTarget_column;
  }

  /** A builder class for FKColumn, mainly for use in the functional builder pattern. */
  public static class FKColumnBuilder {

    /** . */
    public org.ivoa.dm.tapschema.Column from_column;

    /** . */
    public org.ivoa.dm.tapschema.Column target_column;

    private FKColumnBuilder with(java.util.function.Consumer<FKColumnBuilder> f) {
      f.accept(this);
      return this;
    }

    /**
     * create a FKColumn from this builder.
     *
     * @return an object initialized from the builder.
     */
    public FKColumn create() {
      return new FKColumn(from_column, target_column);
    }
  }

  /**
   * create a FKColumn in functional builder style.
   *
   * @param f the functional builder.
   * @return an object initialized from the builder.
   */
  public static FKColumn createFKColumn(java.util.function.Consumer<FKColumnBuilder> f) {
    return new FKColumnBuilder().with(f).create();
  }

  @Override
  public void forceLoad() {

    if (from_column != null) from_column.forceLoad();

    if (target_column != null) target_column.forceLoad();
  }

  /**
   * {@inheritDoc}
   *
   * @deprecated generally better to use the model level reference persistence as only this can deal
   *     with "contained" references properly.
   */
  @Override
  @Deprecated
  public void persistRefs(jakarta.persistence.EntityManager _em) {

    if (from_column != null) from_column.persistRefs(_em);

    if (target_column != null) target_column.persistRefs(_em);
  }

  /** {@inheritDoc} */
  @Override
  public void delete(jakarta.persistence.EntityManager em) {

    em.remove(this); // nothing special to do
  }
}
