package org.ivoa.dm.tapschema;

import java.util.ArrayList;
import java.util.List;

/**
 * The schema.
 *
 * <p>objectType: Schema
 *
 * @author generated by https://github.com/ivoa/vo-dml tools
 */
@jakarta.persistence.Entity
@jakarta.persistence.Table(name = "schemas", schema = "TAP_SCHEMA")
@jakarta.persistence.NamedQueries({
  @jakarta.persistence.NamedQuery(
      name = "Schema.findById",
      query = "SELECT o FROM Schema o WHERE o.schema_name = :id")
})
@jakarta.persistence.NamedEntityGraph(
    name = "Schema_loadAll",
    attributeNodes = {@jakarta.persistence.NamedAttributeNode(value = "tables")})
@jakarta.xml.bind.annotation.XmlAccessorType(jakarta.xml.bind.annotation.XmlAccessType.NONE)
@jakarta.xml.bind.annotation.XmlType(name = "Schema")
@com.fasterxml.jackson.annotation.JsonTypeInfo(
    use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NONE)

// @jakarta.xml.bind.annotation.XmlRootElement( name = "Schema")

@org.ivoa.vodml.annotation.VoDml(
    id = "tapschema:Schema",
    role = org.ivoa.vodml.annotation.VodmlRole.objectType)
@org.eclipse.microprofile.openapi.annotations.media.Schema(description = "The schema")
public class Schema implements org.ivoa.vodml.jpa.JPAManipulationsForObjectType<String> {

  /** The name of the schema . : Attribute schema_name : multiplicity 1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:Schema.schema_name",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:string",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "The name of the schema")
  @jakarta.xml.bind.annotation.XmlElement(
      name = "schema_name",
      required = true,
      type = String.class)
  @jakarta.persistence.Id
  @jakarta.persistence.Basic(optional = false)
  @jakarta.persistence.Column(name = "schema_name", nullable = false)
  protected String schema_name;

  /** utype. : Attribute utype : multiplicity 0..1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:Schema.utype",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:string",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "utype")
  @jakarta.xml.bind.annotation.XmlElement(name = "utype", required = false, type = String.class)
  @jakarta.persistence.Basic(optional = true)
  @jakarta.persistence.Column(name = "utype", nullable = true)
  protected String utype;

  /** description. : Attribute description : multiplicity 0..1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:Schema.description",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:string",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "description")
  @jakarta.xml.bind.annotation.XmlElement(
      name = "description",
      required = false,
      type = String.class)
  @jakarta.persistence.Basic(optional = true)
  @jakarta.persistence.Column(name = "description", nullable = true, length = 4095)
  protected String description;

  /**
   * used to recommend table ordering for clients. Clients may order by index (ascending) so lower
   * index items would appear earlier in a listing. : Attribute schema_index : multiplicity 0..1
   */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:Schema.schema_index",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:integer",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(
      description =
          "used to recommend table ordering for clients. Clients may order by index (ascending) so lower index items would appear earlier in a listing.")
  @jakarta.xml.bind.annotation.XmlElement(
      name = "schema_index",
      required = false,
      type = Integer.class)
  @jakarta.persistence.Basic(optional = true)
  @jakarta.persistence.Column(name = "schema_index", nullable = true)
  protected Integer schema_index;

  /** the tables. composition tables : ( Multiplicity : 1..* ) */
  @jakarta.xml.bind.annotation.XmlElementWrapper(name = "tables")
  @jakarta.xml.bind.annotation.XmlElement(
      name = "table",
      required = true,
      type = org.ivoa.dm.tapschema.Table.class)
  @jakarta.persistence.OneToMany(
      cascade = jakarta.persistence.CascadeType.ALL,
      fetch = jakarta.persistence.FetchType.LAZY,
      targetEntity = org.ivoa.dm.tapschema.Table.class)
  @jakarta.persistence.JoinColumn(name = "schema_name")
  @org.hibernate.annotations.Fetch(org.hibernate.annotations.FetchMode.SUBSELECT)
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:Schema.tables",
      role = org.ivoa.vodml.annotation.VodmlRole.composition,
      type = "tapschema:table",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.objectType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "the tables")
  protected java.util.List<org.ivoa.dm.tapschema.Table> tables = new java.util.ArrayList<>();

  /** Creates a new Schema */
  public Schema() {
    super();
  }

  /**
   * full parameter constructor.
   *
   * @param schema_name The name of the schema .
   * @param utype utype.
   * @param description description.
   * @param schema_index used to recommend table ordering for clients. Clients may order by index
   *     (ascending) so lower index items would appear earlier in a listing.
   * @param tables the tables.
   */
  public Schema(
      final String schema_name,
      final String utype,
      final String description,
      final Integer schema_index,
      final java.util.List<org.ivoa.dm.tapschema.Table> tables) {
    super();

    this.schema_name = schema_name;

    this.utype = utype;

    this.description = description;

    this.schema_index = schema_index;

    this.tables = tables;
  }

  /** updates any cloned references that are contained within the hierarchy. */
  public void updateClonedReferences() {

    //  this.schema_name false false  ch=;

    //  this.utype false false  ch=;

    //  this.description false false  ch=;

    //  this.schema_index false false  ch=;

    if (this.tables != null) {

      for (var _x : this.tables) {
        _x.updateClonedReferences();
      }
    }
  }

  /**
   * Copy Constructor. Note that references will remain as is rather than be copied.
   *
   * @param other the object to be copied.
   */
  public Schema(final Schema other) {

    super();

    this.schema_name = other.schema_name;

    this.utype = other.utype;

    this.description = other.description;

    this.schema_index = other.schema_index;

    // contained reference

    if (other.tables != null) {
      var cache = org.ivoa.vodml.ModelContext.current().cache(org.ivoa.dm.tapschema.Table.class);
      var cloned =
          other.tables.stream()
              .map(s -> new org.ivoa.dm.tapschema.Table((org.ivoa.dm.tapschema.Table) s))
              .collect(java.util.stream.Collectors.toList());
      cache.setValues(other.tables, cloned);
      this.tables = cloned;
    }
  }

  /**
   * Update this object with the content of the given object. Note that references will remain as is
   * rather than be copied.
   *
   * @param other the object to be copied.
   */
  public void updateUsing(final Schema other) {

    this.schema_name = other.schema_name;

    this.utype = other.utype;

    this.description = other.description;

    this.schema_index = other.schema_index;

    // contained reference

    if (other.tables != null) {
      var cache = org.ivoa.vodml.ModelContext.current().cache(org.ivoa.dm.tapschema.Table.class);
      var cloned =
          other.tables.stream()
              .map(s -> new org.ivoa.dm.tapschema.Table((org.ivoa.dm.tapschema.Table) s))
              .collect(java.util.stream.Collectors.toList());
      cache.setValues(other.tables, cloned);
      this.tables = cloned;
    }
  }

  /**
   * Returns schema_name Attribute.
   *
   * @return schema_name Attribute
   */
  public String getSchema_name() {
    return (String) this.schema_name;
  }

  /**
   * Set schema_name Attribute.
   *
   * @param pSchema_name value to set
   */
  public void setSchema_name(final String pSchema_name) {

    this.schema_name = pSchema_name;
  }

  /**
   * fluent setter for schema_name Attribute.
   *
   * @param pSchema_name value to set
   * @return Schema
   */
  public org.ivoa.dm.tapschema.Schema withSchema_name(final String pSchema_name) {
    setSchema_name(pSchema_name);
    return this;
  }

  /**
   * Returns utype Attribute.
   *
   * @return utype Attribute
   */
  public String getUtype() {
    return (String) this.utype;
  }

  /**
   * Set utype Attribute.
   *
   * @param pUtype value to set
   */
  public void setUtype(final String pUtype) {

    this.utype = pUtype;
  }

  /**
   * fluent setter for utype Attribute.
   *
   * @param pUtype value to set
   * @return Schema
   */
  public org.ivoa.dm.tapschema.Schema withUtype(final String pUtype) {
    setUtype(pUtype);
    return this;
  }

  /**
   * Returns description Attribute.
   *
   * @return description Attribute
   */
  public String getDescription() {
    return (String) this.description;
  }

  /**
   * Set description Attribute.
   *
   * @param pDescription value to set
   */
  public void setDescription(final String pDescription) {

    this.description = pDescription;
  }

  /**
   * fluent setter for description Attribute.
   *
   * @param pDescription value to set
   * @return Schema
   */
  public org.ivoa.dm.tapschema.Schema withDescription(final String pDescription) {
    setDescription(pDescription);
    return this;
  }

  /**
   * Returns schema_index Attribute.
   *
   * @return schema_index Attribute
   */
  public Integer getSchema_index() {
    return (Integer) this.schema_index;
  }

  /**
   * Set schema_index Attribute.
   *
   * @param pSchema_index value to set
   */
  public void setSchema_index(final Integer pSchema_index) {

    this.schema_index = pSchema_index;
  }

  /**
   * fluent setter for schema_index Attribute.
   *
   * @param pSchema_index value to set
   * @return Schema
   */
  public org.ivoa.dm.tapschema.Schema withSchema_index(final Integer pSchema_index) {
    setSchema_index(pSchema_index);
    return this;
  }

  /**
   * Returns tables composition as an immutable list.
   *
   * @return tables composition.
   */
  public List<org.ivoa.dm.tapschema.Table> getTables() {

    return java.util.Collections.unmodifiableList(
        this.tables != null ? this.tables : new ArrayList<>());
  }

  /**
   * Defines whole tables composition.
   *
   * @param pTables composition to set.
   */
  public void setTables(final java.util.List<org.ivoa.dm.tapschema.Table> pTables) {

    this.tables = pTables;
  }

  /**
   * Add a org.ivoa.dm.tapschema.Table to the composition.
   *
   * @param p org.ivoa.dm.tapschema.Table to add
   */
  public void addToTables(final org.ivoa.dm.tapschema.Table p) {
    if (this.tables == null) {
      this.tables = new ArrayList<>();
    }
    this.tables.add(p);
  }

  /**
   * Remove a org.ivoa.dm.tapschema.Table from the composition.
   *
   * @param p org.ivoa.dm.tapschema.Table to remove
   */
  public void removeFromTables(final org.ivoa.dm.tapschema.Table p) {
    if (this.tables != null) {
      this.tables.remove(p);
    }
  }

  /**
   * update a org.ivoa.dm.tapschema.Table in the composition.
   *
   * @param _p org.ivoa.dm.tapschema.Table to update the match is done via the database key
   */
  public void replaceInTables(final org.ivoa.dm.tapschema.Table _p) {
    if (this.tables != null) {
      for (org.ivoa.dm.tapschema.Table _l : this.tables) {
        if (_l.getId().equals(_p.getId())) {
          _l.updateUsing(_p);
          return;
        }
      }
      throw new IllegalArgumentException("entry not found in composition");
    } else throw new IllegalStateException("there is no exiting entry in the composition");
  }

  /**
   * return the database key id. Note that this is the same as attribute schema_name.
   *
   * @return the id
   */
  @Override
  public String getId() {
    return schema_name;
  }

  /** A builder class for Schema, mainly for use in the functional builder pattern. */
  public static class SchemaBuilder {

    /** The name of the schema . */
    public String schema_name;

    /** utype. */
    public String utype;

    /** description. */
    public String description;

    /**
     * used to recommend table ordering for clients. Clients may order by index (ascending) so lower
     * index items would appear earlier in a listing.
     */
    public Integer schema_index;

    /** the tables. */
    public java.util.List<org.ivoa.dm.tapschema.Table> tables;

    private SchemaBuilder with(java.util.function.Consumer<SchemaBuilder> f) {
      f.accept(this);
      return this;
    }

    /**
     * create a Schema from this builder.
     *
     * @return an object initialized from the builder.
     */
    public Schema create() {
      return new Schema(schema_name, utype, description, schema_index, tables);
    }
  }

  /**
   * create a Schema in functional builder style.
   *
   * @param f the functional builder.
   * @return an object initialized from the builder.
   */
  public static Schema createSchema(java.util.function.Consumer<SchemaBuilder> f) {
    return new SchemaBuilder().with(f).create();
  }

  @Override
  public void forceLoad() {

    if (tables != null) {
      for (org.ivoa.dm.tapschema.Table c : tables) {
        c.forceLoad();
      }
    }
  }

  /**
   * {@inheritDoc}
   *
   * @deprecated generally better to use the model level reference persistence as only this can deal
   *     with "contained" references properly.
   */
  @Override
  @Deprecated
  public void persistRefs(jakarta.persistence.EntityManager _em) {

    if (tables != null) {
      for (org.ivoa.dm.tapschema.Table _c : tables) {
        _c.persistRefs(_em);
      }
    }
  }

  /** {@inheritDoc} */
  @Override
  public void delete(jakarta.persistence.EntityManager em) {

    // has contained references tapschema:table,tapschema:column
    // referred to by tapschema:ForeignKey,tapschema:FKColumn

    em.remove(this); // finish up with itself.
  }
}
