/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.dm.tapschema;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.ivoa.dm.tapschema.Table;
import org.ivoa.vodml.ModelContext;
import org.ivoa.vodml.annotation.VoDml;
import org.ivoa.vodml.annotation.VodmlRole;
import org.ivoa.vodml.jpa.JPAManipulationsForObjectType;
import org.ivoa.vodml.nav.ReferenceCache;

@Entity
@jakarta.persistence.Table(name="schemas", schema="TAP_SCHEMA")
@NamedQueries(value={@NamedQuery(name="Schema.findById", query="SELECT o FROM Schema o WHERE o.schema_name = :id")})
@NamedEntityGraph(name="Schema_loadAll", attributeNodes={@NamedAttributeNode(value="tables")})
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="Schema")
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
@VoDml(id="tapschema:Schema", role=VodmlRole.objectType)
@org.eclipse.microprofile.openapi.annotations.media.Schema(description="The schema")
public class Schema
implements JPAManipulationsForObjectType<String> {
    @VoDml(id="tapschema:Schema.schema_name", role=VodmlRole.attribute, type="ivoa:string", typeRole=VodmlRole.primitiveType)
    @org.eclipse.microprofile.openapi.annotations.media.Schema(description="The name of the schema")
    @XmlElement(name="schema_name", required=true, type=String.class)
    @Id
    @Basic(optional=false)
    @Column(name="schema_name", nullable=false)
    protected String schema_name;
    @VoDml(id="tapschema:Schema.utype", role=VodmlRole.attribute, type="ivoa:string", typeRole=VodmlRole.primitiveType)
    @org.eclipse.microprofile.openapi.annotations.media.Schema(description="utype")
    @XmlElement(name="utype", required=false, type=String.class)
    @Basic(optional=true)
    @Column(name="utype", nullable=true)
    protected String utype;
    @VoDml(id="tapschema:Schema.description", role=VodmlRole.attribute, type="ivoa:string", typeRole=VodmlRole.primitiveType)
    @org.eclipse.microprofile.openapi.annotations.media.Schema(description="description")
    @XmlElement(name="description", required=false, type=String.class)
    @Basic(optional=true)
    @Column(name="description", nullable=true, length=4095)
    protected String description;
    @VoDml(id="tapschema:Schema.schema_index", role=VodmlRole.attribute, type="ivoa:integer", typeRole=VodmlRole.primitiveType)
    @org.eclipse.microprofile.openapi.annotations.media.Schema(description="used to recommend table ordering for clients. Clients may order by index (ascending) so lower index items would appear earlier in a listing.")
    @XmlElement(name="schema_index", required=false, type=Integer.class)
    @Basic(optional=true)
    @Column(name="schema_index", nullable=true)
    protected Integer schema_index;
    @XmlElementWrapper(name="tables")
    @XmlElement(name="table", required=true, type=Table.class)
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, targetEntity=Table.class)
    @JoinColumn(name="schema_name")
    @Fetch(value=FetchMode.SUBSELECT)
    @VoDml(id="tapschema:Schema.tables", role=VodmlRole.composition, type="tapschema:table", typeRole=VodmlRole.objectType)
    @org.eclipse.microprofile.openapi.annotations.media.Schema(description="the tables")
    protected List<Table> tables = new ArrayList<Table>();

    public Schema() {
    }

    public Schema(String schema_name, String utype, String description, Integer schema_index, List<Table> tables) {
        this.schema_name = schema_name;
        this.utype = utype;
        this.description = description;
        this.schema_index = schema_index;
        this.tables = tables;
    }

    public void updateClonedReferences() {
        if (this.tables != null) {
            for (Table _x : this.tables) {
                _x.updateClonedReferences();
            }
        }
    }

    public Schema(Schema other) {
        this.schema_name = other.schema_name;
        this.utype = other.utype;
        this.description = other.description;
        this.schema_index = other.schema_index;
        if (other.tables != null) {
            ReferenceCache cache = ModelContext.current().cache(Table.class);
            List cloned = other.tables.stream().map(s -> new Table((Table)s)).collect(Collectors.toList());
            cache.setValues(other.tables, cloned);
            this.tables = cloned;
        }
    }

    public void updateUsing(Schema other) {
        this.schema_name = other.schema_name;
        this.utype = other.utype;
        this.description = other.description;
        this.schema_index = other.schema_index;
        if (other.tables != null) {
            ReferenceCache cache = ModelContext.current().cache(Table.class);
            List cloned = other.tables.stream().map(s -> new Table((Table)s)).collect(Collectors.toList());
            cache.setValues(other.tables, cloned);
            this.tables = cloned;
        }
    }

    public String getSchema_name() {
        return this.schema_name;
    }

    public void setSchema_name(String pSchema_name) {
        this.schema_name = pSchema_name;
    }

    public Schema withSchema_name(String pSchema_name) {
        this.setSchema_name(pSchema_name);
        return this;
    }

    public String getUtype() {
        return this.utype;
    }

    public void setUtype(String pUtype) {
        this.utype = pUtype;
    }

    public Schema withUtype(String pUtype) {
        this.setUtype(pUtype);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String pDescription) {
        this.description = pDescription;
    }

    public Schema withDescription(String pDescription) {
        this.setDescription(pDescription);
        return this;
    }

    public Integer getSchema_index() {
        return this.schema_index;
    }

    public void setSchema_index(Integer pSchema_index) {
        this.schema_index = pSchema_index;
    }

    public Schema withSchema_index(Integer pSchema_index) {
        this.setSchema_index(pSchema_index);
        return this;
    }

    public List<Table> getTables() {
        return Collections.unmodifiableList(this.tables != null ? this.tables : new ArrayList());
    }

    public void setTables(List<Table> pTables) {
        this.tables = pTables;
    }

    public void addToTables(Table p) {
        if (this.tables == null) {
            this.tables = new ArrayList<Table>();
        }
        this.tables.add(p);
    }

    public void removeFromTables(Table p) {
        if (this.tables != null) {
            this.tables.remove(p);
        }
    }

    public void replaceInTables(Table _p) {
        if (this.tables != null) {
            for (Table _l : this.tables) {
                if (!_l.getId().equals(_p.getId())) continue;
                _l.updateUsing(_p);
                return;
            }
            throw new IllegalArgumentException("entry not found in composition");
        }
        throw new IllegalStateException("there is no exiting entry in the composition");
    }

    public String getId() {
        return this.schema_name;
    }

    public static Schema createSchema(Consumer<SchemaBuilder> f) {
        return new SchemaBuilder().with(f).create();
    }

    public void forceLoad() {
        if (this.tables != null) {
            for (Table c : this.tables) {
                c.forceLoad();
            }
        }
    }

    @Deprecated
    public void persistRefs(EntityManager _em) {
        if (this.tables != null) {
            for (Table _c : this.tables) {
                _c.persistRefs(_em);
            }
        }
    }

    public void delete(EntityManager em) {
        em.remove((Object)this);
    }

    public static class SchemaBuilder {
        public String schema_name;
        public String utype;
        public String description;
        public Integer schema_index;
        public List<Table> tables;

        private SchemaBuilder with(Consumer<SchemaBuilder> f) {
            f.accept(this);
            return this;
        }

        public Schema create() {
            return new Schema(this.schema_name, this.utype, this.description, this.schema_index, this.tables);
        }
    }
}

