/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.dm.tapschema;

import org.ivoa.dm.tapschema.Column;
import org.ivoa.dm.tapschema.FKColumn;
import org.ivoa.dm.tapschema.ForeignKey;
import org.ivoa.dm.tapschema.Schema;
import org.ivoa.dm.tapschema.Table;
import org.ivoa.dm.tapschema.TapschemaModel;

public class ColNameKeys {
    public static void normalize(TapschemaModel model) {
        for (Schema sc : model.getContent(Schema.class)) {
            for (Table t : sc.getTables()) {
                for (Column c : t.getColumns()) {
                    String cn = c.getColumn_name();
                    if (cn.contains(".")) {
                        c.setColumn_name(cn.substring(cn.lastIndexOf(46) + 1));
                        c.table_name = cn.substring(0, cn.lastIndexOf(46));
                        continue;
                    }
                    c.table_name = t.table_name;
                }
                for (ForeignKey k : t.getFkeys()) {
                    for (FKColumn c : k.getColumns()) {
                        ColNameKeys.updateColumName(c.getFrom_column());
                        ColNameKeys.updateColumName(c.getTarget_column());
                    }
                }
            }
        }
    }

    private static void updateColumName(Column fc) {
        String cn = fc.getColumn_name();
        fc.setColumn_name(cn.substring(cn.lastIndexOf(46) + 1));
    }
}

