/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.dm.tapschema;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinColumns;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.function.Consumer;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.ivoa.dm.tapschema.Column;
import org.ivoa.vodml.ModelContext;
import org.ivoa.vodml.annotation.VoDml;
import org.ivoa.vodml.annotation.VodmlRole;
import org.ivoa.vodml.jpa.JPAManipulationsForObjectType;

@Entity
@Table(name="key_columns", schema="TAP_SCHEMA")
@NamedQueries(value={@NamedQuery(name="FKColumn.findById", query="SELECT o FROM FKColumn o WHERE o._id = :id")})
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="FKColumn")
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
@VoDml(id="tapschema:FKColumn", role=VodmlRole.objectType)
@Schema(description="the foreign key columns")
public class FKColumn
implements JPAManipulationsForObjectType<Long> {
    @Id
    @GeneratedValue
    @jakarta.persistence.Column(name="FKCOLUMN_ID")
    @XmlTransient
    protected Long _id = 0L;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumns(value={@JoinColumn(name="from_column_table", referencedColumnName="table_name", nullable=false), @JoinColumn(name="from_column", referencedColumnName="column_name", nullable=false)})
    @XmlIDREF
    @VoDml(id="tapschema:FKColumn.from_column", role=VodmlRole.reference, type="tapschema:column", typeRole=VodmlRole.objectType)
    @Schema(description="A reference to - ")
    protected Column from_column = null;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumns(value={@JoinColumn(name="target_column_table", referencedColumnName="table_name", nullable=false), @JoinColumn(name="target_column", referencedColumnName="column_name", nullable=false)})
    @XmlIDREF
    @VoDml(id="tapschema:FKColumn.target_column", role=VodmlRole.reference, type="tapschema:column", typeRole=VodmlRole.objectType)
    @Schema(description="A reference to - ")
    protected Column target_column = null;

    public Long getId() {
        return this._id;
    }

    public FKColumn() {
    }

    public FKColumn(Column from_column, Column target_column) {
        this.from_column = from_column;
        this.target_column = target_column;
    }

    public void updateClonedReferences() {
        this.from_column = (Column)ModelContext.current().cache(Column.class).get((Object)this.from_column);
        this.target_column = (Column)ModelContext.current().cache(Column.class).get((Object)this.target_column);
    }

    public FKColumn(FKColumn other) {
        this.from_column = other.from_column;
        this.target_column = other.target_column;
    }

    public void updateUsing(FKColumn other) {
        this.from_column = other.from_column;
        this.target_column = other.target_column;
    }

    public Column getFrom_column() {
        return this.from_column;
    }

    public void setFrom_column(Column pFrom_column) {
        this.from_column = pFrom_column;
    }

    public Column getTarget_column() {
        return this.target_column;
    }

    public void setTarget_column(Column pTarget_column) {
        this.target_column = pTarget_column;
    }

    public static FKColumn createFKColumn(Consumer<FKColumnBuilder> f) {
        return new FKColumnBuilder().with(f).create();
    }

    public void forceLoad() {
        if (this.from_column != null) {
            this.from_column.forceLoad();
        }
        if (this.target_column != null) {
            this.target_column.forceLoad();
        }
    }

    public void delete(EntityManager em) {
        em.remove((Object)this);
    }

    public static class FKColumnBuilder {
        public Column from_column;
        public Column target_column;

        private FKColumnBuilder with(Consumer<FKColumnBuilder> f) {
            f.accept(this);
            return this;
        }

        public FKColumn create() {
            return new FKColumn(this.from_column, this.target_column);
        }
    }
}

