/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.dm.tapschema;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToMany;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.ivoa.dm.tapschema.FKColumn;
import org.ivoa.dm.tapschema.Table;
import org.ivoa.vodml.ModelContext;
import org.ivoa.vodml.annotation.VoDml;
import org.ivoa.vodml.annotation.VodmlRole;
import org.ivoa.vodml.jpa.JPAManipulationsForObjectType;

@Entity
@jakarta.persistence.Table(name="keys", schema="TAP_SCHEMA")
@NamedQueries(value={@NamedQuery(name="ForeignKey.findById", query="SELECT o FROM ForeignKey o WHERE o.key_id = :id")})
@NamedEntityGraph(name="ForeignKey_loadAll", attributeNodes={@NamedAttributeNode(value="columns")})
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="ForeignKey")
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
@VoDml(id="tapschema:ForeignKey", role=VodmlRole.objectType)
@Schema(description="foreign key definition")
public class ForeignKey
implements JPAManipulationsForObjectType<String> {
    @VoDml(id="tapschema:ForeignKey.key_id", role=VodmlRole.attribute, type="ivoa:string", typeRole=VodmlRole.primitiveType)
    @Schema(description="the id of the key")
    @XmlElement(name="key_id", required=true, type=String.class)
    @Id
    @Basic(optional=false)
    @Column(name="key_id", nullable=false)
    protected String key_id;
    @ManyToOne(cascade={CascadeType.REFRESH})
    @JoinColumn(name="target_table", referencedColumnName="table_name", nullable=false)
    @XmlIDREF
    @VoDml(id="tapschema:ForeignKey.target_table", role=VodmlRole.reference, type="tapschema:table", typeRole=VodmlRole.objectType)
    @Schema(description="A reference to - ")
    protected Table target_table = null;
    @VoDml(id="tapschema:ForeignKey.description", role=VodmlRole.attribute, type="ivoa:string", typeRole=VodmlRole.primitiveType)
    @Schema(description="description")
    @XmlElement(name="description", required=false, type=String.class)
    @Basic(optional=true)
    @Column(name="description", nullable=true)
    protected String description;
    @VoDml(id="tapschema:ForeignKey.utype", role=VodmlRole.attribute, type="ivoa:string", typeRole=VodmlRole.primitiveType)
    @Schema(description="utype")
    @XmlElement(name="utype", required=false, type=String.class)
    @Basic(optional=true)
    @Column(name="utype", nullable=true)
    protected String utype;
    @XmlElementWrapper(name="columns")
    @XmlElement(name="fKColumn", required=true, type=FKColumn.class)
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, targetEntity=FKColumn.class)
    @JoinColumn(name="key_id")
    @Fetch(value=FetchMode.SUBSELECT)
    @VoDml(id="tapschema:ForeignKey.columns", role=VodmlRole.composition, type="tapschema:FKColumn", typeRole=VodmlRole.objectType)
    @Schema(description="")
    protected List<FKColumn> columns = new ArrayList<FKColumn>();

    public ForeignKey() {
    }

    public ForeignKey(String key_id, Table target_table, String description, String utype, List<FKColumn> columns) {
        this.key_id = key_id;
        this.target_table = target_table;
        this.description = description;
        this.utype = utype;
        this.columns = columns;
    }

    public void updateClonedReferences() {
        this.target_table = (Table)ModelContext.current().cache(Table.class).get((Object)this.target_table);
        if (this.columns != null) {
            for (FKColumn _x : this.columns) {
                _x.updateClonedReferences();
            }
        }
    }

    public ForeignKey(ForeignKey other) {
        this.key_id = other.key_id;
        this.target_table = other.target_table;
        this.description = other.description;
        this.utype = other.utype;
        if (other.columns != null) {
            this.columns = other.columns.stream().map(s -> new FKColumn((FKColumn)s)).collect(Collectors.toList());
        }
    }

    public void updateUsing(ForeignKey other) {
        this.key_id = other.key_id;
        this.target_table = other.target_table;
        this.description = other.description;
        this.utype = other.utype;
        if (other.columns != null) {
            this.columns = other.columns.stream().map(s -> new FKColumn((FKColumn)s)).collect(Collectors.toList());
        }
    }

    public String getKey_id() {
        return this.key_id;
    }

    public void setKey_id(String pKey_id) {
        this.key_id = pKey_id;
    }

    public ForeignKey withKey_id(String pKey_id) {
        this.setKey_id(pKey_id);
        return this;
    }

    public Table getTarget_table() {
        return this.target_table;
    }

    public void setTarget_table(Table pTarget_table) {
        this.target_table = pTarget_table;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String pDescription) {
        this.description = pDescription;
    }

    public ForeignKey withDescription(String pDescription) {
        this.setDescription(pDescription);
        return this;
    }

    public String getUtype() {
        return this.utype;
    }

    public void setUtype(String pUtype) {
        this.utype = pUtype;
    }

    public ForeignKey withUtype(String pUtype) {
        this.setUtype(pUtype);
        return this;
    }

    public List<FKColumn> getColumns() {
        return Collections.unmodifiableList(this.columns != null ? this.columns : new ArrayList());
    }

    public void setColumns(List<FKColumn> pColumns) {
        this.columns = pColumns;
    }

    public void addToColumns(FKColumn p) {
        if (this.columns == null) {
            this.columns = new ArrayList<FKColumn>();
        }
        this.columns.add(p);
    }

    public void removeFromColumns(FKColumn p) {
        if (this.columns != null) {
            this.columns.remove(p);
        }
    }

    public void replaceInColumns(FKColumn _p) {
        if (this.columns != null) {
            for (FKColumn _l : this.columns) {
                if (!_l.getId().equals(_p.getId())) continue;
                _l.updateUsing(_p);
                return;
            }
            throw new IllegalArgumentException("entry not found in composition");
        }
        throw new IllegalStateException("there is no exiting entry in the composition");
    }

    public String getId() {
        return this.key_id;
    }

    public static ForeignKey createForeignKey(Consumer<ForeignKeyBuilder> f) {
        return new ForeignKeyBuilder().with(f).create();
    }

    public void forceLoad() {
        if (this.target_table != null) {
            this.target_table.forceLoad();
        }
        if (this.columns != null) {
            for (FKColumn c : this.columns) {
                c.forceLoad();
            }
        }
    }

    public void delete(EntityManager em) {
        em.remove((Object)this);
    }

    public static class ForeignKeyBuilder {
        public String key_id;
        public Table target_table;
        public String description;
        public String utype;
        public List<FKColumn> columns;

        private ForeignKeyBuilder with(Consumer<ForeignKeyBuilder> f) {
            f.accept(this);
            return this;
        }

        public ForeignKey create() {
            return new ForeignKey(this.key_id, this.target_table, this.description, this.utype, this.columns);
        }
    }
}

