/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.dm.tapschema;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import jakarta.persistence.EntityManager;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ivoa.dm.ivoa.IntegerQuantity;
import org.ivoa.dm.ivoa.Quantity;
import org.ivoa.dm.ivoa.RealQuantity;
import org.ivoa.dm.tapschema.Column;
import org.ivoa.dm.tapschema.FKColumn;
import org.ivoa.dm.tapschema.ForeignKey;
import org.ivoa.dm.tapschema.Schema;
import org.ivoa.dm.tapschema.Table;
import org.ivoa.vodml.ModelContext;
import org.ivoa.vodml.ModelDescription;
import org.ivoa.vodml.ModelManagement;
import org.ivoa.vodml.VodmlModel;
import org.ivoa.vodml.annotation.VoDml;
import org.ivoa.vodml.annotation.VodmlRole;
import org.ivoa.vodml.json.JsonManagement;
import org.ivoa.vodml.json.VodmlTypeResolver;
import org.ivoa.vodml.nav.ReferenceCache;
import org.ivoa.vodml.nav.Util;
import org.ivoa.vodml.vocabularies.Vocabulary;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="tapschemaModel")
@XmlType(propOrder={"refs", "content"})
@JsonTypeInfo(include=JsonTypeInfo.As.WRAPPER_OBJECT, use=JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties(value={"refmap"})
@VoDml(id="tapschema", role=VodmlRole.model, type="tapschema")
public class TapschemaModel
implements VodmlModel<TapschemaModel> {
    private References refs = new References();
    private static List<Class> refOrder = List.of();
    @XmlElements(value={@XmlElement(name="schema", type=Schema.class)})
    @JsonTypeIdResolver(value=VodmlTypeResolver.class)
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@type")
    private List<Object> content = new ArrayList<Object>();
    private static volatile Map<String, Vocabulary> vocabs;
    public static final ModelDescription modelDescription;

    private References getRefs() {
        return this.refs;
    }

    @XmlElement(required=false)
    private void setRefs(References refs) {
        this.refs = refs;
    }

    private static void loadVocabs() {
        vocabs = new HashMap<String, Vocabulary>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static boolean isInVocabulary(String value, String vocabulary) {
        if (vocabs == null) {
            Class<TapschemaModel> clazz = TapschemaModel.class;
            // MONITORENTER : org.ivoa.dm.tapschema.TapschemaModel.class
            TapschemaModel.loadVocabs();
            // MONITOREXIT : clazz
        }
        if (value == null) {
            return true;
        }
        if (!vocabs.containsKey(vocabulary)) return false;
        return vocabs.get(vocabulary).hasTerm(value);
    }

    public void addContent(Schema c) {
        this.content.add(c);
    }

    public void deleteContent(Schema c) {
        this.content.remove(c);
    }

    public <T> List<T> getContent(Class<T> c) {
        if (!Stream.concat(refOrder.stream(), modelDescription.contentClasses().stream()).anyMatch(i -> i.isAssignableFrom(c))) {
            throw new IllegalArgumentException(c.getCanonicalName() + " is not part of the model");
        }
        return this.content.stream().filter(p -> p.getClass().isAssignableFrom(c)).collect(Collectors.toUnmodifiableList());
    }

    public void processReferences() {
        List il = Util.findXmlIDs(this.content);
        Util.makeUniqueIDs((List)il);
    }

    public static boolean hasReferences() {
        return false;
    }

    public static JAXBContext contextFactory() throws JAXBException {
        return JAXBContext.newInstance((String)"org.ivoa.dm.tapschema:org.ivoa.dm.ivoa");
    }

    public static String pu_name() {
        return "tapschema";
    }

    public static ObjectMapper jsonMapper() {
        return JsonManagement.jsonMapper((ModelDescription)modelDescription);
    }

    public ModelManagement<TapschemaModel> management() {
        return new ModelManagement<TapschemaModel>(){

            public String pu_name() {
                return TapschemaModel.pu_name();
            }

            public JAXBContext contextFactory() throws JAXBException {
                return TapschemaModel.contextFactory();
            }

            public boolean hasReferences() {
                return TapschemaModel.hasReferences();
            }

            public void persistRefs(EntityManager em) {
            }

            public ObjectMapper jsonMapper() {
                return TapschemaModel.jsonMapper();
            }

            public TapschemaModel theModel() {
                return TapschemaModel.this;
            }

            public List<Object> getContent() {
                return TapschemaModel.this.content;
            }

            public ModelDescription description() {
                return modelDescription;
            }
        };
    }

    public static InputStream TAPSchema() {
        return TapschemaModel.class.getResourceAsStream("/tapschema.vo-dml.tap.xml");
    }

    public void createContext() {
        Map collect = Map.ofEntries(Map.entry(Table.class, new ReferenceCache()), Map.entry(Column.class, new ReferenceCache()));
        ModelContext.create(collect);
    }

    static {
        modelDescription = new ModelDescription(){

            public Map<String, Class> utypeToClassMap() {
                HashMap<String, Class> retval = new HashMap<String, Class>();
                retval.put("tapschema:Schema", Schema.class);
                retval.put("tapschema:table", Table.class);
                retval.put("tapschema:column", Column.class);
                retval.put("tapschema:ForeignKey", ForeignKey.class);
                retval.put("tapschema:FKColumn", FKColumn.class);
                retval.put("ivoa:IntegerQuantity", IntegerQuantity.class);
                retval.put("ivoa:Quantity", Quantity.class);
                retval.put("ivoa:RealQuantity", RealQuantity.class);
                return retval;
            }

            public Map<String, String> schemaMap() {
                HashMap<String, String> schemaMap = new HashMap<String, String>();
                schemaMap.put("http://ivoa.net/dm/tapschema/v1", "tapschema.vo-dml.xsd");
                schemaMap.put("http://ivoa.net/vodml/ivoa", "IVOA-v1.0.vo-dml.xsd");
                return schemaMap;
            }

            public String xmlNamespace() {
                return "http://ivoa.net/dm/tapschema/v1";
            }

            public String jsonSchema() {
                return "https://ivoa.net/dm/tapschema.vo-dml.json";
            }

            public List<Class> contentClasses() {
                return List.of(Schema.class);
            }

            public List<String> allClassNames() {
                return List.of("org.ivoa.dm.tapschema.Schema", "org.ivoa.dm.tapschema.Table", "org.ivoa.dm.tapschema.Column", "org.ivoa.dm.tapschema.ForeignKey", "org.ivoa.dm.tapschema.FKColumn", "org.ivoa.dm.tapschema.Schema", "org.ivoa.dm.tapschema.Table", "org.ivoa.dm.tapschema.Column", "org.ivoa.dm.tapschema.ForeignKey", "org.ivoa.dm.tapschema.FKColumn", "org.ivoa.dm.ivoa.Unit", "org.ivoa.vodml.stdtypes.Complex", "org.ivoa.vodml.stdtypes.Rational", "org.ivoa.dm.ivoa.IntegerQuantity", "org.ivoa.dm.ivoa.Quantity", "org.ivoa.dm.ivoa.RealQuantity");
            }
        };
    }

    @XmlType
    public static class References {
    }
}

