package org.ivoa.dm.tapschema;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ivoa.vodml.ModelContext;
import org.ivoa.vodml.ModelDescription;
import org.ivoa.vodml.ModelManagement;
import org.ivoa.vodml.VodmlModel;
import org.ivoa.vodml.annotation.VoDml;
import org.ivoa.vodml.annotation.VodmlRole;
import org.ivoa.vodml.jaxb.XmlIdManagement;
import org.ivoa.vodml.nav.ReferenceCache;
import org.ivoa.vodml.vocabularies.Vocabulary;

/** The container class for the tapschema Model. tapschema model */
@XmlAccessorType(XmlAccessType.NONE)
@XmlRootElement(name = "tapschemaModel")
@XmlType(propOrder = {"refs", "content"})
@JsonTypeInfo(include = JsonTypeInfo.As.WRAPPER_OBJECT, use = JsonTypeInfo.Id.NAME)
@JsonIgnoreProperties({"refmap"})
@VoDml(id = "tapschema", role = VodmlRole.model, type = "tapschema")
public class TapschemaModel implements VodmlModel<TapschemaModel> {

  /** A container class for the references in the model. */
  @XmlType
  public static class References {}

  private References refs = new References();

  /**
   * @return the refs
   */
  private References getRefs() {
    return refs;
  }

  /**
   * @param refs the refs to set
   */
  @XmlElement(required = false)
  private void setRefs(References refs) {
    this.refs = refs;
  }

  @SuppressWarnings("rawtypes")
  private static java.util.List<Class> refOrder = java.util.List.of();

  @XmlElements(value = {@XmlElement(name = "schema", type = org.ivoa.dm.tapschema.Schema.class)})
  @com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver(
      value = org.ivoa.vodml.json.VodmlTypeResolver.class)
  //   @com.fasterxml.jackson.annotation.JsonTypeInfo (use =
  // com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NAME, include =
  // com.fasterxml.jackson.annotation.JsonTypeInfo.As.WRAPPER_OBJECT )
  @com.fasterxml.jackson.annotation.JsonTypeInfo(
      use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NAME,
      include = com.fasterxml.jackson.annotation.JsonTypeInfo.As.PROPERTY,
      property = "@type")
  private List<Object> content = new ArrayList<>();

  /** default constructor. */
  public TapschemaModel() {

    // no references

  }

  private static volatile Map<String, Vocabulary> vocabs;

  private static void loadVocabs() {
    vocabs = new HashMap<>();
  }

  /**
   * Test if a term is in the vocabulary.
   *
   * @param value the value to test
   * @param vocabulary the uri for the vocabulary.
   * @return true if the term is in the vocabulary.
   */
  public static boolean isInVocabulary(String value, String vocabulary) {
    if (vocabs == null) {
      synchronized (TapschemaModel.class) {
        loadVocabs();
      }
    }
    if (value == null) return true;
    if (vocabs.containsKey(vocabulary)) {
      return vocabs.get(vocabulary).hasTerm(value);
    }
    return false;
  }

  /**
   * add Schema to model.
   *
   * @param c org.ivoa.dm.tapschema.Schema
   */
  public void addContent(final org.ivoa.dm.tapschema.Schema c) {
    content.add(c);
  }

  /**
   * remove Schema from model.
   *
   * @param c org.ivoa.dm.tapschema.Schema
   */
  public void deleteContent(final org.ivoa.dm.tapschema.Schema c) {
    content.remove(c);
  }

  /**
   * Get the content of the given type.
   *
   * @param <T> The type of the content
   * @param c the class of the content.
   * @return the content.
   */
  @SuppressWarnings("unchecked")
  public <T> List<T> getContent(Class<T> c) {
    if (!Stream.concat(refOrder.stream(), modelDescription.contentClasses().stream())
        .anyMatch(i -> i.isAssignableFrom(c)))
      throw new IllegalArgumentException(c.getCanonicalName() + " is not part of the model");

    return (List<T>)
        content.stream()
            .filter(p -> p.getClass().isAssignableFrom(c))
            .collect(Collectors.toUnmodifiableList());
  }

  @Override
  public void processReferences() {
    List<XmlIdManagement> il = org.ivoa.vodml.nav.Util.findXmlIDs(content);

    org.ivoa.vodml.nav.Util.makeUniqueIDs(il);
  }

  /**
   * if the model has references.
   *
   * @return true if the model has references.
   */
  public static boolean hasReferences() {
    return false;
  }

  /**
   * the context factory for the model.
   *
   * @return the JAXBContext.
   * @throws JAXBException if there is a problem.
   */
  public static JAXBContext contextFactory() throws JAXBException {

    return JAXBContext.newInstance("org.ivoa.dm.tapschema:org.ivoa.dm.ivoa");
  }

  /**
   * The persistence unit name for the model.
   *
   * @return the name.
   */
  public static String pu_name() {
    return "tapschema";
  }

  /**
   * Return a Jackson objectMapper suitable for JSON serialzation.
   *
   * @return the objectmapper.
   */
  public static ObjectMapper jsonMapper() {
    return org.ivoa.vodml.json.JsonManagement.jsonMapper(TapschemaModel.modelDescription);
  }

  /**
   * generate management interface instance for model.
   *
   * @return the management interface.
   */
  @Override
  public ModelManagement<TapschemaModel> management() {
    return new ModelManagement<TapschemaModel>() {
      /** {@inheritDoc} */
      @Override
      public String pu_name() {
        return TapschemaModel.pu_name();
      }

      /** {@inheritDoc} */
      @Override
      public JAXBContext contextFactory() throws JAXBException {
        return TapschemaModel.contextFactory();
      }

      /** {@inheritDoc} */
      @Override
      public boolean hasReferences() {
        return TapschemaModel.hasReferences();
      }

      /** {@inheritDoc} */
      @Override
      public void persistRefs(jakarta.persistence.EntityManager em) {}

      /** {@inheritDoc} */
      @Override
      public ObjectMapper jsonMapper() {
        return TapschemaModel.jsonMapper();
      }

      /** {@inheritDoc} */
      @Override
      public TapschemaModel theModel() {
        return TapschemaModel.this;
      }

      /** {@inheritDoc} */
      @Override
      public List<Object> getContent() {
        return content;
      }

      /** {@inheritDoc} */
      @Override
      public ModelDescription description() {
        return modelDescription;
      }
    };
  }
  ;

  /** the description. */
  public static final ModelDescription modelDescription =
      new ModelDescription() {
        @SuppressWarnings("rawtypes")
        @Override
        public Map<String, Class> utypeToClassMap() {
          final HashMap<String, Class> retval = new HashMap<>();

          retval.put("tapschema:Schema", org.ivoa.dm.tapschema.Schema.class);

          retval.put("tapschema:table", org.ivoa.dm.tapschema.Table.class);

          retval.put("tapschema:column", org.ivoa.dm.tapschema.Column.class);

          retval.put("tapschema:ForeignKey", org.ivoa.dm.tapschema.ForeignKey.class);

          retval.put("tapschema:FKColumn", org.ivoa.dm.tapschema.FKColumn.class);

          retval.put("ivoa:IntegerQuantity", org.ivoa.dm.ivoa.IntegerQuantity.class);

          retval.put("ivoa:Quantity", org.ivoa.dm.ivoa.Quantity.class);

          retval.put("ivoa:RealQuantity", org.ivoa.dm.ivoa.RealQuantity.class);

          return retval;
        }

        @Override
        public Map<String, String> schemaMap() {
          final Map<String, String> schemaMap = new HashMap<>();

          schemaMap.put("http://ivoa.net/dm/tapschema/v1", "tapschema.vo-dml.xsd");

          schemaMap.put("http://ivoa.net/vodml/ivoa", "IVOA-v1.0.vo-dml.xsd");

          return schemaMap;
        }

        @Override
        public String xmlNamespace() {
          return "http://ivoa.net/dm/tapschema/v1";
        }

        @Override
        public String jsonSchema() {
          return "https://ivoa.net/dm/tapschema.vo-dml.json";
        }

        /**
         * Return a list of content classes for this model.
         *
         * @return the list.
         */
        @Override
        @SuppressWarnings("rawtypes")
        public java.util.List<Class> contentClasses() {
          return java.util.List.of(org.ivoa.dm.tapschema.Schema.class);
        }

        /**
         * Return a list of all classes for this model and included models. Generally useful for
         * things like JPA.
         *
         * @return the list.
         */
        @Override
        public java.util.List<String> allClassNames() {
          return java.util.List.of(
              "org.ivoa.dm.tapschema.Schema",
              "org.ivoa.dm.tapschema.Table",
              "org.ivoa.dm.tapschema.Column",
              "org.ivoa.dm.tapschema.ForeignKey",
              "org.ivoa.dm.tapschema.FKColumn",
              "org.ivoa.dm.tapschema.Schema",
              "org.ivoa.dm.tapschema.Table",
              "org.ivoa.dm.tapschema.Column",
              "org.ivoa.dm.tapschema.ForeignKey",
              "org.ivoa.dm.tapschema.FKColumn",
              "org.ivoa.dm.ivoa.Unit",
              "org.ivoa.vodml.stdtypes.Complex",
              "org.ivoa.vodml.stdtypes.Rational",
              "org.ivoa.dm.ivoa.IntegerQuantity",
              "org.ivoa.dm.ivoa.Quantity",
              "org.ivoa.dm.ivoa.RealQuantity");
        }
      };

  /**
   * the TAP schema for the model. The schema is represented via the TAPSchemaDM datamodel.
   *
   * @return an InputStream to the XML representation of the model.
   */
  public static java.io.InputStream TAPSchema() {
    return TapschemaModel.class.getResourceAsStream("/tapschema.vo-dml.tap.xml");
  }

  /** create a context in preparation for cloning. */
  @SuppressWarnings("rawtypes")
  public void createContext() {

    final Map<Class, ReferenceCache> collect =
        Map.ofEntries(
            Map.entry(
                org.ivoa.dm.tapschema.Table.class,
                new ReferenceCache<org.ivoa.dm.tapschema.Table>()),
            Map.entry(
                org.ivoa.dm.tapschema.Column.class,
                new ReferenceCache<org.ivoa.dm.tapschema.Column>()));
    ModelContext.create(collect);
  }
}
