package org.ivoa.dm.tapschema;

import java.util.ArrayList;
import java.util.List;

/**
 * foreign key definition.
 *
 * <p>objectType: ForeignKey
 *
 * @author generated by https://github.com/ivoa/vo-dml tools
 */
@jakarta.persistence.Entity
@jakarta.persistence.Table(name = "keys", schema = "TAP_SCHEMA")
@jakarta.persistence.NamedQueries({
  @jakarta.persistence.NamedQuery(
      name = "ForeignKey.findById",
      query = "SELECT o FROM ForeignKey o WHERE o.key_id = :id")
})
@jakarta.persistence.NamedEntityGraph(
    name = "ForeignKey_loadAll",
    attributeNodes = {@jakarta.persistence.NamedAttributeNode(value = "columns")})
@jakarta.xml.bind.annotation.XmlAccessorType(jakarta.xml.bind.annotation.XmlAccessType.NONE)
@jakarta.xml.bind.annotation.XmlType(name = "ForeignKey")
@com.fasterxml.jackson.annotation.JsonTypeInfo(
    use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NONE)
@org.ivoa.vodml.annotation.VoDml(
    id = "tapschema:ForeignKey",
    role = org.ivoa.vodml.annotation.VodmlRole.objectType)
@org.eclipse.microprofile.openapi.annotations.media.Schema(description = "foreign key definition")
public class ForeignKey implements org.ivoa.vodml.jpa.JPAManipulationsForObjectType<String> {

  /** the id of the key. : Attribute key_id : multiplicity 1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:ForeignKey.key_id",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:string",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "the id of the key")
  @jakarta.xml.bind.annotation.XmlElement(name = "key_id", required = true, type = String.class)
  @jakarta.persistence.Id
  @jakarta.persistence.Basic(optional = false)
  @jakarta.persistence.Column(name = "key_id", nullable = false)
  protected String key_id;

  /** ReferenceObject target_table : the target table of the foreign key. ( Multiplicity : 1 ) */
  @jakarta.persistence.ManyToOne(cascade = {jakarta.persistence.CascadeType.REFRESH})
  @jakarta.persistence.JoinColumn(
      name = "target_table_schema_name",
      referencedColumnName = "schema_name",
      nullable = false)
  @jakarta.persistence.JoinColumn(
      name = "target_table",
      referencedColumnName = "table_name",
      nullable = false)
  @jakarta.xml.bind.annotation.XmlIDREF
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:ForeignKey.target_table",
      role = org.ivoa.vodml.annotation.VodmlRole.reference,
      type = "tapschema:table",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.objectType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(
      description = "A reference to - the target table of the foreign key")
  protected org.ivoa.dm.tapschema.Table target_table = null;

  /** description. : Attribute description : multiplicity 0..1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:ForeignKey.description",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:string",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "description")
  @jakarta.xml.bind.annotation.XmlElement(
      name = "description",
      required = false,
      type = String.class)
  @jakarta.persistence.Basic(optional = true)
  @jakarta.persistence.Column(name = "description", nullable = true)
  protected String description;

  /** utype. : Attribute utype : multiplicity 0..1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:ForeignKey.utype",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:string",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "utype")
  @jakarta.xml.bind.annotation.XmlElement(name = "utype", required = false, type = String.class)
  @jakarta.persistence.Basic(optional = true)
  @jakarta.persistence.Column(name = "utype", nullable = true)
  protected String utype;

  /** The columns that make up the foreign key. composition columns : ( Multiplicity : 1..* ) */
  @jakarta.xml.bind.annotation.XmlElementWrapper(name = "columns")
  @jakarta.xml.bind.annotation.XmlElement(
      name = "fKColumn",
      required = true,
      type = org.ivoa.dm.tapschema.FKColumn.class)
  @jakarta.persistence.OneToMany(
      cascade = jakarta.persistence.CascadeType.ALL,
      fetch = jakarta.persistence.FetchType.LAZY,
      targetEntity = org.ivoa.dm.tapschema.FKColumn.class)
  @jakarta.persistence.JoinColumn(name = "key_id", referencedColumnName = "key_id")
  @org.hibernate.annotations.Fetch(org.hibernate.annotations.FetchMode.SUBSELECT)
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:ForeignKey.columns",
      role = org.ivoa.vodml.annotation.VodmlRole.composition,
      type = "tapschema:FKColumn",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.objectType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(
      description = "The columns that make up the foreign key")
  protected java.util.List<org.ivoa.dm.tapschema.FKColumn> columns = new java.util.ArrayList<>();

  /** Creates a new ForeignKey */
  public ForeignKey() {
    super();
  }

  /**
   * full parameter constructor.
   *
   * @param key_id the id of the key.
   * @param target_table the target table of the foreign key.
   * @param description description.
   * @param utype utype.
   * @param columns The columns that make up the foreign key.
   */
  public ForeignKey(
      final String key_id,
      final org.ivoa.dm.tapschema.Table target_table,
      final String description,
      final String utype,
      final java.util.List<org.ivoa.dm.tapschema.FKColumn> columns) {
    super();

    this.key_id = key_id;

    this.target_table = target_table;

    this.description = description;

    this.utype = utype;

    this.columns = columns;
  }

  /** updates any cloned references that are contained within the hierarchy. */
  public void updateClonedReferences() {

    //  this.key_id false false  ch=tapschema:table,tapschema:Schema;

    this.target_table =
        org.ivoa.vodml.ModelContext.current()
            .cache(org.ivoa.dm.tapschema.Table.class)
            .get(this.target_table);
    //  this.description false false  ch=tapschema:table,tapschema:Schema;

    //  this.utype false false  ch=tapschema:table,tapschema:Schema;

    if (this.columns != null) {

      for (var _x : this.columns) {
        _x.updateClonedReferences();
      }
    }
  }

  /**
   * Copy Constructor. Note that references will remain as is rather than be copied.
   *
   * @param other the object to be copied.
   */
  public ForeignKey(final ForeignKey other) {

    super();

    this.key_id = other.key_id;

    this.target_table = other.target_table;

    this.description = other.description;

    this.utype = other.utype;

    if (other.columns != null) {
      this.columns =
          other.columns.stream()
              .map(s -> new org.ivoa.dm.tapschema.FKColumn((org.ivoa.dm.tapschema.FKColumn) s))
              .collect(java.util.stream.Collectors.toList());
    }
  }

  /**
   * Update this object with the content of the given object. Note that references will remain as is
   * rather than be copied.
   *
   * @param other the object to be copied.
   */
  public void updateUsing(final ForeignKey other) {

    this.key_id = other.key_id;

    this.target_table = other.target_table;

    this.description = other.description;

    this.utype = other.utype;

    if (other.columns != null) {
      this.columns =
          other.columns.stream()
              .map(s -> new org.ivoa.dm.tapschema.FKColumn((org.ivoa.dm.tapschema.FKColumn) s))
              .collect(java.util.stream.Collectors.toList());
    }
  }

  /**
   * Returns key_id Attribute.
   *
   * @return key_id Attribute
   */
  public String getKey_id() {
    return (String) this.key_id;
  }

  /**
   * Set key_id Attribute.
   *
   * @param pKey_id value to set
   */
  public void setKey_id(final String pKey_id) {

    this.key_id = pKey_id;
  }

  /**
   * fluent setter for key_id Attribute.
   *
   * @param pKey_id value to set
   * @return ForeignKey
   */
  public org.ivoa.dm.tapschema.ForeignKey withKey_id(final String pKey_id) {
    setKey_id(pKey_id);
    return this;
  }

  /**
   * Returns target_table Reference
   *
   * @return target_table Reference
   */
  public org.ivoa.dm.tapschema.Table getTarget_table() {
    return this.target_table;
  }

  /**
   * Defines target_table Reference
   *
   * @param pTarget_table reference to set
   */
  public void setTarget_table(final org.ivoa.dm.tapschema.Table pTarget_table) {
    this.target_table = pTarget_table;
  }

  /**
   * Returns description Attribute.
   *
   * @return description Attribute
   */
  public String getDescription() {
    return (String) this.description;
  }

  /**
   * Set description Attribute.
   *
   * @param pDescription value to set
   */
  public void setDescription(final String pDescription) {

    this.description = pDescription;
  }

  /**
   * fluent setter for description Attribute.
   *
   * @param pDescription value to set
   * @return ForeignKey
   */
  public org.ivoa.dm.tapschema.ForeignKey withDescription(final String pDescription) {
    setDescription(pDescription);
    return this;
  }

  /**
   * Returns utype Attribute.
   *
   * @return utype Attribute
   */
  public String getUtype() {
    return (String) this.utype;
  }

  /**
   * Set utype Attribute.
   *
   * @param pUtype value to set
   */
  public void setUtype(final String pUtype) {

    this.utype = pUtype;
  }

  /**
   * fluent setter for utype Attribute.
   *
   * @param pUtype value to set
   * @return ForeignKey
   */
  public org.ivoa.dm.tapschema.ForeignKey withUtype(final String pUtype) {
    setUtype(pUtype);
    return this;
  }

  /**
   * Returns columns composition as an immutable list.
   *
   * @return columns composition.
   */
  public List<org.ivoa.dm.tapschema.FKColumn> getColumns() {

    return java.util.Collections.unmodifiableList(
        this.columns != null ? this.columns : new ArrayList<>());
  }

  /**
   * Defines whole columns composition.
   *
   * @param pColumns composition to set.
   */
  public void setColumns(final java.util.List<org.ivoa.dm.tapschema.FKColumn> pColumns) {

    this.columns = pColumns;
  }

  /**
   * Add a org.ivoa.dm.tapschema.FKColumn to the composition.
   *
   * @param p org.ivoa.dm.tapschema.FKColumn to add
   */
  public void addToColumns(final org.ivoa.dm.tapschema.FKColumn p) {
    if (this.columns == null) {
      this.columns = new ArrayList<>();
    }
    this.columns.add(p);
  }

  /**
   * Remove a org.ivoa.dm.tapschema.FKColumn from the composition.
   *
   * @param p org.ivoa.dm.tapschema.FKColumn to remove
   */
  public void removeFromColumns(final org.ivoa.dm.tapschema.FKColumn p) {
    if (this.columns != null) {
      this.columns.remove(p);
    }
  }

  /**
   * update a org.ivoa.dm.tapschema.FKColumn in the composition.
   *
   * @param _p org.ivoa.dm.tapschema.FKColumn to update the match is done via the database key
   */
  public void replaceInColumns(final org.ivoa.dm.tapschema.FKColumn _p) {
    if (this.columns != null) {
      for (org.ivoa.dm.tapschema.FKColumn _l : this.columns) {
        if (_l.getId().equals(_p.getId())) {
          _l.updateUsing(_p);
          return;
        }
      }
      throw new IllegalArgumentException("entry not found in composition");
    } else throw new IllegalStateException("there is no exiting entry in the composition");
  }

  /**
   * return the database key id. Note that this is the same as attribute key_id.
   *
   * @return the id
   */
  @Override
  public String getId() {
    return key_id;
  }

  /** A builder class for ForeignKey, mainly for use in the functional builder pattern. */
  public static class ForeignKeyBuilder {

    /** the id of the key. */
    public String key_id;

    /** the target table of the foreign key. */
    public org.ivoa.dm.tapschema.Table target_table;

    /** description. */
    public String description;

    /** utype. */
    public String utype;

    /** The columns that make up the foreign key. */
    public java.util.List<org.ivoa.dm.tapschema.FKColumn> columns;

    private ForeignKeyBuilder with(java.util.function.Consumer<ForeignKeyBuilder> f) {
      f.accept(this);
      return this;
    }

    /**
     * create a ForeignKey from this builder.
     *
     * @return an object initialized from the builder.
     */
    public ForeignKey create() {
      return new ForeignKey(key_id, target_table, description, utype, columns);
    }
  }

  /**
   * create a ForeignKey in functional builder style.
   *
   * @param f the functional builder.
   * @return an object initialized from the builder.
   */
  public static ForeignKey createForeignKey(java.util.function.Consumer<ForeignKeyBuilder> f) {
    return new ForeignKeyBuilder().with(f).create();
  }

  @Override
  public void forceLoad() {

    if (target_table != null) target_table.forceLoad();

    if (columns != null) {
      for (org.ivoa.dm.tapschema.FKColumn c : columns) {
        c.forceLoad();
      }
    }
  }

  /** {@inheritDoc} */
  @Override
  public void delete(jakarta.persistence.EntityManager em) {

    em.remove(this); // nothing special to do
  }
}
