package org.ivoa.dm.tapschema;

import java.util.ArrayList;
import java.util.List;

/**
 * The table.
 *
 * <p>objectType: Table
 *
 * @author generated by https://github.com/ivoa/vo-dml tools
 */
@jakarta.persistence.Entity
@jakarta.persistence.Table(name = "tables", schema = "TAP_SCHEMA")
@jakarta.persistence.NamedQueries({
  @jakarta.persistence.NamedQuery(
      name = "Table.findById",
      query = "SELECT o FROM Table o WHERE o.table_name = :id")
})
@jakarta.persistence.NamedEntityGraph(
    name = "Table_loadAll",
    attributeNodes = {
      @jakarta.persistence.NamedAttributeNode(value = "columns"),
      @jakarta.persistence.NamedAttributeNode(value = "fkeys")
    })
@jakarta.persistence.IdClass(Table.Table_PK.class)
@jakarta.xml.bind.annotation.XmlAccessorType(jakarta.xml.bind.annotation.XmlAccessType.NONE)
@jakarta.xml.bind.annotation.XmlType(name = "table")
@com.fasterxml.jackson.annotation.JsonTypeInfo(
    use = com.fasterxml.jackson.annotation.JsonTypeInfo.Id.NONE)
@com.fasterxml.jackson.annotation.JsonIdentityInfo(
    property = "table_name",
    generator = com.fasterxml.jackson.annotation.ObjectIdGenerators.PropertyGenerator.class,
    scope = org.ivoa.dm.tapschema.Table.class)
@org.ivoa.vodml.annotation.VoDml(
    id = "tapschema:table",
    role = org.ivoa.vodml.annotation.VodmlRole.objectType)
@org.eclipse.microprofile.openapi.annotations.media.Schema(description = "The table")
public class Table
    implements org.ivoa.vodml.jpa.JPAManipulationsForObjectType<String>,
        org.ivoa.vodml.jaxb.XmlIdManagement {

  /** Composite key for Table. */
  public static class Table_PK {
    String schema_name;
    String table_name;
  }

  /** additional key to parent of composition(s). */
  @jakarta.persistence.Id
  @jakarta.xml.bind.annotation.XmlTransient
  @jakarta.persistence.Column(insertable = false, updatable = false)
  protected String schema_name;

  /** name of the table. : Attribute table_name : multiplicity 1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:table.table_name",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:string",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "name of the table")
  @jakarta.xml.bind.annotation.XmlElement(name = "table_name", required = true, type = String.class)
  @jakarta.xml.bind.annotation.XmlID
  @jakarta.persistence.Id
  @jakarta.persistence.Basic(optional = false)
  @jakarta.persistence.Column(name = "table_name", nullable = false)
  protected String table_name;

  /** the type of table. : Attribute table_type : multiplicity 1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:table.table_type",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "tapschema:TableType",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.enumeration)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "the type of table")
  @jakarta.xml.bind.annotation.XmlElement(
      name = "table_type",
      required = true,
      type = org.ivoa.dm.tapschema.TableType.class)
  @jakarta.persistence.Basic(optional = false)
  @jakarta.persistence.Enumerated(jakarta.persistence.EnumType.STRING)
  @jakarta.persistence.Column(name = "table_type", nullable = false)
  protected org.ivoa.dm.tapschema.TableType table_type;

  /** utype. : Attribute utype : multiplicity 0..1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:table.utype",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:string",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "utype")
  @jakarta.xml.bind.annotation.XmlElement(name = "utype", required = false, type = String.class)
  @jakarta.persistence.Basic(optional = true)
  @jakarta.persistence.Column(name = "utype", nullable = true)
  protected String utype;

  /** description. : Attribute description : multiplicity 0..1 */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:table.description",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:string",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(description = "description")
  @jakarta.xml.bind.annotation.XmlElement(
      name = "description",
      required = false,
      type = String.class)
  @jakarta.persistence.Basic(optional = true)
  @jakarta.persistence.Column(name = "description", nullable = true, length = 4095)
  protected String description;

  /**
   * used to recommend table ordering for clients. Clients may order by index (ascending) so lower
   * index items would appear earlier in a listing. : Attribute table_index : multiplicity 0..1
   */
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:table.table_index",
      role = org.ivoa.vodml.annotation.VodmlRole.attribute,
      type = "ivoa:integer",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.primitiveType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(
      description =
          "used to recommend table ordering for clients. Clients may order by index (ascending) so lower index items would appear earlier in a listing.")
  @jakarta.xml.bind.annotation.XmlElement(
      name = "table_index",
      required = false,
      type = Integer.class)
  @jakarta.persistence.Basic(optional = true)
  @jakarta.persistence.Column(name = "table_index", nullable = true)
  protected Integer table_index;

  /** the columns that make up the table. composition columns : ( Multiplicity : 1..* ) */
  @jakarta.xml.bind.annotation.XmlElementWrapper(name = "columns")
  @jakarta.xml.bind.annotation.XmlElement(
      name = "column",
      required = true,
      type = org.ivoa.dm.tapschema.Column.class)
  @jakarta.persistence.OneToMany(
      cascade = jakarta.persistence.CascadeType.ALL,
      fetch = jakarta.persistence.FetchType.LAZY,
      targetEntity = org.ivoa.dm.tapschema.Column.class)
  @jakarta.persistence.JoinColumn(name = "schema_name", referencedColumnName = "schema_name")
  @jakarta.persistence.JoinColumn(name = "table_name", referencedColumnName = "table_name")
  @org.hibernate.annotations.Fetch(org.hibernate.annotations.FetchMode.SUBSELECT)
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:table.columns",
      role = org.ivoa.vodml.annotation.VodmlRole.composition,
      type = "tapschema:column",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.objectType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(
      description = "the columns that make up the table")
  protected java.util.List<org.ivoa.dm.tapschema.Column> columns = new java.util.ArrayList<>();

  /** the foreign keys for this table. composition fkeys : ( Multiplicity : 0..* ) */
  @jakarta.xml.bind.annotation.XmlElementWrapper(name = "fkeys")
  @jakarta.xml.bind.annotation.XmlElement(
      name = "foreignKey",
      required = false,
      type = org.ivoa.dm.tapschema.ForeignKey.class)
  @jakarta.persistence.OneToMany(
      cascade = jakarta.persistence.CascadeType.ALL,
      fetch = jakarta.persistence.FetchType.LAZY,
      targetEntity = org.ivoa.dm.tapschema.ForeignKey.class)
  @jakarta.persistence.JoinColumn(name = "schema_name", referencedColumnName = "schema_name")
  @jakarta.persistence.JoinColumn(name = "from_table", referencedColumnName = "table_name")
  @org.hibernate.annotations.Fetch(org.hibernate.annotations.FetchMode.SUBSELECT)
  @org.ivoa.vodml.annotation.VoDml(
      id = "tapschema:table.fkeys",
      role = org.ivoa.vodml.annotation.VodmlRole.composition,
      type = "tapschema:ForeignKey",
      typeRole = org.ivoa.vodml.annotation.VodmlRole.objectType)
  @org.eclipse.microprofile.openapi.annotations.media.Schema(
      description = "the foreign keys for this table")
  protected java.util.List<org.ivoa.dm.tapschema.ForeignKey> fkeys = new java.util.ArrayList<>();

  /** Creates a new table */
  public Table() {
    super();
  }

  /**
   * full parameter constructor.
   *
   * @param table_name name of the table.
   * @param table_type the type of table.
   * @param utype utype.
   * @param description description.
   * @param table_index used to recommend table ordering for clients. Clients may order by index
   *     (ascending) so lower index items would appear earlier in a listing.
   * @param columns the columns that make up the table.
   * @param fkeys the foreign keys for this table.
   */
  public Table(
      final String table_name,
      final org.ivoa.dm.tapschema.TableType table_type,
      final String utype,
      final String description,
      final Integer table_index,
      final java.util.List<org.ivoa.dm.tapschema.Column> columns,
      final java.util.List<org.ivoa.dm.tapschema.ForeignKey> fkeys) {
    super();

    this.table_name = table_name;

    this.table_type = table_type;

    this.utype = utype;

    this.description = description;

    this.table_index = table_index;

    this.columns = columns;

    this.fkeys = fkeys;
  }

  /** updates any cloned references that are contained within the hierarchy. */
  public void updateClonedReferences() {

    //  this.table_name false false  ch=tapschema:Schema;

    //  this.table_type false false  ch=tapschema:Schema;

    //  this.utype false false  ch=tapschema:Schema;

    //  this.description false false  ch=tapschema:Schema;

    //  this.table_index false false  ch=tapschema:Schema;

    //  this.columns false false  ch=tapschema:Schema;

    if (this.fkeys != null) {

      for (var _x : this.fkeys) {
        _x.updateClonedReferences();
      }
    }
  }

  /**
   * Copy Constructor. Note that references will remain as is rather than be copied.
   *
   * @param other the object to be copied.
   */
  public Table(final Table other) {

    super();

    this.table_name = other.table_name;

    this.table_type = other.table_type;

    this.utype = other.utype;

    this.description = other.description;

    this.table_index = other.table_index;

    // contained reference

    if (other.columns != null) {
      var cache = org.ivoa.vodml.ModelContext.current().cache(org.ivoa.dm.tapschema.Column.class);
      var cloned =
          other.columns.stream()
              .map(s -> new org.ivoa.dm.tapschema.Column((org.ivoa.dm.tapschema.Column) s))
              .collect(java.util.stream.Collectors.toList());
      cache.setValues(other.columns, cloned);
      this.columns = cloned;
    }

    if (other.fkeys != null) {
      this.fkeys =
          other.fkeys.stream()
              .map(s -> new org.ivoa.dm.tapschema.ForeignKey((org.ivoa.dm.tapschema.ForeignKey) s))
              .collect(java.util.stream.Collectors.toList());
    }
  }

  /**
   * Update this object with the content of the given object. Note that references will remain as is
   * rather than be copied.
   *
   * @param other the object to be copied.
   */
  public void updateUsing(final Table other) {

    this.table_name = other.table_name;

    this.table_type = other.table_type;

    this.utype = other.utype;

    this.description = other.description;

    this.table_index = other.table_index;

    // contained reference

    if (other.columns != null) {
      var cache = org.ivoa.vodml.ModelContext.current().cache(org.ivoa.dm.tapschema.Column.class);
      var cloned =
          other.columns.stream()
              .map(s -> new org.ivoa.dm.tapschema.Column((org.ivoa.dm.tapschema.Column) s))
              .collect(java.util.stream.Collectors.toList());
      cache.setValues(other.columns, cloned);
      this.columns = cloned;
    }

    if (other.fkeys != null) {
      this.fkeys =
          other.fkeys.stream()
              .map(s -> new org.ivoa.dm.tapschema.ForeignKey((org.ivoa.dm.tapschema.ForeignKey) s))
              .collect(java.util.stream.Collectors.toList());
    }
  }

  /**
   * Returns table_name Attribute.
   *
   * @return table_name Attribute
   */
  public String getTable_name() {
    return (String) this.table_name;
  }

  /**
   * Set table_name Attribute.
   *
   * @param pTable_name value to set
   */
  public void setTable_name(final String pTable_name) {

    this.table_name = pTable_name;
  }

  /**
   * fluent setter for table_name Attribute.
   *
   * @param pTable_name value to set
   * @return table
   */
  public org.ivoa.dm.tapschema.Table withTable_name(final String pTable_name) {
    setTable_name(pTable_name);
    return this;
  }

  /**
   * Returns table_type Attribute.
   *
   * @return table_type Attribute
   */
  public org.ivoa.dm.tapschema.TableType getTable_type() {
    return (org.ivoa.dm.tapschema.TableType) this.table_type;
  }

  /**
   * Set table_type Attribute.
   *
   * @param pTable_type value to set
   */
  public void setTable_type(final org.ivoa.dm.tapschema.TableType pTable_type) {

    this.table_type = pTable_type;
  }

  /**
   * fluent setter for table_type Attribute.
   *
   * @param pTable_type value to set
   * @return table
   */
  public org.ivoa.dm.tapschema.Table withTable_type(
      final org.ivoa.dm.tapschema.TableType pTable_type) {
    setTable_type(pTable_type);
    return this;
  }

  /**
   * Returns utype Attribute.
   *
   * @return utype Attribute
   */
  public String getUtype() {
    return (String) this.utype;
  }

  /**
   * Set utype Attribute.
   *
   * @param pUtype value to set
   */
  public void setUtype(final String pUtype) {

    this.utype = pUtype;
  }

  /**
   * fluent setter for utype Attribute.
   *
   * @param pUtype value to set
   * @return table
   */
  public org.ivoa.dm.tapschema.Table withUtype(final String pUtype) {
    setUtype(pUtype);
    return this;
  }

  /**
   * Returns description Attribute.
   *
   * @return description Attribute
   */
  public String getDescription() {
    return (String) this.description;
  }

  /**
   * Set description Attribute.
   *
   * @param pDescription value to set
   */
  public void setDescription(final String pDescription) {

    this.description = pDescription;
  }

  /**
   * fluent setter for description Attribute.
   *
   * @param pDescription value to set
   * @return table
   */
  public org.ivoa.dm.tapschema.Table withDescription(final String pDescription) {
    setDescription(pDescription);
    return this;
  }

  /**
   * Returns table_index Attribute.
   *
   * @return table_index Attribute
   */
  public Integer getTable_index() {
    return (Integer) this.table_index;
  }

  /**
   * Set table_index Attribute.
   *
   * @param pTable_index value to set
   */
  public void setTable_index(final Integer pTable_index) {

    this.table_index = pTable_index;
  }

  /**
   * fluent setter for table_index Attribute.
   *
   * @param pTable_index value to set
   * @return table
   */
  public org.ivoa.dm.tapschema.Table withTable_index(final Integer pTable_index) {
    setTable_index(pTable_index);
    return this;
  }

  /**
   * Returns columns composition as an immutable list.
   *
   * @return columns composition.
   */
  public List<org.ivoa.dm.tapschema.Column> getColumns() {

    return java.util.Collections.unmodifiableList(
        this.columns != null ? this.columns : new ArrayList<>());
  }

  /**
   * Defines whole columns composition.
   *
   * @param pColumns composition to set.
   */
  public void setColumns(final java.util.List<org.ivoa.dm.tapschema.Column> pColumns) {

    this.columns = pColumns;
  }

  /**
   * Add a org.ivoa.dm.tapschema.Column to the composition.
   *
   * @param p org.ivoa.dm.tapschema.Column to add
   */
  public void addToColumns(final org.ivoa.dm.tapschema.Column p) {
    if (this.columns == null) {
      this.columns = new ArrayList<>();
    }
    this.columns.add(p);
  }

  /**
   * Remove a org.ivoa.dm.tapschema.Column from the composition.
   *
   * @param p org.ivoa.dm.tapschema.Column to remove
   */
  public void removeFromColumns(final org.ivoa.dm.tapschema.Column p) {
    if (this.columns != null) {
      this.columns.remove(p);
    }
  }

  /**
   * update a org.ivoa.dm.tapschema.Column in the composition.
   *
   * @param _p org.ivoa.dm.tapschema.Column to update the match is done via the database key
   */
  public void replaceInColumns(final org.ivoa.dm.tapschema.Column _p) {
    if (this.columns != null) {
      for (org.ivoa.dm.tapschema.Column _l : this.columns) {
        if (_l.getId().equals(_p.getId())) {
          _l.updateUsing(_p);
          return;
        }
      }
      throw new IllegalArgumentException("entry not found in composition");
    } else throw new IllegalStateException("there is no exiting entry in the composition");
  }

  /**
   * Returns fkeys composition as an immutable list.
   *
   * @return fkeys composition.
   */
  public List<org.ivoa.dm.tapschema.ForeignKey> getFkeys() {

    return java.util.Collections.unmodifiableList(
        this.fkeys != null ? this.fkeys : new ArrayList<>());
  }

  /**
   * Defines whole fkeys composition.
   *
   * @param pFkeys composition to set.
   */
  public void setFkeys(final java.util.List<org.ivoa.dm.tapschema.ForeignKey> pFkeys) {

    this.fkeys = pFkeys;
  }

  /**
   * Add a org.ivoa.dm.tapschema.ForeignKey to the composition.
   *
   * @param p org.ivoa.dm.tapschema.ForeignKey to add
   */
  public void addToFkeys(final org.ivoa.dm.tapschema.ForeignKey p) {
    if (this.fkeys == null) {
      this.fkeys = new ArrayList<>();
    }
    this.fkeys.add(p);
  }

  /**
   * Remove a org.ivoa.dm.tapschema.ForeignKey from the composition.
   *
   * @param p org.ivoa.dm.tapschema.ForeignKey to remove
   */
  public void removeFromFkeys(final org.ivoa.dm.tapschema.ForeignKey p) {
    if (this.fkeys != null) {
      this.fkeys.remove(p);
    }
  }

  /**
   * update a org.ivoa.dm.tapschema.ForeignKey in the composition.
   *
   * @param _p org.ivoa.dm.tapschema.ForeignKey to update the match is done via the database key
   */
  public void replaceInFkeys(final org.ivoa.dm.tapschema.ForeignKey _p) {
    if (this.fkeys != null) {
      for (org.ivoa.dm.tapschema.ForeignKey _l : this.fkeys) {
        if (_l.getId().equals(_p.getId())) {
          _l.updateUsing(_p);
          return;
        }
      }
      throw new IllegalArgumentException("entry not found in composition");
    } else throw new IllegalStateException("there is no exiting entry in the composition");
  }

  @Override
  public String getXmlId() {
    return table_name;
  }

  @Override
  public void setXmlId(String id) {
    this.table_name = id;
  }

  @Override
  public boolean hasNaturalKey() {
    return true;
  }

  /**
   * return the database key id. Note that this is the same as attribute table_name.
   *
   * @return the id
   */
  @Override
  public String getId() {
    return table_name;
  }

  /** A builder class for table, mainly for use in the functional builder pattern. */
  public static class TableBuilder {

    /** name of the table. */
    public String table_name;

    /** the type of table. */
    public org.ivoa.dm.tapschema.TableType table_type;

    /** utype. */
    public String utype;

    /** description. */
    public String description;

    /**
     * used to recommend table ordering for clients. Clients may order by index (ascending) so lower
     * index items would appear earlier in a listing.
     */
    public Integer table_index;

    /** the columns that make up the table. */
    public java.util.List<org.ivoa.dm.tapschema.Column> columns;

    /** the foreign keys for this table. */
    public java.util.List<org.ivoa.dm.tapschema.ForeignKey> fkeys;

    private TableBuilder with(java.util.function.Consumer<TableBuilder> f) {
      f.accept(this);
      return this;
    }

    /**
     * create a table from this builder.
     *
     * @return an object initialized from the builder.
     */
    public Table create() {
      return new Table(table_name, table_type, utype, description, table_index, columns, fkeys);
    }
  }

  /**
   * create a table in functional builder style.
   *
   * @param f the functional builder.
   * @return an object initialized from the builder.
   */
  public static Table createTable(java.util.function.Consumer<TableBuilder> f) {
    return new TableBuilder().with(f).create();
  }

  @Override
  public void forceLoad() {

    if (columns != null) {
      for (org.ivoa.dm.tapschema.Column c : columns) {
        c.forceLoad();
      }
    }

    if (fkeys != null) {
      for (org.ivoa.dm.tapschema.ForeignKey c : fkeys) {
        c.forceLoad();
      }
    }
  }

  /** {@inheritDoc} */
  @Override
  public void delete(jakarta.persistence.EntityManager em) {

    // has contained references tapschema:column
    // referred to by tapschema:FKColumn

    em.remove(this); // finish up with itself.
  }
}
