/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.dm.tapschema;

import org.ivoa.dm.tapschema.Column;
import org.ivoa.dm.tapschema.Schema;
import org.ivoa.dm.tapschema.Table;
import org.ivoa.dm.tapschema.TapschemaModel;

public class ColNameKeys {
    static boolean include_schema = true;

    public static void normalize(TapschemaModel model) {
        for (Schema sc : model.getContent(Schema.class)) {
            for (Table t : sc.getTables()) {
                t.schema_name = sc.schema_name;
                if (include_schema) {
                    t.table_name = sc.schema_name + "." + t.table_name;
                }
                for (Column c : t.getColumns()) {
                    c.table_name = t.table_name;
                    c.schema_name = sc.schema_name;
                    String cn = c.getColumn_name();
                    if (!cn.contains(".")) continue;
                    c.setColumn_name(cn.substring(cn.lastIndexOf(46) + 1));
                }
            }
        }
    }

    static {
        include_schema = !System.getenv().containsKey("TAPSCHEMADM_NO_SCHEMA_IN_TABLE_NAME");
    }
}

