/*
 * Decompiled with CFR 0.152.
 */
package org.ivoa.dm.tapschema;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import jakarta.persistence.Basic;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.function.Consumer;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.ivoa.dm.tapschema.TAPType;
import org.ivoa.vodml.annotation.VoDml;
import org.ivoa.vodml.annotation.VodmlRole;
import org.ivoa.vodml.jaxb.XmlIdManagement;
import org.ivoa.vodml.jpa.JPAManipulationsForObjectType;

@Entity
@Table(name="columns", schema="TAP_SCHEMA")
@NamedQueries(value={@NamedQuery(name="Column.findById", query="SELECT o FROM Column o WHERE o.column_name = :id")})
@IdClass(value=Column_PK.class)
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="column")
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
@JsonIdentityInfo(property="column_name", generator=ObjectIdGenerators.PropertyGenerator.class, scope=Column.class)
@VoDml(id="tapschema:column", role=VodmlRole.objectType)
@Schema(description="the column")
public class Column
implements JPAManipulationsForObjectType<String>,
XmlIdManagement {
    @Id
    @XmlTransient
    @jakarta.persistence.Column(insertable=false, updatable=false)
    protected String schema_name;
    @Id
    @XmlTransient
    @jakarta.persistence.Column(insertable=false, updatable=false)
    protected String table_name;
    @VoDml(id="tapschema:column.column_name", role=VodmlRole.attribute, type="ivoa:string", typeRole=VodmlRole.primitiveType)
    @Schema(description="name of the column")
    @XmlElement(name="column_name", required=true, type=String.class)
    @XmlID
    @Id
    @Basic(optional=false)
    @jakarta.persistence.Column(name="column_name", nullable=false)
    protected String column_name;
    @VoDml(id="tapschema:column.datatype", role=VodmlRole.attribute, type="tapschema:TAPType", typeRole=VodmlRole.enumeration)
    @Schema(description="the type of the column (VOTable semantics)")
    @XmlElement(name="datatype", required=true, type=TAPType.class)
    @Basic(optional=false)
    @Enumerated(value=EnumType.STRING)
    @jakarta.persistence.Column(name="datatype", nullable=false)
    protected TAPType datatype;
    @VoDml(id="tapschema:column.arraysize", role=VodmlRole.attribute, type="ivoa:string", typeRole=VodmlRole.primitiveType)
    @Schema(description="the array size of the column")
    @XmlElement(name="arraysize", required=false, type=String.class)
    @Basic(optional=true)
    @jakarta.persistence.Column(name="arraysize", nullable=true)
    protected String arraysize;
    @VoDml(id="tapschema:column.xtype", role=VodmlRole.attribute, type="ivoa:string", typeRole=VodmlRole.primitiveType)
    @Schema(description="the xtype of the column")
    @XmlElement(name="xtype", required=false, type=String.class)
    @Basic(optional=true)
    @jakarta.persistence.Column(name="xtype", nullable=true)
    protected String xtype;
    @VoDml(id="tapschema:column.description", role=VodmlRole.attribute, type="ivoa:string", typeRole=VodmlRole.primitiveType)
    @Schema(description="a description of the column")
    @XmlElement(name="description", required=false, type=String.class)
    @Basic(optional=true)
    @jakarta.persistence.Column(name="description", nullable=true, length=4095)
    protected String description;
    @VoDml(id="tapschema:column.utype", role=VodmlRole.attribute, type="ivoa:string", typeRole=VodmlRole.primitiveType)
    @Schema(description="the utype for the column")
    @XmlElement(name="utype", required=false, type=String.class)
    @Basic(optional=true)
    @jakarta.persistence.Column(name="utype", nullable=true)
    protected String utype;
    @VoDml(id="tapschema:column.unit", role=VodmlRole.attribute, type="ivoa:string", typeRole=VodmlRole.primitiveType)
    @Schema(description="the unit for the column (taken from VOUnits)")
    @XmlElement(name="unit", required=false, type=String.class)
    @Basic(optional=true)
    @jakarta.persistence.Column(name="unit", nullable=true)
    protected String unit;
    @VoDml(id="tapschema:column.ucd", role=VodmlRole.attribute, type="ivoa:string", typeRole=VodmlRole.primitiveType)
    @Schema(description="")
    @XmlElement(name="ucd", required=false, type=String.class)
    @Basic(optional=true)
    @jakarta.persistence.Column(name="ucd", nullable=true)
    protected String ucd;
    @VoDml(id="tapschema:column.indexed", role=VodmlRole.attribute, type="ivoa:boolean", typeRole=VodmlRole.primitiveType)
    @Schema(description="does the column have an index")
    @XmlElement(name="indexed", required=true, type=Boolean.class)
    @Basic(optional=false)
    @jakarta.persistence.Column(name="indexed", nullable=false)
    protected Boolean indexed;
    @VoDml(id="tapschema:column.principal", role=VodmlRole.attribute, type="ivoa:boolean", typeRole=VodmlRole.primitiveType)
    @Schema(description="indicates that the column is considered a core part of the content; clients can use this hint to make the principal column(s) visible, for example by selecting them by default in generating an ADQL query. In cases where the service selects the columns to return (such as a query language without an explicit output selection), the principal column indicates those columns that are returned by default")
    @XmlElement(name="principal", required=true, type=Boolean.class)
    @Basic(optional=false)
    @jakarta.persistence.Column(name="principal", nullable=false)
    protected Boolean principal;
    @VoDml(id="tapschema:column.std", role=VodmlRole.attribute, type="ivoa:boolean", typeRole=VodmlRole.primitiveType)
    @Schema(description="is the column defined by a standard")
    @XmlElement(name="std", required=true, type=Boolean.class)
    @Basic(optional=false)
    @jakarta.persistence.Column(name="std", nullable=false)
    protected Boolean std;
    @VoDml(id="tapschema:column.column_index", role=VodmlRole.attribute, type="ivoa:integer", typeRole=VodmlRole.primitiveType)
    @Schema(description="used to recommend table ordering for clients. Clients may order by index (ascending) so lower index items would appear earlier in a listing.")
    @XmlElement(name="column_index", required=false, type=Integer.class)
    @Basic(optional=true)
    @jakarta.persistence.Column(name="column_index", nullable=true)
    protected Integer column_index;

    public Column() {
    }

    public Column(String column_name, TAPType datatype, String arraysize, String xtype, String description, String utype, String unit, String ucd, Boolean indexed, Boolean principal, Boolean std, Integer column_index) {
        this.column_name = column_name;
        this.datatype = datatype;
        this.arraysize = arraysize;
        this.xtype = xtype;
        this.description = description;
        this.utype = utype;
        this.unit = unit;
        this.ucd = ucd;
        this.indexed = indexed;
        this.principal = principal;
        this.std = std;
        this.column_index = column_index;
    }

    public Column(Column other) {
        this.column_name = other.column_name;
        this.datatype = other.datatype;
        this.arraysize = other.arraysize;
        this.xtype = other.xtype;
        this.description = other.description;
        this.utype = other.utype;
        this.unit = other.unit;
        this.ucd = other.ucd;
        this.indexed = other.indexed;
        this.principal = other.principal;
        this.std = other.std;
        this.column_index = other.column_index;
    }

    public void updateUsing(Column other) {
        this.column_name = other.column_name;
        this.datatype = other.datatype;
        this.arraysize = other.arraysize;
        this.xtype = other.xtype;
        this.description = other.description;
        this.utype = other.utype;
        this.unit = other.unit;
        this.ucd = other.ucd;
        this.indexed = other.indexed;
        this.principal = other.principal;
        this.std = other.std;
        this.column_index = other.column_index;
    }

    public String getColumn_name() {
        return this.column_name;
    }

    public void setColumn_name(String pColumn_name) {
        this.column_name = pColumn_name;
    }

    public Column withColumn_name(String pColumn_name) {
        this.setColumn_name(pColumn_name);
        return this;
    }

    public TAPType getDatatype() {
        return this.datatype;
    }

    public void setDatatype(TAPType pDatatype) {
        this.datatype = pDatatype;
    }

    public Column withDatatype(TAPType pDatatype) {
        this.setDatatype(pDatatype);
        return this;
    }

    public String getArraysize() {
        return this.arraysize;
    }

    public void setArraysize(String pArraysize) {
        this.arraysize = pArraysize;
    }

    public Column withArraysize(String pArraysize) {
        this.setArraysize(pArraysize);
        return this;
    }

    public String getXtype() {
        return this.xtype;
    }

    public void setXtype(String pXtype) {
        this.xtype = pXtype;
    }

    public Column withXtype(String pXtype) {
        this.setXtype(pXtype);
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String pDescription) {
        this.description = pDescription;
    }

    public Column withDescription(String pDescription) {
        this.setDescription(pDescription);
        return this;
    }

    public String getUtype() {
        return this.utype;
    }

    public void setUtype(String pUtype) {
        this.utype = pUtype;
    }

    public Column withUtype(String pUtype) {
        this.setUtype(pUtype);
        return this;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String pUnit) {
        this.unit = pUnit;
    }

    public Column withUnit(String pUnit) {
        this.setUnit(pUnit);
        return this;
    }

    public String getUcd() {
        return this.ucd;
    }

    public void setUcd(String pUcd) {
        this.ucd = pUcd;
    }

    public Column withUcd(String pUcd) {
        this.setUcd(pUcd);
        return this;
    }

    public Boolean getIndexed() {
        return this.indexed;
    }

    public void setIndexed(Boolean pIndexed) {
        this.indexed = pIndexed;
    }

    public Column withIndexed(Boolean pIndexed) {
        this.setIndexed(pIndexed);
        return this;
    }

    public Boolean getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Boolean pPrincipal) {
        this.principal = pPrincipal;
    }

    public Column withPrincipal(Boolean pPrincipal) {
        this.setPrincipal(pPrincipal);
        return this;
    }

    public Boolean getStd() {
        return this.std;
    }

    public void setStd(Boolean pStd) {
        this.std = pStd;
    }

    public Column withStd(Boolean pStd) {
        this.setStd(pStd);
        return this;
    }

    public Integer getColumn_index() {
        return this.column_index;
    }

    public void setColumn_index(Integer pColumn_index) {
        this.column_index = pColumn_index;
    }

    public Column withColumn_index(Integer pColumn_index) {
        this.setColumn_index(pColumn_index);
        return this;
    }

    public String getXmlId() {
        return this.column_name;
    }

    public void setXmlId(String id) {
        this.column_name = id;
    }

    public boolean hasNaturalKey() {
        return true;
    }

    public String getId() {
        return this.column_name;
    }

    public static Column createColumn(Consumer<ColumnBuilder> f) {
        return new ColumnBuilder().with(f).create();
    }

    public void forceLoad() {
    }

    public void delete(EntityManager em) {
        em.remove((Object)this);
    }

    public static class ColumnBuilder {
        public String column_name;
        public TAPType datatype;
        public String arraysize;
        public String xtype;
        public String description;
        public String utype;
        public String unit;
        public String ucd;
        public Boolean indexed;
        public Boolean principal;
        public Boolean std;
        public Integer column_index;

        private ColumnBuilder with(Consumer<ColumnBuilder> f) {
            f.accept(this);
            return this;
        }

        public Column create() {
            return new Column(this.column_name, this.datatype, this.arraysize, this.xtype, this.description, this.utype, this.unit, this.ucd, this.indexed, this.principal, this.std, this.column_index);
        }
    }

    public static class Column_PK {
        String schema_name;
        String table_name;
        String column_name;
    }
}

