
package org.javastro.ivoa.entities.resource;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * The main purpose of an organisation as a registered resource is 
 *            to serve as a publisher of other resources.
 * 
 * <p>Java class for Organisation complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Organisation">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/VOResource/v1.0}Resource">
 *       <sequence>
 *         <element name="facility" type="{http://www.ivoa.net/xml/VOResource/v1.0}ResourceName" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="instrument" type="{http://www.ivoa.net/xml/VOResource/v1.0}ResourceName" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Organisation", propOrder = {
    "facilities",
    "instruments"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class Organisation
    extends Resource
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * the observatory or facility used to collect the data 
     *                        contained or managed by this resource.
     * 
     */
    @XmlElement(name = "facility")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<ResourceName> facilities;
    /**
     * the Instrument used to collect the data contain or 
     *                        managed by a resource.
     * 
     */
    @XmlElement(name = "instrument")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<ResourceName> instruments;

    /**
     * Default no-arg constructor
     * 
     */
    public Organisation() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Organisation(final List<Validation> validationLevels, final String title, final String shortName, final String identifier, final List<String> altIdentifiers, final Curation curation, final Content content, final LocalDateTime created, final LocalDateTime updated, final String status, final String version, final List<ResourceName> facilities, final List<ResourceName> instruments) {
        super(validationLevels, title, shortName, identifier, altIdentifiers, curation, content, created, updated, status, version);
        this.facilities = facilities;
        this.instruments = instruments;
    }

    /**
     * the observatory or facility used to collect the data 
     *                        contained or managed by this resource.
     * 
     * Gets the value of the facilities property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the facilities property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFacilities().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ResourceName }
     * </p>
     * 
     * 
     * @return
     *     The value of the facilities property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<ResourceName> getFacilities() {
        if (facilities == null) {
            facilities = new ArrayList<>();
        }
        return this.facilities;
    }

    /**
     * the Instrument used to collect the data contain or 
     *                        managed by a resource.
     * 
     * Gets the value of the instruments property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the instruments property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getInstruments().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ResourceName }
     * </p>
     * 
     * 
     * @return
     *     The value of the instruments property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<ResourceName> getInstruments() {
        if (instruments == null) {
            instruments = new ArrayList<>();
        }
        return this.instruments;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final Organisation that = ((Organisation) object);
        {
            List<ResourceName> leftFacilities;
            leftFacilities = (((this.facilities!= null)&&(!this.facilities.isEmpty()))?this.getFacilities():null);
            List<ResourceName> rightFacilities;
            rightFacilities = (((that.facilities!= null)&&(!that.facilities.isEmpty()))?that.getFacilities():null);
            if ((this.facilities!= null)&&(!this.facilities.isEmpty())) {
                if ((that.facilities!= null)&&(!that.facilities.isEmpty())) {
                    if (!leftFacilities.equals(rightFacilities)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.facilities!= null)&&(!that.facilities.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<ResourceName> leftInstruments;
            leftInstruments = (((this.instruments!= null)&&(!this.instruments.isEmpty()))?this.getInstruments():null);
            List<ResourceName> rightInstruments;
            rightInstruments = (((that.instruments!= null)&&(!that.instruments.isEmpty()))?that.getInstruments():null);
            if ((this.instruments!= null)&&(!this.instruments.isEmpty())) {
                if ((that.instruments!= null)&&(!that.instruments.isEmpty())) {
                    if (!leftInstruments.equals(rightInstruments)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.instruments!= null)&&(!that.instruments.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<ResourceName> theFacilities;
            theFacilities = (((this.facilities!= null)&&(!this.facilities.isEmpty()))?this.getFacilities():null);
            if ((this.facilities!= null)&&(!this.facilities.isEmpty())) {
                currentHashCode += theFacilities.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<ResourceName> theInstruments;
            theInstruments = (((this.instruments!= null)&&(!this.instruments.isEmpty()))?this.getInstruments():null);
            if ((this.instruments!= null)&&(!this.instruments.isEmpty())) {
                currentHashCode += theInstruments.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<ResourceName> theFacilities;
            theFacilities = (((this.facilities!= null)&&(!this.facilities.isEmpty()))?this.getFacilities():null);
            strategy.appendField(locator, this, "facilities", buffer, theFacilities, ((this.facilities!= null)&&(!this.facilities.isEmpty())));
        }
        {
            List<ResourceName> theInstruments;
            theInstruments = (((this.instruments!= null)&&(!this.instruments.isEmpty()))?this.getInstruments():null);
            strategy.appendField(locator, this, "instruments", buffer, theInstruments, ((this.instruments!= null)&&(!this.instruments.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof Organisation) {
            final Organisation target = this;
            final Organisation leftObject = ((Organisation) left);
            final Organisation rightObject = ((Organisation) right);
            {
                Boolean facilitiesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.facilities!= null)&&(!leftObject.facilities.isEmpty())), ((rightObject.facilities!= null)&&(!rightObject.facilities.isEmpty())));
                if (facilitiesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<ResourceName> lhsFacilities;
                    lhsFacilities = (((leftObject.facilities!= null)&&(!leftObject.facilities.isEmpty()))?leftObject.getFacilities():null);
                    List<ResourceName> rhsFacilities;
                    rhsFacilities = (((rightObject.facilities!= null)&&(!rightObject.facilities.isEmpty()))?rightObject.getFacilities():null);
                    List<ResourceName> mergedFacilities = ((List<ResourceName> ) strategy.merge(LocatorUtils.property(leftLocator, "facilities", lhsFacilities), LocatorUtils.property(rightLocator, "facilities", rhsFacilities), lhsFacilities, rhsFacilities, ((leftObject.facilities!= null)&&(!leftObject.facilities.isEmpty())), ((rightObject.facilities!= null)&&(!rightObject.facilities.isEmpty()))));
                    target.facilities = null;
                    if (mergedFacilities!= null) {
                        List<ResourceName> uniqueFacilitiesl = target.getFacilities();
                        uniqueFacilitiesl.addAll(mergedFacilities);
                    }
                } else {
                    if (facilitiesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.facilities = null;
                    }
                }
            }
            {
                Boolean instrumentsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.instruments!= null)&&(!leftObject.instruments.isEmpty())), ((rightObject.instruments!= null)&&(!rightObject.instruments.isEmpty())));
                if (instrumentsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<ResourceName> lhsInstruments;
                    lhsInstruments = (((leftObject.instruments!= null)&&(!leftObject.instruments.isEmpty()))?leftObject.getInstruments():null);
                    List<ResourceName> rhsInstruments;
                    rhsInstruments = (((rightObject.instruments!= null)&&(!rightObject.instruments.isEmpty()))?rightObject.getInstruments():null);
                    List<ResourceName> mergedInstruments = ((List<ResourceName> ) strategy.merge(LocatorUtils.property(leftLocator, "instruments", lhsInstruments), LocatorUtils.property(rightLocator, "instruments", rhsInstruments), lhsInstruments, rhsInstruments, ((leftObject.instruments!= null)&&(!leftObject.instruments.isEmpty())), ((rightObject.instruments!= null)&&(!rightObject.instruments.isEmpty()))));
                    target.instruments = null;
                    if (mergedInstruments!= null) {
                        List<ResourceName> uniqueInstrumentsl = target.getInstruments();
                        uniqueInstrumentsl.addAll(mergedInstruments);
                    }
                } else {
                    if (instrumentsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.instruments = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new Organisation();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Organisation clone() {
        final Organisation _newObject;
        _newObject = ((Organisation) super.clone());
        if (this.facilities == null) {
            _newObject.facilities = null;
        } else {
            _newObject.facilities = new ArrayList<>();
            for (ResourceName _item: this.facilities) {
                _newObject.facilities.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.instruments == null) {
            _newObject.instruments = null;
        } else {
            _newObject.instruments = new ArrayList<>();
            for (ResourceName _item: this.instruments) {
                _newObject.instruments.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Organisation createCopy() {
        final Organisation _newObject = ((Organisation) super.createCopy());
        if (this.facilities == null) {
            _newObject.facilities = null;
        } else {
            _newObject.facilities = new ArrayList<>();
            for (ResourceName _item: this.facilities) {
                _newObject.facilities.add(((_item == null)?null:_item.createCopy()));
            }
        }
        if (this.instruments == null) {
            _newObject.instruments = null;
        } else {
            _newObject.instruments = new ArrayList<>();
            for (ResourceName _item: this.instruments) {
                _newObject.instruments.add(((_item == null)?null:_item.createCopy()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Organisation createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Organisation _newObject = ((Organisation) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree facilitiesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("facilities"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(facilitiesPropertyTree!= null):((facilitiesPropertyTree == null)||(!facilitiesPropertyTree.isLeaf())))) {
            if (this.facilities == null) {
                _newObject.facilities = null;
            } else {
                _newObject.facilities = new ArrayList<>();
                for (ResourceName _item: this.facilities) {
                    _newObject.facilities.add(((_item == null)?null:_item.createCopy(facilitiesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree instrumentsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("instruments"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(instrumentsPropertyTree!= null):((instrumentsPropertyTree == null)||(!instrumentsPropertyTree.isLeaf())))) {
            if (this.instruments == null) {
                _newObject.instruments = null;
            } else {
                _newObject.instruments = new ArrayList<>();
                for (ResourceName _item: this.instruments) {
                    _newObject.instruments.add(((_item == null)?null:_item.createCopy(instrumentsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Organisation copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Organisation copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Organisation.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Organisation.Modifier();
        }
        return ((Organisation.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final Organisation.Builder<_B> _other) {
        super.copyTo(_other);
        if (this.facilities == null) {
            _other.facilities = null;
        } else {
            _other.facilities = new ArrayList<>();
            for (ResourceName _item: this.facilities) {
                _other.facilities.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        if (this.instruments == null) {
            _other.instruments = null;
        } else {
            _other.instruments = new ArrayList<>();
            for (ResourceName _item: this.instruments) {
                _other.instruments.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >Organisation.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Organisation.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Organisation.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Organisation.Builder<Void> builder() {
        return new Organisation.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Organisation.Builder<_B> copyOf(final Resource _other) {
        final Organisation.Builder<_B> _newBuilder = new Organisation.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Organisation.Builder<_B> copyOf(final Organisation _other) {
        final Organisation.Builder<_B> _newBuilder = new Organisation.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final Organisation.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree facilitiesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("facilities"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(facilitiesPropertyTree!= null):((facilitiesPropertyTree == null)||(!facilitiesPropertyTree.isLeaf())))) {
            if (this.facilities == null) {
                _other.facilities = null;
            } else {
                _other.facilities = new ArrayList<>();
                for (ResourceName _item: this.facilities) {
                    _other.facilities.add(((_item == null)?null:_item.newCopyBuilder(_other, facilitiesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree instrumentsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("instruments"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(instrumentsPropertyTree!= null):((instrumentsPropertyTree == null)||(!instrumentsPropertyTree.isLeaf())))) {
            if (this.instruments == null) {
                _other.instruments = null;
            } else {
                _other.instruments = new ArrayList<>();
                for (ResourceName _item: this.instruments) {
                    _other.instruments.add(((_item == null)?null:_item.newCopyBuilder(_other, instrumentsPropertyTree, _propertyTreeUse)));
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >Organisation.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Organisation.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Organisation.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Organisation.Builder<_B> copyOf(final Resource _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Organisation.Builder<_B> _newBuilder = new Organisation.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Organisation.Builder<_B> copyOf(final Organisation _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Organisation.Builder<_B> _newBuilder = new Organisation.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Organisation.Builder<Void> copyExcept(final Resource _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Organisation.Builder<Void> copyExcept(final Organisation _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Organisation.Builder<Void> copyOnly(final Resource _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Organisation.Builder<Void> copyOnly(final Organisation _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Organisation visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new CollectionProperty<>(Organisation.PropInfo.FACILITIES, this))&&(this.facilities!= null)) {
            for (ResourceName _item_: this.facilities) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new CollectionProperty<>(Organisation.PropInfo.INSTRUMENTS, this))&&(this.instruments!= null)) {
            for (ResourceName _item_: this.instruments) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        return this;
    }

    public static class Builder<_B >
        extends Resource.Builder<_B>
        implements Buildable
    {

        private List<ResourceName.Builder<Organisation.Builder<_B>>> facilities;
        private List<ResourceName.Builder<Organisation.Builder<_B>>> instruments;

        public Builder(final _B _parentBuilder, final Organisation _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                if (_other.facilities == null) {
                    this.facilities = null;
                } else {
                    this.facilities = new ArrayList<>();
                    for (ResourceName _item: _other.facilities) {
                        this.facilities.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
                if (_other.instruments == null) {
                    this.instruments = null;
                } else {
                    this.instruments = new ArrayList<>();
                    for (ResourceName _item: _other.instruments) {
                        this.instruments.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
            }
        }

        public Builder(final _B _parentBuilder, final Organisation _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree facilitiesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("facilities"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(facilitiesPropertyTree!= null):((facilitiesPropertyTree == null)||(!facilitiesPropertyTree.isLeaf())))) {
                    if (_other.facilities == null) {
                        this.facilities = null;
                    } else {
                        this.facilities = new ArrayList<>();
                        for (ResourceName _item: _other.facilities) {
                            this.facilities.add(((_item == null)?null:_item.newCopyBuilder(this, facilitiesPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
                final PropertyTree instrumentsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("instruments"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(instrumentsPropertyTree!= null):((instrumentsPropertyTree == null)||(!instrumentsPropertyTree.isLeaf())))) {
                    if (_other.instruments == null) {
                        this.instruments = null;
                    } else {
                        this.instruments = new ArrayList<>();
                        for (ResourceName _item: _other.instruments) {
                            this.instruments.add(((_item == null)?null:_item.newCopyBuilder(this, instrumentsPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
            }
        }

        protected<_P extends Organisation >_P init(final _P _product) {
            if (this.facilities!= null) {
                final List<ResourceName> facilities = new ArrayList<>(this.facilities.size());
                for (ResourceName.Builder<Organisation.Builder<_B>> _item: this.facilities) {
                    facilities.add(_item.build());
                }
                _product.facilities = facilities;
            }
            if (this.instruments!= null) {
                final List<ResourceName> instruments = new ArrayList<>(this.instruments.size());
                for (ResourceName.Builder<Organisation.Builder<_B>> _item: this.instruments) {
                    instruments.add(_item.build());
                }
                _product.instruments = instruments;
            }
            return super.init(_product);
        }

        /**
         * Adds the given items to the value of "facilities"
         * 
         * @param facilities
         *     Items to add to the value of the "facilities" property
         */
        public Organisation.Builder<_B> addFacilities(final Iterable<? extends ResourceName> facilities) {
            if (facilities!= null) {
                if (this.facilities == null) {
                    this.facilities = new ArrayList<>();
                }
                for (ResourceName _item: facilities) {
                    this.facilities.add(new ResourceName.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "facilities" (any previous value will be replaced)
         * 
         * @param facilities
         *     New value of the "facilities" property.
         */
        public Organisation.Builder<_B> withFacilities(final Iterable<? extends ResourceName> facilities) {
            if (this.facilities!= null) {
                this.facilities.clear();
            }
            return addFacilities(facilities);
        }

        /**
         * Adds the given items to the value of "facilities"
         * 
         * @param facilities
         *     Items to add to the value of the "facilities" property
         */
        public Organisation.Builder<_B> addFacilities(ResourceName... facilities) {
            addFacilities(Arrays.asList(facilities));
            return this;
        }

        /**
         * Sets the new value of "facilities" (any previous value will be replaced)
         * 
         * @param facilities
         *     New value of the "facilities" property.
         */
        public Organisation.Builder<_B> withFacilities(ResourceName... facilities) {
            withFacilities(Arrays.asList(facilities));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Facilities" property.
         * Use {@link org.javastro.ivoa.entities.resource.ResourceName.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Facilities" property.
         *     Use {@link org.javastro.ivoa.entities.resource.ResourceName.Builder#end()} to
         *     return to the current builder.
         */
        public ResourceName.Builder<? extends Organisation.Builder<_B>> addFacilities() {
            if (this.facilities == null) {
                this.facilities = new ArrayList<>();
            }
            final ResourceName.Builder<Organisation.Builder<_B>> facilities_Builder = new ResourceName.Builder<>(this, null, false);
            this.facilities.add(facilities_Builder);
            return facilities_Builder;
        }

        /**
         * Adds the given items to the value of "instruments"
         * 
         * @param instruments
         *     Items to add to the value of the "instruments" property
         */
        public Organisation.Builder<_B> addInstruments(final Iterable<? extends ResourceName> instruments) {
            if (instruments!= null) {
                if (this.instruments == null) {
                    this.instruments = new ArrayList<>();
                }
                for (ResourceName _item: instruments) {
                    this.instruments.add(new ResourceName.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "instruments" (any previous value will be replaced)
         * 
         * @param instruments
         *     New value of the "instruments" property.
         */
        public Organisation.Builder<_B> withInstruments(final Iterable<? extends ResourceName> instruments) {
            if (this.instruments!= null) {
                this.instruments.clear();
            }
            return addInstruments(instruments);
        }

        /**
         * Adds the given items to the value of "instruments"
         * 
         * @param instruments
         *     Items to add to the value of the "instruments" property
         */
        public Organisation.Builder<_B> addInstruments(ResourceName... instruments) {
            addInstruments(Arrays.asList(instruments));
            return this;
        }

        /**
         * Sets the new value of "instruments" (any previous value will be replaced)
         * 
         * @param instruments
         *     New value of the "instruments" property.
         */
        public Organisation.Builder<_B> withInstruments(ResourceName... instruments) {
            withInstruments(Arrays.asList(instruments));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Instruments"
         * property.
         * Use {@link org.javastro.ivoa.entities.resource.ResourceName.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Instruments" property.
         *     Use {@link org.javastro.ivoa.entities.resource.ResourceName.Builder#end()} to
         *     return to the current builder.
         */
        public ResourceName.Builder<? extends Organisation.Builder<_B>> addInstruments() {
            if (this.instruments == null) {
                this.instruments = new ArrayList<>();
            }
            final ResourceName.Builder<Organisation.Builder<_B>> instruments_Builder = new ResourceName.Builder<>(this, null, false);
            this.instruments.add(instruments_Builder);
            return instruments_Builder;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public Organisation.Builder<_B> addValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public Organisation.Builder<_B> addValidationLevels(Validation... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public Organisation.Builder<_B> withValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public Organisation.Builder<_B> withValidationLevels(Validation... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "title" (any previous value will be replaced)
         * 
         * @param title
         *     New value of the "title" property.
         */
        @Override
        public Organisation.Builder<_B> withTitle(final String title) {
            super.withTitle(title);
            return this;
        }

        /**
         * Sets the new value of "shortName" (any previous value will be replaced)
         * 
         * @param shortName
         *     New value of the "shortName" property.
         */
        @Override
        public Organisation.Builder<_B> withShortName(final String shortName) {
            super.withShortName(shortName);
            return this;
        }

        /**
         * Sets the new value of "identifier" (any previous value will be replaced)
         * 
         * @param identifier
         *     New value of the "identifier" property.
         */
        @Override
        public Organisation.Builder<_B> withIdentifier(final String identifier) {
            super.withIdentifier(identifier);
            return this;
        }

        /**
         * Adds the given items to the value of "altIdentifiers"
         * 
         * @param altIdentifiers
         *     Items to add to the value of the "altIdentifiers" property
         */
        @Override
        public Organisation.Builder<_B> addAltIdentifiers(final Iterable<? extends String> altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Adds the given items to the value of "altIdentifiers"
         * 
         * @param altIdentifiers
         *     Items to add to the value of the "altIdentifiers" property
         */
        @Override
        public Organisation.Builder<_B> addAltIdentifiers(String... altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "altIdentifiers" (any previous value will be replaced)
         * 
         * @param altIdentifiers
         *     New value of the "altIdentifiers" property.
         */
        @Override
        public Organisation.Builder<_B> withAltIdentifiers(final Iterable<? extends String> altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "altIdentifiers" (any previous value will be replaced)
         * 
         * @param altIdentifiers
         *     New value of the "altIdentifiers" property.
         */
        @Override
        public Organisation.Builder<_B> withAltIdentifiers(String... altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "curation" (any previous value will be replaced)
         * 
         * @param curation
         *     New value of the "curation" property.
         */
        @Override
        public Organisation.Builder<_B> withCuration(final Curation curation) {
            super.withCuration(curation);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "curation" property.
         * Use {@link org.javastro.ivoa.entities.resource.Curation.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "curation" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Curation.Builder#end()} to return
         *     to the current builder.
         */
        public Curation.Builder<? extends Organisation.Builder<_B>> withCuration() {
            return ((Curation.Builder<? extends Organisation.Builder<_B>> ) super.withCuration());
        }

        /**
         * Sets the new value of "content" (any previous value will be replaced)
         * 
         * @param content
         *     New value of the "content" property.
         */
        @Override
        public Organisation.Builder<_B> withContent(final Content content) {
            super.withContent(content);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "content" property.
         * Use {@link org.javastro.ivoa.entities.resource.Content.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "content" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Content.Builder#end()} to return
         *     to the current builder.
         */
        public Content.Builder<? extends Organisation.Builder<_B>> withContent() {
            return ((Content.Builder<? extends Organisation.Builder<_B>> ) super.withContent());
        }

        /**
         * Sets the new value of "created" (any previous value will be replaced)
         * 
         * @param created
         *     New value of the "created" property.
         */
        @Override
        public Organisation.Builder<_B> withCreated(final LocalDateTime created) {
            super.withCreated(created);
            return this;
        }

        /**
         * Sets the new value of "updated" (any previous value will be replaced)
         * 
         * @param updated
         *     New value of the "updated" property.
         */
        @Override
        public Organisation.Builder<_B> withUpdated(final LocalDateTime updated) {
            super.withUpdated(updated);
            return this;
        }

        /**
         * Sets the new value of "status" (any previous value will be replaced)
         * 
         * @param status
         *     New value of the "status" property.
         */
        @Override
        public Organisation.Builder<_B> withStatus(final String status) {
            super.withStatus(status);
            return this;
        }

        /**
         * Sets the new value of "version" (any previous value will be replaced)
         * 
         * @param version
         *     New value of the "version" property.
         */
        @Override
        public Organisation.Builder<_B> withVersion(final String version) {
            super.withVersion(version);
            return this;
        }

        @Override
        public Organisation build() {
            if (_storedValue == null) {
                return this.init(new Organisation());
            } else {
                return ((Organisation) _storedValue);
            }
        }

        public Organisation.Builder<_B> copyOf(final Organisation _other) {
            _other.copyTo(this);
            return this;
        }

        public Organisation.Builder<_B> copyOf(final Organisation.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends Resource.Modifier
    {


        public List<ResourceName> getFacilities() {
            if (Organisation.this.facilities == null) {
                Organisation.this.facilities = new ArrayList<>();
            }
            return Organisation.this.facilities;
        }

        public List<ResourceName> getInstruments() {
            if (Organisation.this.instruments == null) {
                Organisation.this.instruments = new ArrayList<>();
            }
            return Organisation.this.instruments;
        }

    }

    public static class PropInfo {

        public static final transient CollectionPropertyInfo<Organisation, ResourceName> FACILITIES = new CollectionPropertyInfo<Organisation,ResourceName>("facilities", Organisation.class, ResourceName.class, true, null, new QName("", "facility"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "ResourceName"), false) {


            @Override
            public List<ResourceName> get(final Organisation _instance_) {
                return ((_instance_ == null)?null:_instance_.facilities);
            }

            @Override
            public void set(final Organisation _instance_, final List<ResourceName> _value_) {
                if (_instance_!= null) {
                    _instance_.facilities = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Organisation, ResourceName> INSTRUMENTS = new CollectionPropertyInfo<Organisation,ResourceName>("instruments", Organisation.class, ResourceName.class, true, null, new QName("", "instrument"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "ResourceName"), false) {


            @Override
            public List<ResourceName> get(final Organisation _instance_) {
                return ((_instance_ == null)?null:_instance_.instruments);
            }

            @Override
            public void set(final Organisation _instance_, final List<ResourceName> _value_) {
                if (_instance_!= null) {
                    _instance_.instruments = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Organisation.Selector<Organisation.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Organisation.Select _root() {
            return new Organisation.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends Resource.Selector<TRoot, TParent>
    {

        private ResourceName.Selector<TRoot, Organisation.Selector<TRoot, TParent>> facilities = null;
        private ResourceName.Selector<TRoot, Organisation.Selector<TRoot, TParent>> instruments = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.facilities!= null) {
                products.put("facilities", this.facilities.init());
            }
            if (this.instruments!= null) {
                products.put("instruments", this.instruments.init());
            }
            return products;
        }

        public ResourceName.Selector<TRoot, Organisation.Selector<TRoot, TParent>> facilities() {
            return ((this.facilities == null)?this.facilities = new ResourceName.Selector<>(this._root, this, "facilities"):this.facilities);
        }

        public ResourceName.Selector<TRoot, Organisation.Selector<TRoot, TParent>> instruments() {
            return ((this.instruments == null)?this.instruments = new ResourceName.Selector<>(this._root, this, "instruments"):this.instruments);
        }

    }

}
