
package org.javastro.ivoa.entities.resource;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.javastro.ivoa.entities.resource.applications.Application;
import org.javastro.ivoa.entities.resource.dataservice.DataCollection;
import org.javastro.ivoa.entities.resource.dataservice.StandardSTC;
import org.javastro.ivoa.entities.resource.registry.Authority;
import org.javastro.ivoa.entities.resource.standard.Standard;
import org.javastro.ivoa.entities.resource.standard.StandardKeyEnumeration;
import org.javastro.ivoa.jaxb.adapters.DateTimeXmlAdapter;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Any entity or component of a VO application that is
 *            describable and identifiable by an IVOA Identifier.
 * 
 * <p>Java class for Resource complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Resource">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="validationLevel" type="{http://www.ivoa.net/xml/VOResource/v1.0}Validation" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="title" type="{http://www.w3.org/2001/XMLSchema}token"/>
 *         <element name="shortName" type="{http://www.ivoa.net/xml/VOResource/v1.0}ShortName" minOccurs="0"/>
 *         <element name="identifier" type="{http://www.ivoa.net/xml/VOResource/v1.0}IdentifierURI"/>
 *         <element name="altIdentifier" type="{http://www.w3.org/2001/XMLSchema}anyURI" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="curation" type="{http://www.ivoa.net/xml/VOResource/v1.0}Curation"/>
 *         <element name="content" type="{http://www.ivoa.net/xml/VOResource/v1.0}Content"/>
 *       </sequence>
 *       <attribute name="created" use="required" type="{http://www.ivoa.net/xml/VOResource/v1.0}UTCTimestamp" />
 *       <attribute name="updated" use="required" type="{http://www.ivoa.net/xml/VOResource/v1.0}UTCTimestamp" />
 *       <attribute name="status" use="required">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *             <enumeration value="active"/>
 *             <enumeration value="inactive"/>
 *             <enumeration value="deleted"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="version" type="{http://www.w3.org/2001/XMLSchema}token" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Resource", propOrder = {
    "validationLevels",
    "title",
    "shortName",
    "identifier",
    "altIdentifiers",
    "curation",
    "content"
})
@XmlSeeAlso({
    Organisation.class,
    DataCollection.class,
    StandardSTC.class,
    Application.class,
    Service.class,
    Authority.class,
    Standard.class,
    StandardKeyEnumeration.class
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class Resource implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * Note that when this resource is a Service, this
     *                   grade applies to the core set of metadata.
     *                   Capability and interface metadata, as well as the
     *                   compliance of the service with the interface
     *                   standard, is rated by validationLevel tag in the 
     *                   capability element (see the vr:Service complex
     *                   type).
     * 
     */
    @XmlElement(name = "validationLevel")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<Validation> validationLevels;
    /**
     * the full name given to the resource
     * 
     */
    @XmlElement(required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String title;
    /**
     * One word or a few letters is recommended.  No more
     *                  than sixteen characters are allowed.
     * 
     */
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String shortName;
    /**
     * Unambiguous reference to the resource conforming to the IVOA
     *                   standard for identifiers
     * 
     */
    @XmlElement(required = true)
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String identifier;
    /**
     * A reference to this resource in a non-IVOA identifier
     *                   scheme, e.g., DOI or bibcode.  Always use the an URI scheme
     *                   here, e.g., doi:10.1016/j.epsl.2011.11.037.  For bibcodes,
     *                   use a form like bibcode:2008ivoa.spec.0222P.
     * 
     */
    @XmlElement(name = "altIdentifier")
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<String> altIdentifiers;
    /**
     * Information regarding the general curation of the resource
     * 
     */
    @XmlElement(required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected Curation curation;
    /**
     * Information regarding the general content of the resource
     * 
     */
    @XmlElement(required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected Content content;
    /**
     * This timestamp must not be in the future.  This time is
     *               not required to be accurate; it should be at least
     *               accurate to the day.  Any non-significant time fields
     *               should be set to zero.
     * 
     */
    @XmlAttribute(name = "created", required = true)
    @XmlJavaTypeAdapter(DateTimeXmlAdapter.class)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected LocalDateTime created;
    /**
     * This timestamp must not be in the future.  This time is
     *               not required to be accurate; it should be at least
     *               accurate to the day.  Any non-significant time fields
     *               should be set to zero.
     * 
     */
    @XmlAttribute(name = "updated", required = true)
    @XmlJavaTypeAdapter(DateTimeXmlAdapter.class)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected LocalDateTime updated;
    /**
     * a tag indicating whether this resource is believed to be still
     *               actively maintained.
     * 
     */
    @XmlAttribute(name = "status", required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String status;
    /**
     * The VOResource XML schema version 
     *                against which this instance was written.
     *                Implementors should set this to the value of the version
     *                attribute of their schema's root (xs:schema) element.
     *                Clients may assume version 1.0 if this attribute is 
     *                missing.
     * 
     */
    @XmlAttribute(name = "version")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String version;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected transient Resource.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public Resource() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Resource(final List<Validation> validationLevels, final String title, final String shortName, final String identifier, final List<String> altIdentifiers, final Curation curation, final Content content, final LocalDateTime created, final LocalDateTime updated, final String status, final String version) {
        this.validationLevels = validationLevels;
        this.title = title;
        this.shortName = shortName;
        this.identifier = identifier;
        this.altIdentifiers = altIdentifiers;
        this.curation = curation;
        this.content = content;
        this.created = created;
        this.updated = updated;
        this.status = status;
        this.version = version;
    }

    /**
     * Note that when this resource is a Service, this
     *                   grade applies to the core set of metadata.
     *                   Capability and interface metadata, as well as the
     *                   compliance of the service with the interface
     *                   standard, is rated by validationLevel tag in the 
     *                   capability element (see the vr:Service complex
     *                   type).
     * 
     * Gets the value of the validationLevels property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the validationLevels property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getValidationLevels().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Validation }
     * </p>
     * 
     * 
     * @return
     *     The value of the validationLevels property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<Validation> getValidationLevels() {
        if (validationLevels == null) {
            validationLevels = new ArrayList<>();
        }
        return this.validationLevels;
    }

    /**
     * the full name given to the resource
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getTitle() {
        return title;
    }

    /**
     * Sets the value of the title property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getTitle()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setTitle(String value) {
        this.title = value;
    }

    /**
     * One word or a few letters is recommended.  No more
     *                  than sixteen characters are allowed.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getShortName() {
        return shortName;
    }

    /**
     * Sets the value of the shortName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getShortName()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setShortName(String value) {
        this.shortName = value;
    }

    /**
     * Unambiguous reference to the resource conforming to the IVOA
     *                   standard for identifiers
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getIdentifier() {
        return identifier;
    }

    /**
     * Sets the value of the identifier property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getIdentifier()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setIdentifier(String value) {
        this.identifier = value;
    }

    /**
     * A reference to this resource in a non-IVOA identifier
     *                   scheme, e.g., DOI or bibcode.  Always use the an URI scheme
     *                   here, e.g., doi:10.1016/j.epsl.2011.11.037.  For bibcodes,
     *                   use a form like bibcode:2008ivoa.spec.0222P.
     * 
     * Gets the value of the altIdentifiers property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the altIdentifiers property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAltIdentifiers().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * </p>
     * 
     * 
     * @return
     *     The value of the altIdentifiers property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<String> getAltIdentifiers() {
        if (altIdentifiers == null) {
            altIdentifiers = new ArrayList<>();
        }
        return this.altIdentifiers;
    }

    /**
     * Information regarding the general curation of the resource
     * 
     * @return
     *     possible object is
     *     {@link Curation }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Curation getCuration() {
        return curation;
    }

    /**
     * Sets the value of the curation property.
     * 
     * @param value
     *     allowed object is
     *     {@link Curation }
     *     
     * @see #getCuration()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setCuration(Curation value) {
        this.curation = value;
    }

    /**
     * Information regarding the general content of the resource
     * 
     * @return
     *     possible object is
     *     {@link Content }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Content getContent() {
        return content;
    }

    /**
     * Sets the value of the content property.
     * 
     * @param value
     *     allowed object is
     *     {@link Content }
     *     
     * @see #getContent()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setContent(Content value) {
        this.content = value;
    }

    /**
     * This timestamp must not be in the future.  This time is
     *               not required to be accurate; it should be at least
     *               accurate to the day.  Any non-significant time fields
     *               should be set to zero.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public LocalDateTime getCreated() {
        return created;
    }

    /**
     * Sets the value of the created property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getCreated()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setCreated(LocalDateTime value) {
        this.created = value;
    }

    /**
     * This timestamp must not be in the future.  This time is
     *               not required to be accurate; it should be at least
     *               accurate to the day.  Any non-significant time fields
     *               should be set to zero.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public LocalDateTime getUpdated() {
        return updated;
    }

    /**
     * Sets the value of the updated property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getUpdated()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setUpdated(LocalDateTime value) {
        this.updated = value;
    }

    /**
     * a tag indicating whether this resource is believed to be still
     *               actively maintained.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getStatus() {
        return status;
    }

    /**
     * Sets the value of the status property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getStatus()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setStatus(String value) {
        this.status = value;
    }

    /**
     * The VOResource XML schema version 
     *                against which this instance was written.
     *                Implementors should set this to the value of the version
     *                attribute of their schema's root (xs:schema) element.
     *                Clients may assume version 1.0 if this attribute is 
     *                missing.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getVersion()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setVersion(String value) {
        this.version = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final Resource that = ((Resource) object);
        {
            List<Validation> leftValidationLevels;
            leftValidationLevels = (((this.validationLevels!= null)&&(!this.validationLevels.isEmpty()))?this.getValidationLevels():null);
            List<Validation> rightValidationLevels;
            rightValidationLevels = (((that.validationLevels!= null)&&(!that.validationLevels.isEmpty()))?that.getValidationLevels():null);
            if ((this.validationLevels!= null)&&(!this.validationLevels.isEmpty())) {
                if ((that.validationLevels!= null)&&(!that.validationLevels.isEmpty())) {
                    if (!leftValidationLevels.equals(rightValidationLevels)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.validationLevels!= null)&&(!that.validationLevels.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftTitle;
            leftTitle = this.getTitle();
            String rightTitle;
            rightTitle = that.getTitle();
            if (this.title!= null) {
                if (that.title!= null) {
                    if (!leftTitle.equals(rightTitle)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.title!= null) {
                    return false;
                }
            }
        }
        {
            String leftShortName;
            leftShortName = this.getShortName();
            String rightShortName;
            rightShortName = that.getShortName();
            if (this.shortName!= null) {
                if (that.shortName!= null) {
                    if (!leftShortName.equals(rightShortName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.shortName!= null) {
                    return false;
                }
            }
        }
        {
            String leftIdentifier;
            leftIdentifier = this.getIdentifier();
            String rightIdentifier;
            rightIdentifier = that.getIdentifier();
            if (this.identifier!= null) {
                if (that.identifier!= null) {
                    if (!leftIdentifier.equals(rightIdentifier)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.identifier!= null) {
                    return false;
                }
            }
        }
        {
            List<String> leftAltIdentifiers;
            leftAltIdentifiers = (((this.altIdentifiers!= null)&&(!this.altIdentifiers.isEmpty()))?this.getAltIdentifiers():null);
            List<String> rightAltIdentifiers;
            rightAltIdentifiers = (((that.altIdentifiers!= null)&&(!that.altIdentifiers.isEmpty()))?that.getAltIdentifiers():null);
            if ((this.altIdentifiers!= null)&&(!this.altIdentifiers.isEmpty())) {
                if ((that.altIdentifiers!= null)&&(!that.altIdentifiers.isEmpty())) {
                    if (!leftAltIdentifiers.equals(rightAltIdentifiers)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.altIdentifiers!= null)&&(!that.altIdentifiers.isEmpty())) {
                    return false;
                }
            }
        }
        {
            Curation leftCuration;
            leftCuration = this.getCuration();
            Curation rightCuration;
            rightCuration = that.getCuration();
            if (this.curation!= null) {
                if (that.curation!= null) {
                    if (!leftCuration.equals(rightCuration)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.curation!= null) {
                    return false;
                }
            }
        }
        {
            Content leftContent;
            leftContent = this.getContent();
            Content rightContent;
            rightContent = that.getContent();
            if (this.content!= null) {
                if (that.content!= null) {
                    if (!leftContent.equals(rightContent)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.content!= null) {
                    return false;
                }
            }
        }
        {
            LocalDateTime leftCreated;
            leftCreated = this.getCreated();
            LocalDateTime rightCreated;
            rightCreated = that.getCreated();
            if (this.created!= null) {
                if (that.created!= null) {
                    if (!leftCreated.equals(rightCreated)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.created!= null) {
                    return false;
                }
            }
        }
        {
            LocalDateTime leftUpdated;
            leftUpdated = this.getUpdated();
            LocalDateTime rightUpdated;
            rightUpdated = that.getUpdated();
            if (this.updated!= null) {
                if (that.updated!= null) {
                    if (!leftUpdated.equals(rightUpdated)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.updated!= null) {
                    return false;
                }
            }
        }
        {
            String leftStatus;
            leftStatus = this.getStatus();
            String rightStatus;
            rightStatus = that.getStatus();
            if (this.status!= null) {
                if (that.status!= null) {
                    if (!leftStatus.equals(rightStatus)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.status!= null) {
                    return false;
                }
            }
        }
        {
            String leftVersion;
            leftVersion = this.getVersion();
            String rightVersion;
            rightVersion = that.getVersion();
            if (this.version!= null) {
                if (that.version!= null) {
                    if (!leftVersion.equals(rightVersion)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.version!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            List<Validation> theValidationLevels;
            theValidationLevels = (((this.validationLevels!= null)&&(!this.validationLevels.isEmpty()))?this.getValidationLevels():null);
            if ((this.validationLevels!= null)&&(!this.validationLevels.isEmpty())) {
                currentHashCode += theValidationLevels.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theTitle;
            theTitle = this.getTitle();
            if (this.title!= null) {
                currentHashCode += theTitle.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theShortName;
            theShortName = this.getShortName();
            if (this.shortName!= null) {
                currentHashCode += theShortName.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theIdentifier;
            theIdentifier = this.getIdentifier();
            if (this.identifier!= null) {
                currentHashCode += theIdentifier.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theAltIdentifiers;
            theAltIdentifiers = (((this.altIdentifiers!= null)&&(!this.altIdentifiers.isEmpty()))?this.getAltIdentifiers():null);
            if ((this.altIdentifiers!= null)&&(!this.altIdentifiers.isEmpty())) {
                currentHashCode += theAltIdentifiers.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Curation theCuration;
            theCuration = this.getCuration();
            if (this.curation!= null) {
                currentHashCode += theCuration.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Content theContent;
            theContent = this.getContent();
            if (this.content!= null) {
                currentHashCode += theContent.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            LocalDateTime theCreated;
            theCreated = this.getCreated();
            if (this.created!= null) {
                currentHashCode += theCreated.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            LocalDateTime theUpdated;
            theUpdated = this.getUpdated();
            if (this.updated!= null) {
                currentHashCode += theUpdated.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theStatus;
            theStatus = this.getStatus();
            if (this.status!= null) {
                currentHashCode += theStatus.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theVersion;
            theVersion = this.getVersion();
            if (this.version!= null) {
                currentHashCode += theVersion.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            List<Validation> theValidationLevels;
            theValidationLevels = (((this.validationLevels!= null)&&(!this.validationLevels.isEmpty()))?this.getValidationLevels():null);
            strategy.appendField(locator, this, "validationLevels", buffer, theValidationLevels, ((this.validationLevels!= null)&&(!this.validationLevels.isEmpty())));
        }
        {
            String theTitle;
            theTitle = this.getTitle();
            strategy.appendField(locator, this, "title", buffer, theTitle, (this.title!= null));
        }
        {
            String theShortName;
            theShortName = this.getShortName();
            strategy.appendField(locator, this, "shortName", buffer, theShortName, (this.shortName!= null));
        }
        {
            String theIdentifier;
            theIdentifier = this.getIdentifier();
            strategy.appendField(locator, this, "identifier", buffer, theIdentifier, (this.identifier!= null));
        }
        {
            List<String> theAltIdentifiers;
            theAltIdentifiers = (((this.altIdentifiers!= null)&&(!this.altIdentifiers.isEmpty()))?this.getAltIdentifiers():null);
            strategy.appendField(locator, this, "altIdentifiers", buffer, theAltIdentifiers, ((this.altIdentifiers!= null)&&(!this.altIdentifiers.isEmpty())));
        }
        {
            Curation theCuration;
            theCuration = this.getCuration();
            strategy.appendField(locator, this, "curation", buffer, theCuration, (this.curation!= null));
        }
        {
            Content theContent;
            theContent = this.getContent();
            strategy.appendField(locator, this, "content", buffer, theContent, (this.content!= null));
        }
        {
            LocalDateTime theCreated;
            theCreated = this.getCreated();
            strategy.appendField(locator, this, "created", buffer, theCreated, (this.created!= null));
        }
        {
            LocalDateTime theUpdated;
            theUpdated = this.getUpdated();
            strategy.appendField(locator, this, "updated", buffer, theUpdated, (this.updated!= null));
        }
        {
            String theStatus;
            theStatus = this.getStatus();
            strategy.appendField(locator, this, "status", buffer, theStatus, (this.status!= null));
        }
        {
            String theVersion;
            theVersion = this.getVersion();
            strategy.appendField(locator, this, "version", buffer, theVersion, (this.version!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof Resource) {
            final Resource target = this;
            final Resource leftObject = ((Resource) left);
            final Resource rightObject = ((Resource) right);
            {
                Boolean validationLevelsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.validationLevels!= null)&&(!leftObject.validationLevels.isEmpty())), ((rightObject.validationLevels!= null)&&(!rightObject.validationLevels.isEmpty())));
                if (validationLevelsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<Validation> lhsValidationLevels;
                    lhsValidationLevels = (((leftObject.validationLevels!= null)&&(!leftObject.validationLevels.isEmpty()))?leftObject.getValidationLevels():null);
                    List<Validation> rhsValidationLevels;
                    rhsValidationLevels = (((rightObject.validationLevels!= null)&&(!rightObject.validationLevels.isEmpty()))?rightObject.getValidationLevels():null);
                    List<Validation> mergedValidationLevels = ((List<Validation> ) strategy.merge(LocatorUtils.property(leftLocator, "validationLevels", lhsValidationLevels), LocatorUtils.property(rightLocator, "validationLevels", rhsValidationLevels), lhsValidationLevels, rhsValidationLevels, ((leftObject.validationLevels!= null)&&(!leftObject.validationLevels.isEmpty())), ((rightObject.validationLevels!= null)&&(!rightObject.validationLevels.isEmpty()))));
                    target.validationLevels = null;
                    if (mergedValidationLevels!= null) {
                        List<Validation> uniqueValidationLevelsl = target.getValidationLevels();
                        uniqueValidationLevelsl.addAll(mergedValidationLevels);
                    }
                } else {
                    if (validationLevelsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.validationLevels = null;
                    }
                }
            }
            {
                Boolean titleShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.title!= null), (rightObject.title!= null));
                if (titleShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsTitle;
                    lhsTitle = leftObject.getTitle();
                    String rhsTitle;
                    rhsTitle = rightObject.getTitle();
                    String mergedTitle = ((String) strategy.merge(LocatorUtils.property(leftLocator, "title", lhsTitle), LocatorUtils.property(rightLocator, "title", rhsTitle), lhsTitle, rhsTitle, (leftObject.title!= null), (rightObject.title!= null)));
                    target.setTitle(mergedTitle);
                } else {
                    if (titleShouldBeMergedAndSet == Boolean.FALSE) {
                        target.title = null;
                    }
                }
            }
            {
                Boolean shortNameShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.shortName!= null), (rightObject.shortName!= null));
                if (shortNameShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsShortName;
                    lhsShortName = leftObject.getShortName();
                    String rhsShortName;
                    rhsShortName = rightObject.getShortName();
                    String mergedShortName = ((String) strategy.merge(LocatorUtils.property(leftLocator, "shortName", lhsShortName), LocatorUtils.property(rightLocator, "shortName", rhsShortName), lhsShortName, rhsShortName, (leftObject.shortName!= null), (rightObject.shortName!= null)));
                    target.setShortName(mergedShortName);
                } else {
                    if (shortNameShouldBeMergedAndSet == Boolean.FALSE) {
                        target.shortName = null;
                    }
                }
            }
            {
                Boolean identifierShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.identifier!= null), (rightObject.identifier!= null));
                if (identifierShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsIdentifier;
                    lhsIdentifier = leftObject.getIdentifier();
                    String rhsIdentifier;
                    rhsIdentifier = rightObject.getIdentifier();
                    String mergedIdentifier = ((String) strategy.merge(LocatorUtils.property(leftLocator, "identifier", lhsIdentifier), LocatorUtils.property(rightLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, (leftObject.identifier!= null), (rightObject.identifier!= null)));
                    target.setIdentifier(mergedIdentifier);
                } else {
                    if (identifierShouldBeMergedAndSet == Boolean.FALSE) {
                        target.identifier = null;
                    }
                }
            }
            {
                Boolean altIdentifiersShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.altIdentifiers!= null)&&(!leftObject.altIdentifiers.isEmpty())), ((rightObject.altIdentifiers!= null)&&(!rightObject.altIdentifiers.isEmpty())));
                if (altIdentifiersShouldBeMergedAndSet == Boolean.TRUE) {
                    List<String> lhsAltIdentifiers;
                    lhsAltIdentifiers = (((leftObject.altIdentifiers!= null)&&(!leftObject.altIdentifiers.isEmpty()))?leftObject.getAltIdentifiers():null);
                    List<String> rhsAltIdentifiers;
                    rhsAltIdentifiers = (((rightObject.altIdentifiers!= null)&&(!rightObject.altIdentifiers.isEmpty()))?rightObject.getAltIdentifiers():null);
                    List<String> mergedAltIdentifiers = ((List<String> ) strategy.merge(LocatorUtils.property(leftLocator, "altIdentifiers", lhsAltIdentifiers), LocatorUtils.property(rightLocator, "altIdentifiers", rhsAltIdentifiers), lhsAltIdentifiers, rhsAltIdentifiers, ((leftObject.altIdentifiers!= null)&&(!leftObject.altIdentifiers.isEmpty())), ((rightObject.altIdentifiers!= null)&&(!rightObject.altIdentifiers.isEmpty()))));
                    target.altIdentifiers = null;
                    if (mergedAltIdentifiers!= null) {
                        List<String> uniqueAltIdentifiersl = target.getAltIdentifiers();
                        uniqueAltIdentifiersl.addAll(mergedAltIdentifiers);
                    }
                } else {
                    if (altIdentifiersShouldBeMergedAndSet == Boolean.FALSE) {
                        target.altIdentifiers = null;
                    }
                }
            }
            {
                Boolean curationShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.curation!= null), (rightObject.curation!= null));
                if (curationShouldBeMergedAndSet == Boolean.TRUE) {
                    Curation lhsCuration;
                    lhsCuration = leftObject.getCuration();
                    Curation rhsCuration;
                    rhsCuration = rightObject.getCuration();
                    Curation mergedCuration = ((Curation) strategy.merge(LocatorUtils.property(leftLocator, "curation", lhsCuration), LocatorUtils.property(rightLocator, "curation", rhsCuration), lhsCuration, rhsCuration, (leftObject.curation!= null), (rightObject.curation!= null)));
                    target.setCuration(mergedCuration);
                } else {
                    if (curationShouldBeMergedAndSet == Boolean.FALSE) {
                        target.curation = null;
                    }
                }
            }
            {
                Boolean contentShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.content!= null), (rightObject.content!= null));
                if (contentShouldBeMergedAndSet == Boolean.TRUE) {
                    Content lhsContent;
                    lhsContent = leftObject.getContent();
                    Content rhsContent;
                    rhsContent = rightObject.getContent();
                    Content mergedContent = ((Content) strategy.merge(LocatorUtils.property(leftLocator, "content", lhsContent), LocatorUtils.property(rightLocator, "content", rhsContent), lhsContent, rhsContent, (leftObject.content!= null), (rightObject.content!= null)));
                    target.setContent(mergedContent);
                } else {
                    if (contentShouldBeMergedAndSet == Boolean.FALSE) {
                        target.content = null;
                    }
                }
            }
            {
                Boolean createdShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.created!= null), (rightObject.created!= null));
                if (createdShouldBeMergedAndSet == Boolean.TRUE) {
                    LocalDateTime lhsCreated;
                    lhsCreated = leftObject.getCreated();
                    LocalDateTime rhsCreated;
                    rhsCreated = rightObject.getCreated();
                    LocalDateTime mergedCreated = ((LocalDateTime) strategy.merge(LocatorUtils.property(leftLocator, "created", lhsCreated), LocatorUtils.property(rightLocator, "created", rhsCreated), lhsCreated, rhsCreated, (leftObject.created!= null), (rightObject.created!= null)));
                    target.setCreated(mergedCreated);
                } else {
                    if (createdShouldBeMergedAndSet == Boolean.FALSE) {
                        target.created = null;
                    }
                }
            }
            {
                Boolean updatedShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.updated!= null), (rightObject.updated!= null));
                if (updatedShouldBeMergedAndSet == Boolean.TRUE) {
                    LocalDateTime lhsUpdated;
                    lhsUpdated = leftObject.getUpdated();
                    LocalDateTime rhsUpdated;
                    rhsUpdated = rightObject.getUpdated();
                    LocalDateTime mergedUpdated = ((LocalDateTime) strategy.merge(LocatorUtils.property(leftLocator, "updated", lhsUpdated), LocatorUtils.property(rightLocator, "updated", rhsUpdated), lhsUpdated, rhsUpdated, (leftObject.updated!= null), (rightObject.updated!= null)));
                    target.setUpdated(mergedUpdated);
                } else {
                    if (updatedShouldBeMergedAndSet == Boolean.FALSE) {
                        target.updated = null;
                    }
                }
            }
            {
                Boolean statusShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.status!= null), (rightObject.status!= null));
                if (statusShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsStatus;
                    lhsStatus = leftObject.getStatus();
                    String rhsStatus;
                    rhsStatus = rightObject.getStatus();
                    String mergedStatus = ((String) strategy.merge(LocatorUtils.property(leftLocator, "status", lhsStatus), LocatorUtils.property(rightLocator, "status", rhsStatus), lhsStatus, rhsStatus, (leftObject.status!= null), (rightObject.status!= null)));
                    target.setStatus(mergedStatus);
                } else {
                    if (statusShouldBeMergedAndSet == Boolean.FALSE) {
                        target.status = null;
                    }
                }
            }
            {
                Boolean versionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.version!= null), (rightObject.version!= null));
                if (versionShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsVersion;
                    lhsVersion = leftObject.getVersion();
                    String rhsVersion;
                    rhsVersion = rightObject.getVersion();
                    String mergedVersion = ((String) strategy.merge(LocatorUtils.property(leftLocator, "version", lhsVersion), LocatorUtils.property(rightLocator, "version", rhsVersion), lhsVersion, rhsVersion, (leftObject.version!= null), (rightObject.version!= null)));
                    target.setVersion(mergedVersion);
                } else {
                    if (versionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.version = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new Resource();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Resource clone() {
        final Resource _newObject;
        try {
            _newObject = ((Resource) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.validationLevels == null) {
            _newObject.validationLevels = null;
        } else {
            _newObject.validationLevels = new ArrayList<>();
            for (Validation _item: this.validationLevels) {
                _newObject.validationLevels.add(((_item == null)?null:_item.clone()));
            }
        }
        _newObject.altIdentifiers = ((this.altIdentifiers == null)?null:new ArrayList<>(this.altIdentifiers));
        _newObject.curation = ((this.curation == null)?null:this.curation.clone());
        _newObject.content = ((this.content == null)?null:this.content.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Resource createCopy() {
        final Resource _newObject;
        try {
            _newObject = ((Resource) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.validationLevels == null) {
            _newObject.validationLevels = null;
        } else {
            _newObject.validationLevels = new ArrayList<>();
            for (Validation _item: this.validationLevels) {
                _newObject.validationLevels.add(((_item == null)?null:_item.createCopy()));
            }
        }
        _newObject.title = this.title;
        _newObject.shortName = this.shortName;
        _newObject.identifier = this.identifier;
        _newObject.altIdentifiers = ((this.altIdentifiers == null)?null:new ArrayList<>(this.altIdentifiers));
        _newObject.curation = ((this.curation == null)?null:this.curation.createCopy());
        _newObject.content = ((this.content == null)?null:this.content.createCopy());
        _newObject.created = this.created;
        _newObject.updated = this.updated;
        _newObject.status = this.status;
        _newObject.version = this.version;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Resource createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Resource _newObject;
        try {
            _newObject = ((Resource) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree validationLevelsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("validationLevels"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(validationLevelsPropertyTree!= null):((validationLevelsPropertyTree == null)||(!validationLevelsPropertyTree.isLeaf())))) {
            if (this.validationLevels == null) {
                _newObject.validationLevels = null;
            } else {
                _newObject.validationLevels = new ArrayList<>();
                for (Validation _item: this.validationLevels) {
                    _newObject.validationLevels.add(((_item == null)?null:_item.createCopy(validationLevelsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree titlePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("title"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(titlePropertyTree!= null):((titlePropertyTree == null)||(!titlePropertyTree.isLeaf())))) {
            _newObject.title = this.title;
        }
        final PropertyTree shortNamePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("shortName"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(shortNamePropertyTree!= null):((shortNamePropertyTree == null)||(!shortNamePropertyTree.isLeaf())))) {
            _newObject.shortName = this.shortName;
        }
        final PropertyTree identifierPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("identifier"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(identifierPropertyTree!= null):((identifierPropertyTree == null)||(!identifierPropertyTree.isLeaf())))) {
            _newObject.identifier = this.identifier;
        }
        final PropertyTree altIdentifiersPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("altIdentifiers"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(altIdentifiersPropertyTree!= null):((altIdentifiersPropertyTree == null)||(!altIdentifiersPropertyTree.isLeaf())))) {
            _newObject.altIdentifiers = ((this.altIdentifiers == null)?null:new ArrayList<>(this.altIdentifiers));
        }
        final PropertyTree curationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("curation"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(curationPropertyTree!= null):((curationPropertyTree == null)||(!curationPropertyTree.isLeaf())))) {
            _newObject.curation = ((this.curation == null)?null:this.curation.createCopy(curationPropertyTree, _propertyTreeUse));
        }
        final PropertyTree contentPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("content"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(contentPropertyTree!= null):((contentPropertyTree == null)||(!contentPropertyTree.isLeaf())))) {
            _newObject.content = ((this.content == null)?null:this.content.createCopy(contentPropertyTree, _propertyTreeUse));
        }
        final PropertyTree createdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("created"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(createdPropertyTree!= null):((createdPropertyTree == null)||(!createdPropertyTree.isLeaf())))) {
            _newObject.created = this.created;
        }
        final PropertyTree updatedPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("updated"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(updatedPropertyTree!= null):((updatedPropertyTree == null)||(!updatedPropertyTree.isLeaf())))) {
            _newObject.updated = this.updated;
        }
        final PropertyTree statusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("status"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(statusPropertyTree!= null):((statusPropertyTree == null)||(!statusPropertyTree.isLeaf())))) {
            _newObject.status = this.status;
        }
        final PropertyTree versionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("version"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(versionPropertyTree!= null):((versionPropertyTree == null)||(!versionPropertyTree.isLeaf())))) {
            _newObject.version = this.version;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Resource copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Resource copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Resource.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Resource.Modifier();
        }
        return ((Resource.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final Resource.Builder<_B> _other) {
        if (this.validationLevels == null) {
            _other.validationLevels = null;
        } else {
            _other.validationLevels = new ArrayList<>();
            for (Validation _item: this.validationLevels) {
                _other.validationLevels.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        _other.title = this.title;
        _other.shortName = this.shortName;
        _other.identifier = this.identifier;
        if (this.altIdentifiers == null) {
            _other.altIdentifiers = null;
        } else {
            _other.altIdentifiers = new ArrayList<>();
            for (String _item: this.altIdentifiers) {
                _other.altIdentifiers.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
        _other.curation = ((this.curation == null)?null:this.curation.newCopyBuilder(_other));
        _other.content = ((this.content == null)?null:this.content.newCopyBuilder(_other));
        _other.created = this.created;
        _other.updated = this.updated;
        _other.status = this.status;
        _other.version = this.version;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >Resource.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Resource.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Resource.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Resource.Builder<Void> builder() {
        return new Resource.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Resource.Builder<_B> copyOf(final Resource _other) {
        final Resource.Builder<_B> _newBuilder = new Resource.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final Resource.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree validationLevelsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("validationLevels"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(validationLevelsPropertyTree!= null):((validationLevelsPropertyTree == null)||(!validationLevelsPropertyTree.isLeaf())))) {
            if (this.validationLevels == null) {
                _other.validationLevels = null;
            } else {
                _other.validationLevels = new ArrayList<>();
                for (Validation _item: this.validationLevels) {
                    _other.validationLevels.add(((_item == null)?null:_item.newCopyBuilder(_other, validationLevelsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree titlePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("title"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(titlePropertyTree!= null):((titlePropertyTree == null)||(!titlePropertyTree.isLeaf())))) {
            _other.title = this.title;
        }
        final PropertyTree shortNamePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("shortName"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(shortNamePropertyTree!= null):((shortNamePropertyTree == null)||(!shortNamePropertyTree.isLeaf())))) {
            _other.shortName = this.shortName;
        }
        final PropertyTree identifierPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("identifier"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(identifierPropertyTree!= null):((identifierPropertyTree == null)||(!identifierPropertyTree.isLeaf())))) {
            _other.identifier = this.identifier;
        }
        final PropertyTree altIdentifiersPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("altIdentifiers"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(altIdentifiersPropertyTree!= null):((altIdentifiersPropertyTree == null)||(!altIdentifiersPropertyTree.isLeaf())))) {
            if (this.altIdentifiers == null) {
                _other.altIdentifiers = null;
            } else {
                _other.altIdentifiers = new ArrayList<>();
                for (String _item: this.altIdentifiers) {
                    _other.altIdentifiers.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
        final PropertyTree curationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("curation"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(curationPropertyTree!= null):((curationPropertyTree == null)||(!curationPropertyTree.isLeaf())))) {
            _other.curation = ((this.curation == null)?null:this.curation.newCopyBuilder(_other, curationPropertyTree, _propertyTreeUse));
        }
        final PropertyTree contentPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("content"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(contentPropertyTree!= null):((contentPropertyTree == null)||(!contentPropertyTree.isLeaf())))) {
            _other.content = ((this.content == null)?null:this.content.newCopyBuilder(_other, contentPropertyTree, _propertyTreeUse));
        }
        final PropertyTree createdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("created"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(createdPropertyTree!= null):((createdPropertyTree == null)||(!createdPropertyTree.isLeaf())))) {
            _other.created = this.created;
        }
        final PropertyTree updatedPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("updated"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(updatedPropertyTree!= null):((updatedPropertyTree == null)||(!updatedPropertyTree.isLeaf())))) {
            _other.updated = this.updated;
        }
        final PropertyTree statusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("status"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(statusPropertyTree!= null):((statusPropertyTree == null)||(!statusPropertyTree.isLeaf())))) {
            _other.status = this.status;
        }
        final PropertyTree versionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("version"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(versionPropertyTree!= null):((versionPropertyTree == null)||(!versionPropertyTree.isLeaf())))) {
            _other.version = this.version;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >Resource.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Resource.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Resource.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Resource.Builder<_B> copyOf(final Resource _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Resource.Builder<_B> _newBuilder = new Resource.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Resource.Builder<Void> copyExcept(final Resource _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Resource.Builder<Void> copyOnly(final Resource _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Resource visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        if (_visitor_.visit(new CollectionProperty<>(Resource.PropInfo.VALIDATION_LEVELS, this))&&(this.validationLevels!= null)) {
            for (Validation _item_: this.validationLevels) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        _visitor_.visit(new SingleProperty<>(Resource.PropInfo.TITLE, this));
        _visitor_.visit(new SingleProperty<>(Resource.PropInfo.SHORT_NAME, this));
        _visitor_.visit(new SingleProperty<>(Resource.PropInfo.IDENTIFIER, this));
        _visitor_.visit(new CollectionProperty<>(Resource.PropInfo.ALT_IDENTIFIERS, this));
        if (_visitor_.visit(new SingleProperty<>(Resource.PropInfo.CURATION, this))&&(this.curation!= null)) {
            this.curation.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(Resource.PropInfo.CONTENT, this))&&(this.content!= null)) {
            this.content.visit(_visitor_);
        }
        _visitor_.visit(new SingleProperty<>(Resource.PropInfo.CREATED, this));
        _visitor_.visit(new SingleProperty<>(Resource.PropInfo.UPDATED, this));
        _visitor_.visit(new SingleProperty<>(Resource.PropInfo.STATUS, this));
        _visitor_.visit(new SingleProperty<>(Resource.PropInfo.VERSION, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final Resource _storedValue;
        private List<Validation.Builder<Resource.Builder<_B>>> validationLevels;
        private String title;
        private String shortName;
        private String identifier;
        private List<Buildable> altIdentifiers;
        private Curation.Builder<Resource.Builder<_B>> curation;
        private Content.Builder<Resource.Builder<_B>> content;
        private LocalDateTime created;
        private LocalDateTime updated;
        private String status;
        private String version;

        public Builder(final _B _parentBuilder, final Resource _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    if (_other.validationLevels == null) {
                        this.validationLevels = null;
                    } else {
                        this.validationLevels = new ArrayList<>();
                        for (Validation _item: _other.validationLevels) {
                            this.validationLevels.add(((_item == null)?null:_item.newCopyBuilder(this)));
                        }
                    }
                    this.title = _other.title;
                    this.shortName = _other.shortName;
                    this.identifier = _other.identifier;
                    if (_other.altIdentifiers == null) {
                        this.altIdentifiers = null;
                    } else {
                        this.altIdentifiers = new ArrayList<>();
                        for (String _item: _other.altIdentifiers) {
                            this.altIdentifiers.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                    this.curation = ((_other.curation == null)?null:_other.curation.newCopyBuilder(this));
                    this.content = ((_other.content == null)?null:_other.content.newCopyBuilder(this));
                    this.created = _other.created;
                    this.updated = _other.updated;
                    this.status = _other.status;
                    this.version = _other.version;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final Resource _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree validationLevelsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("validationLevels"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(validationLevelsPropertyTree!= null):((validationLevelsPropertyTree == null)||(!validationLevelsPropertyTree.isLeaf())))) {
                        if (_other.validationLevels == null) {
                            this.validationLevels = null;
                        } else {
                            this.validationLevels = new ArrayList<>();
                            for (Validation _item: _other.validationLevels) {
                                this.validationLevels.add(((_item == null)?null:_item.newCopyBuilder(this, validationLevelsPropertyTree, _propertyTreeUse)));
                            }
                        }
                    }
                    final PropertyTree titlePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("title"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(titlePropertyTree!= null):((titlePropertyTree == null)||(!titlePropertyTree.isLeaf())))) {
                        this.title = _other.title;
                    }
                    final PropertyTree shortNamePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("shortName"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(shortNamePropertyTree!= null):((shortNamePropertyTree == null)||(!shortNamePropertyTree.isLeaf())))) {
                        this.shortName = _other.shortName;
                    }
                    final PropertyTree identifierPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("identifier"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(identifierPropertyTree!= null):((identifierPropertyTree == null)||(!identifierPropertyTree.isLeaf())))) {
                        this.identifier = _other.identifier;
                    }
                    final PropertyTree altIdentifiersPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("altIdentifiers"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(altIdentifiersPropertyTree!= null):((altIdentifiersPropertyTree == null)||(!altIdentifiersPropertyTree.isLeaf())))) {
                        if (_other.altIdentifiers == null) {
                            this.altIdentifiers = null;
                        } else {
                            this.altIdentifiers = new ArrayList<>();
                            for (String _item: _other.altIdentifiers) {
                                this.altIdentifiers.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                            }
                        }
                    }
                    final PropertyTree curationPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("curation"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(curationPropertyTree!= null):((curationPropertyTree == null)||(!curationPropertyTree.isLeaf())))) {
                        this.curation = ((_other.curation == null)?null:_other.curation.newCopyBuilder(this, curationPropertyTree, _propertyTreeUse));
                    }
                    final PropertyTree contentPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("content"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(contentPropertyTree!= null):((contentPropertyTree == null)||(!contentPropertyTree.isLeaf())))) {
                        this.content = ((_other.content == null)?null:_other.content.newCopyBuilder(this, contentPropertyTree, _propertyTreeUse));
                    }
                    final PropertyTree createdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("created"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(createdPropertyTree!= null):((createdPropertyTree == null)||(!createdPropertyTree.isLeaf())))) {
                        this.created = _other.created;
                    }
                    final PropertyTree updatedPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("updated"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(updatedPropertyTree!= null):((updatedPropertyTree == null)||(!updatedPropertyTree.isLeaf())))) {
                        this.updated = _other.updated;
                    }
                    final PropertyTree statusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("status"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(statusPropertyTree!= null):((statusPropertyTree == null)||(!statusPropertyTree.isLeaf())))) {
                        this.status = _other.status;
                    }
                    final PropertyTree versionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("version"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(versionPropertyTree!= null):((versionPropertyTree == null)||(!versionPropertyTree.isLeaf())))) {
                        this.version = _other.version;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends Resource >_P init(final _P _product) {
            if (this.validationLevels!= null) {
                final List<Validation> validationLevels = new ArrayList<>(this.validationLevels.size());
                for (Validation.Builder<Resource.Builder<_B>> _item: this.validationLevels) {
                    validationLevels.add(_item.build());
                }
                _product.validationLevels = validationLevels;
            }
            _product.title = this.title;
            _product.shortName = this.shortName;
            _product.identifier = this.identifier;
            if (this.altIdentifiers!= null) {
                final List<String> altIdentifiers = new ArrayList<>(this.altIdentifiers.size());
                for (Buildable _item: this.altIdentifiers) {
                    altIdentifiers.add(((String) _item.build()));
                }
                _product.altIdentifiers = altIdentifiers;
            }
            _product.curation = ((this.curation == null)?null:this.curation.build());
            _product.content = ((this.content == null)?null:this.content.build());
            _product.created = this.created;
            _product.updated = this.updated;
            _product.status = this.status;
            _product.version = this.version;
            return _product;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        public Resource.Builder<_B> addValidationLevels(final Iterable<? extends Validation> validationLevels) {
            if (validationLevels!= null) {
                if (this.validationLevels == null) {
                    this.validationLevels = new ArrayList<>();
                }
                for (Validation _item: validationLevels) {
                    this.validationLevels.add(new Validation.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        public Resource.Builder<_B> withValidationLevels(final Iterable<? extends Validation> validationLevels) {
            if (this.validationLevels!= null) {
                this.validationLevels.clear();
            }
            return addValidationLevels(validationLevels);
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        public Resource.Builder<_B> addValidationLevels(Validation... validationLevels) {
            addValidationLevels(Arrays.asList(validationLevels));
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        public Resource.Builder<_B> withValidationLevels(Validation... validationLevels) {
            withValidationLevels(Arrays.asList(validationLevels));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "ValidationLevels"
         * property.
         * Use {@link org.javastro.ivoa.entities.resource.Validation.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "ValidationLevels" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Validation.Builder#end()} to
         *     return to the current builder.
         */
        public Validation.Builder<? extends Resource.Builder<_B>> addValidationLevels() {
            if (this.validationLevels == null) {
                this.validationLevels = new ArrayList<>();
            }
            final Validation.Builder<Resource.Builder<_B>> validationLevels_Builder = new Validation.Builder<>(this, null, false);
            this.validationLevels.add(validationLevels_Builder);
            return validationLevels_Builder;
        }

        /**
         * Sets the new value of "title" (any previous value will be replaced)
         * 
         * @param title
         *     New value of the "title" property.
         */
        public Resource.Builder<_B> withTitle(final String title) {
            this.title = title;
            return this;
        }

        /**
         * Sets the new value of "shortName" (any previous value will be replaced)
         * 
         * @param shortName
         *     New value of the "shortName" property.
         */
        public Resource.Builder<_B> withShortName(final String shortName) {
            this.shortName = shortName;
            return this;
        }

        /**
         * Sets the new value of "identifier" (any previous value will be replaced)
         * 
         * @param identifier
         *     New value of the "identifier" property.
         */
        public Resource.Builder<_B> withIdentifier(final String identifier) {
            this.identifier = identifier;
            return this;
        }

        /**
         * Adds the given items to the value of "altIdentifiers"
         * 
         * @param altIdentifiers
         *     Items to add to the value of the "altIdentifiers" property
         */
        public Resource.Builder<_B> addAltIdentifiers(final Iterable<? extends String> altIdentifiers) {
            if (altIdentifiers!= null) {
                if (this.altIdentifiers == null) {
                    this.altIdentifiers = new ArrayList<>();
                }
                for (String _item: altIdentifiers) {
                    this.altIdentifiers.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "altIdentifiers" (any previous value will be replaced)
         * 
         * @param altIdentifiers
         *     New value of the "altIdentifiers" property.
         */
        public Resource.Builder<_B> withAltIdentifiers(final Iterable<? extends String> altIdentifiers) {
            if (this.altIdentifiers!= null) {
                this.altIdentifiers.clear();
            }
            return addAltIdentifiers(altIdentifiers);
        }

        /**
         * Adds the given items to the value of "altIdentifiers"
         * 
         * @param altIdentifiers
         *     Items to add to the value of the "altIdentifiers" property
         */
        public Resource.Builder<_B> addAltIdentifiers(String... altIdentifiers) {
            addAltIdentifiers(Arrays.asList(altIdentifiers));
            return this;
        }

        /**
         * Sets the new value of "altIdentifiers" (any previous value will be replaced)
         * 
         * @param altIdentifiers
         *     New value of the "altIdentifiers" property.
         */
        public Resource.Builder<_B> withAltIdentifiers(String... altIdentifiers) {
            withAltIdentifiers(Arrays.asList(altIdentifiers));
            return this;
        }

        /**
         * Sets the new value of "curation" (any previous value will be replaced)
         * 
         * @param curation
         *     New value of the "curation" property.
         */
        public Resource.Builder<_B> withCuration(final Curation curation) {
            this.curation = ((curation == null)?null:new Curation.Builder<>(this, curation, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "curation" property.
         * Use {@link org.javastro.ivoa.entities.resource.Curation.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "curation" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Curation.Builder#end()} to return
         *     to the current builder.
         */
        public Curation.Builder<? extends Resource.Builder<_B>> withCuration() {
            if (this.curation!= null) {
                return this.curation;
            }
            return this.curation = new Curation.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "content" (any previous value will be replaced)
         * 
         * @param content
         *     New value of the "content" property.
         */
        public Resource.Builder<_B> withContent(final Content content) {
            this.content = ((content == null)?null:new Content.Builder<>(this, content, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "content" property.
         * Use {@link org.javastro.ivoa.entities.resource.Content.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "content" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Content.Builder#end()} to return
         *     to the current builder.
         */
        public Content.Builder<? extends Resource.Builder<_B>> withContent() {
            if (this.content!= null) {
                return this.content;
            }
            return this.content = new Content.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "created" (any previous value will be replaced)
         * 
         * @param created
         *     New value of the "created" property.
         */
        public Resource.Builder<_B> withCreated(final LocalDateTime created) {
            this.created = created;
            return this;
        }

        /**
         * Sets the new value of "updated" (any previous value will be replaced)
         * 
         * @param updated
         *     New value of the "updated" property.
         */
        public Resource.Builder<_B> withUpdated(final LocalDateTime updated) {
            this.updated = updated;
            return this;
        }

        /**
         * Sets the new value of "status" (any previous value will be replaced)
         * 
         * @param status
         *     New value of the "status" property.
         */
        public Resource.Builder<_B> withStatus(final String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the new value of "version" (any previous value will be replaced)
         * 
         * @param version
         *     New value of the "version" property.
         */
        public Resource.Builder<_B> withVersion(final String version) {
            this.version = version;
            return this;
        }

        @Override
        public Resource build() {
            if (_storedValue == null) {
                return this.init(new Resource());
            } else {
                return ((Resource) _storedValue);
            }
        }

        public Resource.Builder<_B> copyOf(final Resource _other) {
            _other.copyTo(this);
            return this;
        }

        public Resource.Builder<_B> copyOf(final Resource.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public List<Validation> getValidationLevels() {
            if (Resource.this.validationLevels == null) {
                Resource.this.validationLevels = new ArrayList<>();
            }
            return Resource.this.validationLevels;
        }

        public void setTitle(final String title) {
            Resource.this.setTitle(title);
        }

        public void setShortName(final String shortName) {
            Resource.this.setShortName(shortName);
        }

        public void setIdentifier(final String identifier) {
            Resource.this.setIdentifier(identifier);
        }

        public List<String> getAltIdentifiers() {
            if (Resource.this.altIdentifiers == null) {
                Resource.this.altIdentifiers = new ArrayList<>();
            }
            return Resource.this.altIdentifiers;
        }

        public void setCuration(final Curation curation) {
            Resource.this.setCuration(curation);
        }

        public void setContent(final Content content) {
            Resource.this.setContent(content);
        }

        public void setCreated(final LocalDateTime created) {
            Resource.this.setCreated(created);
        }

        public void setUpdated(final LocalDateTime updated) {
            Resource.this.setUpdated(updated);
        }

        public void setStatus(final String status) {
            Resource.this.setStatus(status);
        }

        public void setVersion(final String version) {
            Resource.this.setVersion(version);
        }

    }

    public static class PropInfo {

        public static final transient CollectionPropertyInfo<Resource, Validation> VALIDATION_LEVELS = new CollectionPropertyInfo<Resource,Validation>("validationLevels", Resource.class, Validation.class, true, null, new QName("", "validationLevel"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "Validation"), false) {


            @Override
            public List<Validation> get(final Resource _instance_) {
                return ((_instance_ == null)?null:_instance_.validationLevels);
            }

            @Override
            public void set(final Resource _instance_, final List<Validation> _value_) {
                if (_instance_!= null) {
                    _instance_.validationLevels = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Resource, String> TITLE = new SinglePropertyInfo<Resource,String>("title", Resource.class, String.class, false, null, new QName("", "title"), new QName("http://www.w3.org/2001/XMLSchema", "token"), false) {


            @Override
            public String get(final Resource _instance_) {
                return ((_instance_ == null)?null:_instance_.title);
            }

            @Override
            public void set(final Resource _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.title = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Resource, String> SHORT_NAME = new SinglePropertyInfo<Resource,String>("shortName", Resource.class, String.class, false, null, new QName("", "shortName"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "ShortName"), false) {


            @Override
            public String get(final Resource _instance_) {
                return ((_instance_ == null)?null:_instance_.shortName);
            }

            @Override
            public void set(final Resource _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.shortName = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Resource, String> IDENTIFIER = new SinglePropertyInfo<Resource,String>("identifier", Resource.class, String.class, false, null, new QName("", "identifier"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "IdentifierURI"), false) {


            @Override
            public String get(final Resource _instance_) {
                return ((_instance_ == null)?null:_instance_.identifier);
            }

            @Override
            public void set(final Resource _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.identifier = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Resource, String> ALT_IDENTIFIERS = new CollectionPropertyInfo<Resource,String>("altIdentifiers", Resource.class, String.class, true, null, new QName("", "altIdentifier"), new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), false) {


            @Override
            public List<String> get(final Resource _instance_) {
                return ((_instance_ == null)?null:_instance_.altIdentifiers);
            }

            @Override
            public void set(final Resource _instance_, final List<String> _value_) {
                if (_instance_!= null) {
                    _instance_.altIdentifiers = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Resource, Curation> CURATION = new SinglePropertyInfo<Resource,Curation>("curation", Resource.class, Curation.class, false, null, new QName("", "curation"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "Curation"), false) {


            @Override
            public Curation get(final Resource _instance_) {
                return ((_instance_ == null)?null:_instance_.curation);
            }

            @Override
            public void set(final Resource _instance_, final Curation _value_) {
                if (_instance_!= null) {
                    _instance_.curation = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Resource, Content> CONTENT = new SinglePropertyInfo<Resource,Content>("content", Resource.class, Content.class, false, null, new QName("", "content"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "Content"), false) {


            @Override
            public Content get(final Resource _instance_) {
                return ((_instance_ == null)?null:_instance_.content);
            }

            @Override
            public void set(final Resource _instance_, final Content _value_) {
                if (_instance_!= null) {
                    _instance_.content = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Resource, LocalDateTime> CREATED = new SinglePropertyInfo<Resource,LocalDateTime>("created", Resource.class, LocalDateTime.class, false, null, new QName("", "created"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "UTCTimestamp"), true) {


            @Override
            public LocalDateTime get(final Resource _instance_) {
                return ((_instance_ == null)?null:_instance_.created);
            }

            @Override
            public void set(final Resource _instance_, final LocalDateTime _value_) {
                if (_instance_!= null) {
                    _instance_.created = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Resource, LocalDateTime> UPDATED = new SinglePropertyInfo<Resource,LocalDateTime>("updated", Resource.class, LocalDateTime.class, false, null, new QName("", "updated"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "UTCTimestamp"), true) {


            @Override
            public LocalDateTime get(final Resource _instance_) {
                return ((_instance_ == null)?null:_instance_.updated);
            }

            @Override
            public void set(final Resource _instance_, final LocalDateTime _value_) {
                if (_instance_!= null) {
                    _instance_.updated = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Resource, String> STATUS = new SinglePropertyInfo<Resource,String>("status", Resource.class, String.class, false, null, new QName("", "status"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "anonymousAttributeType"), true) {


            @Override
            public String get(final Resource _instance_) {
                return ((_instance_ == null)?null:_instance_.status);
            }

            @Override
            public void set(final Resource _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.status = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Resource, String> VERSION = new SinglePropertyInfo<Resource,String>("version", Resource.class, String.class, false, null, new QName("", "version"), new QName("http://www.w3.org/2001/XMLSchema", "token"), true) {


            @Override
            public String get(final Resource _instance_) {
                return ((_instance_ == null)?null:_instance_.version);
            }

            @Override
            public void set(final Resource _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.version = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Resource.Selector<Resource.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Resource.Select _root() {
            return new Resource.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private Validation.Selector<TRoot, Resource.Selector<TRoot, TParent>> validationLevels = null;
        private com.kscs.util.jaxb.Selector<TRoot, Resource.Selector<TRoot, TParent>> title = null;
        private com.kscs.util.jaxb.Selector<TRoot, Resource.Selector<TRoot, TParent>> shortName = null;
        private com.kscs.util.jaxb.Selector<TRoot, Resource.Selector<TRoot, TParent>> identifier = null;
        private com.kscs.util.jaxb.Selector<TRoot, Resource.Selector<TRoot, TParent>> altIdentifiers = null;
        private Curation.Selector<TRoot, Resource.Selector<TRoot, TParent>> curation = null;
        private Content.Selector<TRoot, Resource.Selector<TRoot, TParent>> content = null;
        private com.kscs.util.jaxb.Selector<TRoot, Resource.Selector<TRoot, TParent>> created = null;
        private com.kscs.util.jaxb.Selector<TRoot, Resource.Selector<TRoot, TParent>> updated = null;
        private com.kscs.util.jaxb.Selector<TRoot, Resource.Selector<TRoot, TParent>> status = null;
        private com.kscs.util.jaxb.Selector<TRoot, Resource.Selector<TRoot, TParent>> version = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.validationLevels!= null) {
                products.put("validationLevels", this.validationLevels.init());
            }
            if (this.title!= null) {
                products.put("title", this.title.init());
            }
            if (this.shortName!= null) {
                products.put("shortName", this.shortName.init());
            }
            if (this.identifier!= null) {
                products.put("identifier", this.identifier.init());
            }
            if (this.altIdentifiers!= null) {
                products.put("altIdentifiers", this.altIdentifiers.init());
            }
            if (this.curation!= null) {
                products.put("curation", this.curation.init());
            }
            if (this.content!= null) {
                products.put("content", this.content.init());
            }
            if (this.created!= null) {
                products.put("created", this.created.init());
            }
            if (this.updated!= null) {
                products.put("updated", this.updated.init());
            }
            if (this.status!= null) {
                products.put("status", this.status.init());
            }
            if (this.version!= null) {
                products.put("version", this.version.init());
            }
            return products;
        }

        public Validation.Selector<TRoot, Resource.Selector<TRoot, TParent>> validationLevels() {
            return ((this.validationLevels == null)?this.validationLevels = new Validation.Selector<>(this._root, this, "validationLevels"):this.validationLevels);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Resource.Selector<TRoot, TParent>> title() {
            return ((this.title == null)?this.title = new com.kscs.util.jaxb.Selector<>(this._root, this, "title"):this.title);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Resource.Selector<TRoot, TParent>> shortName() {
            return ((this.shortName == null)?this.shortName = new com.kscs.util.jaxb.Selector<>(this._root, this, "shortName"):this.shortName);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Resource.Selector<TRoot, TParent>> identifier() {
            return ((this.identifier == null)?this.identifier = new com.kscs.util.jaxb.Selector<>(this._root, this, "identifier"):this.identifier);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Resource.Selector<TRoot, TParent>> altIdentifiers() {
            return ((this.altIdentifiers == null)?this.altIdentifiers = new com.kscs.util.jaxb.Selector<>(this._root, this, "altIdentifiers"):this.altIdentifiers);
        }

        public Curation.Selector<TRoot, Resource.Selector<TRoot, TParent>> curation() {
            return ((this.curation == null)?this.curation = new Curation.Selector<>(this._root, this, "curation"):this.curation);
        }

        public Content.Selector<TRoot, Resource.Selector<TRoot, TParent>> content() {
            return ((this.content == null)?this.content = new Content.Selector<>(this._root, this, "content"):this.content);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Resource.Selector<TRoot, TParent>> created() {
            return ((this.created == null)?this.created = new com.kscs.util.jaxb.Selector<>(this._root, this, "created"):this.created);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Resource.Selector<TRoot, TParent>> updated() {
            return ((this.updated == null)?this.updated = new com.kscs.util.jaxb.Selector<>(this._root, this, "updated"):this.updated);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Resource.Selector<TRoot, TParent>> status() {
            return ((this.status == null)?this.status = new com.kscs.util.jaxb.Selector<>(this._root, this, "status"):this.status);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Resource.Selector<TRoot, TParent>> version() {
            return ((this.version == null)?this.version = new com.kscs.util.jaxb.Selector<>(this._root, this, "version"):this.version);
        }

    }

}
