
package org.javastro.ivoa.entities.resource.dataservice;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.javastro.ivoa.entities.resource.AccessURL;
import org.javastro.ivoa.entities.resource.Content;
import org.javastro.ivoa.entities.resource.Curation;
import org.javastro.ivoa.entities.resource.Resource;
import org.javastro.ivoa.entities.resource.ResourceName;
import org.javastro.ivoa.entities.resource.Rights;
import org.javastro.ivoa.entities.resource.Validation;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * This type is deprecated.  Resource record authors should
 *             use vs:CatalogResource instead.  This type will be removed
 *             from the schema when no resource record using it remains in
 *             the registry.
 * 
 * <p>Java class for DataCollection complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="DataCollection">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/VOResource/v1.0}Resource">
 *       <sequence>
 *         <element name="facility" type="{http://www.ivoa.net/xml/VOResource/v1.0}ResourceName" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="instrument" type="{http://www.ivoa.net/xml/VOResource/v1.0}ResourceName" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="rights" type="{http://www.ivoa.net/xml/VOResource/v1.0}Rights" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="format" type="{http://www.ivoa.net/xml/VODataService/v1.1}Format" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="coverage" type="{http://www.ivoa.net/xml/VODataService/v1.1}Coverage" minOccurs="0"/>
 *         <element name="tableset" type="{http://www.ivoa.net/xml/VODataService/v1.1}TableSet" minOccurs="0"/>
 *         <element name="accessURL" type="{http://www.ivoa.net/xml/VOResource/v1.0}AccessURL" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "DataCollection", propOrder = {
    "facilities",
    "instruments",
    "rights",
    "formats",
    "coverage",
    "tableset",
    "accessURL"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class DataCollection
    extends Resource
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * the observatory or facility used to collect the data 
     *                      contained or managed by this resource.
     * 
     */
    @XmlElement(name = "facility")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<ResourceName> facilities;
    /**
     * the Instrument used to collect the data contain or 
     *                      managed by a resource.
     * 
     */
    @XmlElement(name = "instrument")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<ResourceName> instruments;
    /**
     * This should be repeated for all Rights values that apply.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<Rights> rights;
    /**
     * This should use RFC 2046 media (“MIME”) types for 
     *                       network-retrievable, digital data.  
     *                       Non-RFC 2046 values could be used for media that cannot
     *                       be retrieved over the network.
     * 
     */
    @XmlElement(name = "format")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<Format> formats;
    /**
     * Extent of the content of the resource over space, time, 
     *                      and frequency.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected Coverage coverage;
    /**
     * Each schema name must be
     *                      unique within this tableset.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected Tableset tableset;
    /**
     * The URL that can be used to download the data contained in 
     *                      this data collection.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected AccessURL accessURL;

    /**
     * Default no-arg constructor
     * 
     */
    public DataCollection() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public DataCollection(final List<Validation> validationLevels, final String title, final String shortName, final String identifier, final List<String> altIdentifiers, final Curation curation, final Content content, final LocalDateTime created, final LocalDateTime updated, final String status, final String version, final List<ResourceName> facilities, final List<ResourceName> instruments, final List<Rights> rights, final List<Format> formats, final Coverage coverage, final Tableset tableset, final AccessURL accessURL) {
        super(validationLevels, title, shortName, identifier, altIdentifiers, curation, content, created, updated, status, version);
        this.facilities = facilities;
        this.instruments = instruments;
        this.rights = rights;
        this.formats = formats;
        this.coverage = coverage;
        this.tableset = tableset;
        this.accessURL = accessURL;
    }

    /**
     * the observatory or facility used to collect the data 
     *                      contained or managed by this resource.
     * 
     * Gets the value of the facilities property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the facilities property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFacilities().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ResourceName }
     * </p>
     * 
     * 
     * @return
     *     The value of the facilities property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<ResourceName> getFacilities() {
        if (facilities == null) {
            facilities = new ArrayList<>();
        }
        return this.facilities;
    }

    /**
     * the Instrument used to collect the data contain or 
     *                      managed by a resource.
     * 
     * Gets the value of the instruments property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the instruments property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getInstruments().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ResourceName }
     * </p>
     * 
     * 
     * @return
     *     The value of the instruments property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<ResourceName> getInstruments() {
        if (instruments == null) {
            instruments = new ArrayList<>();
        }
        return this.instruments;
    }

    /**
     * This should be repeated for all Rights values that apply.
     * 
     * Gets the value of the rights property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the rights property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getRights().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Rights }
     * </p>
     * 
     * 
     * @return
     *     The value of the rights property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<Rights> getRights() {
        if (rights == null) {
            rights = new ArrayList<>();
        }
        return this.rights;
    }

    /**
     * This should use RFC 2046 media (“MIME”) types for 
     *                       network-retrievable, digital data.  
     *                       Non-RFC 2046 values could be used for media that cannot
     *                       be retrieved over the network.
     * 
     * Gets the value of the formats property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the formats property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFormats().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Format }
     * </p>
     * 
     * 
     * @return
     *     The value of the formats property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<Format> getFormats() {
        if (formats == null) {
            formats = new ArrayList<>();
        }
        return this.formats;
    }

    /**
     * Extent of the content of the resource over space, time, 
     *                      and frequency.
     * 
     * @return
     *     possible object is
     *     {@link Coverage }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Coverage getCoverage() {
        return coverage;
    }

    /**
     * Sets the value of the coverage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Coverage }
     *     
     * @see #getCoverage()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setCoverage(Coverage value) {
        this.coverage = value;
    }

    /**
     * Each schema name must be
     *                      unique within this tableset.
     * 
     * @return
     *     possible object is
     *     {@link Tableset }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Tableset getTableset() {
        return tableset;
    }

    /**
     * Sets the value of the tableset property.
     * 
     * @param value
     *     allowed object is
     *     {@link Tableset }
     *     
     * @see #getTableset()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setTableset(Tableset value) {
        this.tableset = value;
    }

    /**
     * The URL that can be used to download the data contained in 
     *                      this data collection.
     * 
     * @return
     *     possible object is
     *     {@link AccessURL }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public AccessURL getAccessURL() {
        return accessURL;
    }

    /**
     * Sets the value of the accessURL property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccessURL }
     *     
     * @see #getAccessURL()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setAccessURL(AccessURL value) {
        this.accessURL = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final DataCollection that = ((DataCollection) object);
        {
            List<ResourceName> leftFacilities;
            leftFacilities = (((this.facilities!= null)&&(!this.facilities.isEmpty()))?this.getFacilities():null);
            List<ResourceName> rightFacilities;
            rightFacilities = (((that.facilities!= null)&&(!that.facilities.isEmpty()))?that.getFacilities():null);
            if ((this.facilities!= null)&&(!this.facilities.isEmpty())) {
                if ((that.facilities!= null)&&(!that.facilities.isEmpty())) {
                    if (!leftFacilities.equals(rightFacilities)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.facilities!= null)&&(!that.facilities.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<ResourceName> leftInstruments;
            leftInstruments = (((this.instruments!= null)&&(!this.instruments.isEmpty()))?this.getInstruments():null);
            List<ResourceName> rightInstruments;
            rightInstruments = (((that.instruments!= null)&&(!that.instruments.isEmpty()))?that.getInstruments():null);
            if ((this.instruments!= null)&&(!this.instruments.isEmpty())) {
                if ((that.instruments!= null)&&(!that.instruments.isEmpty())) {
                    if (!leftInstruments.equals(rightInstruments)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.instruments!= null)&&(!that.instruments.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<Rights> leftRights;
            leftRights = (((this.rights!= null)&&(!this.rights.isEmpty()))?this.getRights():null);
            List<Rights> rightRights;
            rightRights = (((that.rights!= null)&&(!that.rights.isEmpty()))?that.getRights():null);
            if ((this.rights!= null)&&(!this.rights.isEmpty())) {
                if ((that.rights!= null)&&(!that.rights.isEmpty())) {
                    if (!leftRights.equals(rightRights)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.rights!= null)&&(!that.rights.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<Format> leftFormats;
            leftFormats = (((this.formats!= null)&&(!this.formats.isEmpty()))?this.getFormats():null);
            List<Format> rightFormats;
            rightFormats = (((that.formats!= null)&&(!that.formats.isEmpty()))?that.getFormats():null);
            if ((this.formats!= null)&&(!this.formats.isEmpty())) {
                if ((that.formats!= null)&&(!that.formats.isEmpty())) {
                    if (!leftFormats.equals(rightFormats)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.formats!= null)&&(!that.formats.isEmpty())) {
                    return false;
                }
            }
        }
        {
            Coverage leftCoverage;
            leftCoverage = this.getCoverage();
            Coverage rightCoverage;
            rightCoverage = that.getCoverage();
            if (this.coverage!= null) {
                if (that.coverage!= null) {
                    if (!leftCoverage.equals(rightCoverage)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.coverage!= null) {
                    return false;
                }
            }
        }
        {
            Tableset leftTableset;
            leftTableset = this.getTableset();
            Tableset rightTableset;
            rightTableset = that.getTableset();
            if (this.tableset!= null) {
                if (that.tableset!= null) {
                    if (!leftTableset.equals(rightTableset)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.tableset!= null) {
                    return false;
                }
            }
        }
        {
            AccessURL leftAccessURL;
            leftAccessURL = this.getAccessURL();
            AccessURL rightAccessURL;
            rightAccessURL = that.getAccessURL();
            if (this.accessURL!= null) {
                if (that.accessURL!= null) {
                    if (!leftAccessURL.equals(rightAccessURL)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.accessURL!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<ResourceName> theFacilities;
            theFacilities = (((this.facilities!= null)&&(!this.facilities.isEmpty()))?this.getFacilities():null);
            if ((this.facilities!= null)&&(!this.facilities.isEmpty())) {
                currentHashCode += theFacilities.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<ResourceName> theInstruments;
            theInstruments = (((this.instruments!= null)&&(!this.instruments.isEmpty()))?this.getInstruments():null);
            if ((this.instruments!= null)&&(!this.instruments.isEmpty())) {
                currentHashCode += theInstruments.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Rights> theRights;
            theRights = (((this.rights!= null)&&(!this.rights.isEmpty()))?this.getRights():null);
            if ((this.rights!= null)&&(!this.rights.isEmpty())) {
                currentHashCode += theRights.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Format> theFormats;
            theFormats = (((this.formats!= null)&&(!this.formats.isEmpty()))?this.getFormats():null);
            if ((this.formats!= null)&&(!this.formats.isEmpty())) {
                currentHashCode += theFormats.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Coverage theCoverage;
            theCoverage = this.getCoverage();
            if (this.coverage!= null) {
                currentHashCode += theCoverage.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Tableset theTableset;
            theTableset = this.getTableset();
            if (this.tableset!= null) {
                currentHashCode += theTableset.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            AccessURL theAccessURL;
            theAccessURL = this.getAccessURL();
            if (this.accessURL!= null) {
                currentHashCode += theAccessURL.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<ResourceName> theFacilities;
            theFacilities = (((this.facilities!= null)&&(!this.facilities.isEmpty()))?this.getFacilities():null);
            strategy.appendField(locator, this, "facilities", buffer, theFacilities, ((this.facilities!= null)&&(!this.facilities.isEmpty())));
        }
        {
            List<ResourceName> theInstruments;
            theInstruments = (((this.instruments!= null)&&(!this.instruments.isEmpty()))?this.getInstruments():null);
            strategy.appendField(locator, this, "instruments", buffer, theInstruments, ((this.instruments!= null)&&(!this.instruments.isEmpty())));
        }
        {
            List<Rights> theRights;
            theRights = (((this.rights!= null)&&(!this.rights.isEmpty()))?this.getRights():null);
            strategy.appendField(locator, this, "rights", buffer, theRights, ((this.rights!= null)&&(!this.rights.isEmpty())));
        }
        {
            List<Format> theFormats;
            theFormats = (((this.formats!= null)&&(!this.formats.isEmpty()))?this.getFormats():null);
            strategy.appendField(locator, this, "formats", buffer, theFormats, ((this.formats!= null)&&(!this.formats.isEmpty())));
        }
        {
            Coverage theCoverage;
            theCoverage = this.getCoverage();
            strategy.appendField(locator, this, "coverage", buffer, theCoverage, (this.coverage!= null));
        }
        {
            Tableset theTableset;
            theTableset = this.getTableset();
            strategy.appendField(locator, this, "tableset", buffer, theTableset, (this.tableset!= null));
        }
        {
            AccessURL theAccessURL;
            theAccessURL = this.getAccessURL();
            strategy.appendField(locator, this, "accessURL", buffer, theAccessURL, (this.accessURL!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof DataCollection) {
            final DataCollection target = this;
            final DataCollection leftObject = ((DataCollection) left);
            final DataCollection rightObject = ((DataCollection) right);
            {
                Boolean facilitiesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.facilities!= null)&&(!leftObject.facilities.isEmpty())), ((rightObject.facilities!= null)&&(!rightObject.facilities.isEmpty())));
                if (facilitiesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<ResourceName> lhsFacilities;
                    lhsFacilities = (((leftObject.facilities!= null)&&(!leftObject.facilities.isEmpty()))?leftObject.getFacilities():null);
                    List<ResourceName> rhsFacilities;
                    rhsFacilities = (((rightObject.facilities!= null)&&(!rightObject.facilities.isEmpty()))?rightObject.getFacilities():null);
                    List<ResourceName> mergedFacilities = ((List<ResourceName> ) strategy.merge(LocatorUtils.property(leftLocator, "facilities", lhsFacilities), LocatorUtils.property(rightLocator, "facilities", rhsFacilities), lhsFacilities, rhsFacilities, ((leftObject.facilities!= null)&&(!leftObject.facilities.isEmpty())), ((rightObject.facilities!= null)&&(!rightObject.facilities.isEmpty()))));
                    target.facilities = null;
                    if (mergedFacilities!= null) {
                        List<ResourceName> uniqueFacilitiesl = target.getFacilities();
                        uniqueFacilitiesl.addAll(mergedFacilities);
                    }
                } else {
                    if (facilitiesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.facilities = null;
                    }
                }
            }
            {
                Boolean instrumentsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.instruments!= null)&&(!leftObject.instruments.isEmpty())), ((rightObject.instruments!= null)&&(!rightObject.instruments.isEmpty())));
                if (instrumentsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<ResourceName> lhsInstruments;
                    lhsInstruments = (((leftObject.instruments!= null)&&(!leftObject.instruments.isEmpty()))?leftObject.getInstruments():null);
                    List<ResourceName> rhsInstruments;
                    rhsInstruments = (((rightObject.instruments!= null)&&(!rightObject.instruments.isEmpty()))?rightObject.getInstruments():null);
                    List<ResourceName> mergedInstruments = ((List<ResourceName> ) strategy.merge(LocatorUtils.property(leftLocator, "instruments", lhsInstruments), LocatorUtils.property(rightLocator, "instruments", rhsInstruments), lhsInstruments, rhsInstruments, ((leftObject.instruments!= null)&&(!leftObject.instruments.isEmpty())), ((rightObject.instruments!= null)&&(!rightObject.instruments.isEmpty()))));
                    target.instruments = null;
                    if (mergedInstruments!= null) {
                        List<ResourceName> uniqueInstrumentsl = target.getInstruments();
                        uniqueInstrumentsl.addAll(mergedInstruments);
                    }
                } else {
                    if (instrumentsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.instruments = null;
                    }
                }
            }
            {
                Boolean rightsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.rights!= null)&&(!leftObject.rights.isEmpty())), ((rightObject.rights!= null)&&(!rightObject.rights.isEmpty())));
                if (rightsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<Rights> lhsRights;
                    lhsRights = (((leftObject.rights!= null)&&(!leftObject.rights.isEmpty()))?leftObject.getRights():null);
                    List<Rights> rhsRights;
                    rhsRights = (((rightObject.rights!= null)&&(!rightObject.rights.isEmpty()))?rightObject.getRights():null);
                    List<Rights> mergedRights = ((List<Rights> ) strategy.merge(LocatorUtils.property(leftLocator, "rights", lhsRights), LocatorUtils.property(rightLocator, "rights", rhsRights), lhsRights, rhsRights, ((leftObject.rights!= null)&&(!leftObject.rights.isEmpty())), ((rightObject.rights!= null)&&(!rightObject.rights.isEmpty()))));
                    target.rights = null;
                    if (mergedRights!= null) {
                        List<Rights> uniqueRightsl = target.getRights();
                        uniqueRightsl.addAll(mergedRights);
                    }
                } else {
                    if (rightsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.rights = null;
                    }
                }
            }
            {
                Boolean formatsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.formats!= null)&&(!leftObject.formats.isEmpty())), ((rightObject.formats!= null)&&(!rightObject.formats.isEmpty())));
                if (formatsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<Format> lhsFormats;
                    lhsFormats = (((leftObject.formats!= null)&&(!leftObject.formats.isEmpty()))?leftObject.getFormats():null);
                    List<Format> rhsFormats;
                    rhsFormats = (((rightObject.formats!= null)&&(!rightObject.formats.isEmpty()))?rightObject.getFormats():null);
                    List<Format> mergedFormats = ((List<Format> ) strategy.merge(LocatorUtils.property(leftLocator, "formats", lhsFormats), LocatorUtils.property(rightLocator, "formats", rhsFormats), lhsFormats, rhsFormats, ((leftObject.formats!= null)&&(!leftObject.formats.isEmpty())), ((rightObject.formats!= null)&&(!rightObject.formats.isEmpty()))));
                    target.formats = null;
                    if (mergedFormats!= null) {
                        List<Format> uniqueFormatsl = target.getFormats();
                        uniqueFormatsl.addAll(mergedFormats);
                    }
                } else {
                    if (formatsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.formats = null;
                    }
                }
            }
            {
                Boolean coverageShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.coverage!= null), (rightObject.coverage!= null));
                if (coverageShouldBeMergedAndSet == Boolean.TRUE) {
                    Coverage lhsCoverage;
                    lhsCoverage = leftObject.getCoverage();
                    Coverage rhsCoverage;
                    rhsCoverage = rightObject.getCoverage();
                    Coverage mergedCoverage = ((Coverage) strategy.merge(LocatorUtils.property(leftLocator, "coverage", lhsCoverage), LocatorUtils.property(rightLocator, "coverage", rhsCoverage), lhsCoverage, rhsCoverage, (leftObject.coverage!= null), (rightObject.coverage!= null)));
                    target.setCoverage(mergedCoverage);
                } else {
                    if (coverageShouldBeMergedAndSet == Boolean.FALSE) {
                        target.coverage = null;
                    }
                }
            }
            {
                Boolean tablesetShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.tableset!= null), (rightObject.tableset!= null));
                if (tablesetShouldBeMergedAndSet == Boolean.TRUE) {
                    Tableset lhsTableset;
                    lhsTableset = leftObject.getTableset();
                    Tableset rhsTableset;
                    rhsTableset = rightObject.getTableset();
                    Tableset mergedTableset = ((Tableset) strategy.merge(LocatorUtils.property(leftLocator, "tableset", lhsTableset), LocatorUtils.property(rightLocator, "tableset", rhsTableset), lhsTableset, rhsTableset, (leftObject.tableset!= null), (rightObject.tableset!= null)));
                    target.setTableset(mergedTableset);
                } else {
                    if (tablesetShouldBeMergedAndSet == Boolean.FALSE) {
                        target.tableset = null;
                    }
                }
            }
            {
                Boolean accessURLShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.accessURL!= null), (rightObject.accessURL!= null));
                if (accessURLShouldBeMergedAndSet == Boolean.TRUE) {
                    AccessURL lhsAccessURL;
                    lhsAccessURL = leftObject.getAccessURL();
                    AccessURL rhsAccessURL;
                    rhsAccessURL = rightObject.getAccessURL();
                    AccessURL mergedAccessURL = ((AccessURL) strategy.merge(LocatorUtils.property(leftLocator, "accessURL", lhsAccessURL), LocatorUtils.property(rightLocator, "accessURL", rhsAccessURL), lhsAccessURL, rhsAccessURL, (leftObject.accessURL!= null), (rightObject.accessURL!= null)));
                    target.setAccessURL(mergedAccessURL);
                } else {
                    if (accessURLShouldBeMergedAndSet == Boolean.FALSE) {
                        target.accessURL = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new DataCollection();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public DataCollection clone() {
        final DataCollection _newObject;
        _newObject = ((DataCollection) super.clone());
        if (this.facilities == null) {
            _newObject.facilities = null;
        } else {
            _newObject.facilities = new ArrayList<>();
            for (ResourceName _item: this.facilities) {
                _newObject.facilities.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.instruments == null) {
            _newObject.instruments = null;
        } else {
            _newObject.instruments = new ArrayList<>();
            for (ResourceName _item: this.instruments) {
                _newObject.instruments.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.rights == null) {
            _newObject.rights = null;
        } else {
            _newObject.rights = new ArrayList<>();
            for (Rights _item: this.rights) {
                _newObject.rights.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.formats == null) {
            _newObject.formats = null;
        } else {
            _newObject.formats = new ArrayList<>();
            for (Format _item: this.formats) {
                _newObject.formats.add(((_item == null)?null:_item.clone()));
            }
        }
        _newObject.coverage = ((this.coverage == null)?null:this.coverage.clone());
        _newObject.tableset = ((this.tableset == null)?null:this.tableset.clone());
        _newObject.accessURL = ((this.accessURL == null)?null:this.accessURL.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public DataCollection createCopy() {
        final DataCollection _newObject = ((DataCollection) super.createCopy());
        if (this.facilities == null) {
            _newObject.facilities = null;
        } else {
            _newObject.facilities = new ArrayList<>();
            for (ResourceName _item: this.facilities) {
                _newObject.facilities.add(((_item == null)?null:_item.createCopy()));
            }
        }
        if (this.instruments == null) {
            _newObject.instruments = null;
        } else {
            _newObject.instruments = new ArrayList<>();
            for (ResourceName _item: this.instruments) {
                _newObject.instruments.add(((_item == null)?null:_item.createCopy()));
            }
        }
        if (this.rights == null) {
            _newObject.rights = null;
        } else {
            _newObject.rights = new ArrayList<>();
            for (Rights _item: this.rights) {
                _newObject.rights.add(((_item == null)?null:_item.createCopy()));
            }
        }
        if (this.formats == null) {
            _newObject.formats = null;
        } else {
            _newObject.formats = new ArrayList<>();
            for (Format _item: this.formats) {
                _newObject.formats.add(((_item == null)?null:_item.createCopy()));
            }
        }
        _newObject.coverage = ((this.coverage == null)?null:this.coverage.createCopy());
        _newObject.tableset = ((this.tableset == null)?null:this.tableset.createCopy());
        _newObject.accessURL = ((this.accessURL == null)?null:this.accessURL.createCopy());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public DataCollection createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final DataCollection _newObject = ((DataCollection) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree facilitiesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("facilities"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(facilitiesPropertyTree!= null):((facilitiesPropertyTree == null)||(!facilitiesPropertyTree.isLeaf())))) {
            if (this.facilities == null) {
                _newObject.facilities = null;
            } else {
                _newObject.facilities = new ArrayList<>();
                for (ResourceName _item: this.facilities) {
                    _newObject.facilities.add(((_item == null)?null:_item.createCopy(facilitiesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree instrumentsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("instruments"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(instrumentsPropertyTree!= null):((instrumentsPropertyTree == null)||(!instrumentsPropertyTree.isLeaf())))) {
            if (this.instruments == null) {
                _newObject.instruments = null;
            } else {
                _newObject.instruments = new ArrayList<>();
                for (ResourceName _item: this.instruments) {
                    _newObject.instruments.add(((_item == null)?null:_item.createCopy(instrumentsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree rightsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("rights"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(rightsPropertyTree!= null):((rightsPropertyTree == null)||(!rightsPropertyTree.isLeaf())))) {
            if (this.rights == null) {
                _newObject.rights = null;
            } else {
                _newObject.rights = new ArrayList<>();
                for (Rights _item: this.rights) {
                    _newObject.rights.add(((_item == null)?null:_item.createCopy(rightsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree formatsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("formats"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(formatsPropertyTree!= null):((formatsPropertyTree == null)||(!formatsPropertyTree.isLeaf())))) {
            if (this.formats == null) {
                _newObject.formats = null;
            } else {
                _newObject.formats = new ArrayList<>();
                for (Format _item: this.formats) {
                    _newObject.formats.add(((_item == null)?null:_item.createCopy(formatsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree coveragePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coverage"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coveragePropertyTree!= null):((coveragePropertyTree == null)||(!coveragePropertyTree.isLeaf())))) {
            _newObject.coverage = ((this.coverage == null)?null:this.coverage.createCopy(coveragePropertyTree, _propertyTreeUse));
        }
        final PropertyTree tablesetPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("tableset"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(tablesetPropertyTree!= null):((tablesetPropertyTree == null)||(!tablesetPropertyTree.isLeaf())))) {
            _newObject.tableset = ((this.tableset == null)?null:this.tableset.createCopy(tablesetPropertyTree, _propertyTreeUse));
        }
        final PropertyTree accessURLPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("accessURL"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(accessURLPropertyTree!= null):((accessURLPropertyTree == null)||(!accessURLPropertyTree.isLeaf())))) {
            _newObject.accessURL = ((this.accessURL == null)?null:this.accessURL.createCopy(accessURLPropertyTree, _propertyTreeUse));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public DataCollection copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public DataCollection copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public DataCollection.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new DataCollection.Modifier();
        }
        return ((DataCollection.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final DataCollection.Builder<_B> _other) {
        super.copyTo(_other);
        if (this.facilities == null) {
            _other.facilities = null;
        } else {
            _other.facilities = new ArrayList<>();
            for (ResourceName _item: this.facilities) {
                _other.facilities.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        if (this.instruments == null) {
            _other.instruments = null;
        } else {
            _other.instruments = new ArrayList<>();
            for (ResourceName _item: this.instruments) {
                _other.instruments.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        if (this.rights == null) {
            _other.rights = null;
        } else {
            _other.rights = new ArrayList<>();
            for (Rights _item: this.rights) {
                _other.rights.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        if (this.formats == null) {
            _other.formats = null;
        } else {
            _other.formats = new ArrayList<>();
            for (Format _item: this.formats) {
                _other.formats.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        _other.coverage = ((this.coverage == null)?null:this.coverage.newCopyBuilder(_other));
        _other.tableset = ((this.tableset == null)?null:this.tableset.newCopyBuilder(_other));
        _other.accessURL = ((this.accessURL == null)?null:this.accessURL.newCopyBuilder(_other));
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >DataCollection.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new DataCollection.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public DataCollection.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static DataCollection.Builder<Void> builder() {
        return new DataCollection.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >DataCollection.Builder<_B> copyOf(final Resource _other) {
        final DataCollection.Builder<_B> _newBuilder = new DataCollection.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >DataCollection.Builder<_B> copyOf(final DataCollection _other) {
        final DataCollection.Builder<_B> _newBuilder = new DataCollection.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final DataCollection.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree facilitiesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("facilities"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(facilitiesPropertyTree!= null):((facilitiesPropertyTree == null)||(!facilitiesPropertyTree.isLeaf())))) {
            if (this.facilities == null) {
                _other.facilities = null;
            } else {
                _other.facilities = new ArrayList<>();
                for (ResourceName _item: this.facilities) {
                    _other.facilities.add(((_item == null)?null:_item.newCopyBuilder(_other, facilitiesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree instrumentsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("instruments"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(instrumentsPropertyTree!= null):((instrumentsPropertyTree == null)||(!instrumentsPropertyTree.isLeaf())))) {
            if (this.instruments == null) {
                _other.instruments = null;
            } else {
                _other.instruments = new ArrayList<>();
                for (ResourceName _item: this.instruments) {
                    _other.instruments.add(((_item == null)?null:_item.newCopyBuilder(_other, instrumentsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree rightsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("rights"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(rightsPropertyTree!= null):((rightsPropertyTree == null)||(!rightsPropertyTree.isLeaf())))) {
            if (this.rights == null) {
                _other.rights = null;
            } else {
                _other.rights = new ArrayList<>();
                for (Rights _item: this.rights) {
                    _other.rights.add(((_item == null)?null:_item.newCopyBuilder(_other, rightsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree formatsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("formats"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(formatsPropertyTree!= null):((formatsPropertyTree == null)||(!formatsPropertyTree.isLeaf())))) {
            if (this.formats == null) {
                _other.formats = null;
            } else {
                _other.formats = new ArrayList<>();
                for (Format _item: this.formats) {
                    _other.formats.add(((_item == null)?null:_item.newCopyBuilder(_other, formatsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree coveragePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coverage"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coveragePropertyTree!= null):((coveragePropertyTree == null)||(!coveragePropertyTree.isLeaf())))) {
            _other.coverage = ((this.coverage == null)?null:this.coverage.newCopyBuilder(_other, coveragePropertyTree, _propertyTreeUse));
        }
        final PropertyTree tablesetPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("tableset"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(tablesetPropertyTree!= null):((tablesetPropertyTree == null)||(!tablesetPropertyTree.isLeaf())))) {
            _other.tableset = ((this.tableset == null)?null:this.tableset.newCopyBuilder(_other, tablesetPropertyTree, _propertyTreeUse));
        }
        final PropertyTree accessURLPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("accessURL"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(accessURLPropertyTree!= null):((accessURLPropertyTree == null)||(!accessURLPropertyTree.isLeaf())))) {
            _other.accessURL = ((this.accessURL == null)?null:this.accessURL.newCopyBuilder(_other, accessURLPropertyTree, _propertyTreeUse));
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >DataCollection.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new DataCollection.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public DataCollection.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >DataCollection.Builder<_B> copyOf(final Resource _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final DataCollection.Builder<_B> _newBuilder = new DataCollection.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >DataCollection.Builder<_B> copyOf(final DataCollection _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final DataCollection.Builder<_B> _newBuilder = new DataCollection.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static DataCollection.Builder<Void> copyExcept(final Resource _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static DataCollection.Builder<Void> copyExcept(final DataCollection _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static DataCollection.Builder<Void> copyOnly(final Resource _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static DataCollection.Builder<Void> copyOnly(final DataCollection _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public DataCollection visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new CollectionProperty<>(DataCollection.PropInfo.FACILITIES, this))&&(this.facilities!= null)) {
            for (ResourceName _item_: this.facilities) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new CollectionProperty<>(DataCollection.PropInfo.INSTRUMENTS, this))&&(this.instruments!= null)) {
            for (ResourceName _item_: this.instruments) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new CollectionProperty<>(DataCollection.PropInfo.RIGHTS, this))&&(this.rights!= null)) {
            for (Rights _item_: this.rights) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new CollectionProperty<>(DataCollection.PropInfo.FORMATS, this))&&(this.formats!= null)) {
            for (Format _item_: this.formats) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        if (_visitor_.visit(new SingleProperty<>(DataCollection.PropInfo.COVERAGE, this))&&(this.coverage!= null)) {
            this.coverage.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(DataCollection.PropInfo.TABLESET, this))&&(this.tableset!= null)) {
            this.tableset.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(DataCollection.PropInfo.ACCESS_URL, this))&&(this.accessURL!= null)) {
            this.accessURL.visit(_visitor_);
        }
        return this;
    }

    public static class Builder<_B >
        extends Resource.Builder<_B>
        implements Buildable
    {

        private List<ResourceName.Builder<DataCollection.Builder<_B>>> facilities;
        private List<ResourceName.Builder<DataCollection.Builder<_B>>> instruments;
        private List<Rights.Builder<DataCollection.Builder<_B>>> rights;
        private List<Format.Builder<DataCollection.Builder<_B>>> formats;
        private Coverage.Builder<DataCollection.Builder<_B>> coverage;
        private Tableset.Builder<DataCollection.Builder<_B>> tableset;
        private AccessURL.Builder<DataCollection.Builder<_B>> accessURL;

        public Builder(final _B _parentBuilder, final DataCollection _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                if (_other.facilities == null) {
                    this.facilities = null;
                } else {
                    this.facilities = new ArrayList<>();
                    for (ResourceName _item: _other.facilities) {
                        this.facilities.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
                if (_other.instruments == null) {
                    this.instruments = null;
                } else {
                    this.instruments = new ArrayList<>();
                    for (ResourceName _item: _other.instruments) {
                        this.instruments.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
                if (_other.rights == null) {
                    this.rights = null;
                } else {
                    this.rights = new ArrayList<>();
                    for (Rights _item: _other.rights) {
                        this.rights.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
                if (_other.formats == null) {
                    this.formats = null;
                } else {
                    this.formats = new ArrayList<>();
                    for (Format _item: _other.formats) {
                        this.formats.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
                this.coverage = ((_other.coverage == null)?null:_other.coverage.newCopyBuilder(this));
                this.tableset = ((_other.tableset == null)?null:_other.tableset.newCopyBuilder(this));
                this.accessURL = ((_other.accessURL == null)?null:_other.accessURL.newCopyBuilder(this));
            }
        }

        public Builder(final _B _parentBuilder, final DataCollection _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree facilitiesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("facilities"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(facilitiesPropertyTree!= null):((facilitiesPropertyTree == null)||(!facilitiesPropertyTree.isLeaf())))) {
                    if (_other.facilities == null) {
                        this.facilities = null;
                    } else {
                        this.facilities = new ArrayList<>();
                        for (ResourceName _item: _other.facilities) {
                            this.facilities.add(((_item == null)?null:_item.newCopyBuilder(this, facilitiesPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
                final PropertyTree instrumentsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("instruments"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(instrumentsPropertyTree!= null):((instrumentsPropertyTree == null)||(!instrumentsPropertyTree.isLeaf())))) {
                    if (_other.instruments == null) {
                        this.instruments = null;
                    } else {
                        this.instruments = new ArrayList<>();
                        for (ResourceName _item: _other.instruments) {
                            this.instruments.add(((_item == null)?null:_item.newCopyBuilder(this, instrumentsPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
                final PropertyTree rightsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("rights"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(rightsPropertyTree!= null):((rightsPropertyTree == null)||(!rightsPropertyTree.isLeaf())))) {
                    if (_other.rights == null) {
                        this.rights = null;
                    } else {
                        this.rights = new ArrayList<>();
                        for (Rights _item: _other.rights) {
                            this.rights.add(((_item == null)?null:_item.newCopyBuilder(this, rightsPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
                final PropertyTree formatsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("formats"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(formatsPropertyTree!= null):((formatsPropertyTree == null)||(!formatsPropertyTree.isLeaf())))) {
                    if (_other.formats == null) {
                        this.formats = null;
                    } else {
                        this.formats = new ArrayList<>();
                        for (Format _item: _other.formats) {
                            this.formats.add(((_item == null)?null:_item.newCopyBuilder(this, formatsPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
                final PropertyTree coveragePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coverage"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coveragePropertyTree!= null):((coveragePropertyTree == null)||(!coveragePropertyTree.isLeaf())))) {
                    this.coverage = ((_other.coverage == null)?null:_other.coverage.newCopyBuilder(this, coveragePropertyTree, _propertyTreeUse));
                }
                final PropertyTree tablesetPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("tableset"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(tablesetPropertyTree!= null):((tablesetPropertyTree == null)||(!tablesetPropertyTree.isLeaf())))) {
                    this.tableset = ((_other.tableset == null)?null:_other.tableset.newCopyBuilder(this, tablesetPropertyTree, _propertyTreeUse));
                }
                final PropertyTree accessURLPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("accessURL"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(accessURLPropertyTree!= null):((accessURLPropertyTree == null)||(!accessURLPropertyTree.isLeaf())))) {
                    this.accessURL = ((_other.accessURL == null)?null:_other.accessURL.newCopyBuilder(this, accessURLPropertyTree, _propertyTreeUse));
                }
            }
        }

        protected<_P extends DataCollection >_P init(final _P _product) {
            if (this.facilities!= null) {
                final List<ResourceName> facilities = new ArrayList<>(this.facilities.size());
                for (ResourceName.Builder<DataCollection.Builder<_B>> _item: this.facilities) {
                    facilities.add(_item.build());
                }
                _product.facilities = facilities;
            }
            if (this.instruments!= null) {
                final List<ResourceName> instruments = new ArrayList<>(this.instruments.size());
                for (ResourceName.Builder<DataCollection.Builder<_B>> _item: this.instruments) {
                    instruments.add(_item.build());
                }
                _product.instruments = instruments;
            }
            if (this.rights!= null) {
                final List<Rights> rights = new ArrayList<>(this.rights.size());
                for (Rights.Builder<DataCollection.Builder<_B>> _item: this.rights) {
                    rights.add(_item.build());
                }
                _product.rights = rights;
            }
            if (this.formats!= null) {
                final List<Format> formats = new ArrayList<>(this.formats.size());
                for (Format.Builder<DataCollection.Builder<_B>> _item: this.formats) {
                    formats.add(_item.build());
                }
                _product.formats = formats;
            }
            _product.coverage = ((this.coverage == null)?null:this.coverage.build());
            _product.tableset = ((this.tableset == null)?null:this.tableset.build());
            _product.accessURL = ((this.accessURL == null)?null:this.accessURL.build());
            return super.init(_product);
        }

        /**
         * Adds the given items to the value of "facilities"
         * 
         * @param facilities
         *     Items to add to the value of the "facilities" property
         */
        public DataCollection.Builder<_B> addFacilities(final Iterable<? extends ResourceName> facilities) {
            if (facilities!= null) {
                if (this.facilities == null) {
                    this.facilities = new ArrayList<>();
                }
                for (ResourceName _item: facilities) {
                    this.facilities.add(new ResourceName.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "facilities" (any previous value will be replaced)
         * 
         * @param facilities
         *     New value of the "facilities" property.
         */
        public DataCollection.Builder<_B> withFacilities(final Iterable<? extends ResourceName> facilities) {
            if (this.facilities!= null) {
                this.facilities.clear();
            }
            return addFacilities(facilities);
        }

        /**
         * Adds the given items to the value of "facilities"
         * 
         * @param facilities
         *     Items to add to the value of the "facilities" property
         */
        public DataCollection.Builder<_B> addFacilities(ResourceName... facilities) {
            addFacilities(Arrays.asList(facilities));
            return this;
        }

        /**
         * Sets the new value of "facilities" (any previous value will be replaced)
         * 
         * @param facilities
         *     New value of the "facilities" property.
         */
        public DataCollection.Builder<_B> withFacilities(ResourceName... facilities) {
            withFacilities(Arrays.asList(facilities));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Facilities" property.
         * Use {@link org.javastro.ivoa.entities.resource.ResourceName.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Facilities" property.
         *     Use {@link org.javastro.ivoa.entities.resource.ResourceName.Builder#end()} to
         *     return to the current builder.
         */
        public ResourceName.Builder<? extends DataCollection.Builder<_B>> addFacilities() {
            if (this.facilities == null) {
                this.facilities = new ArrayList<>();
            }
            final ResourceName.Builder<DataCollection.Builder<_B>> facilities_Builder = new ResourceName.Builder<>(this, null, false);
            this.facilities.add(facilities_Builder);
            return facilities_Builder;
        }

        /**
         * Adds the given items to the value of "instruments"
         * 
         * @param instruments
         *     Items to add to the value of the "instruments" property
         */
        public DataCollection.Builder<_B> addInstruments(final Iterable<? extends ResourceName> instruments) {
            if (instruments!= null) {
                if (this.instruments == null) {
                    this.instruments = new ArrayList<>();
                }
                for (ResourceName _item: instruments) {
                    this.instruments.add(new ResourceName.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "instruments" (any previous value will be replaced)
         * 
         * @param instruments
         *     New value of the "instruments" property.
         */
        public DataCollection.Builder<_B> withInstruments(final Iterable<? extends ResourceName> instruments) {
            if (this.instruments!= null) {
                this.instruments.clear();
            }
            return addInstruments(instruments);
        }

        /**
         * Adds the given items to the value of "instruments"
         * 
         * @param instruments
         *     Items to add to the value of the "instruments" property
         */
        public DataCollection.Builder<_B> addInstruments(ResourceName... instruments) {
            addInstruments(Arrays.asList(instruments));
            return this;
        }

        /**
         * Sets the new value of "instruments" (any previous value will be replaced)
         * 
         * @param instruments
         *     New value of the "instruments" property.
         */
        public DataCollection.Builder<_B> withInstruments(ResourceName... instruments) {
            withInstruments(Arrays.asList(instruments));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Instruments"
         * property.
         * Use {@link org.javastro.ivoa.entities.resource.ResourceName.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Instruments" property.
         *     Use {@link org.javastro.ivoa.entities.resource.ResourceName.Builder#end()} to
         *     return to the current builder.
         */
        public ResourceName.Builder<? extends DataCollection.Builder<_B>> addInstruments() {
            if (this.instruments == null) {
                this.instruments = new ArrayList<>();
            }
            final ResourceName.Builder<DataCollection.Builder<_B>> instruments_Builder = new ResourceName.Builder<>(this, null, false);
            this.instruments.add(instruments_Builder);
            return instruments_Builder;
        }

        /**
         * Adds the given items to the value of "rights"
         * 
         * @param rights
         *     Items to add to the value of the "rights" property
         */
        public DataCollection.Builder<_B> addRights(final Iterable<? extends Rights> rights) {
            if (rights!= null) {
                if (this.rights == null) {
                    this.rights = new ArrayList<>();
                }
                for (Rights _item: rights) {
                    this.rights.add(new Rights.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "rights" (any previous value will be replaced)
         * 
         * @param rights
         *     New value of the "rights" property.
         */
        public DataCollection.Builder<_B> withRights(final Iterable<? extends Rights> rights) {
            if (this.rights!= null) {
                this.rights.clear();
            }
            return addRights(rights);
        }

        /**
         * Adds the given items to the value of "rights"
         * 
         * @param rights
         *     Items to add to the value of the "rights" property
         */
        public DataCollection.Builder<_B> addRights(Rights... rights) {
            addRights(Arrays.asList(rights));
            return this;
        }

        /**
         * Sets the new value of "rights" (any previous value will be replaced)
         * 
         * @param rights
         *     New value of the "rights" property.
         */
        public DataCollection.Builder<_B> withRights(Rights... rights) {
            withRights(Arrays.asList(rights));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Rights" property.
         * Use {@link org.javastro.ivoa.entities.resource.Rights.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Rights" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Rights.Builder#end()} to return
         *     to the current builder.
         */
        public Rights.Builder<? extends DataCollection.Builder<_B>> addRights() {
            if (this.rights == null) {
                this.rights = new ArrayList<>();
            }
            final Rights.Builder<DataCollection.Builder<_B>> rights_Builder = new Rights.Builder<>(this, null, false);
            this.rights.add(rights_Builder);
            return rights_Builder;
        }

        /**
         * Adds the given items to the value of "formats"
         * 
         * @param formats
         *     Items to add to the value of the "formats" property
         */
        public DataCollection.Builder<_B> addFormats(final Iterable<? extends Format> formats) {
            if (formats!= null) {
                if (this.formats == null) {
                    this.formats = new ArrayList<>();
                }
                for (Format _item: formats) {
                    this.formats.add(new Format.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "formats" (any previous value will be replaced)
         * 
         * @param formats
         *     New value of the "formats" property.
         */
        public DataCollection.Builder<_B> withFormats(final Iterable<? extends Format> formats) {
            if (this.formats!= null) {
                this.formats.clear();
            }
            return addFormats(formats);
        }

        /**
         * Adds the given items to the value of "formats"
         * 
         * @param formats
         *     Items to add to the value of the "formats" property
         */
        public DataCollection.Builder<_B> addFormats(Format... formats) {
            addFormats(Arrays.asList(formats));
            return this;
        }

        /**
         * Sets the new value of "formats" (any previous value will be replaced)
         * 
         * @param formats
         *     New value of the "formats" property.
         */
        public DataCollection.Builder<_B> withFormats(Format... formats) {
            withFormats(Arrays.asList(formats));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Formats" property.
         * Use {@link org.javastro.ivoa.entities.resource.dataservice.Format.Builder#end()}
         * to return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Formats" property.
         *     Use {@link org.javastro.ivoa.entities.resource.dataservice.Format.Builder#end()}
         *     to return to the current builder.
         */
        public Format.Builder<? extends DataCollection.Builder<_B>> addFormats() {
            if (this.formats == null) {
                this.formats = new ArrayList<>();
            }
            final Format.Builder<DataCollection.Builder<_B>> formats_Builder = new Format.Builder<>(this, null, false);
            this.formats.add(formats_Builder);
            return formats_Builder;
        }

        /**
         * Sets the new value of "coverage" (any previous value will be replaced)
         * 
         * @param coverage
         *     New value of the "coverage" property.
         */
        public DataCollection.Builder<_B> withCoverage(final Coverage coverage) {
            this.coverage = ((coverage == null)?null:new Coverage.Builder<>(this, coverage, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "coverage" property.
         * Use {@link
         * org.javastro.ivoa.entities.resource.dataservice.Coverage.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "coverage" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.resource.dataservice.Coverage.Builder#end()} to
         *     return to the current builder.
         */
        public Coverage.Builder<? extends DataCollection.Builder<_B>> withCoverage() {
            if (this.coverage!= null) {
                return this.coverage;
            }
            return this.coverage = new Coverage.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "tableset" (any previous value will be replaced)
         * 
         * @param tableset
         *     New value of the "tableset" property.
         */
        public DataCollection.Builder<_B> withTableset(final Tableset tableset) {
            this.tableset = ((tableset == null)?null:new Tableset.Builder<>(this, tableset, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "tableset" property.
         * Use {@link
         * org.javastro.ivoa.entities.resource.dataservice.Tableset.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "tableset" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.resource.dataservice.Tableset.Builder#end()} to
         *     return to the current builder.
         */
        public Tableset.Builder<? extends DataCollection.Builder<_B>> withTableset() {
            if (this.tableset!= null) {
                return this.tableset;
            }
            return this.tableset = new Tableset.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "accessURL" (any previous value will be replaced)
         * 
         * @param accessURL
         *     New value of the "accessURL" property.
         */
        public DataCollection.Builder<_B> withAccessURL(final AccessURL accessURL) {
            this.accessURL = ((accessURL == null)?null:new AccessURL.Builder<>(this, accessURL, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "accessURL" property.
         * Use {@link org.javastro.ivoa.entities.resource.AccessURL.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "accessURL" property.
         *     Use {@link org.javastro.ivoa.entities.resource.AccessURL.Builder#end()} to
         *     return to the current builder.
         */
        public AccessURL.Builder<? extends DataCollection.Builder<_B>> withAccessURL() {
            if (this.accessURL!= null) {
                return this.accessURL;
            }
            return this.accessURL = new AccessURL.Builder<>(this, null, false);
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public DataCollection.Builder<_B> addValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public DataCollection.Builder<_B> addValidationLevels(Validation... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public DataCollection.Builder<_B> withValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public DataCollection.Builder<_B> withValidationLevels(Validation... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "title" (any previous value will be replaced)
         * 
         * @param title
         *     New value of the "title" property.
         */
        @Override
        public DataCollection.Builder<_B> withTitle(final String title) {
            super.withTitle(title);
            return this;
        }

        /**
         * Sets the new value of "shortName" (any previous value will be replaced)
         * 
         * @param shortName
         *     New value of the "shortName" property.
         */
        @Override
        public DataCollection.Builder<_B> withShortName(final String shortName) {
            super.withShortName(shortName);
            return this;
        }

        /**
         * Sets the new value of "identifier" (any previous value will be replaced)
         * 
         * @param identifier
         *     New value of the "identifier" property.
         */
        @Override
        public DataCollection.Builder<_B> withIdentifier(final String identifier) {
            super.withIdentifier(identifier);
            return this;
        }

        /**
         * Adds the given items to the value of "altIdentifiers"
         * 
         * @param altIdentifiers
         *     Items to add to the value of the "altIdentifiers" property
         */
        @Override
        public DataCollection.Builder<_B> addAltIdentifiers(final Iterable<? extends String> altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Adds the given items to the value of "altIdentifiers"
         * 
         * @param altIdentifiers
         *     Items to add to the value of the "altIdentifiers" property
         */
        @Override
        public DataCollection.Builder<_B> addAltIdentifiers(String... altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "altIdentifiers" (any previous value will be replaced)
         * 
         * @param altIdentifiers
         *     New value of the "altIdentifiers" property.
         */
        @Override
        public DataCollection.Builder<_B> withAltIdentifiers(final Iterable<? extends String> altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "altIdentifiers" (any previous value will be replaced)
         * 
         * @param altIdentifiers
         *     New value of the "altIdentifiers" property.
         */
        @Override
        public DataCollection.Builder<_B> withAltIdentifiers(String... altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "curation" (any previous value will be replaced)
         * 
         * @param curation
         *     New value of the "curation" property.
         */
        @Override
        public DataCollection.Builder<_B> withCuration(final Curation curation) {
            super.withCuration(curation);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "curation" property.
         * Use {@link org.javastro.ivoa.entities.resource.Curation.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "curation" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Curation.Builder#end()} to return
         *     to the current builder.
         */
        public Curation.Builder<? extends DataCollection.Builder<_B>> withCuration() {
            return ((Curation.Builder<? extends DataCollection.Builder<_B>> ) super.withCuration());
        }

        /**
         * Sets the new value of "content" (any previous value will be replaced)
         * 
         * @param content
         *     New value of the "content" property.
         */
        @Override
        public DataCollection.Builder<_B> withContent(final Content content) {
            super.withContent(content);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "content" property.
         * Use {@link org.javastro.ivoa.entities.resource.Content.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "content" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Content.Builder#end()} to return
         *     to the current builder.
         */
        public Content.Builder<? extends DataCollection.Builder<_B>> withContent() {
            return ((Content.Builder<? extends DataCollection.Builder<_B>> ) super.withContent());
        }

        /**
         * Sets the new value of "created" (any previous value will be replaced)
         * 
         * @param created
         *     New value of the "created" property.
         */
        @Override
        public DataCollection.Builder<_B> withCreated(final LocalDateTime created) {
            super.withCreated(created);
            return this;
        }

        /**
         * Sets the new value of "updated" (any previous value will be replaced)
         * 
         * @param updated
         *     New value of the "updated" property.
         */
        @Override
        public DataCollection.Builder<_B> withUpdated(final LocalDateTime updated) {
            super.withUpdated(updated);
            return this;
        }

        /**
         * Sets the new value of "status" (any previous value will be replaced)
         * 
         * @param status
         *     New value of the "status" property.
         */
        @Override
        public DataCollection.Builder<_B> withStatus(final String status) {
            super.withStatus(status);
            return this;
        }

        /**
         * Sets the new value of "version" (any previous value will be replaced)
         * 
         * @param version
         *     New value of the "version" property.
         */
        @Override
        public DataCollection.Builder<_B> withVersion(final String version) {
            super.withVersion(version);
            return this;
        }

        @Override
        public DataCollection build() {
            if (_storedValue == null) {
                return this.init(new DataCollection());
            } else {
                return ((DataCollection) _storedValue);
            }
        }

        public DataCollection.Builder<_B> copyOf(final DataCollection _other) {
            _other.copyTo(this);
            return this;
        }

        public DataCollection.Builder<_B> copyOf(final DataCollection.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends Resource.Modifier
    {


        public List<ResourceName> getFacilities() {
            if (DataCollection.this.facilities == null) {
                DataCollection.this.facilities = new ArrayList<>();
            }
            return DataCollection.this.facilities;
        }

        public List<ResourceName> getInstruments() {
            if (DataCollection.this.instruments == null) {
                DataCollection.this.instruments = new ArrayList<>();
            }
            return DataCollection.this.instruments;
        }

        public List<Rights> getRights() {
            if (DataCollection.this.rights == null) {
                DataCollection.this.rights = new ArrayList<>();
            }
            return DataCollection.this.rights;
        }

        public List<Format> getFormats() {
            if (DataCollection.this.formats == null) {
                DataCollection.this.formats = new ArrayList<>();
            }
            return DataCollection.this.formats;
        }

        public void setCoverage(final Coverage coverage) {
            DataCollection.this.setCoverage(coverage);
        }

        public void setTableset(final Tableset tableset) {
            DataCollection.this.setTableset(tableset);
        }

        public void setAccessURL(final AccessURL accessURL) {
            DataCollection.this.setAccessURL(accessURL);
        }

    }

    public static class PropInfo {

        public static final transient CollectionPropertyInfo<DataCollection, ResourceName> FACILITIES = new CollectionPropertyInfo<DataCollection,ResourceName>("facilities", DataCollection.class, ResourceName.class, true, null, new QName("", "facility"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "ResourceName"), false) {


            @Override
            public List<ResourceName> get(final DataCollection _instance_) {
                return ((_instance_ == null)?null:_instance_.facilities);
            }

            @Override
            public void set(final DataCollection _instance_, final List<ResourceName> _value_) {
                if (_instance_!= null) {
                    _instance_.facilities = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<DataCollection, ResourceName> INSTRUMENTS = new CollectionPropertyInfo<DataCollection,ResourceName>("instruments", DataCollection.class, ResourceName.class, true, null, new QName("", "instrument"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "ResourceName"), false) {


            @Override
            public List<ResourceName> get(final DataCollection _instance_) {
                return ((_instance_ == null)?null:_instance_.instruments);
            }

            @Override
            public void set(final DataCollection _instance_, final List<ResourceName> _value_) {
                if (_instance_!= null) {
                    _instance_.instruments = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<DataCollection, Rights> RIGHTS = new CollectionPropertyInfo<DataCollection,Rights>("rights", DataCollection.class, Rights.class, true, null, new QName("", "rights"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "Rights"), false) {


            @Override
            public List<Rights> get(final DataCollection _instance_) {
                return ((_instance_ == null)?null:_instance_.rights);
            }

            @Override
            public void set(final DataCollection _instance_, final List<Rights> _value_) {
                if (_instance_!= null) {
                    _instance_.rights = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<DataCollection, Format> FORMATS = new CollectionPropertyInfo<DataCollection,Format>("formats", DataCollection.class, Format.class, true, null, new QName("", "format"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "Format"), false) {


            @Override
            public List<Format> get(final DataCollection _instance_) {
                return ((_instance_ == null)?null:_instance_.formats);
            }

            @Override
            public void set(final DataCollection _instance_, final List<Format> _value_) {
                if (_instance_!= null) {
                    _instance_.formats = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<DataCollection, Coverage> COVERAGE = new SinglePropertyInfo<DataCollection,Coverage>("coverage", DataCollection.class, Coverage.class, false, null, new QName("", "coverage"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "Coverage"), false) {


            @Override
            public Coverage get(final DataCollection _instance_) {
                return ((_instance_ == null)?null:_instance_.coverage);
            }

            @Override
            public void set(final DataCollection _instance_, final Coverage _value_) {
                if (_instance_!= null) {
                    _instance_.coverage = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<DataCollection, Tableset> TABLESET = new SinglePropertyInfo<DataCollection,Tableset>("tableset", DataCollection.class, Tableset.class, false, null, new QName("", "tableset"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "TableSet"), false) {


            @Override
            public Tableset get(final DataCollection _instance_) {
                return ((_instance_ == null)?null:_instance_.tableset);
            }

            @Override
            public void set(final DataCollection _instance_, final Tableset _value_) {
                if (_instance_!= null) {
                    _instance_.tableset = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<DataCollection, AccessURL> ACCESS_URL = new SinglePropertyInfo<DataCollection,AccessURL>("accessURL", DataCollection.class, AccessURL.class, false, null, new QName("", "accessURL"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "AccessURL"), false) {


            @Override
            public AccessURL get(final DataCollection _instance_) {
                return ((_instance_ == null)?null:_instance_.accessURL);
            }

            @Override
            public void set(final DataCollection _instance_, final AccessURL _value_) {
                if (_instance_!= null) {
                    _instance_.accessURL = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends DataCollection.Selector<DataCollection.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static DataCollection.Select _root() {
            return new DataCollection.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends Resource.Selector<TRoot, TParent>
    {

        private ResourceName.Selector<TRoot, DataCollection.Selector<TRoot, TParent>> facilities = null;
        private ResourceName.Selector<TRoot, DataCollection.Selector<TRoot, TParent>> instruments = null;
        private Rights.Selector<TRoot, DataCollection.Selector<TRoot, TParent>> rights = null;
        private Format.Selector<TRoot, DataCollection.Selector<TRoot, TParent>> formats = null;
        private Coverage.Selector<TRoot, DataCollection.Selector<TRoot, TParent>> coverage = null;
        private Tableset.Selector<TRoot, DataCollection.Selector<TRoot, TParent>> tableset = null;
        private AccessURL.Selector<TRoot, DataCollection.Selector<TRoot, TParent>> accessURL = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.facilities!= null) {
                products.put("facilities", this.facilities.init());
            }
            if (this.instruments!= null) {
                products.put("instruments", this.instruments.init());
            }
            if (this.rights!= null) {
                products.put("rights", this.rights.init());
            }
            if (this.formats!= null) {
                products.put("formats", this.formats.init());
            }
            if (this.coverage!= null) {
                products.put("coverage", this.coverage.init());
            }
            if (this.tableset!= null) {
                products.put("tableset", this.tableset.init());
            }
            if (this.accessURL!= null) {
                products.put("accessURL", this.accessURL.init());
            }
            return products;
        }

        public ResourceName.Selector<TRoot, DataCollection.Selector<TRoot, TParent>> facilities() {
            return ((this.facilities == null)?this.facilities = new ResourceName.Selector<>(this._root, this, "facilities"):this.facilities);
        }

        public ResourceName.Selector<TRoot, DataCollection.Selector<TRoot, TParent>> instruments() {
            return ((this.instruments == null)?this.instruments = new ResourceName.Selector<>(this._root, this, "instruments"):this.instruments);
        }

        public Rights.Selector<TRoot, DataCollection.Selector<TRoot, TParent>> rights() {
            return ((this.rights == null)?this.rights = new Rights.Selector<>(this._root, this, "rights"):this.rights);
        }

        public Format.Selector<TRoot, DataCollection.Selector<TRoot, TParent>> formats() {
            return ((this.formats == null)?this.formats = new Format.Selector<>(this._root, this, "formats"):this.formats);
        }

        public Coverage.Selector<TRoot, DataCollection.Selector<TRoot, TParent>> coverage() {
            return ((this.coverage == null)?this.coverage = new Coverage.Selector<>(this._root, this, "coverage"):this.coverage);
        }

        public Tableset.Selector<TRoot, DataCollection.Selector<TRoot, TParent>> tableset() {
            return ((this.tableset == null)?this.tableset = new Tableset.Selector<>(this._root, this, "tableset"):this.tableset);
        }

        public AccessURL.Selector<TRoot, DataCollection.Selector<TRoot, TParent>> accessURL() {
            return ((this.accessURL == null)?this.accessURL = new AccessURL.Selector<>(this._root, this, "accessURL"):this.accessURL);
        }

    }

}
