
package org.javastro.ivoa.entities.resource.dataservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.javastro.ivoa.entities.resource.AccessURL;
import org.javastro.ivoa.entities.resource.MirrorURL;
import org.javastro.ivoa.entities.resource.SecurityMethod;
import org.javastro.ivoa.entities.resource.ServiceInterface;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Note that the URL for help with this service can be put into
 *            the service/referenceURL element.
 * 
 * <p>Java class for ParamHTTP complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ParamHTTP">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/VOResource/v1.0}Interface">
 *       <sequence>
 *         <element name="queryType" type="{http://www.ivoa.net/xml/VODataService/v1.1}HTTPQueryType" maxOccurs="2" minOccurs="0"/>
 *         <element name="resultType" type="{http://www.w3.org/2001/XMLSchema}token" minOccurs="0"/>
 *         <element name="param" type="{http://www.ivoa.net/xml/VODataService/v1.1}InputParam" maxOccurs="unbounded" minOccurs="0"/>
 *         <element name="testQuery" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ParamHTTP", propOrder = {
    "queryTypes",
    "resultType",
    "params",
    "testQuery"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class ParamHTTP
    extends ServiceInterface
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The service may indicate support for both GET
     *                        and POST by providing 2 queryType elements, one
     *                        with GET and one with POST.  Since the IVOA standard
     *                        DALI requires standard services to support both
     *                        GET and POST, this piece of metadata is not
     *                        useful in the description of standard DAL services
     *                        and does not need to be given for those.
     * 
     */
    @XmlElement(name = "queryType")
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<HTTPQueryType> queryTypes;
    /**
     * The MIME media type of a document returned in 
     *                        the HTTP response.
     * 
     */
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String resultType;
    /**
     * A description of a input parameter that can be 
     *                        provided as a name=value argument to the service.
     * 
     */
    @XmlElement(name = "param")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<InputParam> params;
    /**
     * When the interface supports GET, then the full 
     *                        query URL is formed by the concatenation of the 
     *                        base URL (given by the accessURL) and the value 
     *                        given by this testQuery element.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String testQuery;

    /**
     * Default no-arg constructor
     * 
     */
    public ParamHTTP() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public ParamHTTP(final List<AccessURL> accessURLs, final List<MirrorURL> mirrorURLs, final SecurityMethod securityMethod, final String testQueryString, final String version, final String role, final List<HTTPQueryType> queryTypes, final String resultType, final List<InputParam> params, final String testQuery) {
        super(accessURLs, mirrorURLs, securityMethod, testQueryString, version, role);
        this.queryTypes = queryTypes;
        this.resultType = resultType;
        this.params = params;
        this.testQuery = testQuery;
    }

    /**
     * The service may indicate support for both GET
     *                        and POST by providing 2 queryType elements, one
     *                        with GET and one with POST.  Since the IVOA standard
     *                        DALI requires standard services to support both
     *                        GET and POST, this piece of metadata is not
     *                        useful in the description of standard DAL services
     *                        and does not need to be given for those.
     * 
     * Gets the value of the queryTypes property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the queryTypes property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getQueryTypes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link HTTPQueryType }
     * </p>
     * 
     * 
     * @return
     *     The value of the queryTypes property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<HTTPQueryType> getQueryTypes() {
        if (queryTypes == null) {
            queryTypes = new ArrayList<>();
        }
        return this.queryTypes;
    }

    /**
     * The MIME media type of a document returned in 
     *                        the HTTP response.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getResultType() {
        return resultType;
    }

    /**
     * Sets the value of the resultType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getResultType()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setResultType(String value) {
        this.resultType = value;
    }

    /**
     * A description of a input parameter that can be 
     *                        provided as a name=value argument to the service.
     * 
     * Gets the value of the params property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the params property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getParams().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link InputParam }
     * </p>
     * 
     * 
     * @return
     *     The value of the params property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<InputParam> getParams() {
        if (params == null) {
            params = new ArrayList<>();
        }
        return this.params;
    }

    /**
     * When the interface supports GET, then the full 
     *                        query URL is formed by the concatenation of the 
     *                        base URL (given by the accessURL) and the value 
     *                        given by this testQuery element.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getTestQuery() {
        return testQuery;
    }

    /**
     * Sets the value of the testQuery property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getTestQuery()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setTestQuery(String value) {
        this.testQuery = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final ParamHTTP that = ((ParamHTTP) object);
        {
            List<HTTPQueryType> leftQueryTypes;
            leftQueryTypes = (((this.queryTypes!= null)&&(!this.queryTypes.isEmpty()))?this.getQueryTypes():null);
            List<HTTPQueryType> rightQueryTypes;
            rightQueryTypes = (((that.queryTypes!= null)&&(!that.queryTypes.isEmpty()))?that.getQueryTypes():null);
            if ((this.queryTypes!= null)&&(!this.queryTypes.isEmpty())) {
                if ((that.queryTypes!= null)&&(!that.queryTypes.isEmpty())) {
                    if (!leftQueryTypes.equals(rightQueryTypes)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.queryTypes!= null)&&(!that.queryTypes.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftResultType;
            leftResultType = this.getResultType();
            String rightResultType;
            rightResultType = that.getResultType();
            if (this.resultType!= null) {
                if (that.resultType!= null) {
                    if (!leftResultType.equals(rightResultType)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.resultType!= null) {
                    return false;
                }
            }
        }
        {
            List<InputParam> leftParams;
            leftParams = (((this.params!= null)&&(!this.params.isEmpty()))?this.getParams():null);
            List<InputParam> rightParams;
            rightParams = (((that.params!= null)&&(!that.params.isEmpty()))?that.getParams():null);
            if ((this.params!= null)&&(!this.params.isEmpty())) {
                if ((that.params!= null)&&(!that.params.isEmpty())) {
                    if (!leftParams.equals(rightParams)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.params!= null)&&(!that.params.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftTestQuery;
            leftTestQuery = this.getTestQuery();
            String rightTestQuery;
            rightTestQuery = that.getTestQuery();
            if (this.testQuery!= null) {
                if (that.testQuery!= null) {
                    if (!leftTestQuery.equals(rightTestQuery)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.testQuery!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<HTTPQueryType> theQueryTypes;
            theQueryTypes = (((this.queryTypes!= null)&&(!this.queryTypes.isEmpty()))?this.getQueryTypes():null);
            if ((this.queryTypes!= null)&&(!this.queryTypes.isEmpty())) {
                currentHashCode += theQueryTypes.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theResultType;
            theResultType = this.getResultType();
            if (this.resultType!= null) {
                currentHashCode += theResultType.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<InputParam> theParams;
            theParams = (((this.params!= null)&&(!this.params.isEmpty()))?this.getParams():null);
            if ((this.params!= null)&&(!this.params.isEmpty())) {
                currentHashCode += theParams.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theTestQuery;
            theTestQuery = this.getTestQuery();
            if (this.testQuery!= null) {
                currentHashCode += theTestQuery.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<HTTPQueryType> theQueryTypes;
            theQueryTypes = (((this.queryTypes!= null)&&(!this.queryTypes.isEmpty()))?this.getQueryTypes():null);
            strategy.appendField(locator, this, "queryTypes", buffer, theQueryTypes, ((this.queryTypes!= null)&&(!this.queryTypes.isEmpty())));
        }
        {
            String theResultType;
            theResultType = this.getResultType();
            strategy.appendField(locator, this, "resultType", buffer, theResultType, (this.resultType!= null));
        }
        {
            List<InputParam> theParams;
            theParams = (((this.params!= null)&&(!this.params.isEmpty()))?this.getParams():null);
            strategy.appendField(locator, this, "params", buffer, theParams, ((this.params!= null)&&(!this.params.isEmpty())));
        }
        {
            String theTestQuery;
            theTestQuery = this.getTestQuery();
            strategy.appendField(locator, this, "testQuery", buffer, theTestQuery, (this.testQuery!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof ParamHTTP) {
            final ParamHTTP target = this;
            final ParamHTTP leftObject = ((ParamHTTP) left);
            final ParamHTTP rightObject = ((ParamHTTP) right);
            {
                Boolean queryTypesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.queryTypes!= null)&&(!leftObject.queryTypes.isEmpty())), ((rightObject.queryTypes!= null)&&(!rightObject.queryTypes.isEmpty())));
                if (queryTypesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<HTTPQueryType> lhsQueryTypes;
                    lhsQueryTypes = (((leftObject.queryTypes!= null)&&(!leftObject.queryTypes.isEmpty()))?leftObject.getQueryTypes():null);
                    List<HTTPQueryType> rhsQueryTypes;
                    rhsQueryTypes = (((rightObject.queryTypes!= null)&&(!rightObject.queryTypes.isEmpty()))?rightObject.getQueryTypes():null);
                    List<HTTPQueryType> mergedQueryTypes = ((List<HTTPQueryType> ) strategy.merge(LocatorUtils.property(leftLocator, "queryTypes", lhsQueryTypes), LocatorUtils.property(rightLocator, "queryTypes", rhsQueryTypes), lhsQueryTypes, rhsQueryTypes, ((leftObject.queryTypes!= null)&&(!leftObject.queryTypes.isEmpty())), ((rightObject.queryTypes!= null)&&(!rightObject.queryTypes.isEmpty()))));
                    target.queryTypes = null;
                    if (mergedQueryTypes!= null) {
                        List<HTTPQueryType> uniqueQueryTypesl = target.getQueryTypes();
                        uniqueQueryTypesl.addAll(mergedQueryTypes);
                    }
                } else {
                    if (queryTypesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.queryTypes = null;
                    }
                }
            }
            {
                Boolean resultTypeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.resultType!= null), (rightObject.resultType!= null));
                if (resultTypeShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsResultType;
                    lhsResultType = leftObject.getResultType();
                    String rhsResultType;
                    rhsResultType = rightObject.getResultType();
                    String mergedResultType = ((String) strategy.merge(LocatorUtils.property(leftLocator, "resultType", lhsResultType), LocatorUtils.property(rightLocator, "resultType", rhsResultType), lhsResultType, rhsResultType, (leftObject.resultType!= null), (rightObject.resultType!= null)));
                    target.setResultType(mergedResultType);
                } else {
                    if (resultTypeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.resultType = null;
                    }
                }
            }
            {
                Boolean paramsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.params!= null)&&(!leftObject.params.isEmpty())), ((rightObject.params!= null)&&(!rightObject.params.isEmpty())));
                if (paramsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<InputParam> lhsParams;
                    lhsParams = (((leftObject.params!= null)&&(!leftObject.params.isEmpty()))?leftObject.getParams():null);
                    List<InputParam> rhsParams;
                    rhsParams = (((rightObject.params!= null)&&(!rightObject.params.isEmpty()))?rightObject.getParams():null);
                    List<InputParam> mergedParams = ((List<InputParam> ) strategy.merge(LocatorUtils.property(leftLocator, "params", lhsParams), LocatorUtils.property(rightLocator, "params", rhsParams), lhsParams, rhsParams, ((leftObject.params!= null)&&(!leftObject.params.isEmpty())), ((rightObject.params!= null)&&(!rightObject.params.isEmpty()))));
                    target.params = null;
                    if (mergedParams!= null) {
                        List<InputParam> uniqueParamsl = target.getParams();
                        uniqueParamsl.addAll(mergedParams);
                    }
                } else {
                    if (paramsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.params = null;
                    }
                }
            }
            {
                Boolean testQueryShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.testQuery!= null), (rightObject.testQuery!= null));
                if (testQueryShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsTestQuery;
                    lhsTestQuery = leftObject.getTestQuery();
                    String rhsTestQuery;
                    rhsTestQuery = rightObject.getTestQuery();
                    String mergedTestQuery = ((String) strategy.merge(LocatorUtils.property(leftLocator, "testQuery", lhsTestQuery), LocatorUtils.property(rightLocator, "testQuery", rhsTestQuery), lhsTestQuery, rhsTestQuery, (leftObject.testQuery!= null), (rightObject.testQuery!= null)));
                    target.setTestQuery(mergedTestQuery);
                } else {
                    if (testQueryShouldBeMergedAndSet == Boolean.FALSE) {
                        target.testQuery = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new ParamHTTP();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public ParamHTTP clone() {
        final ParamHTTP _newObject;
        _newObject = ((ParamHTTP) super.clone());
        _newObject.queryTypes = ((this.queryTypes == null)?null:new ArrayList<>(this.queryTypes));
        if (this.params == null) {
            _newObject.params = null;
        } else {
            _newObject.params = new ArrayList<>();
            for (InputParam _item: this.params) {
                _newObject.params.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public ParamHTTP createCopy() {
        final ParamHTTP _newObject = ((ParamHTTP) super.createCopy());
        _newObject.queryTypes = ((this.queryTypes == null)?null:new ArrayList<>(this.queryTypes));
        _newObject.resultType = this.resultType;
        if (this.params == null) {
            _newObject.params = null;
        } else {
            _newObject.params = new ArrayList<>();
            for (InputParam _item: this.params) {
                _newObject.params.add(((_item == null)?null:_item.createCopy()));
            }
        }
        _newObject.testQuery = this.testQuery;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public ParamHTTP createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ParamHTTP _newObject = ((ParamHTTP) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree queryTypesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("queryTypes"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(queryTypesPropertyTree!= null):((queryTypesPropertyTree == null)||(!queryTypesPropertyTree.isLeaf())))) {
            _newObject.queryTypes = ((this.queryTypes == null)?null:new ArrayList<>(this.queryTypes));
        }
        final PropertyTree resultTypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("resultType"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(resultTypePropertyTree!= null):((resultTypePropertyTree == null)||(!resultTypePropertyTree.isLeaf())))) {
            _newObject.resultType = this.resultType;
        }
        final PropertyTree paramsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("params"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(paramsPropertyTree!= null):((paramsPropertyTree == null)||(!paramsPropertyTree.isLeaf())))) {
            if (this.params == null) {
                _newObject.params = null;
            } else {
                _newObject.params = new ArrayList<>();
                for (InputParam _item: this.params) {
                    _newObject.params.add(((_item == null)?null:_item.createCopy(paramsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree testQueryPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("testQuery"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(testQueryPropertyTree!= null):((testQueryPropertyTree == null)||(!testQueryPropertyTree.isLeaf())))) {
            _newObject.testQuery = this.testQuery;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public ParamHTTP copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public ParamHTTP copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public ParamHTTP.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new ParamHTTP.Modifier();
        }
        return ((ParamHTTP.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final ParamHTTP.Builder<_B> _other) {
        super.copyTo(_other);
        if (this.queryTypes == null) {
            _other.queryTypes = null;
        } else {
            _other.queryTypes = new ArrayList<>();
            for (HTTPQueryType _item: this.queryTypes) {
                _other.queryTypes.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
        _other.resultType = this.resultType;
        if (this.params == null) {
            _other.params = null;
        } else {
            _other.params = new ArrayList<>();
            for (InputParam _item: this.params) {
                _other.params.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        _other.testQuery = this.testQuery;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >ParamHTTP.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new ParamHTTP.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public ParamHTTP.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static ParamHTTP.Builder<Void> builder() {
        return new ParamHTTP.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >ParamHTTP.Builder<_B> copyOf(final ServiceInterface _other) {
        final ParamHTTP.Builder<_B> _newBuilder = new ParamHTTP.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >ParamHTTP.Builder<_B> copyOf(final ParamHTTP _other) {
        final ParamHTTP.Builder<_B> _newBuilder = new ParamHTTP.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final ParamHTTP.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree queryTypesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("queryTypes"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(queryTypesPropertyTree!= null):((queryTypesPropertyTree == null)||(!queryTypesPropertyTree.isLeaf())))) {
            if (this.queryTypes == null) {
                _other.queryTypes = null;
            } else {
                _other.queryTypes = new ArrayList<>();
                for (HTTPQueryType _item: this.queryTypes) {
                    _other.queryTypes.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
        final PropertyTree resultTypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("resultType"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(resultTypePropertyTree!= null):((resultTypePropertyTree == null)||(!resultTypePropertyTree.isLeaf())))) {
            _other.resultType = this.resultType;
        }
        final PropertyTree paramsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("params"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(paramsPropertyTree!= null):((paramsPropertyTree == null)||(!paramsPropertyTree.isLeaf())))) {
            if (this.params == null) {
                _other.params = null;
            } else {
                _other.params = new ArrayList<>();
                for (InputParam _item: this.params) {
                    _other.params.add(((_item == null)?null:_item.newCopyBuilder(_other, paramsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree testQueryPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("testQuery"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(testQueryPropertyTree!= null):((testQueryPropertyTree == null)||(!testQueryPropertyTree.isLeaf())))) {
            _other.testQuery = this.testQuery;
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >ParamHTTP.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new ParamHTTP.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public ParamHTTP.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >ParamHTTP.Builder<_B> copyOf(final ServiceInterface _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ParamHTTP.Builder<_B> _newBuilder = new ParamHTTP.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >ParamHTTP.Builder<_B> copyOf(final ParamHTTP _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final ParamHTTP.Builder<_B> _newBuilder = new ParamHTTP.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static ParamHTTP.Builder<Void> copyExcept(final ServiceInterface _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static ParamHTTP.Builder<Void> copyExcept(final ParamHTTP _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static ParamHTTP.Builder<Void> copyOnly(final ServiceInterface _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static ParamHTTP.Builder<Void> copyOnly(final ParamHTTP _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public ParamHTTP visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new CollectionProperty<>(ParamHTTP.PropInfo.QUERY_TYPES, this));
        _visitor_.visit(new SingleProperty<>(ParamHTTP.PropInfo.RESULT_TYPE, this));
        if (_visitor_.visit(new CollectionProperty<>(ParamHTTP.PropInfo.PARAMS, this))&&(this.params!= null)) {
            for (InputParam _item_: this.params) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        _visitor_.visit(new SingleProperty<>(ParamHTTP.PropInfo.TEST_QUERY, this));
        return this;
    }

    public static class Builder<_B >
        extends ServiceInterface.Builder<_B>
        implements Buildable
    {

        private List<Buildable> queryTypes;
        private String resultType;
        private List<InputParam.Builder<ParamHTTP.Builder<_B>>> params;
        private String testQuery;

        public Builder(final _B _parentBuilder, final ParamHTTP _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                if (_other.queryTypes == null) {
                    this.queryTypes = null;
                } else {
                    this.queryTypes = new ArrayList<>();
                    for (HTTPQueryType _item: _other.queryTypes) {
                        this.queryTypes.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                    }
                }
                this.resultType = _other.resultType;
                if (_other.params == null) {
                    this.params = null;
                } else {
                    this.params = new ArrayList<>();
                    for (InputParam _item: _other.params) {
                        this.params.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
                this.testQuery = _other.testQuery;
            }
        }

        public Builder(final _B _parentBuilder, final ParamHTTP _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree queryTypesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("queryTypes"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(queryTypesPropertyTree!= null):((queryTypesPropertyTree == null)||(!queryTypesPropertyTree.isLeaf())))) {
                    if (_other.queryTypes == null) {
                        this.queryTypes = null;
                    } else {
                        this.queryTypes = new ArrayList<>();
                        for (HTTPQueryType _item: _other.queryTypes) {
                            this.queryTypes.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                }
                final PropertyTree resultTypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("resultType"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(resultTypePropertyTree!= null):((resultTypePropertyTree == null)||(!resultTypePropertyTree.isLeaf())))) {
                    this.resultType = _other.resultType;
                }
                final PropertyTree paramsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("params"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(paramsPropertyTree!= null):((paramsPropertyTree == null)||(!paramsPropertyTree.isLeaf())))) {
                    if (_other.params == null) {
                        this.params = null;
                    } else {
                        this.params = new ArrayList<>();
                        for (InputParam _item: _other.params) {
                            this.params.add(((_item == null)?null:_item.newCopyBuilder(this, paramsPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
                final PropertyTree testQueryPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("testQuery"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(testQueryPropertyTree!= null):((testQueryPropertyTree == null)||(!testQueryPropertyTree.isLeaf())))) {
                    this.testQuery = _other.testQuery;
                }
            }
        }

        protected<_P extends ParamHTTP >_P init(final _P _product) {
            if (this.queryTypes!= null) {
                final List<HTTPQueryType> queryTypes = new ArrayList<>(this.queryTypes.size());
                for (Buildable _item: this.queryTypes) {
                    queryTypes.add(((HTTPQueryType) _item.build()));
                }
                _product.queryTypes = queryTypes;
            }
            _product.resultType = this.resultType;
            if (this.params!= null) {
                final List<InputParam> params = new ArrayList<>(this.params.size());
                for (InputParam.Builder<ParamHTTP.Builder<_B>> _item: this.params) {
                    params.add(_item.build());
                }
                _product.params = params;
            }
            _product.testQuery = this.testQuery;
            return super.init(_product);
        }

        /**
         * Adds the given items to the value of "queryTypes"
         * 
         * @param queryTypes
         *     Items to add to the value of the "queryTypes" property
         */
        public ParamHTTP.Builder<_B> addQueryTypes(final Iterable<? extends HTTPQueryType> queryTypes) {
            if (queryTypes!= null) {
                if (this.queryTypes == null) {
                    this.queryTypes = new ArrayList<>();
                }
                for (HTTPQueryType _item: queryTypes) {
                    this.queryTypes.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "queryTypes" (any previous value will be replaced)
         * 
         * @param queryTypes
         *     New value of the "queryTypes" property.
         */
        public ParamHTTP.Builder<_B> withQueryTypes(final Iterable<? extends HTTPQueryType> queryTypes) {
            if (this.queryTypes!= null) {
                this.queryTypes.clear();
            }
            return addQueryTypes(queryTypes);
        }

        /**
         * Adds the given items to the value of "queryTypes"
         * 
         * @param queryTypes
         *     Items to add to the value of the "queryTypes" property
         */
        public ParamHTTP.Builder<_B> addQueryTypes(HTTPQueryType... queryTypes) {
            addQueryTypes(Arrays.asList(queryTypes));
            return this;
        }

        /**
         * Sets the new value of "queryTypes" (any previous value will be replaced)
         * 
         * @param queryTypes
         *     New value of the "queryTypes" property.
         */
        public ParamHTTP.Builder<_B> withQueryTypes(HTTPQueryType... queryTypes) {
            withQueryTypes(Arrays.asList(queryTypes));
            return this;
        }

        /**
         * Sets the new value of "resultType" (any previous value will be replaced)
         * 
         * @param resultType
         *     New value of the "resultType" property.
         */
        public ParamHTTP.Builder<_B> withResultType(final String resultType) {
            this.resultType = resultType;
            return this;
        }

        /**
         * Adds the given items to the value of "params"
         * 
         * @param params
         *     Items to add to the value of the "params" property
         */
        public ParamHTTP.Builder<_B> addParams(final Iterable<? extends InputParam> params) {
            if (params!= null) {
                if (this.params == null) {
                    this.params = new ArrayList<>();
                }
                for (InputParam _item: params) {
                    this.params.add(new InputParam.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "params" (any previous value will be replaced)
         * 
         * @param params
         *     New value of the "params" property.
         */
        public ParamHTTP.Builder<_B> withParams(final Iterable<? extends InputParam> params) {
            if (this.params!= null) {
                this.params.clear();
            }
            return addParams(params);
        }

        /**
         * Adds the given items to the value of "params"
         * 
         * @param params
         *     Items to add to the value of the "params" property
         */
        public ParamHTTP.Builder<_B> addParams(InputParam... params) {
            addParams(Arrays.asList(params));
            return this;
        }

        /**
         * Sets the new value of "params" (any previous value will be replaced)
         * 
         * @param params
         *     New value of the "params" property.
         */
        public ParamHTTP.Builder<_B> withParams(InputParam... params) {
            withParams(Arrays.asList(params));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Params" property.
         * Use {@link
         * org.javastro.ivoa.entities.resource.dataservice.InputParam.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Params" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.resource.dataservice.InputParam.Builder#end()} to
         *     return to the current builder.
         */
        public InputParam.Builder<? extends ParamHTTP.Builder<_B>> addParams() {
            if (this.params == null) {
                this.params = new ArrayList<>();
            }
            final InputParam.Builder<ParamHTTP.Builder<_B>> params_Builder = new InputParam.Builder<>(this, null, false);
            this.params.add(params_Builder);
            return params_Builder;
        }

        /**
         * Sets the new value of "testQuery" (any previous value will be replaced)
         * 
         * @param testQuery
         *     New value of the "testQuery" property.
         */
        public ParamHTTP.Builder<_B> withTestQuery(final String testQuery) {
            this.testQuery = testQuery;
            return this;
        }

        /**
         * Adds the given items to the value of "accessURLs"
         * 
         * @param accessURLs
         *     Items to add to the value of the "accessURLs" property
         */
        @Override
        public ParamHTTP.Builder<_B> addAccessURLs(final Iterable<? extends AccessURL> accessURLs) {
            super.addAccessURLs(accessURLs);
            return this;
        }

        /**
         * Adds the given items to the value of "accessURLs"
         * 
         * @param accessURLs
         *     Items to add to the value of the "accessURLs" property
         */
        @Override
        public ParamHTTP.Builder<_B> addAccessURLs(AccessURL... accessURLs) {
            super.addAccessURLs(accessURLs);
            return this;
        }

        /**
         * Sets the new value of "accessURLs" (any previous value will be replaced)
         * 
         * @param accessURLs
         *     New value of the "accessURLs" property.
         */
        @Override
        public ParamHTTP.Builder<_B> withAccessURLs(final Iterable<? extends AccessURL> accessURLs) {
            super.withAccessURLs(accessURLs);
            return this;
        }

        /**
         * Sets the new value of "accessURLs" (any previous value will be replaced)
         * 
         * @param accessURLs
         *     New value of the "accessURLs" property.
         */
        @Override
        public ParamHTTP.Builder<_B> withAccessURLs(AccessURL... accessURLs) {
            super.withAccessURLs(accessURLs);
            return this;
        }

        /**
         * Adds the given items to the value of "mirrorURLs"
         * 
         * @param mirrorURLs
         *     Items to add to the value of the "mirrorURLs" property
         */
        @Override
        public ParamHTTP.Builder<_B> addMirrorURLs(final Iterable<? extends MirrorURL> mirrorURLs) {
            super.addMirrorURLs(mirrorURLs);
            return this;
        }

        /**
         * Adds the given items to the value of "mirrorURLs"
         * 
         * @param mirrorURLs
         *     Items to add to the value of the "mirrorURLs" property
         */
        @Override
        public ParamHTTP.Builder<_B> addMirrorURLs(MirrorURL... mirrorURLs) {
            super.addMirrorURLs(mirrorURLs);
            return this;
        }

        /**
         * Sets the new value of "mirrorURLs" (any previous value will be replaced)
         * 
         * @param mirrorURLs
         *     New value of the "mirrorURLs" property.
         */
        @Override
        public ParamHTTP.Builder<_B> withMirrorURLs(final Iterable<? extends MirrorURL> mirrorURLs) {
            super.withMirrorURLs(mirrorURLs);
            return this;
        }

        /**
         * Sets the new value of "mirrorURLs" (any previous value will be replaced)
         * 
         * @param mirrorURLs
         *     New value of the "mirrorURLs" property.
         */
        @Override
        public ParamHTTP.Builder<_B> withMirrorURLs(MirrorURL... mirrorURLs) {
            super.withMirrorURLs(mirrorURLs);
            return this;
        }

        /**
         * Sets the new value of "securityMethod" (any previous value will be replaced)
         * 
         * @param securityMethod
         *     New value of the "securityMethod" property.
         */
        @Override
        public ParamHTTP.Builder<_B> withSecurityMethod(final SecurityMethod securityMethod) {
            super.withSecurityMethod(securityMethod);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "securityMethod" property.
         * Use {@link org.javastro.ivoa.entities.resource.SecurityMethod.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "securityMethod" property.
         *     Use {@link org.javastro.ivoa.entities.resource.SecurityMethod.Builder#end()} to
         *     return to the current builder.
         */
        public SecurityMethod.Builder<? extends ParamHTTP.Builder<_B>> withSecurityMethod() {
            return ((SecurityMethod.Builder<? extends ParamHTTP.Builder<_B>> ) super.withSecurityMethod());
        }

        /**
         * Sets the new value of "testQueryString" (any previous value will be replaced)
         * 
         * @param testQueryString
         *     New value of the "testQueryString" property.
         */
        @Override
        public ParamHTTP.Builder<_B> withTestQueryString(final String testQueryString) {
            super.withTestQueryString(testQueryString);
            return this;
        }

        /**
         * Sets the new value of "version" (any previous value will be replaced)
         * 
         * @param version
         *     New value of the "version" property.
         */
        @Override
        public ParamHTTP.Builder<_B> withVersion(final String version) {
            super.withVersion(version);
            return this;
        }

        /**
         * Sets the new value of "role" (any previous value will be replaced)
         * 
         * @param role
         *     New value of the "role" property.
         */
        @Override
        public ParamHTTP.Builder<_B> withRole(final String role) {
            super.withRole(role);
            return this;
        }

        @Override
        public ParamHTTP build() {
            if (_storedValue == null) {
                return this.init(new ParamHTTP());
            } else {
                return ((ParamHTTP) _storedValue);
            }
        }

        public ParamHTTP.Builder<_B> copyOf(final ParamHTTP _other) {
            _other.copyTo(this);
            return this;
        }

        public ParamHTTP.Builder<_B> copyOf(final ParamHTTP.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends ServiceInterface.Modifier
    {


        public List<HTTPQueryType> getQueryTypes() {
            if (ParamHTTP.this.queryTypes == null) {
                ParamHTTP.this.queryTypes = new ArrayList<>();
            }
            return ParamHTTP.this.queryTypes;
        }

        public void setResultType(final String resultType) {
            ParamHTTP.this.setResultType(resultType);
        }

        public List<InputParam> getParams() {
            if (ParamHTTP.this.params == null) {
                ParamHTTP.this.params = new ArrayList<>();
            }
            return ParamHTTP.this.params;
        }

        public void setTestQuery(final String testQuery) {
            ParamHTTP.this.setTestQuery(testQuery);
        }

    }

    public static class PropInfo {

        public static final transient CollectionPropertyInfo<ParamHTTP, HTTPQueryType> QUERY_TYPES = new CollectionPropertyInfo<ParamHTTP,HTTPQueryType>("queryTypes", ParamHTTP.class, HTTPQueryType.class, true, null, new QName("", "queryType"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "HTTPQueryType"), false) {


            @Override
            public List<HTTPQueryType> get(final ParamHTTP _instance_) {
                return ((_instance_ == null)?null:_instance_.queryTypes);
            }

            @Override
            public void set(final ParamHTTP _instance_, final List<HTTPQueryType> _value_) {
                if (_instance_!= null) {
                    _instance_.queryTypes = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ParamHTTP, String> RESULT_TYPE = new SinglePropertyInfo<ParamHTTP,String>("resultType", ParamHTTP.class, String.class, false, null, new QName("", "resultType"), new QName("http://www.w3.org/2001/XMLSchema", "token"), false) {


            @Override
            public String get(final ParamHTTP _instance_) {
                return ((_instance_ == null)?null:_instance_.resultType);
            }

            @Override
            public void set(final ParamHTTP _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.resultType = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<ParamHTTP, InputParam> PARAMS = new CollectionPropertyInfo<ParamHTTP,InputParam>("params", ParamHTTP.class, InputParam.class, true, null, new QName("", "param"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "InputParam"), false) {


            @Override
            public List<InputParam> get(final ParamHTTP _instance_) {
                return ((_instance_ == null)?null:_instance_.params);
            }

            @Override
            public void set(final ParamHTTP _instance_, final List<InputParam> _value_) {
                if (_instance_!= null) {
                    _instance_.params = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<ParamHTTP, String> TEST_QUERY = new SinglePropertyInfo<ParamHTTP,String>("testQuery", ParamHTTP.class, String.class, false, null, new QName("", "testQuery"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final ParamHTTP _instance_) {
                return ((_instance_ == null)?null:_instance_.testQuery);
            }

            @Override
            public void set(final ParamHTTP _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.testQuery = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends ParamHTTP.Selector<ParamHTTP.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static ParamHTTP.Select _root() {
            return new ParamHTTP.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends ServiceInterface.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, ParamHTTP.Selector<TRoot, TParent>> queryTypes = null;
        private com.kscs.util.jaxb.Selector<TRoot, ParamHTTP.Selector<TRoot, TParent>> resultType = null;
        private InputParam.Selector<TRoot, ParamHTTP.Selector<TRoot, TParent>> params = null;
        private com.kscs.util.jaxb.Selector<TRoot, ParamHTTP.Selector<TRoot, TParent>> testQuery = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.queryTypes!= null) {
                products.put("queryTypes", this.queryTypes.init());
            }
            if (this.resultType!= null) {
                products.put("resultType", this.resultType.init());
            }
            if (this.params!= null) {
                products.put("params", this.params.init());
            }
            if (this.testQuery!= null) {
                products.put("testQuery", this.testQuery.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, ParamHTTP.Selector<TRoot, TParent>> queryTypes() {
            return ((this.queryTypes == null)?this.queryTypes = new com.kscs.util.jaxb.Selector<>(this._root, this, "queryTypes"):this.queryTypes);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ParamHTTP.Selector<TRoot, TParent>> resultType() {
            return ((this.resultType == null)?this.resultType = new com.kscs.util.jaxb.Selector<>(this._root, this, "resultType"):this.resultType);
        }

        public InputParam.Selector<TRoot, ParamHTTP.Selector<TRoot, TParent>> params() {
            return ((this.params == null)?this.params = new InputParam.Selector<>(this._root, this, "params"):this.params);
        }

        public com.kscs.util.jaxb.Selector<TRoot, ParamHTTP.Selector<TRoot, TParent>> testQuery() {
            return ((this.testQuery == null)?this.testQuery = new com.kscs.util.jaxb.Selector<>(this._root, this, "testQuery"):this.testQuery);
        }

    }

}
