
package org.javastro.ivoa.entities.resource.dataservice;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * An abstract parent for the specific data types supported 
 *             by the Table Access Protocol.
 * 
 * <p>Java class for TAPDataType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TAPDataType">
 *   <simpleContent>
 *     <extension base="<http://www.ivoa.net/xml/VODataService/v1.1>TableDataType">
 *       <attribute name="size" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" />
 *       <anyAttribute namespace='##other'/>
 *     </extension>
 *   </simpleContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TAPDataType")
@XmlSeeAlso({
    TAPType.class
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public abstract class TAPDataType
    extends TableDataType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * This corresponds to the size Column attribute in
     *                     the TAP_SCHEMA and can be used with data types
     *                     that are defined with a length (CHAR, BINARY).
     * 
     */
    @XmlAttribute(name = "size")
    @XmlSchemaType(name = "positiveInteger")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected BigInteger size;

    /**
     * Default no-arg constructor
     * 
     */
    public TAPDataType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public TAPDataType(final String value, final String arraysize, final String delim, final String extendedType, final String extendedSchema, final Map<QName, String> otherAttributes, final BigInteger size) {
        super(value, arraysize, delim, extendedType, extendedSchema, otherAttributes);
        this.size = size;
    }

    /**
     * This corresponds to the size Column attribute in
     *                     the TAP_SCHEMA and can be used with data types
     *                     that are defined with a length (CHAR, BINARY).
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public BigInteger getSize() {
        return size;
    }

    /**
     * Sets the value of the size property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     * @see #getSize()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setSize(BigInteger value) {
        this.size = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final TAPDataType that = ((TAPDataType) object);
        {
            BigInteger leftSize;
            leftSize = this.getSize();
            BigInteger rightSize;
            rightSize = that.getSize();
            if (this.size!= null) {
                if (that.size!= null) {
                    if (!leftSize.equals(rightSize)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.size!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theSize;
            theSize = this.getSize();
            if (this.size!= null) {
                currentHashCode += theSize.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            BigInteger theSize;
            theSize = this.getSize();
            strategy.appendField(locator, this, "size", buffer, theSize, (this.size!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof TAPDataType) {
            final TAPDataType target = this;
            final TAPDataType leftObject = ((TAPDataType) left);
            final TAPDataType rightObject = ((TAPDataType) right);
            {
                Boolean sizeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.size!= null), (rightObject.size!= null));
                if (sizeShouldBeMergedAndSet == Boolean.TRUE) {
                    BigInteger lhsSize;
                    lhsSize = leftObject.getSize();
                    BigInteger rhsSize;
                    rhsSize = rightObject.getSize();
                    BigInteger mergedSize = ((BigInteger) strategy.merge(LocatorUtils.property(leftLocator, "size", lhsSize), LocatorUtils.property(rightLocator, "size", rhsSize), lhsSize, rhsSize, (leftObject.size!= null), (rightObject.size!= null)));
                    target.setSize(mergedSize);
                } else {
                    if (sizeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.size = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TAPDataType clone() {
        final TAPDataType _newObject;
        _newObject = ((TAPDataType) super.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TAPDataType createCopy() {
        final TAPDataType _newObject = ((TAPDataType) super.createCopy());
        _newObject.size = this.size;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TAPDataType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final TAPDataType _newObject = ((TAPDataType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree sizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("size"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(sizePropertyTree!= null):((sizePropertyTree == null)||(!sizePropertyTree.isLeaf())))) {
            _newObject.size = this.size;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TAPDataType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TAPDataType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TAPDataType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new TAPDataType.Modifier();
        }
        return ((TAPDataType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final TAPDataType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.size = this.size;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public abstract<_B >TAPDataType.Builder<_B> newCopyBuilder(final _B _parentBuilder);

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public abstract TAPDataType.Builder<Void> newCopyBuilder();

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final TAPDataType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree sizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("size"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(sizePropertyTree!= null):((sizePropertyTree == null)||(!sizePropertyTree.isLeaf())))) {
            _other.size = this.size;
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public abstract<_B >TAPDataType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse);

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public abstract TAPDataType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse);

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TAPDataType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty<>(TAPDataType.PropInfo.SIZE, this));
        return this;
    }

    public static class Builder<_B >
        extends TableDataType.Builder<_B>
        implements Buildable
    {

        private BigInteger size;

        public Builder(final _B _parentBuilder, final TAPDataType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.size = _other.size;
            }
        }

        public Builder(final _B _parentBuilder, final TAPDataType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree sizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("size"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(sizePropertyTree!= null):((sizePropertyTree == null)||(!sizePropertyTree.isLeaf())))) {
                    this.size = _other.size;
                }
            }
        }

        protected<_P extends TAPDataType >_P init(final _P _product) {
            _product.size = this.size;
            return super.init(_product);
        }

        /**
         * Sets the new value of "size" (any previous value will be replaced)
         * 
         * @param size
         *     New value of the "size" property.
         */
        public TAPDataType.Builder<_B> withSize(final BigInteger size) {
            this.size = size;
            return this;
        }

        /**
         * Sets the new value of "value" (any previous value will be replaced)
         * 
         * @param value
         *     New value of the "value" property.
         */
        @Override
        public TAPDataType.Builder<_B> withValue(final String value) {
            super.withValue(value);
            return this;
        }

        /**
         * Sets the new value of "arraysize" (any previous value will be replaced)
         * 
         * @param arraysize
         *     New value of the "arraysize" property.
         */
        @Override
        public TAPDataType.Builder<_B> withArraysize(final String arraysize) {
            super.withArraysize(arraysize);
            return this;
        }

        /**
         * Sets the new value of "delim" (any previous value will be replaced)
         * 
         * @param delim
         *     New value of the "delim" property.
         */
        @Override
        public TAPDataType.Builder<_B> withDelim(final String delim) {
            super.withDelim(delim);
            return this;
        }

        /**
         * Sets the new value of "extendedType" (any previous value will be replaced)
         * 
         * @param extendedType
         *     New value of the "extendedType" property.
         */
        @Override
        public TAPDataType.Builder<_B> withExtendedType(final String extendedType) {
            super.withExtendedType(extendedType);
            return this;
        }

        /**
         * Sets the new value of "extendedSchema" (any previous value will be replaced)
         * 
         * @param extendedSchema
         *     New value of the "extendedSchema" property.
         */
        @Override
        public TAPDataType.Builder<_B> withExtendedSchema(final String extendedSchema) {
            super.withExtendedSchema(extendedSchema);
            return this;
        }

        @Override
        public TAPDataType build() {
            return ((TAPDataType) _storedValue);
        }

        public TAPDataType.Builder<_B> copyOf(final TAPDataType _other) {
            _other.copyTo(this);
            return this;
        }

        public TAPDataType.Builder<_B> copyOf(final TAPDataType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends TableDataType.Modifier
    {


        public void setSize(final BigInteger size) {
            TAPDataType.this.setSize(size);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<TAPDataType, BigInteger> SIZE = new SinglePropertyInfo<TAPDataType,BigInteger>("size", TAPDataType.class, BigInteger.class, false, null, new QName("", "size"), new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), true) {


            @Override
            public BigInteger get(final TAPDataType _instance_) {
                return ((_instance_ == null)?null:_instance_.size);
            }

            @Override
            public void set(final TAPDataType _instance_, final BigInteger _value_) {
                if (_instance_!= null) {
                    _instance_.size = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends TAPDataType.Selector<TAPDataType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static TAPDataType.Select _root() {
            return new TAPDataType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends TableDataType.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, TAPDataType.Selector<TRoot, TParent>> size = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.size!= null) {
                products.put("size", this.size.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, TAPDataType.Selector<TRoot, TParent>> size() {
            return ((this.size == null)?this.size = new com.kscs.util.jaxb.Selector<>(this._root, this, "size"):this.size);
        }

    }

}
