
package org.javastro.ivoa.entities.resource.dataservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A detailed description of a logically related group of tables.
 * 
 * <p>Java class for TableSchema complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TableSchema">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="name" type="{http://www.w3.org/2001/XMLSchema}token"/>
 *         <element name="title" type="{http://www.w3.org/2001/XMLSchema}token" minOccurs="0"/>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}token" minOccurs="0"/>
 *         <element name="utype" type="{http://www.w3.org/2001/XMLSchema}token" minOccurs="0"/>
 *         <element name="table" type="{http://www.ivoa.net/xml/VODataService/v1.1}Table" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <anyAttribute namespace='##other'/>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TableSchema", propOrder = {
    "name",
    "title",
    "description",
    "utype",
    "tables"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class TableSchema implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * If there is no appropriate logical name associated with
     *                this group, the name should be explicitly set to
     *                “default”.
     * 
     */
    @XmlElement(required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String name;
    /**
     * This is used for display purposes.  There is no requirement
     *                   regarding uniqueness.  It is useful when there are
     *                   multiple schemas in the context (e.g., within a
     *                   tableset; otherwise, the resource title could be
     *                   used instead).
     * 
     */
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String title;
    /**
     * A free text description of the group of tables that should
     *                explain in general how all of the tables in the group are 
     *                related.
     * 
     */
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String description;
    /**
     * The form of the utype string depends on the data
     *                   model; common forms are sequences of dotted identifiers
     *                   (e.g., in SSA) or URIs (e.g., in RegTAP).
     * 
     */
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String utype;
    /**
     * A description of one table.
     * 
     */
    @XmlElement(name = "table")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<Table> tables;
    @XmlAnyAttribute
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    private Map<QName, String> otherAttributes = new HashMap<>();
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected transient TableSchema.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public TableSchema() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public TableSchema(final String name, final String title, final String description, final String utype, final List<Table> tables, final Map<QName, String> otherAttributes) {
        this.name = name;
        this.title = title;
        this.description = description;
        this.utype = utype;
        this.tables = tables;
        this.otherAttributes = otherAttributes;
    }

    /**
     * If there is no appropriate logical name associated with
     *                this group, the name should be explicitly set to
     *                “default”.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getName()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setName(String value) {
        this.name = value;
    }

    /**
     * This is used for display purposes.  There is no requirement
     *                   regarding uniqueness.  It is useful when there are
     *                   multiple schemas in the context (e.g., within a
     *                   tableset; otherwise, the resource title could be
     *                   used instead).
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getTitle() {
        return title;
    }

    /**
     * Sets the value of the title property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getTitle()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setTitle(String value) {
        this.title = value;
    }

    /**
     * A free text description of the group of tables that should
     *                explain in general how all of the tables in the group are 
     *                related.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDescription()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * The form of the utype string depends on the data
     *                   model; common forms are sequences of dotted identifiers
     *                   (e.g., in SSA) or URIs (e.g., in RegTAP).
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getUtype() {
        return utype;
    }

    /**
     * Sets the value of the utype property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getUtype()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setUtype(String value) {
        this.utype = value;
    }

    /**
     * A description of one table.
     * 
     * Gets the value of the tables property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the tables property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTables().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Table }
     * </p>
     * 
     * 
     * @return
     *     The value of the tables property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<Table> getTables() {
        if (tables == null) {
            tables = new ArrayList<>();
        }
        return this.tables;
    }

    /**
     * Gets a map that contains attributes that aren't bound to any typed property on this class.
     * 
     * <p>
     * the map is keyed by the name of the attribute and 
     * the value is the string value of the attribute.
     * 
     * the map returned by this method is live, and you can add new attribute
     * by updating the map directly. Because of this design, there's no setter.
     * 
     * 
     * @return
     *     always non-null
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Map<QName, String> getOtherAttributes() {
        return otherAttributes;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final TableSchema that = ((TableSchema) object);
        {
            String leftName;
            leftName = this.getName();
            String rightName;
            rightName = that.getName();
            if (this.name!= null) {
                if (that.name!= null) {
                    if (!leftName.equals(rightName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.name!= null) {
                    return false;
                }
            }
        }
        {
            String leftTitle;
            leftTitle = this.getTitle();
            String rightTitle;
            rightTitle = that.getTitle();
            if (this.title!= null) {
                if (that.title!= null) {
                    if (!leftTitle.equals(rightTitle)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.title!= null) {
                    return false;
                }
            }
        }
        {
            String leftDescription;
            leftDescription = this.getDescription();
            String rightDescription;
            rightDescription = that.getDescription();
            if (this.description!= null) {
                if (that.description!= null) {
                    if (!leftDescription.equals(rightDescription)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.description!= null) {
                    return false;
                }
            }
        }
        {
            String leftUtype;
            leftUtype = this.getUtype();
            String rightUtype;
            rightUtype = that.getUtype();
            if (this.utype!= null) {
                if (that.utype!= null) {
                    if (!leftUtype.equals(rightUtype)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.utype!= null) {
                    return false;
                }
            }
        }
        {
            List<Table> leftTables;
            leftTables = (((this.tables!= null)&&(!this.tables.isEmpty()))?this.getTables():null);
            List<Table> rightTables;
            rightTables = (((that.tables!= null)&&(!that.tables.isEmpty()))?that.getTables():null);
            if ((this.tables!= null)&&(!this.tables.isEmpty())) {
                if ((that.tables!= null)&&(!that.tables.isEmpty())) {
                    if (!leftTables.equals(rightTables)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.tables!= null)&&(!that.tables.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theName;
            theName = this.getName();
            if (this.name!= null) {
                currentHashCode += theName.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theTitle;
            theTitle = this.getTitle();
            if (this.title!= null) {
                currentHashCode += theTitle.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theDescription;
            theDescription = this.getDescription();
            if (this.description!= null) {
                currentHashCode += theDescription.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theUtype;
            theUtype = this.getUtype();
            if (this.utype!= null) {
                currentHashCode += theUtype.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Table> theTables;
            theTables = (((this.tables!= null)&&(!this.tables.isEmpty()))?this.getTables():null);
            if ((this.tables!= null)&&(!this.tables.isEmpty())) {
                currentHashCode += theTables.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theName;
            theName = this.getName();
            strategy.appendField(locator, this, "name", buffer, theName, (this.name!= null));
        }
        {
            String theTitle;
            theTitle = this.getTitle();
            strategy.appendField(locator, this, "title", buffer, theTitle, (this.title!= null));
        }
        {
            String theDescription;
            theDescription = this.getDescription();
            strategy.appendField(locator, this, "description", buffer, theDescription, (this.description!= null));
        }
        {
            String theUtype;
            theUtype = this.getUtype();
            strategy.appendField(locator, this, "utype", buffer, theUtype, (this.utype!= null));
        }
        {
            List<Table> theTables;
            theTables = (((this.tables!= null)&&(!this.tables.isEmpty()))?this.getTables():null);
            strategy.appendField(locator, this, "tables", buffer, theTables, ((this.tables!= null)&&(!this.tables.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof TableSchema) {
            final TableSchema target = this;
            final TableSchema leftObject = ((TableSchema) left);
            final TableSchema rightObject = ((TableSchema) right);
            {
                Boolean nameShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.name!= null), (rightObject.name!= null));
                if (nameShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsName;
                    lhsName = leftObject.getName();
                    String rhsName;
                    rhsName = rightObject.getName();
                    String mergedName = ((String) strategy.merge(LocatorUtils.property(leftLocator, "name", lhsName), LocatorUtils.property(rightLocator, "name", rhsName), lhsName, rhsName, (leftObject.name!= null), (rightObject.name!= null)));
                    target.setName(mergedName);
                } else {
                    if (nameShouldBeMergedAndSet == Boolean.FALSE) {
                        target.name = null;
                    }
                }
            }
            {
                Boolean titleShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.title!= null), (rightObject.title!= null));
                if (titleShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsTitle;
                    lhsTitle = leftObject.getTitle();
                    String rhsTitle;
                    rhsTitle = rightObject.getTitle();
                    String mergedTitle = ((String) strategy.merge(LocatorUtils.property(leftLocator, "title", lhsTitle), LocatorUtils.property(rightLocator, "title", rhsTitle), lhsTitle, rhsTitle, (leftObject.title!= null), (rightObject.title!= null)));
                    target.setTitle(mergedTitle);
                } else {
                    if (titleShouldBeMergedAndSet == Boolean.FALSE) {
                        target.title = null;
                    }
                }
            }
            {
                Boolean descriptionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.description!= null), (rightObject.description!= null));
                if (descriptionShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsDescription;
                    lhsDescription = leftObject.getDescription();
                    String rhsDescription;
                    rhsDescription = rightObject.getDescription();
                    String mergedDescription = ((String) strategy.merge(LocatorUtils.property(leftLocator, "description", lhsDescription), LocatorUtils.property(rightLocator, "description", rhsDescription), lhsDescription, rhsDescription, (leftObject.description!= null), (rightObject.description!= null)));
                    target.setDescription(mergedDescription);
                } else {
                    if (descriptionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.description = null;
                    }
                }
            }
            {
                Boolean utypeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.utype!= null), (rightObject.utype!= null));
                if (utypeShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsUtype;
                    lhsUtype = leftObject.getUtype();
                    String rhsUtype;
                    rhsUtype = rightObject.getUtype();
                    String mergedUtype = ((String) strategy.merge(LocatorUtils.property(leftLocator, "utype", lhsUtype), LocatorUtils.property(rightLocator, "utype", rhsUtype), lhsUtype, rhsUtype, (leftObject.utype!= null), (rightObject.utype!= null)));
                    target.setUtype(mergedUtype);
                } else {
                    if (utypeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.utype = null;
                    }
                }
            }
            {
                Boolean tablesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.tables!= null)&&(!leftObject.tables.isEmpty())), ((rightObject.tables!= null)&&(!rightObject.tables.isEmpty())));
                if (tablesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<Table> lhsTables;
                    lhsTables = (((leftObject.tables!= null)&&(!leftObject.tables.isEmpty()))?leftObject.getTables():null);
                    List<Table> rhsTables;
                    rhsTables = (((rightObject.tables!= null)&&(!rightObject.tables.isEmpty()))?rightObject.getTables():null);
                    List<Table> mergedTables = ((List<Table> ) strategy.merge(LocatorUtils.property(leftLocator, "tables", lhsTables), LocatorUtils.property(rightLocator, "tables", rhsTables), lhsTables, rhsTables, ((leftObject.tables!= null)&&(!leftObject.tables.isEmpty())), ((rightObject.tables!= null)&&(!rightObject.tables.isEmpty()))));
                    target.tables = null;
                    if (mergedTables!= null) {
                        List<Table> uniqueTablesl = target.getTables();
                        uniqueTablesl.addAll(mergedTables);
                    }
                } else {
                    if (tablesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.tables = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new TableSchema();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TableSchema clone() {
        final TableSchema _newObject;
        try {
            _newObject = ((TableSchema) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.tables == null) {
            _newObject.tables = null;
        } else {
            _newObject.tables = new ArrayList<>();
            for (Table _item: this.tables) {
                _newObject.tables.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TableSchema createCopy() {
        final TableSchema _newObject;
        try {
            _newObject = ((TableSchema) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.name = this.name;
        _newObject.title = this.title;
        _newObject.description = this.description;
        _newObject.utype = this.utype;
        if (this.tables == null) {
            _newObject.tables = null;
        } else {
            _newObject.tables = new ArrayList<>();
            for (Table _item: this.tables) {
                _newObject.tables.add(((_item == null)?null:_item.createCopy()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TableSchema createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final TableSchema _newObject;
        try {
            _newObject = ((TableSchema) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
            _newObject.name = this.name;
        }
        final PropertyTree titlePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("title"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(titlePropertyTree!= null):((titlePropertyTree == null)||(!titlePropertyTree.isLeaf())))) {
            _newObject.title = this.title;
        }
        final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
            _newObject.description = this.description;
        }
        final PropertyTree utypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("utype"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(utypePropertyTree!= null):((utypePropertyTree == null)||(!utypePropertyTree.isLeaf())))) {
            _newObject.utype = this.utype;
        }
        final PropertyTree tablesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("tables"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(tablesPropertyTree!= null):((tablesPropertyTree == null)||(!tablesPropertyTree.isLeaf())))) {
            if (this.tables == null) {
                _newObject.tables = null;
            } else {
                _newObject.tables = new ArrayList<>();
                for (Table _item: this.tables) {
                    _newObject.tables.add(((_item == null)?null:_item.createCopy(tablesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TableSchema copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TableSchema copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TableSchema.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new TableSchema.Modifier();
        }
        return ((TableSchema.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final TableSchema.Builder<_B> _other) {
        _other.name = this.name;
        _other.title = this.title;
        _other.description = this.description;
        _other.utype = this.utype;
        if (this.tables == null) {
            _other.tables = null;
        } else {
            _other.tables = new ArrayList<>();
            for (Table _item: this.tables) {
                _other.tables.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >TableSchema.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new TableSchema.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TableSchema.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static TableSchema.Builder<Void> builder() {
        return new TableSchema.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >TableSchema.Builder<_B> copyOf(final TableSchema _other) {
        final TableSchema.Builder<_B> _newBuilder = new TableSchema.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final TableSchema.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
            _other.name = this.name;
        }
        final PropertyTree titlePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("title"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(titlePropertyTree!= null):((titlePropertyTree == null)||(!titlePropertyTree.isLeaf())))) {
            _other.title = this.title;
        }
        final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
            _other.description = this.description;
        }
        final PropertyTree utypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("utype"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(utypePropertyTree!= null):((utypePropertyTree == null)||(!utypePropertyTree.isLeaf())))) {
            _other.utype = this.utype;
        }
        final PropertyTree tablesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("tables"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(tablesPropertyTree!= null):((tablesPropertyTree == null)||(!tablesPropertyTree.isLeaf())))) {
            if (this.tables == null) {
                _other.tables = null;
            } else {
                _other.tables = new ArrayList<>();
                for (Table _item: this.tables) {
                    _other.tables.add(((_item == null)?null:_item.newCopyBuilder(_other, tablesPropertyTree, _propertyTreeUse)));
                }
            }
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >TableSchema.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new TableSchema.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TableSchema.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >TableSchema.Builder<_B> copyOf(final TableSchema _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final TableSchema.Builder<_B> _newBuilder = new TableSchema.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static TableSchema.Builder<Void> copyExcept(final TableSchema _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static TableSchema.Builder<Void> copyOnly(final TableSchema _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TableSchema visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(TableSchema.PropInfo.NAME, this));
        _visitor_.visit(new SingleProperty<>(TableSchema.PropInfo.TITLE, this));
        _visitor_.visit(new SingleProperty<>(TableSchema.PropInfo.DESCRIPTION, this));
        _visitor_.visit(new SingleProperty<>(TableSchema.PropInfo.UTYPE, this));
        if (_visitor_.visit(new CollectionProperty<>(TableSchema.PropInfo.TABLES, this))&&(this.tables!= null)) {
            for (Table _item_: this.tables) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final TableSchema _storedValue;
        private String name;
        private String title;
        private String description;
        private String utype;
        private List<Table.Builder<TableSchema.Builder<_B>>> tables;

        public Builder(final _B _parentBuilder, final TableSchema _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.name = _other.name;
                    this.title = _other.title;
                    this.description = _other.description;
                    this.utype = _other.utype;
                    if (_other.tables == null) {
                        this.tables = null;
                    } else {
                        this.tables = new ArrayList<>();
                        for (Table _item: _other.tables) {
                            this.tables.add(((_item == null)?null:_item.newCopyBuilder(this)));
                        }
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final TableSchema _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
                        this.name = _other.name;
                    }
                    final PropertyTree titlePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("title"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(titlePropertyTree!= null):((titlePropertyTree == null)||(!titlePropertyTree.isLeaf())))) {
                        this.title = _other.title;
                    }
                    final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
                        this.description = _other.description;
                    }
                    final PropertyTree utypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("utype"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(utypePropertyTree!= null):((utypePropertyTree == null)||(!utypePropertyTree.isLeaf())))) {
                        this.utype = _other.utype;
                    }
                    final PropertyTree tablesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("tables"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(tablesPropertyTree!= null):((tablesPropertyTree == null)||(!tablesPropertyTree.isLeaf())))) {
                        if (_other.tables == null) {
                            this.tables = null;
                        } else {
                            this.tables = new ArrayList<>();
                            for (Table _item: _other.tables) {
                                this.tables.add(((_item == null)?null:_item.newCopyBuilder(this, tablesPropertyTree, _propertyTreeUse)));
                            }
                        }
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends TableSchema >_P init(final _P _product) {
            _product.name = this.name;
            _product.title = this.title;
            _product.description = this.description;
            _product.utype = this.utype;
            if (this.tables!= null) {
                final List<Table> tables = new ArrayList<>(this.tables.size());
                for (Table.Builder<TableSchema.Builder<_B>> _item: this.tables) {
                    tables.add(_item.build());
                }
                _product.tables = tables;
            }
            return _product;
        }

        /**
         * Sets the new value of "name" (any previous value will be replaced)
         * 
         * @param name
         *     New value of the "name" property.
         */
        public TableSchema.Builder<_B> withName(final String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the new value of "title" (any previous value will be replaced)
         * 
         * @param title
         *     New value of the "title" property.
         */
        public TableSchema.Builder<_B> withTitle(final String title) {
            this.title = title;
            return this;
        }

        /**
         * Sets the new value of "description" (any previous value will be replaced)
         * 
         * @param description
         *     New value of the "description" property.
         */
        public TableSchema.Builder<_B> withDescription(final String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the new value of "utype" (any previous value will be replaced)
         * 
         * @param utype
         *     New value of the "utype" property.
         */
        public TableSchema.Builder<_B> withUtype(final String utype) {
            this.utype = utype;
            return this;
        }

        /**
         * Adds the given items to the value of "tables"
         * 
         * @param tables
         *     Items to add to the value of the "tables" property
         */
        public TableSchema.Builder<_B> addTables(final Iterable<? extends Table> tables) {
            if (tables!= null) {
                if (this.tables == null) {
                    this.tables = new ArrayList<>();
                }
                for (Table _item: tables) {
                    this.tables.add(new Table.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "tables" (any previous value will be replaced)
         * 
         * @param tables
         *     New value of the "tables" property.
         */
        public TableSchema.Builder<_B> withTables(final Iterable<? extends Table> tables) {
            if (this.tables!= null) {
                this.tables.clear();
            }
            return addTables(tables);
        }

        /**
         * Adds the given items to the value of "tables"
         * 
         * @param tables
         *     Items to add to the value of the "tables" property
         */
        public TableSchema.Builder<_B> addTables(Table... tables) {
            addTables(Arrays.asList(tables));
            return this;
        }

        /**
         * Sets the new value of "tables" (any previous value will be replaced)
         * 
         * @param tables
         *     New value of the "tables" property.
         */
        public TableSchema.Builder<_B> withTables(Table... tables) {
            withTables(Arrays.asList(tables));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Tables" property.
         * Use {@link org.javastro.ivoa.entities.resource.dataservice.Table.Builder#end()}
         * to return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Tables" property.
         *     Use {@link org.javastro.ivoa.entities.resource.dataservice.Table.Builder#end()}
         *     to return to the current builder.
         */
        public Table.Builder<? extends TableSchema.Builder<_B>> addTables() {
            if (this.tables == null) {
                this.tables = new ArrayList<>();
            }
            final Table.Builder<TableSchema.Builder<_B>> tables_Builder = new Table.Builder<>(this, null, false);
            this.tables.add(tables_Builder);
            return tables_Builder;
        }

        @Override
        public TableSchema build() {
            if (_storedValue == null) {
                return this.init(new TableSchema());
            } else {
                return ((TableSchema) _storedValue);
            }
        }

        public TableSchema.Builder<_B> copyOf(final TableSchema _other) {
            _other.copyTo(this);
            return this;
        }

        public TableSchema.Builder<_B> copyOf(final TableSchema.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setName(final String name) {
            TableSchema.this.setName(name);
        }

        public void setTitle(final String title) {
            TableSchema.this.setTitle(title);
        }

        public void setDescription(final String description) {
            TableSchema.this.setDescription(description);
        }

        public void setUtype(final String utype) {
            TableSchema.this.setUtype(utype);
        }

        public List<Table> getTables() {
            if (TableSchema.this.tables == null) {
                TableSchema.this.tables = new ArrayList<>();
            }
            return TableSchema.this.tables;
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<TableSchema, String> NAME = new SinglePropertyInfo<TableSchema,String>("name", TableSchema.class, String.class, false, null, new QName("", "name"), new QName("http://www.w3.org/2001/XMLSchema", "token"), false) {


            @Override
            public String get(final TableSchema _instance_) {
                return ((_instance_ == null)?null:_instance_.name);
            }

            @Override
            public void set(final TableSchema _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.name = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<TableSchema, String> TITLE = new SinglePropertyInfo<TableSchema,String>("title", TableSchema.class, String.class, false, null, new QName("", "title"), new QName("http://www.w3.org/2001/XMLSchema", "token"), false) {


            @Override
            public String get(final TableSchema _instance_) {
                return ((_instance_ == null)?null:_instance_.title);
            }

            @Override
            public void set(final TableSchema _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.title = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<TableSchema, String> DESCRIPTION = new SinglePropertyInfo<TableSchema,String>("description", TableSchema.class, String.class, false, null, new QName("", "description"), new QName("http://www.w3.org/2001/XMLSchema", "token"), false) {


            @Override
            public String get(final TableSchema _instance_) {
                return ((_instance_ == null)?null:_instance_.description);
            }

            @Override
            public void set(final TableSchema _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.description = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<TableSchema, String> UTYPE = new SinglePropertyInfo<TableSchema,String>("utype", TableSchema.class, String.class, false, null, new QName("", "utype"), new QName("http://www.w3.org/2001/XMLSchema", "token"), false) {


            @Override
            public String get(final TableSchema _instance_) {
                return ((_instance_ == null)?null:_instance_.utype);
            }

            @Override
            public void set(final TableSchema _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.utype = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<TableSchema, Table> TABLES = new CollectionPropertyInfo<TableSchema,Table>("tables", TableSchema.class, Table.class, true, null, new QName("", "table"), new QName("http://www.ivoa.net/xml/VODataService/v1.1", "Table"), false) {


            @Override
            public List<Table> get(final TableSchema _instance_) {
                return ((_instance_ == null)?null:_instance_.tables);
            }

            @Override
            public void set(final TableSchema _instance_, final List<Table> _value_) {
                if (_instance_!= null) {
                    _instance_.tables = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends TableSchema.Selector<TableSchema.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static TableSchema.Select _root() {
            return new TableSchema.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, TableSchema.Selector<TRoot, TParent>> name = null;
        private com.kscs.util.jaxb.Selector<TRoot, TableSchema.Selector<TRoot, TParent>> title = null;
        private com.kscs.util.jaxb.Selector<TRoot, TableSchema.Selector<TRoot, TParent>> description = null;
        private com.kscs.util.jaxb.Selector<TRoot, TableSchema.Selector<TRoot, TParent>> utype = null;
        private Table.Selector<TRoot, TableSchema.Selector<TRoot, TParent>> tables = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.name!= null) {
                products.put("name", this.name.init());
            }
            if (this.title!= null) {
                products.put("title", this.title.init());
            }
            if (this.description!= null) {
                products.put("description", this.description.init());
            }
            if (this.utype!= null) {
                products.put("utype", this.utype.init());
            }
            if (this.tables!= null) {
                products.put("tables", this.tables.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, TableSchema.Selector<TRoot, TParent>> name() {
            return ((this.name == null)?this.name = new com.kscs.util.jaxb.Selector<>(this._root, this, "name"):this.name);
        }

        public com.kscs.util.jaxb.Selector<TRoot, TableSchema.Selector<TRoot, TParent>> title() {
            return ((this.title == null)?this.title = new com.kscs.util.jaxb.Selector<>(this._root, this, "title"):this.title);
        }

        public com.kscs.util.jaxb.Selector<TRoot, TableSchema.Selector<TRoot, TParent>> description() {
            return ((this.description == null)?this.description = new com.kscs.util.jaxb.Selector<>(this._root, this, "description"):this.description);
        }

        public com.kscs.util.jaxb.Selector<TRoot, TableSchema.Selector<TRoot, TParent>> utype() {
            return ((this.utype == null)?this.utype = new com.kscs.util.jaxb.Selector<>(this._root, this, "utype"):this.utype);
        }

        public Table.Selector<TRoot, TableSchema.Selector<TRoot, TParent>> tables() {
            return ((this.tables == null)?this.tables = new Table.Selector<>(this._root, this, "tables"):this.tables);
        }

    }

}
