
package org.javastro.ivoa.entities.resource.registry;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.javastro.ivoa.entities.resource.Content;
import org.javastro.ivoa.entities.resource.Curation;
import org.javastro.ivoa.entities.resource.Resource;
import org.javastro.ivoa.entities.resource.ResourceName;
import org.javastro.ivoa.entities.resource.Validation;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * a naming authority; an assertion of control over a
 *            namespace represented by an authority identifier.
 * 
 * <p>Java class for Authority complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Authority">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/VOResource/v1.0}Resource">
 *       <sequence>
 *         <element name="managingOrg" type="{http://www.ivoa.net/xml/VOResource/v1.0}ResourceName"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Authority", propOrder = {
    "managingOrg"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class Authority
    extends Resource
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * In most cases, this will be the same as the Publisher.
     * 
     */
    @XmlElement(required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected ResourceName managingOrg;

    /**
     * Default no-arg constructor
     * 
     */
    public Authority() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Authority(final List<Validation> validationLevels, final String title, final String shortName, final String identifier, final List<String> altIdentifiers, final Curation curation, final Content content, final LocalDateTime created, final LocalDateTime updated, final String status, final String version, final ResourceName managingOrg) {
        super(validationLevels, title, shortName, identifier, altIdentifiers, curation, content, created, updated, status, version);
        this.managingOrg = managingOrg;
    }

    /**
     * In most cases, this will be the same as the Publisher.
     * 
     * @return
     *     possible object is
     *     {@link ResourceName }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public ResourceName getManagingOrg() {
        return managingOrg;
    }

    /**
     * Sets the value of the managingOrg property.
     * 
     * @param value
     *     allowed object is
     *     {@link ResourceName }
     *     
     * @see #getManagingOrg()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setManagingOrg(ResourceName value) {
        this.managingOrg = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final Authority that = ((Authority) object);
        {
            ResourceName leftManagingOrg;
            leftManagingOrg = this.getManagingOrg();
            ResourceName rightManagingOrg;
            rightManagingOrg = that.getManagingOrg();
            if (this.managingOrg!= null) {
                if (that.managingOrg!= null) {
                    if (!leftManagingOrg.equals(rightManagingOrg)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.managingOrg!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            ResourceName theManagingOrg;
            theManagingOrg = this.getManagingOrg();
            if (this.managingOrg!= null) {
                currentHashCode += theManagingOrg.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            ResourceName theManagingOrg;
            theManagingOrg = this.getManagingOrg();
            strategy.appendField(locator, this, "managingOrg", buffer, theManagingOrg, (this.managingOrg!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof Authority) {
            final Authority target = this;
            final Authority leftObject = ((Authority) left);
            final Authority rightObject = ((Authority) right);
            {
                Boolean managingOrgShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.managingOrg!= null), (rightObject.managingOrg!= null));
                if (managingOrgShouldBeMergedAndSet == Boolean.TRUE) {
                    ResourceName lhsManagingOrg;
                    lhsManagingOrg = leftObject.getManagingOrg();
                    ResourceName rhsManagingOrg;
                    rhsManagingOrg = rightObject.getManagingOrg();
                    ResourceName mergedManagingOrg = ((ResourceName) strategy.merge(LocatorUtils.property(leftLocator, "managingOrg", lhsManagingOrg), LocatorUtils.property(rightLocator, "managingOrg", rhsManagingOrg), lhsManagingOrg, rhsManagingOrg, (leftObject.managingOrg!= null), (rightObject.managingOrg!= null)));
                    target.setManagingOrg(mergedManagingOrg);
                } else {
                    if (managingOrgShouldBeMergedAndSet == Boolean.FALSE) {
                        target.managingOrg = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new Authority();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Authority clone() {
        final Authority _newObject;
        _newObject = ((Authority) super.clone());
        _newObject.managingOrg = ((this.managingOrg == null)?null:this.managingOrg.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Authority createCopy() {
        final Authority _newObject = ((Authority) super.createCopy());
        _newObject.managingOrg = ((this.managingOrg == null)?null:this.managingOrg.createCopy());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Authority createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Authority _newObject = ((Authority) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree managingOrgPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("managingOrg"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(managingOrgPropertyTree!= null):((managingOrgPropertyTree == null)||(!managingOrgPropertyTree.isLeaf())))) {
            _newObject.managingOrg = ((this.managingOrg == null)?null:this.managingOrg.createCopy(managingOrgPropertyTree, _propertyTreeUse));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Authority copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Authority copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Authority.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Authority.Modifier();
        }
        return ((Authority.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final Authority.Builder<_B> _other) {
        super.copyTo(_other);
        _other.managingOrg = ((this.managingOrg == null)?null:this.managingOrg.newCopyBuilder(_other));
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >Authority.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Authority.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Authority.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Authority.Builder<Void> builder() {
        return new Authority.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Authority.Builder<_B> copyOf(final Resource _other) {
        final Authority.Builder<_B> _newBuilder = new Authority.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Authority.Builder<_B> copyOf(final Authority _other) {
        final Authority.Builder<_B> _newBuilder = new Authority.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final Authority.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree managingOrgPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("managingOrg"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(managingOrgPropertyTree!= null):((managingOrgPropertyTree == null)||(!managingOrgPropertyTree.isLeaf())))) {
            _other.managingOrg = ((this.managingOrg == null)?null:this.managingOrg.newCopyBuilder(_other, managingOrgPropertyTree, _propertyTreeUse));
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >Authority.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Authority.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Authority.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Authority.Builder<_B> copyOf(final Resource _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Authority.Builder<_B> _newBuilder = new Authority.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Authority.Builder<_B> copyOf(final Authority _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Authority.Builder<_B> _newBuilder = new Authority.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Authority.Builder<Void> copyExcept(final Resource _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Authority.Builder<Void> copyExcept(final Authority _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Authority.Builder<Void> copyOnly(final Resource _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Authority.Builder<Void> copyOnly(final Authority _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Authority visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(Authority.PropInfo.MANAGING_ORG, this))&&(this.managingOrg!= null)) {
            this.managingOrg.visit(_visitor_);
        }
        return this;
    }

    public static class Builder<_B >
        extends Resource.Builder<_B>
        implements Buildable
    {

        private ResourceName.Builder<Authority.Builder<_B>> managingOrg;

        public Builder(final _B _parentBuilder, final Authority _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.managingOrg = ((_other.managingOrg == null)?null:_other.managingOrg.newCopyBuilder(this));
            }
        }

        public Builder(final _B _parentBuilder, final Authority _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree managingOrgPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("managingOrg"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(managingOrgPropertyTree!= null):((managingOrgPropertyTree == null)||(!managingOrgPropertyTree.isLeaf())))) {
                    this.managingOrg = ((_other.managingOrg == null)?null:_other.managingOrg.newCopyBuilder(this, managingOrgPropertyTree, _propertyTreeUse));
                }
            }
        }

        protected<_P extends Authority >_P init(final _P _product) {
            _product.managingOrg = ((this.managingOrg == null)?null:this.managingOrg.build());
            return super.init(_product);
        }

        /**
         * Sets the new value of "managingOrg" (any previous value will be replaced)
         * 
         * @param managingOrg
         *     New value of the "managingOrg" property.
         */
        public Authority.Builder<_B> withManagingOrg(final ResourceName managingOrg) {
            this.managingOrg = ((managingOrg == null)?null:new ResourceName.Builder<>(this, managingOrg, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "managingOrg" property.
         * Use {@link org.javastro.ivoa.entities.resource.ResourceName.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "managingOrg" property.
         *     Use {@link org.javastro.ivoa.entities.resource.ResourceName.Builder#end()} to
         *     return to the current builder.
         */
        public ResourceName.Builder<? extends Authority.Builder<_B>> withManagingOrg() {
            if (this.managingOrg!= null) {
                return this.managingOrg;
            }
            return this.managingOrg = new ResourceName.Builder<>(this, null, false);
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public Authority.Builder<_B> addValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public Authority.Builder<_B> addValidationLevels(Validation... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public Authority.Builder<_B> withValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public Authority.Builder<_B> withValidationLevels(Validation... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "title" (any previous value will be replaced)
         * 
         * @param title
         *     New value of the "title" property.
         */
        @Override
        public Authority.Builder<_B> withTitle(final String title) {
            super.withTitle(title);
            return this;
        }

        /**
         * Sets the new value of "shortName" (any previous value will be replaced)
         * 
         * @param shortName
         *     New value of the "shortName" property.
         */
        @Override
        public Authority.Builder<_B> withShortName(final String shortName) {
            super.withShortName(shortName);
            return this;
        }

        /**
         * Sets the new value of "identifier" (any previous value will be replaced)
         * 
         * @param identifier
         *     New value of the "identifier" property.
         */
        @Override
        public Authority.Builder<_B> withIdentifier(final String identifier) {
            super.withIdentifier(identifier);
            return this;
        }

        /**
         * Adds the given items to the value of "altIdentifiers"
         * 
         * @param altIdentifiers
         *     Items to add to the value of the "altIdentifiers" property
         */
        @Override
        public Authority.Builder<_B> addAltIdentifiers(final Iterable<? extends String> altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Adds the given items to the value of "altIdentifiers"
         * 
         * @param altIdentifiers
         *     Items to add to the value of the "altIdentifiers" property
         */
        @Override
        public Authority.Builder<_B> addAltIdentifiers(String... altIdentifiers) {
            super.addAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "altIdentifiers" (any previous value will be replaced)
         * 
         * @param altIdentifiers
         *     New value of the "altIdentifiers" property.
         */
        @Override
        public Authority.Builder<_B> withAltIdentifiers(final Iterable<? extends String> altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "altIdentifiers" (any previous value will be replaced)
         * 
         * @param altIdentifiers
         *     New value of the "altIdentifiers" property.
         */
        @Override
        public Authority.Builder<_B> withAltIdentifiers(String... altIdentifiers) {
            super.withAltIdentifiers(altIdentifiers);
            return this;
        }

        /**
         * Sets the new value of "curation" (any previous value will be replaced)
         * 
         * @param curation
         *     New value of the "curation" property.
         */
        @Override
        public Authority.Builder<_B> withCuration(final Curation curation) {
            super.withCuration(curation);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "curation" property.
         * Use {@link org.javastro.ivoa.entities.resource.Curation.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "curation" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Curation.Builder#end()} to return
         *     to the current builder.
         */
        public Curation.Builder<? extends Authority.Builder<_B>> withCuration() {
            return ((Curation.Builder<? extends Authority.Builder<_B>> ) super.withCuration());
        }

        /**
         * Sets the new value of "content" (any previous value will be replaced)
         * 
         * @param content
         *     New value of the "content" property.
         */
        @Override
        public Authority.Builder<_B> withContent(final Content content) {
            super.withContent(content);
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "content" property.
         * Use {@link org.javastro.ivoa.entities.resource.Content.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "content" property.
         *     Use {@link org.javastro.ivoa.entities.resource.Content.Builder#end()} to return
         *     to the current builder.
         */
        public Content.Builder<? extends Authority.Builder<_B>> withContent() {
            return ((Content.Builder<? extends Authority.Builder<_B>> ) super.withContent());
        }

        /**
         * Sets the new value of "created" (any previous value will be replaced)
         * 
         * @param created
         *     New value of the "created" property.
         */
        @Override
        public Authority.Builder<_B> withCreated(final LocalDateTime created) {
            super.withCreated(created);
            return this;
        }

        /**
         * Sets the new value of "updated" (any previous value will be replaced)
         * 
         * @param updated
         *     New value of the "updated" property.
         */
        @Override
        public Authority.Builder<_B> withUpdated(final LocalDateTime updated) {
            super.withUpdated(updated);
            return this;
        }

        /**
         * Sets the new value of "status" (any previous value will be replaced)
         * 
         * @param status
         *     New value of the "status" property.
         */
        @Override
        public Authority.Builder<_B> withStatus(final String status) {
            super.withStatus(status);
            return this;
        }

        /**
         * Sets the new value of "version" (any previous value will be replaced)
         * 
         * @param version
         *     New value of the "version" property.
         */
        @Override
        public Authority.Builder<_B> withVersion(final String version) {
            super.withVersion(version);
            return this;
        }

        @Override
        public Authority build() {
            if (_storedValue == null) {
                return this.init(new Authority());
            } else {
                return ((Authority) _storedValue);
            }
        }

        public Authority.Builder<_B> copyOf(final Authority _other) {
            _other.copyTo(this);
            return this;
        }

        public Authority.Builder<_B> copyOf(final Authority.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends Resource.Modifier
    {


        public void setManagingOrg(final ResourceName managingOrg) {
            Authority.this.setManagingOrg(managingOrg);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<Authority, ResourceName> MANAGING_ORG = new SinglePropertyInfo<Authority,ResourceName>("managingOrg", Authority.class, ResourceName.class, false, null, new QName("", "managingOrg"), new QName("http://www.ivoa.net/xml/VOResource/v1.0", "ResourceName"), false) {


            @Override
            public ResourceName get(final Authority _instance_) {
                return ((_instance_ == null)?null:_instance_.managingOrg);
            }

            @Override
            public void set(final Authority _instance_, final ResourceName _value_) {
                if (_instance_!= null) {
                    _instance_.managingOrg = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Authority.Selector<Authority.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Authority.Select _root() {
            return new Authority.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends Resource.Selector<TRoot, TParent>
    {

        private ResourceName.Selector<TRoot, Authority.Selector<TRoot, TParent>> managingOrg = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.managingOrg!= null) {
                products.put("managingOrg", this.managingOrg.init());
            }
            return products;
        }

        public ResourceName.Selector<TRoot, Authority.Selector<TRoot, TParent>> managingOrg() {
            return ((this.managingOrg == null)?this.managingOrg = new ResourceName.Selector<>(this._root, this, "managingOrg"):this.managingOrg);
        }

    }

}
