
package org.javastro.ivoa.entities.resource.registry;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlType;
import org.javastro.ivoa.entities.resource.Capability;
import org.javastro.ivoa.entities.resource.ServiceInterface;
import org.javastro.ivoa.entities.resource.Validation;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * The capabilities of the Registry Harvest implementation.
 * 
 * <p>Java class for Harvest complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Harvest">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/VORegistry/v1.0}RegCapRestriction">
 *       <sequence>
 *         <element name="maxRecords" type="{http://www.w3.org/2001/XMLSchema}int"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Harvest", propOrder = {
    "maxRecords"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class Harvest
    extends RegCapRestriction
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The largest number of records that the registry search
     *                         method will return.  A value greater than one implies 
     *                         that an OAI continuation token will be provided when 
     *                         the limit is reached.  A value of zero or less 
     *                         indicates that there is no explicit limit and
     *                         thus, continuation tokens are not supported.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected int maxRecords;

    /**
     * Default no-arg constructor
     * 
     */
    public Harvest() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Harvest(final List<Validation> validationLevels, final String description, final List<ServiceInterface> interfaces, final String standardID, final int maxRecords) {
        super(validationLevels, description, interfaces, standardID);
        this.maxRecords = maxRecords;
    }

    /**
     * The largest number of records that the registry search
     *                         method will return.  A value greater than one implies 
     *                         that an OAI continuation token will be provided when 
     *                         the limit is reached.  A value of zero or less 
     *                         indicates that there is no explicit limit and
     *                         thus, continuation tokens are not supported.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int getMaxRecords() {
        return maxRecords;
    }

    /**
     * Sets the value of the maxRecords property.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setMaxRecords(int value) {
        this.maxRecords = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final Harvest that = ((Harvest) object);
        {
            int leftMaxRecords;
            leftMaxRecords = this.getMaxRecords();
            int rightMaxRecords;
            rightMaxRecords = that.getMaxRecords();
            if (leftMaxRecords!= rightMaxRecords) {
                return false;
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            int theMaxRecords;
            theMaxRecords = this.getMaxRecords();
            currentHashCode += theMaxRecords;
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            int theMaxRecords;
            theMaxRecords = this.getMaxRecords();
            strategy.appendField(locator, this, "maxRecords", buffer, theMaxRecords, true);
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof Harvest) {
            final Harvest target = this;
            final Harvest leftObject = ((Harvest) left);
            final Harvest rightObject = ((Harvest) right);
            {
                Boolean maxRecordsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, true, true);
                if (maxRecordsShouldBeMergedAndSet == Boolean.TRUE) {
                    int lhsMaxRecords;
                    lhsMaxRecords = leftObject.getMaxRecords();
                    int rhsMaxRecords;
                    rhsMaxRecords = rightObject.getMaxRecords();
                    int mergedMaxRecords = ((int) strategy.merge(LocatorUtils.property(leftLocator, "maxRecords", lhsMaxRecords), LocatorUtils.property(rightLocator, "maxRecords", rhsMaxRecords), lhsMaxRecords, rhsMaxRecords, true, true));
                    target.setMaxRecords(mergedMaxRecords);
                } else {
                    if (maxRecordsShouldBeMergedAndSet == Boolean.FALSE) {
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new Harvest();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Harvest clone() {
        final Harvest _newObject;
        _newObject = ((Harvest) super.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Harvest createCopy() {
        final Harvest _newObject = ((Harvest) super.createCopy());
        _newObject.maxRecords = this.maxRecords;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Harvest createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Harvest _newObject = ((Harvest) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree maxRecordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxRecords"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxRecordsPropertyTree!= null):((maxRecordsPropertyTree == null)||(!maxRecordsPropertyTree.isLeaf())))) {
            _newObject.maxRecords = this.maxRecords;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Harvest copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Harvest copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Harvest.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Harvest.Modifier();
        }
        return ((Harvest.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final Harvest.Builder<_B> _other) {
        super.copyTo(_other);
        _other.maxRecords = this.maxRecords;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >Harvest.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Harvest.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Harvest.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Harvest.Builder<Void> builder() {
        return new Harvest.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Harvest.Builder<_B> copyOf(final Capability _other) {
        final Harvest.Builder<_B> _newBuilder = new Harvest.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Harvest.Builder<_B> copyOf(final RegCapRestriction _other) {
        final Harvest.Builder<_B> _newBuilder = new Harvest.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Harvest.Builder<_B> copyOf(final Harvest _other) {
        final Harvest.Builder<_B> _newBuilder = new Harvest.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final Harvest.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree maxRecordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxRecords"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxRecordsPropertyTree!= null):((maxRecordsPropertyTree == null)||(!maxRecordsPropertyTree.isLeaf())))) {
            _other.maxRecords = this.maxRecords;
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >Harvest.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Harvest.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Harvest.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Harvest.Builder<_B> copyOf(final Capability _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Harvest.Builder<_B> _newBuilder = new Harvest.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Harvest.Builder<_B> copyOf(final RegCapRestriction _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Harvest.Builder<_B> _newBuilder = new Harvest.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Harvest.Builder<_B> copyOf(final Harvest _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Harvest.Builder<_B> _newBuilder = new Harvest.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Harvest.Builder<Void> copyExcept(final Capability _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Harvest.Builder<Void> copyExcept(final RegCapRestriction _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Harvest.Builder<Void> copyExcept(final Harvest _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Harvest.Builder<Void> copyOnly(final Capability _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Harvest.Builder<Void> copyOnly(final RegCapRestriction _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Harvest.Builder<Void> copyOnly(final Harvest _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Harvest visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty<>(Harvest.PropInfo.MAX_RECORDS, this));
        return this;
    }

    public static class Builder<_B >
        extends RegCapRestriction.Builder<_B>
        implements Buildable
    {

        private int maxRecords;

        public Builder(final _B _parentBuilder, final Harvest _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.maxRecords = _other.maxRecords;
            }
        }

        public Builder(final _B _parentBuilder, final Harvest _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree maxRecordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxRecords"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxRecordsPropertyTree!= null):((maxRecordsPropertyTree == null)||(!maxRecordsPropertyTree.isLeaf())))) {
                    this.maxRecords = _other.maxRecords;
                }
            }
        }

        protected<_P extends Harvest >_P init(final _P _product) {
            _product.maxRecords = this.maxRecords;
            return super.init(_product);
        }

        /**
         * Sets the new value of "maxRecords" (any previous value will be replaced)
         * 
         * @param maxRecords
         *     New value of the "maxRecords" property.
         */
        public Harvest.Builder<_B> withMaxRecords(final int maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public Harvest.Builder<_B> addValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public Harvest.Builder<_B> addValidationLevels(Validation... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public Harvest.Builder<_B> withValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public Harvest.Builder<_B> withValidationLevels(Validation... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "description" (any previous value will be replaced)
         * 
         * @param description
         *     New value of the "description" property.
         */
        @Override
        public Harvest.Builder<_B> withDescription(final String description) {
            super.withDescription(description);
            return this;
        }

        /**
         * Adds the given items to the value of "interfaces"
         * 
         * @param interfaces
         *     Items to add to the value of the "interfaces" property
         */
        @Override
        public Harvest.Builder<_B> addInterfaces(final Iterable<? extends ServiceInterface> interfaces) {
            super.addInterfaces(interfaces);
            return this;
        }

        /**
         * Adds the given items to the value of "interfaces"
         * 
         * @param interfaces
         *     Items to add to the value of the "interfaces" property
         */
        @Override
        public Harvest.Builder<_B> addInterfaces(ServiceInterface... interfaces) {
            super.addInterfaces(interfaces);
            return this;
        }

        /**
         * Sets the new value of "interfaces" (any previous value will be replaced)
         * 
         * @param interfaces
         *     New value of the "interfaces" property.
         */
        @Override
        public Harvest.Builder<_B> withInterfaces(final Iterable<? extends ServiceInterface> interfaces) {
            super.withInterfaces(interfaces);
            return this;
        }

        /**
         * Sets the new value of "interfaces" (any previous value will be replaced)
         * 
         * @param interfaces
         *     New value of the "interfaces" property.
         */
        @Override
        public Harvest.Builder<_B> withInterfaces(ServiceInterface... interfaces) {
            super.withInterfaces(interfaces);
            return this;
        }

        /**
         * Sets the new value of "standardID" (any previous value will be replaced)
         * 
         * @param standardID
         *     New value of the "standardID" property.
         */
        @Override
        public Harvest.Builder<_B> withStandardID(final String standardID) {
            super.withStandardID(standardID);
            return this;
        }

        @Override
        public Harvest build() {
            if (_storedValue == null) {
                return this.init(new Harvest());
            } else {
                return ((Harvest) _storedValue);
            }
        }

        public Harvest.Builder<_B> copyOf(final Harvest _other) {
            _other.copyTo(this);
            return this;
        }

        public Harvest.Builder<_B> copyOf(final Harvest.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends RegCapRestriction.Modifier
    {


        public void setMaxRecords(final int maxRecords) {
            Harvest.this.setMaxRecords(maxRecords);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<Harvest, Integer> MAX_RECORDS = new SinglePropertyInfo<Harvest,Integer>("maxRecords", Harvest.class, Integer.class, false, null, new QName("", "maxRecords"), new QName("http://www.w3.org/2001/XMLSchema", "int"), false) {


            @Override
            public Integer get(final Harvest _instance_) {
                return ((_instance_ == null)?null:_instance_.maxRecords);
            }

            @Override
            public void set(final Harvest _instance_, final Integer _value_) {
                if (_instance_!= null) {
                    _instance_.maxRecords = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Harvest.Selector<Harvest.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Harvest.Select _root() {
            return new Harvest.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends RegCapRestriction.Selector<TRoot, TParent>
    {


        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            return products;
        }

    }

}
