
package org.javastro.ivoa.entities.resource.registry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.javastro.ivoa.entities.resource.Capability;
import org.javastro.ivoa.entities.resource.ServiceInterface;
import org.javastro.ivoa.entities.resource.Validation;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * The capabilities of the Registry Search implementation.
 * 
 * <p>Java class for Search complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Search">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/VORegistry/v1.0}RegCapRestriction">
 *       <sequence>
 *         <element name="maxRecords" type="{http://www.w3.org/2001/XMLSchema}int"/>
 *         <element name="extensionSearchSupport" type="{http://www.ivoa.net/xml/VORegistry/v1.0}ExtensionSearchSupport"/>
 *         <element name="optionalProtocol" type="{http://www.ivoa.net/xml/VORegistry/v1.0}OptionalProtocol" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Search", propOrder = {
    "maxRecords",
    "extensionSearchSupport",
    "optionalProtocols"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class Search
    extends RegCapRestriction
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The largest number of records that the registry search
     *                         method will return.  A value of zero or less indicates
     *                         that there is no explicit limit.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected int maxRecords;
    /**
     * A legal VOResource extension schema is one that imports
     *                        and extends the VOResource core schema in compliance
     *                        with the VOResource standard.
     * 
     */
    @XmlElement(required = true)
    @XmlSchemaType(name = "NMTOKEN")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected ExtensionSearchSupport extensionSearchSupport;
    /**
     * Only one optional protocol is currently allowed 
     *                         (XQuery).  It is assumed that the required protocols 
     *                         (simple keyword search and ADQL) are supported.
     * 
     */
    @XmlElement(name = "optionalProtocol")
    @XmlSchemaType(name = "NMTOKEN")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<OptionalProtocol> optionalProtocols;

    /**
     * Default no-arg constructor
     * 
     */
    public Search() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Search(final List<Validation> validationLevels, final String description, final List<ServiceInterface> interfaces, final String standardID, final int maxRecords, final ExtensionSearchSupport extensionSearchSupport, final List<OptionalProtocol> optionalProtocols) {
        super(validationLevels, description, interfaces, standardID);
        this.maxRecords = maxRecords;
        this.extensionSearchSupport = extensionSearchSupport;
        this.optionalProtocols = optionalProtocols;
    }

    /**
     * The largest number of records that the registry search
     *                         method will return.  A value of zero or less indicates
     *                         that there is no explicit limit.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int getMaxRecords() {
        return maxRecords;
    }

    /**
     * Sets the value of the maxRecords property.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setMaxRecords(int value) {
        this.maxRecords = value;
    }

    /**
     * A legal VOResource extension schema is one that imports
     *                        and extends the VOResource core schema in compliance
     *                        with the VOResource standard.
     * 
     * @return
     *     possible object is
     *     {@link ExtensionSearchSupport }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public ExtensionSearchSupport getExtensionSearchSupport() {
        return extensionSearchSupport;
    }

    /**
     * Sets the value of the extensionSearchSupport property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExtensionSearchSupport }
     *     
     * @see #getExtensionSearchSupport()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setExtensionSearchSupport(ExtensionSearchSupport value) {
        this.extensionSearchSupport = value;
    }

    /**
     * Only one optional protocol is currently allowed 
     *                         (XQuery).  It is assumed that the required protocols 
     *                         (simple keyword search and ADQL) are supported.
     * 
     * Gets the value of the optionalProtocols property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the optionalProtocols property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getOptionalProtocols().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OptionalProtocol }
     * </p>
     * 
     * 
     * @return
     *     The value of the optionalProtocols property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<OptionalProtocol> getOptionalProtocols() {
        if (optionalProtocols == null) {
            optionalProtocols = new ArrayList<>();
        }
        return this.optionalProtocols;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final Search that = ((Search) object);
        {
            int leftMaxRecords;
            leftMaxRecords = this.getMaxRecords();
            int rightMaxRecords;
            rightMaxRecords = that.getMaxRecords();
            if (leftMaxRecords!= rightMaxRecords) {
                return false;
            }
        }
        {
            ExtensionSearchSupport leftExtensionSearchSupport;
            leftExtensionSearchSupport = this.getExtensionSearchSupport();
            ExtensionSearchSupport rightExtensionSearchSupport;
            rightExtensionSearchSupport = that.getExtensionSearchSupport();
            if (this.extensionSearchSupport!= null) {
                if (that.extensionSearchSupport!= null) {
                    if (!leftExtensionSearchSupport.equals(rightExtensionSearchSupport)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.extensionSearchSupport!= null) {
                    return false;
                }
            }
        }
        {
            List<OptionalProtocol> leftOptionalProtocols;
            leftOptionalProtocols = (((this.optionalProtocols!= null)&&(!this.optionalProtocols.isEmpty()))?this.getOptionalProtocols():null);
            List<OptionalProtocol> rightOptionalProtocols;
            rightOptionalProtocols = (((that.optionalProtocols!= null)&&(!that.optionalProtocols.isEmpty()))?that.getOptionalProtocols():null);
            if ((this.optionalProtocols!= null)&&(!this.optionalProtocols.isEmpty())) {
                if ((that.optionalProtocols!= null)&&(!that.optionalProtocols.isEmpty())) {
                    if (!leftOptionalProtocols.equals(rightOptionalProtocols)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.optionalProtocols!= null)&&(!that.optionalProtocols.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            int theMaxRecords;
            theMaxRecords = this.getMaxRecords();
            currentHashCode += theMaxRecords;
        }
        {
            currentHashCode = (currentHashCode* 31);
            ExtensionSearchSupport theExtensionSearchSupport;
            theExtensionSearchSupport = this.getExtensionSearchSupport();
            if (this.extensionSearchSupport!= null) {
                currentHashCode += theExtensionSearchSupport.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<OptionalProtocol> theOptionalProtocols;
            theOptionalProtocols = (((this.optionalProtocols!= null)&&(!this.optionalProtocols.isEmpty()))?this.getOptionalProtocols():null);
            if ((this.optionalProtocols!= null)&&(!this.optionalProtocols.isEmpty())) {
                currentHashCode += theOptionalProtocols.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            int theMaxRecords;
            theMaxRecords = this.getMaxRecords();
            strategy.appendField(locator, this, "maxRecords", buffer, theMaxRecords, true);
        }
        {
            ExtensionSearchSupport theExtensionSearchSupport;
            theExtensionSearchSupport = this.getExtensionSearchSupport();
            strategy.appendField(locator, this, "extensionSearchSupport", buffer, theExtensionSearchSupport, (this.extensionSearchSupport!= null));
        }
        {
            List<OptionalProtocol> theOptionalProtocols;
            theOptionalProtocols = (((this.optionalProtocols!= null)&&(!this.optionalProtocols.isEmpty()))?this.getOptionalProtocols():null);
            strategy.appendField(locator, this, "optionalProtocols", buffer, theOptionalProtocols, ((this.optionalProtocols!= null)&&(!this.optionalProtocols.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof Search) {
            final Search target = this;
            final Search leftObject = ((Search) left);
            final Search rightObject = ((Search) right);
            {
                Boolean maxRecordsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, true, true);
                if (maxRecordsShouldBeMergedAndSet == Boolean.TRUE) {
                    int lhsMaxRecords;
                    lhsMaxRecords = leftObject.getMaxRecords();
                    int rhsMaxRecords;
                    rhsMaxRecords = rightObject.getMaxRecords();
                    int mergedMaxRecords = ((int) strategy.merge(LocatorUtils.property(leftLocator, "maxRecords", lhsMaxRecords), LocatorUtils.property(rightLocator, "maxRecords", rhsMaxRecords), lhsMaxRecords, rhsMaxRecords, true, true));
                    target.setMaxRecords(mergedMaxRecords);
                } else {
                    if (maxRecordsShouldBeMergedAndSet == Boolean.FALSE) {
                    }
                }
            }
            {
                Boolean extensionSearchSupportShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.extensionSearchSupport!= null), (rightObject.extensionSearchSupport!= null));
                if (extensionSearchSupportShouldBeMergedAndSet == Boolean.TRUE) {
                    ExtensionSearchSupport lhsExtensionSearchSupport;
                    lhsExtensionSearchSupport = leftObject.getExtensionSearchSupport();
                    ExtensionSearchSupport rhsExtensionSearchSupport;
                    rhsExtensionSearchSupport = rightObject.getExtensionSearchSupport();
                    ExtensionSearchSupport mergedExtensionSearchSupport = ((ExtensionSearchSupport) strategy.merge(LocatorUtils.property(leftLocator, "extensionSearchSupport", lhsExtensionSearchSupport), LocatorUtils.property(rightLocator, "extensionSearchSupport", rhsExtensionSearchSupport), lhsExtensionSearchSupport, rhsExtensionSearchSupport, (leftObject.extensionSearchSupport!= null), (rightObject.extensionSearchSupport!= null)));
                    target.setExtensionSearchSupport(mergedExtensionSearchSupport);
                } else {
                    if (extensionSearchSupportShouldBeMergedAndSet == Boolean.FALSE) {
                        target.extensionSearchSupport = null;
                    }
                }
            }
            {
                Boolean optionalProtocolsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.optionalProtocols!= null)&&(!leftObject.optionalProtocols.isEmpty())), ((rightObject.optionalProtocols!= null)&&(!rightObject.optionalProtocols.isEmpty())));
                if (optionalProtocolsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<OptionalProtocol> lhsOptionalProtocols;
                    lhsOptionalProtocols = (((leftObject.optionalProtocols!= null)&&(!leftObject.optionalProtocols.isEmpty()))?leftObject.getOptionalProtocols():null);
                    List<OptionalProtocol> rhsOptionalProtocols;
                    rhsOptionalProtocols = (((rightObject.optionalProtocols!= null)&&(!rightObject.optionalProtocols.isEmpty()))?rightObject.getOptionalProtocols():null);
                    List<OptionalProtocol> mergedOptionalProtocols = ((List<OptionalProtocol> ) strategy.merge(LocatorUtils.property(leftLocator, "optionalProtocols", lhsOptionalProtocols), LocatorUtils.property(rightLocator, "optionalProtocols", rhsOptionalProtocols), lhsOptionalProtocols, rhsOptionalProtocols, ((leftObject.optionalProtocols!= null)&&(!leftObject.optionalProtocols.isEmpty())), ((rightObject.optionalProtocols!= null)&&(!rightObject.optionalProtocols.isEmpty()))));
                    target.optionalProtocols = null;
                    if (mergedOptionalProtocols!= null) {
                        List<OptionalProtocol> uniqueOptionalProtocolsl = target.getOptionalProtocols();
                        uniqueOptionalProtocolsl.addAll(mergedOptionalProtocols);
                    }
                } else {
                    if (optionalProtocolsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.optionalProtocols = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new Search();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Search clone() {
        final Search _newObject;
        _newObject = ((Search) super.clone());
        _newObject.optionalProtocols = ((this.optionalProtocols == null)?null:new ArrayList<>(this.optionalProtocols));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Search createCopy() {
        final Search _newObject = ((Search) super.createCopy());
        _newObject.maxRecords = this.maxRecords;
        _newObject.extensionSearchSupport = this.extensionSearchSupport;
        _newObject.optionalProtocols = ((this.optionalProtocols == null)?null:new ArrayList<>(this.optionalProtocols));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Search createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Search _newObject = ((Search) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree maxRecordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxRecords"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxRecordsPropertyTree!= null):((maxRecordsPropertyTree == null)||(!maxRecordsPropertyTree.isLeaf())))) {
            _newObject.maxRecords = this.maxRecords;
        }
        final PropertyTree extensionSearchSupportPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("extensionSearchSupport"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(extensionSearchSupportPropertyTree!= null):((extensionSearchSupportPropertyTree == null)||(!extensionSearchSupportPropertyTree.isLeaf())))) {
            _newObject.extensionSearchSupport = this.extensionSearchSupport;
        }
        final PropertyTree optionalProtocolsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("optionalProtocols"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(optionalProtocolsPropertyTree!= null):((optionalProtocolsPropertyTree == null)||(!optionalProtocolsPropertyTree.isLeaf())))) {
            _newObject.optionalProtocols = ((this.optionalProtocols == null)?null:new ArrayList<>(this.optionalProtocols));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Search copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Search copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Search.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Search.Modifier();
        }
        return ((Search.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final Search.Builder<_B> _other) {
        super.copyTo(_other);
        _other.maxRecords = this.maxRecords;
        _other.extensionSearchSupport = this.extensionSearchSupport;
        if (this.optionalProtocols == null) {
            _other.optionalProtocols = null;
        } else {
            _other.optionalProtocols = new ArrayList<>();
            for (OptionalProtocol _item: this.optionalProtocols) {
                _other.optionalProtocols.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >Search.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Search.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Search.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Search.Builder<Void> builder() {
        return new Search.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Search.Builder<_B> copyOf(final Capability _other) {
        final Search.Builder<_B> _newBuilder = new Search.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Search.Builder<_B> copyOf(final RegCapRestriction _other) {
        final Search.Builder<_B> _newBuilder = new Search.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Search.Builder<_B> copyOf(final Search _other) {
        final Search.Builder<_B> _newBuilder = new Search.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final Search.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree maxRecordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxRecords"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxRecordsPropertyTree!= null):((maxRecordsPropertyTree == null)||(!maxRecordsPropertyTree.isLeaf())))) {
            _other.maxRecords = this.maxRecords;
        }
        final PropertyTree extensionSearchSupportPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("extensionSearchSupport"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(extensionSearchSupportPropertyTree!= null):((extensionSearchSupportPropertyTree == null)||(!extensionSearchSupportPropertyTree.isLeaf())))) {
            _other.extensionSearchSupport = this.extensionSearchSupport;
        }
        final PropertyTree optionalProtocolsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("optionalProtocols"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(optionalProtocolsPropertyTree!= null):((optionalProtocolsPropertyTree == null)||(!optionalProtocolsPropertyTree.isLeaf())))) {
            if (this.optionalProtocols == null) {
                _other.optionalProtocols = null;
            } else {
                _other.optionalProtocols = new ArrayList<>();
                for (OptionalProtocol _item: this.optionalProtocols) {
                    _other.optionalProtocols.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >Search.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Search.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Search.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Search.Builder<_B> copyOf(final Capability _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Search.Builder<_B> _newBuilder = new Search.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Search.Builder<_B> copyOf(final RegCapRestriction _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Search.Builder<_B> _newBuilder = new Search.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Search.Builder<_B> copyOf(final Search _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Search.Builder<_B> _newBuilder = new Search.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Search.Builder<Void> copyExcept(final Capability _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Search.Builder<Void> copyExcept(final RegCapRestriction _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Search.Builder<Void> copyExcept(final Search _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Search.Builder<Void> copyOnly(final Capability _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Search.Builder<Void> copyOnly(final RegCapRestriction _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Search.Builder<Void> copyOnly(final Search _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Search visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty<>(Search.PropInfo.MAX_RECORDS, this));
        _visitor_.visit(new SingleProperty<>(Search.PropInfo.EXTENSION_SEARCH_SUPPORT, this));
        _visitor_.visit(new CollectionProperty<>(Search.PropInfo.OPTIONAL_PROTOCOLS, this));
        return this;
    }

    public static class Builder<_B >
        extends RegCapRestriction.Builder<_B>
        implements Buildable
    {

        private int maxRecords;
        private ExtensionSearchSupport extensionSearchSupport;
        private List<Buildable> optionalProtocols;

        public Builder(final _B _parentBuilder, final Search _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.maxRecords = _other.maxRecords;
                this.extensionSearchSupport = _other.extensionSearchSupport;
                if (_other.optionalProtocols == null) {
                    this.optionalProtocols = null;
                } else {
                    this.optionalProtocols = new ArrayList<>();
                    for (OptionalProtocol _item: _other.optionalProtocols) {
                        this.optionalProtocols.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                    }
                }
            }
        }

        public Builder(final _B _parentBuilder, final Search _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree maxRecordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxRecords"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxRecordsPropertyTree!= null):((maxRecordsPropertyTree == null)||(!maxRecordsPropertyTree.isLeaf())))) {
                    this.maxRecords = _other.maxRecords;
                }
                final PropertyTree extensionSearchSupportPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("extensionSearchSupport"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(extensionSearchSupportPropertyTree!= null):((extensionSearchSupportPropertyTree == null)||(!extensionSearchSupportPropertyTree.isLeaf())))) {
                    this.extensionSearchSupport = _other.extensionSearchSupport;
                }
                final PropertyTree optionalProtocolsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("optionalProtocols"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(optionalProtocolsPropertyTree!= null):((optionalProtocolsPropertyTree == null)||(!optionalProtocolsPropertyTree.isLeaf())))) {
                    if (_other.optionalProtocols == null) {
                        this.optionalProtocols = null;
                    } else {
                        this.optionalProtocols = new ArrayList<>();
                        for (OptionalProtocol _item: _other.optionalProtocols) {
                            this.optionalProtocols.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                }
            }
        }

        protected<_P extends Search >_P init(final _P _product) {
            _product.maxRecords = this.maxRecords;
            _product.extensionSearchSupport = this.extensionSearchSupport;
            if (this.optionalProtocols!= null) {
                final List<OptionalProtocol> optionalProtocols = new ArrayList<>(this.optionalProtocols.size());
                for (Buildable _item: this.optionalProtocols) {
                    optionalProtocols.add(((OptionalProtocol) _item.build()));
                }
                _product.optionalProtocols = optionalProtocols;
            }
            return super.init(_product);
        }

        /**
         * Sets the new value of "maxRecords" (any previous value will be replaced)
         * 
         * @param maxRecords
         *     New value of the "maxRecords" property.
         */
        public Search.Builder<_B> withMaxRecords(final int maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        /**
         * Sets the new value of "extensionSearchSupport" (any previous value will be
         * replaced)
         * 
         * @param extensionSearchSupport
         *     New value of the "extensionSearchSupport" property.
         */
        public Search.Builder<_B> withExtensionSearchSupport(final ExtensionSearchSupport extensionSearchSupport) {
            this.extensionSearchSupport = extensionSearchSupport;
            return this;
        }

        /**
         * Adds the given items to the value of "optionalProtocols"
         * 
         * @param optionalProtocols
         *     Items to add to the value of the "optionalProtocols" property
         */
        public Search.Builder<_B> addOptionalProtocols(final Iterable<? extends OptionalProtocol> optionalProtocols) {
            if (optionalProtocols!= null) {
                if (this.optionalProtocols == null) {
                    this.optionalProtocols = new ArrayList<>();
                }
                for (OptionalProtocol _item: optionalProtocols) {
                    this.optionalProtocols.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "optionalProtocols" (any previous value will be replaced)
         * 
         * @param optionalProtocols
         *     New value of the "optionalProtocols" property.
         */
        public Search.Builder<_B> withOptionalProtocols(final Iterable<? extends OptionalProtocol> optionalProtocols) {
            if (this.optionalProtocols!= null) {
                this.optionalProtocols.clear();
            }
            return addOptionalProtocols(optionalProtocols);
        }

        /**
         * Adds the given items to the value of "optionalProtocols"
         * 
         * @param optionalProtocols
         *     Items to add to the value of the "optionalProtocols" property
         */
        public Search.Builder<_B> addOptionalProtocols(OptionalProtocol... optionalProtocols) {
            addOptionalProtocols(Arrays.asList(optionalProtocols));
            return this;
        }

        /**
         * Sets the new value of "optionalProtocols" (any previous value will be replaced)
         * 
         * @param optionalProtocols
         *     New value of the "optionalProtocols" property.
         */
        public Search.Builder<_B> withOptionalProtocols(OptionalProtocol... optionalProtocols) {
            withOptionalProtocols(Arrays.asList(optionalProtocols));
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public Search.Builder<_B> addValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public Search.Builder<_B> addValidationLevels(Validation... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public Search.Builder<_B> withValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public Search.Builder<_B> withValidationLevels(Validation... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "description" (any previous value will be replaced)
         * 
         * @param description
         *     New value of the "description" property.
         */
        @Override
        public Search.Builder<_B> withDescription(final String description) {
            super.withDescription(description);
            return this;
        }

        /**
         * Adds the given items to the value of "interfaces"
         * 
         * @param interfaces
         *     Items to add to the value of the "interfaces" property
         */
        @Override
        public Search.Builder<_B> addInterfaces(final Iterable<? extends ServiceInterface> interfaces) {
            super.addInterfaces(interfaces);
            return this;
        }

        /**
         * Adds the given items to the value of "interfaces"
         * 
         * @param interfaces
         *     Items to add to the value of the "interfaces" property
         */
        @Override
        public Search.Builder<_B> addInterfaces(ServiceInterface... interfaces) {
            super.addInterfaces(interfaces);
            return this;
        }

        /**
         * Sets the new value of "interfaces" (any previous value will be replaced)
         * 
         * @param interfaces
         *     New value of the "interfaces" property.
         */
        @Override
        public Search.Builder<_B> withInterfaces(final Iterable<? extends ServiceInterface> interfaces) {
            super.withInterfaces(interfaces);
            return this;
        }

        /**
         * Sets the new value of "interfaces" (any previous value will be replaced)
         * 
         * @param interfaces
         *     New value of the "interfaces" property.
         */
        @Override
        public Search.Builder<_B> withInterfaces(ServiceInterface... interfaces) {
            super.withInterfaces(interfaces);
            return this;
        }

        /**
         * Sets the new value of "standardID" (any previous value will be replaced)
         * 
         * @param standardID
         *     New value of the "standardID" property.
         */
        @Override
        public Search.Builder<_B> withStandardID(final String standardID) {
            super.withStandardID(standardID);
            return this;
        }

        @Override
        public Search build() {
            if (_storedValue == null) {
                return this.init(new Search());
            } else {
                return ((Search) _storedValue);
            }
        }

        public Search.Builder<_B> copyOf(final Search _other) {
            _other.copyTo(this);
            return this;
        }

        public Search.Builder<_B> copyOf(final Search.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends RegCapRestriction.Modifier
    {


        public void setMaxRecords(final int maxRecords) {
            Search.this.setMaxRecords(maxRecords);
        }

        public void setExtensionSearchSupport(final ExtensionSearchSupport extensionSearchSupport) {
            Search.this.setExtensionSearchSupport(extensionSearchSupport);
        }

        public List<OptionalProtocol> getOptionalProtocols() {
            if (Search.this.optionalProtocols == null) {
                Search.this.optionalProtocols = new ArrayList<>();
            }
            return Search.this.optionalProtocols;
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<Search, Integer> MAX_RECORDS = new SinglePropertyInfo<Search,Integer>("maxRecords", Search.class, Integer.class, false, null, new QName("", "maxRecords"), new QName("http://www.w3.org/2001/XMLSchema", "int"), false) {


            @Override
            public Integer get(final Search _instance_) {
                return ((_instance_ == null)?null:_instance_.maxRecords);
            }

            @Override
            public void set(final Search _instance_, final Integer _value_) {
                if (_instance_!= null) {
                    _instance_.maxRecords = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Search, ExtensionSearchSupport> EXTENSION_SEARCH_SUPPORT = new SinglePropertyInfo<Search,ExtensionSearchSupport>("extensionSearchSupport", Search.class, ExtensionSearchSupport.class, false, null, new QName("", "extensionSearchSupport"), new QName("http://www.ivoa.net/xml/VORegistry/v1.0", "ExtensionSearchSupport"), false) {


            @Override
            public ExtensionSearchSupport get(final Search _instance_) {
                return ((_instance_ == null)?null:_instance_.extensionSearchSupport);
            }

            @Override
            public void set(final Search _instance_, final ExtensionSearchSupport _value_) {
                if (_instance_!= null) {
                    _instance_.extensionSearchSupport = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Search, OptionalProtocol> OPTIONAL_PROTOCOLS = new CollectionPropertyInfo<Search,OptionalProtocol>("optionalProtocols", Search.class, OptionalProtocol.class, true, null, new QName("", "optionalProtocol"), new QName("http://www.ivoa.net/xml/VORegistry/v1.0", "OptionalProtocol"), false) {


            @Override
            public List<OptionalProtocol> get(final Search _instance_) {
                return ((_instance_ == null)?null:_instance_.optionalProtocols);
            }

            @Override
            public void set(final Search _instance_, final List<OptionalProtocol> _value_) {
                if (_instance_!= null) {
                    _instance_.optionalProtocols = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Search.Selector<Search.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Search.Select _root() {
            return new Search.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends RegCapRestriction.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, Search.Selector<TRoot, TParent>> extensionSearchSupport = null;
        private com.kscs.util.jaxb.Selector<TRoot, Search.Selector<TRoot, TParent>> optionalProtocols = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.extensionSearchSupport!= null) {
                products.put("extensionSearchSupport", this.extensionSearchSupport.init());
            }
            if (this.optionalProtocols!= null) {
                products.put("optionalProtocols", this.optionalProtocols.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Search.Selector<TRoot, TParent>> extensionSearchSupport() {
            return ((this.extensionSearchSupport == null)?this.extensionSearchSupport = new com.kscs.util.jaxb.Selector<>(this._root, this, "extensionSearchSupport"):this.extensionSearchSupport);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Search.Selector<TRoot, TParent>> optionalProtocols() {
            return ((this.optionalProtocols == null)?this.optionalProtocols = new com.kscs.util.jaxb.Selector<>(this._root, this, "optionalProtocols"):this.optionalProtocols);
        }

    }

}
