
package org.javastro.ivoa.entities.resource.registry.oaipmh;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A header has a unique identifier, a datestamp,
 *         and setSpec(s) in case the item from which
 *         the record is disseminated belongs to set(s).
 *         the header can carry a deleted status indicating
 *         that the record is deleted.
 * 
 * <p>Java class for headerType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="headerType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="identifier" type="{http://www.openarchives.org/OAI/2.0/}identifierType"/>
 *         <element name="datestamp" type="{http://www.openarchives.org/OAI/2.0/}UTCdatetimeType"/>
 *         <element name="setSpec" type="{http://www.openarchives.org/OAI/2.0/}setSpecType" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="status" type="{http://www.openarchives.org/OAI/2.0/}statusType" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "headerType", propOrder = {
    "identifier",
    "datestamp",
    "setSpecs"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class HeaderType implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlElement(required = true)
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String identifier;
    @XmlElement(required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String datestamp;
    @XmlElement(name = "setSpec")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<String> setSpecs;
    @XmlAttribute(name = "status")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected StatusType status;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected transient HeaderType.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public HeaderType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public HeaderType(final String identifier, final String datestamp, final List<String> setSpecs, final StatusType status) {
        this.identifier = identifier;
        this.datestamp = datestamp;
        this.setSpecs = setSpecs;
        this.status = status;
    }

    /**
     * Gets the value of the identifier property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getIdentifier() {
        return identifier;
    }

    /**
     * Sets the value of the identifier property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setIdentifier(String value) {
        this.identifier = value;
    }

    /**
     * Gets the value of the datestamp property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getDatestamp() {
        return datestamp;
    }

    /**
     * Sets the value of the datestamp property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setDatestamp(String value) {
        this.datestamp = value;
    }

    /**
     * Gets the value of the setSpecs property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the setSpecs property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSetSpecs().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * </p>
     * 
     * 
     * @return
     *     The value of the setSpecs property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<String> getSetSpecs() {
        if (setSpecs == null) {
            setSpecs = new ArrayList<>();
        }
        return this.setSpecs;
    }

    /**
     * Gets the value of the status property.
     * 
     * @return
     *     possible object is
     *     {@link StatusType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StatusType getStatus() {
        return status;
    }

    /**
     * Sets the value of the status property.
     * 
     * @param value
     *     allowed object is
     *     {@link StatusType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setStatus(StatusType value) {
        this.status = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final HeaderType that = ((HeaderType) object);
        {
            String leftIdentifier;
            leftIdentifier = this.getIdentifier();
            String rightIdentifier;
            rightIdentifier = that.getIdentifier();
            if (this.identifier!= null) {
                if (that.identifier!= null) {
                    if (!leftIdentifier.equals(rightIdentifier)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.identifier!= null) {
                    return false;
                }
            }
        }
        {
            String leftDatestamp;
            leftDatestamp = this.getDatestamp();
            String rightDatestamp;
            rightDatestamp = that.getDatestamp();
            if (this.datestamp!= null) {
                if (that.datestamp!= null) {
                    if (!leftDatestamp.equals(rightDatestamp)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.datestamp!= null) {
                    return false;
                }
            }
        }
        {
            List<String> leftSetSpecs;
            leftSetSpecs = (((this.setSpecs!= null)&&(!this.setSpecs.isEmpty()))?this.getSetSpecs():null);
            List<String> rightSetSpecs;
            rightSetSpecs = (((that.setSpecs!= null)&&(!that.setSpecs.isEmpty()))?that.getSetSpecs():null);
            if ((this.setSpecs!= null)&&(!this.setSpecs.isEmpty())) {
                if ((that.setSpecs!= null)&&(!that.setSpecs.isEmpty())) {
                    if (!leftSetSpecs.equals(rightSetSpecs)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.setSpecs!= null)&&(!that.setSpecs.isEmpty())) {
                    return false;
                }
            }
        }
        {
            StatusType leftStatus;
            leftStatus = this.getStatus();
            StatusType rightStatus;
            rightStatus = that.getStatus();
            if (this.status!= null) {
                if (that.status!= null) {
                    if (!leftStatus.equals(rightStatus)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.status!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theIdentifier;
            theIdentifier = this.getIdentifier();
            if (this.identifier!= null) {
                currentHashCode += theIdentifier.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theDatestamp;
            theDatestamp = this.getDatestamp();
            if (this.datestamp!= null) {
                currentHashCode += theDatestamp.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theSetSpecs;
            theSetSpecs = (((this.setSpecs!= null)&&(!this.setSpecs.isEmpty()))?this.getSetSpecs():null);
            if ((this.setSpecs!= null)&&(!this.setSpecs.isEmpty())) {
                currentHashCode += theSetSpecs.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            StatusType theStatus;
            theStatus = this.getStatus();
            if (this.status!= null) {
                currentHashCode += theStatus.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theIdentifier;
            theIdentifier = this.getIdentifier();
            strategy.appendField(locator, this, "identifier", buffer, theIdentifier, (this.identifier!= null));
        }
        {
            String theDatestamp;
            theDatestamp = this.getDatestamp();
            strategy.appendField(locator, this, "datestamp", buffer, theDatestamp, (this.datestamp!= null));
        }
        {
            List<String> theSetSpecs;
            theSetSpecs = (((this.setSpecs!= null)&&(!this.setSpecs.isEmpty()))?this.getSetSpecs():null);
            strategy.appendField(locator, this, "setSpecs", buffer, theSetSpecs, ((this.setSpecs!= null)&&(!this.setSpecs.isEmpty())));
        }
        {
            StatusType theStatus;
            theStatus = this.getStatus();
            strategy.appendField(locator, this, "status", buffer, theStatus, (this.status!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof HeaderType) {
            final HeaderType target = this;
            final HeaderType leftObject = ((HeaderType) left);
            final HeaderType rightObject = ((HeaderType) right);
            {
                Boolean identifierShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.identifier!= null), (rightObject.identifier!= null));
                if (identifierShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsIdentifier;
                    lhsIdentifier = leftObject.getIdentifier();
                    String rhsIdentifier;
                    rhsIdentifier = rightObject.getIdentifier();
                    String mergedIdentifier = ((String) strategy.merge(LocatorUtils.property(leftLocator, "identifier", lhsIdentifier), LocatorUtils.property(rightLocator, "identifier", rhsIdentifier), lhsIdentifier, rhsIdentifier, (leftObject.identifier!= null), (rightObject.identifier!= null)));
                    target.setIdentifier(mergedIdentifier);
                } else {
                    if (identifierShouldBeMergedAndSet == Boolean.FALSE) {
                        target.identifier = null;
                    }
                }
            }
            {
                Boolean datestampShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.datestamp!= null), (rightObject.datestamp!= null));
                if (datestampShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsDatestamp;
                    lhsDatestamp = leftObject.getDatestamp();
                    String rhsDatestamp;
                    rhsDatestamp = rightObject.getDatestamp();
                    String mergedDatestamp = ((String) strategy.merge(LocatorUtils.property(leftLocator, "datestamp", lhsDatestamp), LocatorUtils.property(rightLocator, "datestamp", rhsDatestamp), lhsDatestamp, rhsDatestamp, (leftObject.datestamp!= null), (rightObject.datestamp!= null)));
                    target.setDatestamp(mergedDatestamp);
                } else {
                    if (datestampShouldBeMergedAndSet == Boolean.FALSE) {
                        target.datestamp = null;
                    }
                }
            }
            {
                Boolean setSpecsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.setSpecs!= null)&&(!leftObject.setSpecs.isEmpty())), ((rightObject.setSpecs!= null)&&(!rightObject.setSpecs.isEmpty())));
                if (setSpecsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<String> lhsSetSpecs;
                    lhsSetSpecs = (((leftObject.setSpecs!= null)&&(!leftObject.setSpecs.isEmpty()))?leftObject.getSetSpecs():null);
                    List<String> rhsSetSpecs;
                    rhsSetSpecs = (((rightObject.setSpecs!= null)&&(!rightObject.setSpecs.isEmpty()))?rightObject.getSetSpecs():null);
                    List<String> mergedSetSpecs = ((List<String> ) strategy.merge(LocatorUtils.property(leftLocator, "setSpecs", lhsSetSpecs), LocatorUtils.property(rightLocator, "setSpecs", rhsSetSpecs), lhsSetSpecs, rhsSetSpecs, ((leftObject.setSpecs!= null)&&(!leftObject.setSpecs.isEmpty())), ((rightObject.setSpecs!= null)&&(!rightObject.setSpecs.isEmpty()))));
                    target.setSpecs = null;
                    if (mergedSetSpecs!= null) {
                        List<String> uniqueSetSpecsl = target.getSetSpecs();
                        uniqueSetSpecsl.addAll(mergedSetSpecs);
                    }
                } else {
                    if (setSpecsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.setSpecs = null;
                    }
                }
            }
            {
                Boolean statusShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.status!= null), (rightObject.status!= null));
                if (statusShouldBeMergedAndSet == Boolean.TRUE) {
                    StatusType lhsStatus;
                    lhsStatus = leftObject.getStatus();
                    StatusType rhsStatus;
                    rhsStatus = rightObject.getStatus();
                    StatusType mergedStatus = ((StatusType) strategy.merge(LocatorUtils.property(leftLocator, "status", lhsStatus), LocatorUtils.property(rightLocator, "status", rhsStatus), lhsStatus, rhsStatus, (leftObject.status!= null), (rightObject.status!= null)));
                    target.setStatus(mergedStatus);
                } else {
                    if (statusShouldBeMergedAndSet == Boolean.FALSE) {
                        target.status = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new HeaderType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HeaderType clone() {
        final HeaderType _newObject;
        try {
            _newObject = ((HeaderType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.setSpecs = ((this.setSpecs == null)?null:new ArrayList<>(this.setSpecs));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HeaderType createCopy() {
        final HeaderType _newObject;
        try {
            _newObject = ((HeaderType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.identifier = this.identifier;
        _newObject.datestamp = this.datestamp;
        _newObject.setSpecs = ((this.setSpecs == null)?null:new ArrayList<>(this.setSpecs));
        _newObject.status = this.status;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HeaderType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final HeaderType _newObject;
        try {
            _newObject = ((HeaderType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree identifierPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("identifier"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(identifierPropertyTree!= null):((identifierPropertyTree == null)||(!identifierPropertyTree.isLeaf())))) {
            _newObject.identifier = this.identifier;
        }
        final PropertyTree datestampPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("datestamp"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(datestampPropertyTree!= null):((datestampPropertyTree == null)||(!datestampPropertyTree.isLeaf())))) {
            _newObject.datestamp = this.datestamp;
        }
        final PropertyTree setSpecsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("setSpecs"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(setSpecsPropertyTree!= null):((setSpecsPropertyTree == null)||(!setSpecsPropertyTree.isLeaf())))) {
            _newObject.setSpecs = ((this.setSpecs == null)?null:new ArrayList<>(this.setSpecs));
        }
        final PropertyTree statusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("status"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(statusPropertyTree!= null):((statusPropertyTree == null)||(!statusPropertyTree.isLeaf())))) {
            _newObject.status = this.status;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HeaderType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HeaderType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HeaderType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new HeaderType.Modifier();
        }
        return ((HeaderType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final HeaderType.Builder<_B> _other) {
        _other.identifier = this.identifier;
        _other.datestamp = this.datestamp;
        if (this.setSpecs == null) {
            _other.setSpecs = null;
        } else {
            _other.setSpecs = new ArrayList<>();
            for (String _item: this.setSpecs) {
                _other.setSpecs.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
        _other.status = this.status;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >HeaderType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new HeaderType.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HeaderType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static HeaderType.Builder<Void> builder() {
        return new HeaderType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >HeaderType.Builder<_B> copyOf(final HeaderType _other) {
        final HeaderType.Builder<_B> _newBuilder = new HeaderType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final HeaderType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree identifierPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("identifier"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(identifierPropertyTree!= null):((identifierPropertyTree == null)||(!identifierPropertyTree.isLeaf())))) {
            _other.identifier = this.identifier;
        }
        final PropertyTree datestampPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("datestamp"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(datestampPropertyTree!= null):((datestampPropertyTree == null)||(!datestampPropertyTree.isLeaf())))) {
            _other.datestamp = this.datestamp;
        }
        final PropertyTree setSpecsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("setSpecs"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(setSpecsPropertyTree!= null):((setSpecsPropertyTree == null)||(!setSpecsPropertyTree.isLeaf())))) {
            if (this.setSpecs == null) {
                _other.setSpecs = null;
            } else {
                _other.setSpecs = new ArrayList<>();
                for (String _item: this.setSpecs) {
                    _other.setSpecs.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
        final PropertyTree statusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("status"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(statusPropertyTree!= null):((statusPropertyTree == null)||(!statusPropertyTree.isLeaf())))) {
            _other.status = this.status;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >HeaderType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new HeaderType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HeaderType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >HeaderType.Builder<_B> copyOf(final HeaderType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final HeaderType.Builder<_B> _newBuilder = new HeaderType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static HeaderType.Builder<Void> copyExcept(final HeaderType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static HeaderType.Builder<Void> copyOnly(final HeaderType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public HeaderType visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(HeaderType.PropInfo.IDENTIFIER, this));
        _visitor_.visit(new SingleProperty<>(HeaderType.PropInfo.DATESTAMP, this));
        _visitor_.visit(new CollectionProperty<>(HeaderType.PropInfo.SET_SPECS, this));
        _visitor_.visit(new SingleProperty<>(HeaderType.PropInfo.STATUS, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final HeaderType _storedValue;
        private String identifier;
        private String datestamp;
        private List<Buildable> setSpecs;
        private StatusType status;

        public Builder(final _B _parentBuilder, final HeaderType _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.identifier = _other.identifier;
                    this.datestamp = _other.datestamp;
                    if (_other.setSpecs == null) {
                        this.setSpecs = null;
                    } else {
                        this.setSpecs = new ArrayList<>();
                        for (String _item: _other.setSpecs) {
                            this.setSpecs.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                    this.status = _other.status;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final HeaderType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree identifierPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("identifier"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(identifierPropertyTree!= null):((identifierPropertyTree == null)||(!identifierPropertyTree.isLeaf())))) {
                        this.identifier = _other.identifier;
                    }
                    final PropertyTree datestampPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("datestamp"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(datestampPropertyTree!= null):((datestampPropertyTree == null)||(!datestampPropertyTree.isLeaf())))) {
                        this.datestamp = _other.datestamp;
                    }
                    final PropertyTree setSpecsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("setSpecs"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(setSpecsPropertyTree!= null):((setSpecsPropertyTree == null)||(!setSpecsPropertyTree.isLeaf())))) {
                        if (_other.setSpecs == null) {
                            this.setSpecs = null;
                        } else {
                            this.setSpecs = new ArrayList<>();
                            for (String _item: _other.setSpecs) {
                                this.setSpecs.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                            }
                        }
                    }
                    final PropertyTree statusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("status"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(statusPropertyTree!= null):((statusPropertyTree == null)||(!statusPropertyTree.isLeaf())))) {
                        this.status = _other.status;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends HeaderType >_P init(final _P _product) {
            _product.identifier = this.identifier;
            _product.datestamp = this.datestamp;
            if (this.setSpecs!= null) {
                final List<String> setSpecs = new ArrayList<>(this.setSpecs.size());
                for (Buildable _item: this.setSpecs) {
                    setSpecs.add(((String) _item.build()));
                }
                _product.setSpecs = setSpecs;
            }
            _product.status = this.status;
            return _product;
        }

        /**
         * Sets the new value of "identifier" (any previous value will be replaced)
         * 
         * @param identifier
         *     New value of the "identifier" property.
         */
        public HeaderType.Builder<_B> withIdentifier(final String identifier) {
            this.identifier = identifier;
            return this;
        }

        /**
         * Sets the new value of "datestamp" (any previous value will be replaced)
         * 
         * @param datestamp
         *     New value of the "datestamp" property.
         */
        public HeaderType.Builder<_B> withDatestamp(final String datestamp) {
            this.datestamp = datestamp;
            return this;
        }

        /**
         * Adds the given items to the value of "setSpecs"
         * 
         * @param setSpecs
         *     Items to add to the value of the "setSpecs" property
         */
        public HeaderType.Builder<_B> addSetSpecs(final Iterable<? extends String> setSpecs) {
            if (setSpecs!= null) {
                if (this.setSpecs == null) {
                    this.setSpecs = new ArrayList<>();
                }
                for (String _item: setSpecs) {
                    this.setSpecs.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "setSpecs" (any previous value will be replaced)
         * 
         * @param setSpecs
         *     New value of the "setSpecs" property.
         */
        public HeaderType.Builder<_B> withSetSpecs(final Iterable<? extends String> setSpecs) {
            if (this.setSpecs!= null) {
                this.setSpecs.clear();
            }
            return addSetSpecs(setSpecs);
        }

        /**
         * Adds the given items to the value of "setSpecs"
         * 
         * @param setSpecs
         *     Items to add to the value of the "setSpecs" property
         */
        public HeaderType.Builder<_B> addSetSpecs(String... setSpecs) {
            addSetSpecs(Arrays.asList(setSpecs));
            return this;
        }

        /**
         * Sets the new value of "setSpecs" (any previous value will be replaced)
         * 
         * @param setSpecs
         *     New value of the "setSpecs" property.
         */
        public HeaderType.Builder<_B> withSetSpecs(String... setSpecs) {
            withSetSpecs(Arrays.asList(setSpecs));
            return this;
        }

        /**
         * Sets the new value of "status" (any previous value will be replaced)
         * 
         * @param status
         *     New value of the "status" property.
         */
        public HeaderType.Builder<_B> withStatus(final StatusType status) {
            this.status = status;
            return this;
        }

        @Override
        public HeaderType build() {
            if (_storedValue == null) {
                return this.init(new HeaderType());
            } else {
                return ((HeaderType) _storedValue);
            }
        }

        public HeaderType.Builder<_B> copyOf(final HeaderType _other) {
            _other.copyTo(this);
            return this;
        }

        public HeaderType.Builder<_B> copyOf(final HeaderType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setIdentifier(final String identifier) {
            HeaderType.this.setIdentifier(identifier);
        }

        public void setDatestamp(final String datestamp) {
            HeaderType.this.setDatestamp(datestamp);
        }

        public List<String> getSetSpecs() {
            if (HeaderType.this.setSpecs == null) {
                HeaderType.this.setSpecs = new ArrayList<>();
            }
            return HeaderType.this.setSpecs;
        }

        public void setStatus(final StatusType status) {
            HeaderType.this.setStatus(status);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<HeaderType, String> IDENTIFIER = new SinglePropertyInfo<HeaderType,String>("identifier", HeaderType.class, String.class, false, null, new QName("http://www.openarchives.org/OAI/2.0/", "identifier"), new QName("http://www.openarchives.org/OAI/2.0/", "identifierType"), false) {


            @Override
            public String get(final HeaderType _instance_) {
                return ((_instance_ == null)?null:_instance_.identifier);
            }

            @Override
            public void set(final HeaderType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.identifier = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<HeaderType, String> DATESTAMP = new SinglePropertyInfo<HeaderType,String>("datestamp", HeaderType.class, String.class, false, null, new QName("http://www.openarchives.org/OAI/2.0/", "datestamp"), new QName("http://www.openarchives.org/OAI/2.0/", "UTCdatetimeType"), false) {


            @Override
            public String get(final HeaderType _instance_) {
                return ((_instance_ == null)?null:_instance_.datestamp);
            }

            @Override
            public void set(final HeaderType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.datestamp = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<HeaderType, String> SET_SPECS = new CollectionPropertyInfo<HeaderType,String>("setSpecs", HeaderType.class, String.class, true, null, new QName("http://www.openarchives.org/OAI/2.0/", "setSpec"), new QName("http://www.openarchives.org/OAI/2.0/", "setSpecType"), false) {


            @Override
            public List<String> get(final HeaderType _instance_) {
                return ((_instance_ == null)?null:_instance_.setSpecs);
            }

            @Override
            public void set(final HeaderType _instance_, final List<String> _value_) {
                if (_instance_!= null) {
                    _instance_.setSpecs = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<HeaderType, StatusType> STATUS = new SinglePropertyInfo<HeaderType,StatusType>("status", HeaderType.class, StatusType.class, false, null, new QName("", "status"), new QName("http://www.openarchives.org/OAI/2.0/", "statusType"), true) {


            @Override
            public StatusType get(final HeaderType _instance_) {
                return ((_instance_ == null)?null:_instance_.status);
            }

            @Override
            public void set(final HeaderType _instance_, final StatusType _value_) {
                if (_instance_!= null) {
                    _instance_.status = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends HeaderType.Selector<HeaderType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static HeaderType.Select _root() {
            return new HeaderType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, HeaderType.Selector<TRoot, TParent>> identifier = null;
        private com.kscs.util.jaxb.Selector<TRoot, HeaderType.Selector<TRoot, TParent>> datestamp = null;
        private com.kscs.util.jaxb.Selector<TRoot, HeaderType.Selector<TRoot, TParent>> setSpecs = null;
        private com.kscs.util.jaxb.Selector<TRoot, HeaderType.Selector<TRoot, TParent>> status = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.identifier!= null) {
                products.put("identifier", this.identifier.init());
            }
            if (this.datestamp!= null) {
                products.put("datestamp", this.datestamp.init());
            }
            if (this.setSpecs!= null) {
                products.put("setSpecs", this.setSpecs.init());
            }
            if (this.status!= null) {
                products.put("status", this.status.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, HeaderType.Selector<TRoot, TParent>> identifier() {
            return ((this.identifier == null)?this.identifier = new com.kscs.util.jaxb.Selector<>(this._root, this, "identifier"):this.identifier);
        }

        public com.kscs.util.jaxb.Selector<TRoot, HeaderType.Selector<TRoot, TParent>> datestamp() {
            return ((this.datestamp == null)?this.datestamp = new com.kscs.util.jaxb.Selector<>(this._root, this, "datestamp"):this.datestamp);
        }

        public com.kscs.util.jaxb.Selector<TRoot, HeaderType.Selector<TRoot, TParent>> setSpecs() {
            return ((this.setSpecs == null)?this.setSpecs = new com.kscs.util.jaxb.Selector<>(this._root, this, "setSpecs"):this.setSpecs);
        }

        public com.kscs.util.jaxb.Selector<TRoot, HeaderType.Selector<TRoot, TParent>> status() {
            return ((this.status == null)?this.status = new com.kscs.util.jaxb.Selector<>(this._root, this, "status"):this.status);
        }

    }

}
