
package org.javastro.ivoa.entities.resource.sia;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.javastro.ivoa.entities.resource.Capability;
import org.javastro.ivoa.entities.resource.ServiceInterface;
import org.javastro.ivoa.entities.resource.Validation;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Editor's Notes: 
 *                *  This is a prototype definition to
 *                   illustrate how to extend the schema to a specific 
 *                   standard interface.
 *                *  Staging information is not included yet.
 * 
 * <p>Java class for SimpleImageAccess complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SimpleImageAccess">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/SIA/v1.1}SIACapRestriction">
 *       <sequence>
 *         <element name="imageServiceType" type="{http://www.ivoa.net/xml/SIA/v1.1}ImageServiceType"/>
 *         <element name="maxQueryRegionSize" type="{http://www.ivoa.net/xml/SIA/v1.1}SkySize" minOccurs="0"/>
 *         <element name="maxImageExtent" type="{http://www.ivoa.net/xml/SIA/v1.1}SkySize" minOccurs="0"/>
 *         <element name="maxImageSize" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/>
 *         <element name="maxFileSize" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/>
 *         <element name="maxRecords" type="{http://www.w3.org/2001/XMLSchema}positiveInteger" minOccurs="0"/>
 *         <element name="testQuery" type="{http://www.ivoa.net/xml/SIA/v1.1}Query" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SimpleImageAccess", propOrder = {
    "imageServiceType",
    "maxQueryRegionSize",
    "maxImageExtent",
    "maxImageSize",
    "maxFileSize",
    "maxRecords",
    "testQuery"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class SimpleImageAccess
    extends SIACapRestriction
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The class of image service: Cutout, Mosaic, Atlas, Pointed
     * 
     */
    @XmlElement(required = true)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected ImageServiceType imageServiceType;
    /**
     * Not providing a value is the prefered way to indicate
     *                          that there is no limit.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected SkySize maxQueryRegionSize;
    /**
     * Not providing a value is the prefered way to indicate
     *                          that there is no limit.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected SkySize maxImageExtent;
    /**
     * When a service is more fundementally limited
     *                          by the total number of pixels in the image, this 
     *                          value should be set to the square-root of that
     *                          number.  This number will then represent a
     *                          lower limit on the maximum length of a side.
     * 
     */
    @XmlSchemaType(name = "positiveInteger")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected BigInteger maxImageSize;
    /**
     * This is primarily relevant when the imageServiceType
     *                         is "Cutout" or "Mosaic", indicating the largest 
     *                         files that can be created.  When the imageServiceType 
     *                         is "Atlas" or "Pointed", this should be specified only
     *                         when there are static images in the archive that can 
     *                         be searched for but not returned because they are 
     *                         too big.
     * 
     */
    @XmlSchemaType(name = "positiveInteger")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected BigInteger maxFileSize;
    /**
     * This does not refer to the total number of images in 
     *                         the archive but rather maximum number of records the 
     *                         service is capable of returning.  A limit that is 
     *                         greater than the number of images available in the 
     *                         archive is equivalent to their being no effective 
     *                         limit.  (See RM, Hanisch 2007.)
     * 
     */
    @XmlSchemaType(name = "positiveInteger")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected BigInteger maxRecords;
    /**
     * a set of query parameters that is expected
     *                         to produce at least one matched record which
     *                         can be used to test the service.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected Query testQuery;

    /**
     * Default no-arg constructor
     * 
     */
    public SimpleImageAccess() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public SimpleImageAccess(final List<Validation> validationLevels, final String description, final List<ServiceInterface> interfaces, final String standardID, final ImageServiceType imageServiceType, final SkySize maxQueryRegionSize, final SkySize maxImageExtent, final BigInteger maxImageSize, final BigInteger maxFileSize, final BigInteger maxRecords, final Query testQuery) {
        super(validationLevels, description, interfaces, standardID);
        this.imageServiceType = imageServiceType;
        this.maxQueryRegionSize = maxQueryRegionSize;
        this.maxImageExtent = maxImageExtent;
        this.maxImageSize = maxImageSize;
        this.maxFileSize = maxFileSize;
        this.maxRecords = maxRecords;
        this.testQuery = testQuery;
    }

    /**
     * The class of image service: Cutout, Mosaic, Atlas, Pointed
     * 
     * @return
     *     possible object is
     *     {@link ImageServiceType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public ImageServiceType getImageServiceType() {
        return imageServiceType;
    }

    /**
     * Sets the value of the imageServiceType property.
     * 
     * @param value
     *     allowed object is
     *     {@link ImageServiceType }
     *     
     * @see #getImageServiceType()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setImageServiceType(ImageServiceType value) {
        this.imageServiceType = value;
    }

    /**
     * Not providing a value is the prefered way to indicate
     *                          that there is no limit.
     * 
     * @return
     *     possible object is
     *     {@link SkySize }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SkySize getMaxQueryRegionSize() {
        return maxQueryRegionSize;
    }

    /**
     * Sets the value of the maxQueryRegionSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link SkySize }
     *     
     * @see #getMaxQueryRegionSize()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setMaxQueryRegionSize(SkySize value) {
        this.maxQueryRegionSize = value;
    }

    /**
     * Not providing a value is the prefered way to indicate
     *                          that there is no limit.
     * 
     * @return
     *     possible object is
     *     {@link SkySize }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SkySize getMaxImageExtent() {
        return maxImageExtent;
    }

    /**
     * Sets the value of the maxImageExtent property.
     * 
     * @param value
     *     allowed object is
     *     {@link SkySize }
     *     
     * @see #getMaxImageExtent()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setMaxImageExtent(SkySize value) {
        this.maxImageExtent = value;
    }

    /**
     * When a service is more fundementally limited
     *                          by the total number of pixels in the image, this 
     *                          value should be set to the square-root of that
     *                          number.  This number will then represent a
     *                          lower limit on the maximum length of a side.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public BigInteger getMaxImageSize() {
        return maxImageSize;
    }

    /**
     * Sets the value of the maxImageSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     * @see #getMaxImageSize()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setMaxImageSize(BigInteger value) {
        this.maxImageSize = value;
    }

    /**
     * This is primarily relevant when the imageServiceType
     *                         is "Cutout" or "Mosaic", indicating the largest 
     *                         files that can be created.  When the imageServiceType 
     *                         is "Atlas" or "Pointed", this should be specified only
     *                         when there are static images in the archive that can 
     *                         be searched for but not returned because they are 
     *                         too big.
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public BigInteger getMaxFileSize() {
        return maxFileSize;
    }

    /**
     * Sets the value of the maxFileSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     * @see #getMaxFileSize()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setMaxFileSize(BigInteger value) {
        this.maxFileSize = value;
    }

    /**
     * This does not refer to the total number of images in 
     *                         the archive but rather maximum number of records the 
     *                         service is capable of returning.  A limit that is 
     *                         greater than the number of images available in the 
     *                         archive is equivalent to their being no effective 
     *                         limit.  (See RM, Hanisch 2007.)
     * 
     * @return
     *     possible object is
     *     {@link BigInteger }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public BigInteger getMaxRecords() {
        return maxRecords;
    }

    /**
     * Sets the value of the maxRecords property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigInteger }
     *     
     * @see #getMaxRecords()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setMaxRecords(BigInteger value) {
        this.maxRecords = value;
    }

    /**
     * a set of query parameters that is expected
     *                         to produce at least one matched record which
     *                         can be used to test the service.
     * 
     * @return
     *     possible object is
     *     {@link Query }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Query getTestQuery() {
        return testQuery;
    }

    /**
     * Sets the value of the testQuery property.
     * 
     * @param value
     *     allowed object is
     *     {@link Query }
     *     
     * @see #getTestQuery()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setTestQuery(Query value) {
        this.testQuery = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final SimpleImageAccess that = ((SimpleImageAccess) object);
        {
            ImageServiceType leftImageServiceType;
            leftImageServiceType = this.getImageServiceType();
            ImageServiceType rightImageServiceType;
            rightImageServiceType = that.getImageServiceType();
            if (this.imageServiceType!= null) {
                if (that.imageServiceType!= null) {
                    if (!leftImageServiceType.equals(rightImageServiceType)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.imageServiceType!= null) {
                    return false;
                }
            }
        }
        {
            SkySize leftMaxQueryRegionSize;
            leftMaxQueryRegionSize = this.getMaxQueryRegionSize();
            SkySize rightMaxQueryRegionSize;
            rightMaxQueryRegionSize = that.getMaxQueryRegionSize();
            if (this.maxQueryRegionSize!= null) {
                if (that.maxQueryRegionSize!= null) {
                    if (!leftMaxQueryRegionSize.equals(rightMaxQueryRegionSize)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.maxQueryRegionSize!= null) {
                    return false;
                }
            }
        }
        {
            SkySize leftMaxImageExtent;
            leftMaxImageExtent = this.getMaxImageExtent();
            SkySize rightMaxImageExtent;
            rightMaxImageExtent = that.getMaxImageExtent();
            if (this.maxImageExtent!= null) {
                if (that.maxImageExtent!= null) {
                    if (!leftMaxImageExtent.equals(rightMaxImageExtent)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.maxImageExtent!= null) {
                    return false;
                }
            }
        }
        {
            BigInteger leftMaxImageSize;
            leftMaxImageSize = this.getMaxImageSize();
            BigInteger rightMaxImageSize;
            rightMaxImageSize = that.getMaxImageSize();
            if (this.maxImageSize!= null) {
                if (that.maxImageSize!= null) {
                    if (!leftMaxImageSize.equals(rightMaxImageSize)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.maxImageSize!= null) {
                    return false;
                }
            }
        }
        {
            BigInteger leftMaxFileSize;
            leftMaxFileSize = this.getMaxFileSize();
            BigInteger rightMaxFileSize;
            rightMaxFileSize = that.getMaxFileSize();
            if (this.maxFileSize!= null) {
                if (that.maxFileSize!= null) {
                    if (!leftMaxFileSize.equals(rightMaxFileSize)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.maxFileSize!= null) {
                    return false;
                }
            }
        }
        {
            BigInteger leftMaxRecords;
            leftMaxRecords = this.getMaxRecords();
            BigInteger rightMaxRecords;
            rightMaxRecords = that.getMaxRecords();
            if (this.maxRecords!= null) {
                if (that.maxRecords!= null) {
                    if (!leftMaxRecords.equals(rightMaxRecords)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.maxRecords!= null) {
                    return false;
                }
            }
        }
        {
            Query leftTestQuery;
            leftTestQuery = this.getTestQuery();
            Query rightTestQuery;
            rightTestQuery = that.getTestQuery();
            if (this.testQuery!= null) {
                if (that.testQuery!= null) {
                    if (!leftTestQuery.equals(rightTestQuery)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.testQuery!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            ImageServiceType theImageServiceType;
            theImageServiceType = this.getImageServiceType();
            if (this.imageServiceType!= null) {
                currentHashCode += theImageServiceType.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            SkySize theMaxQueryRegionSize;
            theMaxQueryRegionSize = this.getMaxQueryRegionSize();
            if (this.maxQueryRegionSize!= null) {
                currentHashCode += theMaxQueryRegionSize.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            SkySize theMaxImageExtent;
            theMaxImageExtent = this.getMaxImageExtent();
            if (this.maxImageExtent!= null) {
                currentHashCode += theMaxImageExtent.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theMaxImageSize;
            theMaxImageSize = this.getMaxImageSize();
            if (this.maxImageSize!= null) {
                currentHashCode += theMaxImageSize.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theMaxFileSize;
            theMaxFileSize = this.getMaxFileSize();
            if (this.maxFileSize!= null) {
                currentHashCode += theMaxFileSize.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            BigInteger theMaxRecords;
            theMaxRecords = this.getMaxRecords();
            if (this.maxRecords!= null) {
                currentHashCode += theMaxRecords.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Query theTestQuery;
            theTestQuery = this.getTestQuery();
            if (this.testQuery!= null) {
                currentHashCode += theTestQuery.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            ImageServiceType theImageServiceType;
            theImageServiceType = this.getImageServiceType();
            strategy.appendField(locator, this, "imageServiceType", buffer, theImageServiceType, (this.imageServiceType!= null));
        }
        {
            SkySize theMaxQueryRegionSize;
            theMaxQueryRegionSize = this.getMaxQueryRegionSize();
            strategy.appendField(locator, this, "maxQueryRegionSize", buffer, theMaxQueryRegionSize, (this.maxQueryRegionSize!= null));
        }
        {
            SkySize theMaxImageExtent;
            theMaxImageExtent = this.getMaxImageExtent();
            strategy.appendField(locator, this, "maxImageExtent", buffer, theMaxImageExtent, (this.maxImageExtent!= null));
        }
        {
            BigInteger theMaxImageSize;
            theMaxImageSize = this.getMaxImageSize();
            strategy.appendField(locator, this, "maxImageSize", buffer, theMaxImageSize, (this.maxImageSize!= null));
        }
        {
            BigInteger theMaxFileSize;
            theMaxFileSize = this.getMaxFileSize();
            strategy.appendField(locator, this, "maxFileSize", buffer, theMaxFileSize, (this.maxFileSize!= null));
        }
        {
            BigInteger theMaxRecords;
            theMaxRecords = this.getMaxRecords();
            strategy.appendField(locator, this, "maxRecords", buffer, theMaxRecords, (this.maxRecords!= null));
        }
        {
            Query theTestQuery;
            theTestQuery = this.getTestQuery();
            strategy.appendField(locator, this, "testQuery", buffer, theTestQuery, (this.testQuery!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof SimpleImageAccess) {
            final SimpleImageAccess target = this;
            final SimpleImageAccess leftObject = ((SimpleImageAccess) left);
            final SimpleImageAccess rightObject = ((SimpleImageAccess) right);
            {
                Boolean imageServiceTypeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.imageServiceType!= null), (rightObject.imageServiceType!= null));
                if (imageServiceTypeShouldBeMergedAndSet == Boolean.TRUE) {
                    ImageServiceType lhsImageServiceType;
                    lhsImageServiceType = leftObject.getImageServiceType();
                    ImageServiceType rhsImageServiceType;
                    rhsImageServiceType = rightObject.getImageServiceType();
                    ImageServiceType mergedImageServiceType = ((ImageServiceType) strategy.merge(LocatorUtils.property(leftLocator, "imageServiceType", lhsImageServiceType), LocatorUtils.property(rightLocator, "imageServiceType", rhsImageServiceType), lhsImageServiceType, rhsImageServiceType, (leftObject.imageServiceType!= null), (rightObject.imageServiceType!= null)));
                    target.setImageServiceType(mergedImageServiceType);
                } else {
                    if (imageServiceTypeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.imageServiceType = null;
                    }
                }
            }
            {
                Boolean maxQueryRegionSizeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.maxQueryRegionSize!= null), (rightObject.maxQueryRegionSize!= null));
                if (maxQueryRegionSizeShouldBeMergedAndSet == Boolean.TRUE) {
                    SkySize lhsMaxQueryRegionSize;
                    lhsMaxQueryRegionSize = leftObject.getMaxQueryRegionSize();
                    SkySize rhsMaxQueryRegionSize;
                    rhsMaxQueryRegionSize = rightObject.getMaxQueryRegionSize();
                    SkySize mergedMaxQueryRegionSize = ((SkySize) strategy.merge(LocatorUtils.property(leftLocator, "maxQueryRegionSize", lhsMaxQueryRegionSize), LocatorUtils.property(rightLocator, "maxQueryRegionSize", rhsMaxQueryRegionSize), lhsMaxQueryRegionSize, rhsMaxQueryRegionSize, (leftObject.maxQueryRegionSize!= null), (rightObject.maxQueryRegionSize!= null)));
                    target.setMaxQueryRegionSize(mergedMaxQueryRegionSize);
                } else {
                    if (maxQueryRegionSizeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.maxQueryRegionSize = null;
                    }
                }
            }
            {
                Boolean maxImageExtentShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.maxImageExtent!= null), (rightObject.maxImageExtent!= null));
                if (maxImageExtentShouldBeMergedAndSet == Boolean.TRUE) {
                    SkySize lhsMaxImageExtent;
                    lhsMaxImageExtent = leftObject.getMaxImageExtent();
                    SkySize rhsMaxImageExtent;
                    rhsMaxImageExtent = rightObject.getMaxImageExtent();
                    SkySize mergedMaxImageExtent = ((SkySize) strategy.merge(LocatorUtils.property(leftLocator, "maxImageExtent", lhsMaxImageExtent), LocatorUtils.property(rightLocator, "maxImageExtent", rhsMaxImageExtent), lhsMaxImageExtent, rhsMaxImageExtent, (leftObject.maxImageExtent!= null), (rightObject.maxImageExtent!= null)));
                    target.setMaxImageExtent(mergedMaxImageExtent);
                } else {
                    if (maxImageExtentShouldBeMergedAndSet == Boolean.FALSE) {
                        target.maxImageExtent = null;
                    }
                }
            }
            {
                Boolean maxImageSizeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.maxImageSize!= null), (rightObject.maxImageSize!= null));
                if (maxImageSizeShouldBeMergedAndSet == Boolean.TRUE) {
                    BigInteger lhsMaxImageSize;
                    lhsMaxImageSize = leftObject.getMaxImageSize();
                    BigInteger rhsMaxImageSize;
                    rhsMaxImageSize = rightObject.getMaxImageSize();
                    BigInteger mergedMaxImageSize = ((BigInteger) strategy.merge(LocatorUtils.property(leftLocator, "maxImageSize", lhsMaxImageSize), LocatorUtils.property(rightLocator, "maxImageSize", rhsMaxImageSize), lhsMaxImageSize, rhsMaxImageSize, (leftObject.maxImageSize!= null), (rightObject.maxImageSize!= null)));
                    target.setMaxImageSize(mergedMaxImageSize);
                } else {
                    if (maxImageSizeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.maxImageSize = null;
                    }
                }
            }
            {
                Boolean maxFileSizeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.maxFileSize!= null), (rightObject.maxFileSize!= null));
                if (maxFileSizeShouldBeMergedAndSet == Boolean.TRUE) {
                    BigInteger lhsMaxFileSize;
                    lhsMaxFileSize = leftObject.getMaxFileSize();
                    BigInteger rhsMaxFileSize;
                    rhsMaxFileSize = rightObject.getMaxFileSize();
                    BigInteger mergedMaxFileSize = ((BigInteger) strategy.merge(LocatorUtils.property(leftLocator, "maxFileSize", lhsMaxFileSize), LocatorUtils.property(rightLocator, "maxFileSize", rhsMaxFileSize), lhsMaxFileSize, rhsMaxFileSize, (leftObject.maxFileSize!= null), (rightObject.maxFileSize!= null)));
                    target.setMaxFileSize(mergedMaxFileSize);
                } else {
                    if (maxFileSizeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.maxFileSize = null;
                    }
                }
            }
            {
                Boolean maxRecordsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.maxRecords!= null), (rightObject.maxRecords!= null));
                if (maxRecordsShouldBeMergedAndSet == Boolean.TRUE) {
                    BigInteger lhsMaxRecords;
                    lhsMaxRecords = leftObject.getMaxRecords();
                    BigInteger rhsMaxRecords;
                    rhsMaxRecords = rightObject.getMaxRecords();
                    BigInteger mergedMaxRecords = ((BigInteger) strategy.merge(LocatorUtils.property(leftLocator, "maxRecords", lhsMaxRecords), LocatorUtils.property(rightLocator, "maxRecords", rhsMaxRecords), lhsMaxRecords, rhsMaxRecords, (leftObject.maxRecords!= null), (rightObject.maxRecords!= null)));
                    target.setMaxRecords(mergedMaxRecords);
                } else {
                    if (maxRecordsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.maxRecords = null;
                    }
                }
            }
            {
                Boolean testQueryShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.testQuery!= null), (rightObject.testQuery!= null));
                if (testQueryShouldBeMergedAndSet == Boolean.TRUE) {
                    Query lhsTestQuery;
                    lhsTestQuery = leftObject.getTestQuery();
                    Query rhsTestQuery;
                    rhsTestQuery = rightObject.getTestQuery();
                    Query mergedTestQuery = ((Query) strategy.merge(LocatorUtils.property(leftLocator, "testQuery", lhsTestQuery), LocatorUtils.property(rightLocator, "testQuery", rhsTestQuery), lhsTestQuery, rhsTestQuery, (leftObject.testQuery!= null), (rightObject.testQuery!= null)));
                    target.setTestQuery(mergedTestQuery);
                } else {
                    if (testQueryShouldBeMergedAndSet == Boolean.FALSE) {
                        target.testQuery = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new SimpleImageAccess();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SimpleImageAccess clone() {
        final SimpleImageAccess _newObject;
        _newObject = ((SimpleImageAccess) super.clone());
        _newObject.maxQueryRegionSize = ((this.maxQueryRegionSize == null)?null:this.maxQueryRegionSize.clone());
        _newObject.maxImageExtent = ((this.maxImageExtent == null)?null:this.maxImageExtent.clone());
        _newObject.testQuery = ((this.testQuery == null)?null:this.testQuery.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SimpleImageAccess createCopy() {
        final SimpleImageAccess _newObject = ((SimpleImageAccess) super.createCopy());
        _newObject.imageServiceType = this.imageServiceType;
        _newObject.maxQueryRegionSize = ((this.maxQueryRegionSize == null)?null:this.maxQueryRegionSize.createCopy());
        _newObject.maxImageExtent = ((this.maxImageExtent == null)?null:this.maxImageExtent.createCopy());
        _newObject.maxImageSize = this.maxImageSize;
        _newObject.maxFileSize = this.maxFileSize;
        _newObject.maxRecords = this.maxRecords;
        _newObject.testQuery = ((this.testQuery == null)?null:this.testQuery.createCopy());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SimpleImageAccess createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SimpleImageAccess _newObject = ((SimpleImageAccess) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree imageServiceTypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("imageServiceType"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(imageServiceTypePropertyTree!= null):((imageServiceTypePropertyTree == null)||(!imageServiceTypePropertyTree.isLeaf())))) {
            _newObject.imageServiceType = this.imageServiceType;
        }
        final PropertyTree maxQueryRegionSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxQueryRegionSize"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxQueryRegionSizePropertyTree!= null):((maxQueryRegionSizePropertyTree == null)||(!maxQueryRegionSizePropertyTree.isLeaf())))) {
            _newObject.maxQueryRegionSize = ((this.maxQueryRegionSize == null)?null:this.maxQueryRegionSize.createCopy(maxQueryRegionSizePropertyTree, _propertyTreeUse));
        }
        final PropertyTree maxImageExtentPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxImageExtent"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxImageExtentPropertyTree!= null):((maxImageExtentPropertyTree == null)||(!maxImageExtentPropertyTree.isLeaf())))) {
            _newObject.maxImageExtent = ((this.maxImageExtent == null)?null:this.maxImageExtent.createCopy(maxImageExtentPropertyTree, _propertyTreeUse));
        }
        final PropertyTree maxImageSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxImageSize"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxImageSizePropertyTree!= null):((maxImageSizePropertyTree == null)||(!maxImageSizePropertyTree.isLeaf())))) {
            _newObject.maxImageSize = this.maxImageSize;
        }
        final PropertyTree maxFileSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxFileSize"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxFileSizePropertyTree!= null):((maxFileSizePropertyTree == null)||(!maxFileSizePropertyTree.isLeaf())))) {
            _newObject.maxFileSize = this.maxFileSize;
        }
        final PropertyTree maxRecordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxRecords"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxRecordsPropertyTree!= null):((maxRecordsPropertyTree == null)||(!maxRecordsPropertyTree.isLeaf())))) {
            _newObject.maxRecords = this.maxRecords;
        }
        final PropertyTree testQueryPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("testQuery"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(testQueryPropertyTree!= null):((testQueryPropertyTree == null)||(!testQueryPropertyTree.isLeaf())))) {
            _newObject.testQuery = ((this.testQuery == null)?null:this.testQuery.createCopy(testQueryPropertyTree, _propertyTreeUse));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SimpleImageAccess copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SimpleImageAccess copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SimpleImageAccess.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new SimpleImageAccess.Modifier();
        }
        return ((SimpleImageAccess.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final SimpleImageAccess.Builder<_B> _other) {
        super.copyTo(_other);
        _other.imageServiceType = this.imageServiceType;
        _other.maxQueryRegionSize = ((this.maxQueryRegionSize == null)?null:this.maxQueryRegionSize.newCopyBuilder(_other));
        _other.maxImageExtent = ((this.maxImageExtent == null)?null:this.maxImageExtent.newCopyBuilder(_other));
        _other.maxImageSize = this.maxImageSize;
        _other.maxFileSize = this.maxFileSize;
        _other.maxRecords = this.maxRecords;
        _other.testQuery = ((this.testQuery == null)?null:this.testQuery.newCopyBuilder(_other));
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >SimpleImageAccess.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new SimpleImageAccess.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SimpleImageAccess.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SimpleImageAccess.Builder<Void> builder() {
        return new SimpleImageAccess.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >SimpleImageAccess.Builder<_B> copyOf(final Capability _other) {
        final SimpleImageAccess.Builder<_B> _newBuilder = new SimpleImageAccess.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >SimpleImageAccess.Builder<_B> copyOf(final SIACapRestriction _other) {
        final SimpleImageAccess.Builder<_B> _newBuilder = new SimpleImageAccess.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >SimpleImageAccess.Builder<_B> copyOf(final SimpleImageAccess _other) {
        final SimpleImageAccess.Builder<_B> _newBuilder = new SimpleImageAccess.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final SimpleImageAccess.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree imageServiceTypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("imageServiceType"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(imageServiceTypePropertyTree!= null):((imageServiceTypePropertyTree == null)||(!imageServiceTypePropertyTree.isLeaf())))) {
            _other.imageServiceType = this.imageServiceType;
        }
        final PropertyTree maxQueryRegionSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxQueryRegionSize"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxQueryRegionSizePropertyTree!= null):((maxQueryRegionSizePropertyTree == null)||(!maxQueryRegionSizePropertyTree.isLeaf())))) {
            _other.maxQueryRegionSize = ((this.maxQueryRegionSize == null)?null:this.maxQueryRegionSize.newCopyBuilder(_other, maxQueryRegionSizePropertyTree, _propertyTreeUse));
        }
        final PropertyTree maxImageExtentPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxImageExtent"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxImageExtentPropertyTree!= null):((maxImageExtentPropertyTree == null)||(!maxImageExtentPropertyTree.isLeaf())))) {
            _other.maxImageExtent = ((this.maxImageExtent == null)?null:this.maxImageExtent.newCopyBuilder(_other, maxImageExtentPropertyTree, _propertyTreeUse));
        }
        final PropertyTree maxImageSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxImageSize"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxImageSizePropertyTree!= null):((maxImageSizePropertyTree == null)||(!maxImageSizePropertyTree.isLeaf())))) {
            _other.maxImageSize = this.maxImageSize;
        }
        final PropertyTree maxFileSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxFileSize"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxFileSizePropertyTree!= null):((maxFileSizePropertyTree == null)||(!maxFileSizePropertyTree.isLeaf())))) {
            _other.maxFileSize = this.maxFileSize;
        }
        final PropertyTree maxRecordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxRecords"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxRecordsPropertyTree!= null):((maxRecordsPropertyTree == null)||(!maxRecordsPropertyTree.isLeaf())))) {
            _other.maxRecords = this.maxRecords;
        }
        final PropertyTree testQueryPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("testQuery"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(testQueryPropertyTree!= null):((testQueryPropertyTree == null)||(!testQueryPropertyTree.isLeaf())))) {
            _other.testQuery = ((this.testQuery == null)?null:this.testQuery.newCopyBuilder(_other, testQueryPropertyTree, _propertyTreeUse));
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >SimpleImageAccess.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new SimpleImageAccess.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SimpleImageAccess.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >SimpleImageAccess.Builder<_B> copyOf(final Capability _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SimpleImageAccess.Builder<_B> _newBuilder = new SimpleImageAccess.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >SimpleImageAccess.Builder<_B> copyOf(final SIACapRestriction _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SimpleImageAccess.Builder<_B> _newBuilder = new SimpleImageAccess.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >SimpleImageAccess.Builder<_B> copyOf(final SimpleImageAccess _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SimpleImageAccess.Builder<_B> _newBuilder = new SimpleImageAccess.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SimpleImageAccess.Builder<Void> copyExcept(final Capability _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SimpleImageAccess.Builder<Void> copyExcept(final SIACapRestriction _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SimpleImageAccess.Builder<Void> copyExcept(final SimpleImageAccess _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SimpleImageAccess.Builder<Void> copyOnly(final Capability _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SimpleImageAccess.Builder<Void> copyOnly(final SIACapRestriction _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SimpleImageAccess.Builder<Void> copyOnly(final SimpleImageAccess _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SimpleImageAccess visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty<>(SimpleImageAccess.PropInfo.IMAGE_SERVICE_TYPE, this));
        if (_visitor_.visit(new SingleProperty<>(SimpleImageAccess.PropInfo.MAX_QUERY_REGION_SIZE, this))&&(this.maxQueryRegionSize!= null)) {
            this.maxQueryRegionSize.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(SimpleImageAccess.PropInfo.MAX_IMAGE_EXTENT, this))&&(this.maxImageExtent!= null)) {
            this.maxImageExtent.visit(_visitor_);
        }
        _visitor_.visit(new SingleProperty<>(SimpleImageAccess.PropInfo.MAX_IMAGE_SIZE, this));
        _visitor_.visit(new SingleProperty<>(SimpleImageAccess.PropInfo.MAX_FILE_SIZE, this));
        _visitor_.visit(new SingleProperty<>(SimpleImageAccess.PropInfo.MAX_RECORDS, this));
        if (_visitor_.visit(new SingleProperty<>(SimpleImageAccess.PropInfo.TEST_QUERY, this))&&(this.testQuery!= null)) {
            this.testQuery.visit(_visitor_);
        }
        return this;
    }

    public static class Builder<_B >
        extends SIACapRestriction.Builder<_B>
        implements Buildable
    {

        private ImageServiceType imageServiceType;
        private SkySize.Builder<SimpleImageAccess.Builder<_B>> maxQueryRegionSize;
        private SkySize.Builder<SimpleImageAccess.Builder<_B>> maxImageExtent;
        private BigInteger maxImageSize;
        private BigInteger maxFileSize;
        private BigInteger maxRecords;
        private Query.Builder<SimpleImageAccess.Builder<_B>> testQuery;

        public Builder(final _B _parentBuilder, final SimpleImageAccess _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.imageServiceType = _other.imageServiceType;
                this.maxQueryRegionSize = ((_other.maxQueryRegionSize == null)?null:_other.maxQueryRegionSize.newCopyBuilder(this));
                this.maxImageExtent = ((_other.maxImageExtent == null)?null:_other.maxImageExtent.newCopyBuilder(this));
                this.maxImageSize = _other.maxImageSize;
                this.maxFileSize = _other.maxFileSize;
                this.maxRecords = _other.maxRecords;
                this.testQuery = ((_other.testQuery == null)?null:_other.testQuery.newCopyBuilder(this));
            }
        }

        public Builder(final _B _parentBuilder, final SimpleImageAccess _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree imageServiceTypePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("imageServiceType"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(imageServiceTypePropertyTree!= null):((imageServiceTypePropertyTree == null)||(!imageServiceTypePropertyTree.isLeaf())))) {
                    this.imageServiceType = _other.imageServiceType;
                }
                final PropertyTree maxQueryRegionSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxQueryRegionSize"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxQueryRegionSizePropertyTree!= null):((maxQueryRegionSizePropertyTree == null)||(!maxQueryRegionSizePropertyTree.isLeaf())))) {
                    this.maxQueryRegionSize = ((_other.maxQueryRegionSize == null)?null:_other.maxQueryRegionSize.newCopyBuilder(this, maxQueryRegionSizePropertyTree, _propertyTreeUse));
                }
                final PropertyTree maxImageExtentPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxImageExtent"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxImageExtentPropertyTree!= null):((maxImageExtentPropertyTree == null)||(!maxImageExtentPropertyTree.isLeaf())))) {
                    this.maxImageExtent = ((_other.maxImageExtent == null)?null:_other.maxImageExtent.newCopyBuilder(this, maxImageExtentPropertyTree, _propertyTreeUse));
                }
                final PropertyTree maxImageSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxImageSize"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxImageSizePropertyTree!= null):((maxImageSizePropertyTree == null)||(!maxImageSizePropertyTree.isLeaf())))) {
                    this.maxImageSize = _other.maxImageSize;
                }
                final PropertyTree maxFileSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxFileSize"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxFileSizePropertyTree!= null):((maxFileSizePropertyTree == null)||(!maxFileSizePropertyTree.isLeaf())))) {
                    this.maxFileSize = _other.maxFileSize;
                }
                final PropertyTree maxRecordsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("maxRecords"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(maxRecordsPropertyTree!= null):((maxRecordsPropertyTree == null)||(!maxRecordsPropertyTree.isLeaf())))) {
                    this.maxRecords = _other.maxRecords;
                }
                final PropertyTree testQueryPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("testQuery"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(testQueryPropertyTree!= null):((testQueryPropertyTree == null)||(!testQueryPropertyTree.isLeaf())))) {
                    this.testQuery = ((_other.testQuery == null)?null:_other.testQuery.newCopyBuilder(this, testQueryPropertyTree, _propertyTreeUse));
                }
            }
        }

        protected<_P extends SimpleImageAccess >_P init(final _P _product) {
            _product.imageServiceType = this.imageServiceType;
            _product.maxQueryRegionSize = ((this.maxQueryRegionSize == null)?null:this.maxQueryRegionSize.build());
            _product.maxImageExtent = ((this.maxImageExtent == null)?null:this.maxImageExtent.build());
            _product.maxImageSize = this.maxImageSize;
            _product.maxFileSize = this.maxFileSize;
            _product.maxRecords = this.maxRecords;
            _product.testQuery = ((this.testQuery == null)?null:this.testQuery.build());
            return super.init(_product);
        }

        /**
         * Sets the new value of "imageServiceType" (any previous value will be replaced)
         * 
         * @param imageServiceType
         *     New value of the "imageServiceType" property.
         */
        public SimpleImageAccess.Builder<_B> withImageServiceType(final ImageServiceType imageServiceType) {
            this.imageServiceType = imageServiceType;
            return this;
        }

        /**
         * Sets the new value of "maxQueryRegionSize" (any previous value will be replaced)
         * 
         * @param maxQueryRegionSize
         *     New value of the "maxQueryRegionSize" property.
         */
        public SimpleImageAccess.Builder<_B> withMaxQueryRegionSize(final SkySize maxQueryRegionSize) {
            this.maxQueryRegionSize = ((maxQueryRegionSize == null)?null:new SkySize.Builder<>(this, maxQueryRegionSize, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "maxQueryRegionSize" property.
         * Use {@link org.javastro.ivoa.entities.resource.sia.SkySize.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "maxQueryRegionSize" property.
         *     Use {@link org.javastro.ivoa.entities.resource.sia.SkySize.Builder#end()} to
         *     return to the current builder.
         */
        public SkySize.Builder<? extends SimpleImageAccess.Builder<_B>> withMaxQueryRegionSize() {
            if (this.maxQueryRegionSize!= null) {
                return this.maxQueryRegionSize;
            }
            return this.maxQueryRegionSize = new SkySize.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "maxImageExtent" (any previous value will be replaced)
         * 
         * @param maxImageExtent
         *     New value of the "maxImageExtent" property.
         */
        public SimpleImageAccess.Builder<_B> withMaxImageExtent(final SkySize maxImageExtent) {
            this.maxImageExtent = ((maxImageExtent == null)?null:new SkySize.Builder<>(this, maxImageExtent, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "maxImageExtent" property.
         * Use {@link org.javastro.ivoa.entities.resource.sia.SkySize.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "maxImageExtent" property.
         *     Use {@link org.javastro.ivoa.entities.resource.sia.SkySize.Builder#end()} to
         *     return to the current builder.
         */
        public SkySize.Builder<? extends SimpleImageAccess.Builder<_B>> withMaxImageExtent() {
            if (this.maxImageExtent!= null) {
                return this.maxImageExtent;
            }
            return this.maxImageExtent = new SkySize.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "maxImageSize" (any previous value will be replaced)
         * 
         * @param maxImageSize
         *     New value of the "maxImageSize" property.
         */
        public SimpleImageAccess.Builder<_B> withMaxImageSize(final BigInteger maxImageSize) {
            this.maxImageSize = maxImageSize;
            return this;
        }

        /**
         * Sets the new value of "maxFileSize" (any previous value will be replaced)
         * 
         * @param maxFileSize
         *     New value of the "maxFileSize" property.
         */
        public SimpleImageAccess.Builder<_B> withMaxFileSize(final BigInteger maxFileSize) {
            this.maxFileSize = maxFileSize;
            return this;
        }

        /**
         * Sets the new value of "maxRecords" (any previous value will be replaced)
         * 
         * @param maxRecords
         *     New value of the "maxRecords" property.
         */
        public SimpleImageAccess.Builder<_B> withMaxRecords(final BigInteger maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        /**
         * Sets the new value of "testQuery" (any previous value will be replaced)
         * 
         * @param testQuery
         *     New value of the "testQuery" property.
         */
        public SimpleImageAccess.Builder<_B> withTestQuery(final Query testQuery) {
            this.testQuery = ((testQuery == null)?null:new Query.Builder<>(this, testQuery, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "testQuery" property.
         * Use {@link org.javastro.ivoa.entities.resource.sia.Query.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "testQuery" property.
         *     Use {@link org.javastro.ivoa.entities.resource.sia.Query.Builder#end()} to
         *     return to the current builder.
         */
        public Query.Builder<? extends SimpleImageAccess.Builder<_B>> withTestQuery() {
            if (this.testQuery!= null) {
                return this.testQuery;
            }
            return this.testQuery = new Query.Builder<>(this, null, false);
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public SimpleImageAccess.Builder<_B> addValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Adds the given items to the value of "validationLevels"
         * 
         * @param validationLevels
         *     Items to add to the value of the "validationLevels" property
         */
        @Override
        public SimpleImageAccess.Builder<_B> addValidationLevels(Validation... validationLevels) {
            super.addValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public SimpleImageAccess.Builder<_B> withValidationLevels(final Iterable<? extends Validation> validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "validationLevels" (any previous value will be replaced)
         * 
         * @param validationLevels
         *     New value of the "validationLevels" property.
         */
        @Override
        public SimpleImageAccess.Builder<_B> withValidationLevels(Validation... validationLevels) {
            super.withValidationLevels(validationLevels);
            return this;
        }

        /**
         * Sets the new value of "description" (any previous value will be replaced)
         * 
         * @param description
         *     New value of the "description" property.
         */
        @Override
        public SimpleImageAccess.Builder<_B> withDescription(final String description) {
            super.withDescription(description);
            return this;
        }

        /**
         * Adds the given items to the value of "interfaces"
         * 
         * @param interfaces
         *     Items to add to the value of the "interfaces" property
         */
        @Override
        public SimpleImageAccess.Builder<_B> addInterfaces(final Iterable<? extends ServiceInterface> interfaces) {
            super.addInterfaces(interfaces);
            return this;
        }

        /**
         * Adds the given items to the value of "interfaces"
         * 
         * @param interfaces
         *     Items to add to the value of the "interfaces" property
         */
        @Override
        public SimpleImageAccess.Builder<_B> addInterfaces(ServiceInterface... interfaces) {
            super.addInterfaces(interfaces);
            return this;
        }

        /**
         * Sets the new value of "interfaces" (any previous value will be replaced)
         * 
         * @param interfaces
         *     New value of the "interfaces" property.
         */
        @Override
        public SimpleImageAccess.Builder<_B> withInterfaces(final Iterable<? extends ServiceInterface> interfaces) {
            super.withInterfaces(interfaces);
            return this;
        }

        /**
         * Sets the new value of "interfaces" (any previous value will be replaced)
         * 
         * @param interfaces
         *     New value of the "interfaces" property.
         */
        @Override
        public SimpleImageAccess.Builder<_B> withInterfaces(ServiceInterface... interfaces) {
            super.withInterfaces(interfaces);
            return this;
        }

        /**
         * Sets the new value of "standardID" (any previous value will be replaced)
         * 
         * @param standardID
         *     New value of the "standardID" property.
         */
        @Override
        public SimpleImageAccess.Builder<_B> withStandardID(final String standardID) {
            super.withStandardID(standardID);
            return this;
        }

        @Override
        public SimpleImageAccess build() {
            if (_storedValue == null) {
                return this.init(new SimpleImageAccess());
            } else {
                return ((SimpleImageAccess) _storedValue);
            }
        }

        public SimpleImageAccess.Builder<_B> copyOf(final SimpleImageAccess _other) {
            _other.copyTo(this);
            return this;
        }

        public SimpleImageAccess.Builder<_B> copyOf(final SimpleImageAccess.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends SIACapRestriction.Modifier
    {


        public void setImageServiceType(final ImageServiceType imageServiceType) {
            SimpleImageAccess.this.setImageServiceType(imageServiceType);
        }

        public void setMaxQueryRegionSize(final SkySize maxQueryRegionSize) {
            SimpleImageAccess.this.setMaxQueryRegionSize(maxQueryRegionSize);
        }

        public void setMaxImageExtent(final SkySize maxImageExtent) {
            SimpleImageAccess.this.setMaxImageExtent(maxImageExtent);
        }

        public void setMaxImageSize(final BigInteger maxImageSize) {
            SimpleImageAccess.this.setMaxImageSize(maxImageSize);
        }

        public void setMaxFileSize(final BigInteger maxFileSize) {
            SimpleImageAccess.this.setMaxFileSize(maxFileSize);
        }

        public void setMaxRecords(final BigInteger maxRecords) {
            SimpleImageAccess.this.setMaxRecords(maxRecords);
        }

        public void setTestQuery(final Query testQuery) {
            SimpleImageAccess.this.setTestQuery(testQuery);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<SimpleImageAccess, ImageServiceType> IMAGE_SERVICE_TYPE = new SinglePropertyInfo<SimpleImageAccess,ImageServiceType>("imageServiceType", SimpleImageAccess.class, ImageServiceType.class, false, null, new QName("", "imageServiceType"), new QName("http://www.ivoa.net/xml/SIA/v1.1", "ImageServiceType"), false) {


            @Override
            public ImageServiceType get(final SimpleImageAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.imageServiceType);
            }

            @Override
            public void set(final SimpleImageAccess _instance_, final ImageServiceType _value_) {
                if (_instance_!= null) {
                    _instance_.imageServiceType = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SimpleImageAccess, SkySize> MAX_QUERY_REGION_SIZE = new SinglePropertyInfo<SimpleImageAccess,SkySize>("maxQueryRegionSize", SimpleImageAccess.class, SkySize.class, false, null, new QName("", "maxQueryRegionSize"), new QName("http://www.ivoa.net/xml/SIA/v1.1", "SkySize"), false) {


            @Override
            public SkySize get(final SimpleImageAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.maxQueryRegionSize);
            }

            @Override
            public void set(final SimpleImageAccess _instance_, final SkySize _value_) {
                if (_instance_!= null) {
                    _instance_.maxQueryRegionSize = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SimpleImageAccess, SkySize> MAX_IMAGE_EXTENT = new SinglePropertyInfo<SimpleImageAccess,SkySize>("maxImageExtent", SimpleImageAccess.class, SkySize.class, false, null, new QName("", "maxImageExtent"), new QName("http://www.ivoa.net/xml/SIA/v1.1", "SkySize"), false) {


            @Override
            public SkySize get(final SimpleImageAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.maxImageExtent);
            }

            @Override
            public void set(final SimpleImageAccess _instance_, final SkySize _value_) {
                if (_instance_!= null) {
                    _instance_.maxImageExtent = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SimpleImageAccess, BigInteger> MAX_IMAGE_SIZE = new SinglePropertyInfo<SimpleImageAccess,BigInteger>("maxImageSize", SimpleImageAccess.class, BigInteger.class, false, null, new QName("", "maxImageSize"), new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), false) {


            @Override
            public BigInteger get(final SimpleImageAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.maxImageSize);
            }

            @Override
            public void set(final SimpleImageAccess _instance_, final BigInteger _value_) {
                if (_instance_!= null) {
                    _instance_.maxImageSize = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SimpleImageAccess, BigInteger> MAX_FILE_SIZE = new SinglePropertyInfo<SimpleImageAccess,BigInteger>("maxFileSize", SimpleImageAccess.class, BigInteger.class, false, null, new QName("", "maxFileSize"), new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), false) {


            @Override
            public BigInteger get(final SimpleImageAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.maxFileSize);
            }

            @Override
            public void set(final SimpleImageAccess _instance_, final BigInteger _value_) {
                if (_instance_!= null) {
                    _instance_.maxFileSize = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SimpleImageAccess, BigInteger> MAX_RECORDS = new SinglePropertyInfo<SimpleImageAccess,BigInteger>("maxRecords", SimpleImageAccess.class, BigInteger.class, false, null, new QName("", "maxRecords"), new QName("http://www.w3.org/2001/XMLSchema", "positiveInteger"), false) {


            @Override
            public BigInteger get(final SimpleImageAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.maxRecords);
            }

            @Override
            public void set(final SimpleImageAccess _instance_, final BigInteger _value_) {
                if (_instance_!= null) {
                    _instance_.maxRecords = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SimpleImageAccess, Query> TEST_QUERY = new SinglePropertyInfo<SimpleImageAccess,Query>("testQuery", SimpleImageAccess.class, Query.class, false, null, new QName("", "testQuery"), new QName("http://www.ivoa.net/xml/SIA/v1.1", "Query"), false) {


            @Override
            public Query get(final SimpleImageAccess _instance_) {
                return ((_instance_ == null)?null:_instance_.testQuery);
            }

            @Override
            public void set(final SimpleImageAccess _instance_, final Query _value_) {
                if (_instance_!= null) {
                    _instance_.testQuery = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends SimpleImageAccess.Selector<SimpleImageAccess.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static SimpleImageAccess.Select _root() {
            return new SimpleImageAccess.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends SIACapRestriction.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, SimpleImageAccess.Selector<TRoot, TParent>> imageServiceType = null;
        private SkySize.Selector<TRoot, SimpleImageAccess.Selector<TRoot, TParent>> maxQueryRegionSize = null;
        private SkySize.Selector<TRoot, SimpleImageAccess.Selector<TRoot, TParent>> maxImageExtent = null;
        private com.kscs.util.jaxb.Selector<TRoot, SimpleImageAccess.Selector<TRoot, TParent>> maxImageSize = null;
        private com.kscs.util.jaxb.Selector<TRoot, SimpleImageAccess.Selector<TRoot, TParent>> maxFileSize = null;
        private com.kscs.util.jaxb.Selector<TRoot, SimpleImageAccess.Selector<TRoot, TParent>> maxRecords = null;
        private Query.Selector<TRoot, SimpleImageAccess.Selector<TRoot, TParent>> testQuery = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.imageServiceType!= null) {
                products.put("imageServiceType", this.imageServiceType.init());
            }
            if (this.maxQueryRegionSize!= null) {
                products.put("maxQueryRegionSize", this.maxQueryRegionSize.init());
            }
            if (this.maxImageExtent!= null) {
                products.put("maxImageExtent", this.maxImageExtent.init());
            }
            if (this.maxImageSize!= null) {
                products.put("maxImageSize", this.maxImageSize.init());
            }
            if (this.maxFileSize!= null) {
                products.put("maxFileSize", this.maxFileSize.init());
            }
            if (this.maxRecords!= null) {
                products.put("maxRecords", this.maxRecords.init());
            }
            if (this.testQuery!= null) {
                products.put("testQuery", this.testQuery.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, SimpleImageAccess.Selector<TRoot, TParent>> imageServiceType() {
            return ((this.imageServiceType == null)?this.imageServiceType = new com.kscs.util.jaxb.Selector<>(this._root, this, "imageServiceType"):this.imageServiceType);
        }

        public SkySize.Selector<TRoot, SimpleImageAccess.Selector<TRoot, TParent>> maxQueryRegionSize() {
            return ((this.maxQueryRegionSize == null)?this.maxQueryRegionSize = new SkySize.Selector<>(this._root, this, "maxQueryRegionSize"):this.maxQueryRegionSize);
        }

        public SkySize.Selector<TRoot, SimpleImageAccess.Selector<TRoot, TParent>> maxImageExtent() {
            return ((this.maxImageExtent == null)?this.maxImageExtent = new SkySize.Selector<>(this._root, this, "maxImageExtent"):this.maxImageExtent);
        }

        public com.kscs.util.jaxb.Selector<TRoot, SimpleImageAccess.Selector<TRoot, TParent>> maxImageSize() {
            return ((this.maxImageSize == null)?this.maxImageSize = new com.kscs.util.jaxb.Selector<>(this._root, this, "maxImageSize"):this.maxImageSize);
        }

        public com.kscs.util.jaxb.Selector<TRoot, SimpleImageAccess.Selector<TRoot, TParent>> maxFileSize() {
            return ((this.maxFileSize == null)?this.maxFileSize = new com.kscs.util.jaxb.Selector<>(this._root, this, "maxFileSize"):this.maxFileSize);
        }

        public com.kscs.util.jaxb.Selector<TRoot, SimpleImageAccess.Selector<TRoot, TParent>> maxRecords() {
            return ((this.maxRecords == null)?this.maxRecords = new com.kscs.util.jaxb.Selector<>(this._root, this, "maxRecords"):this.maxRecords);
        }

        public Query.Selector<TRoot, SimpleImageAccess.Selector<TRoot, TParent>> testQuery() {
            return ((this.testQuery == null)?this.testQuery = new Query.Selector<>(this._root, this, "testQuery"):this.testQuery);
        }

    }

}
