
package org.javastro.ivoa.entities.resource.sia;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * <p>Java class for SkyPos complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SkyPos">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="long" type="{http://www.w3.org/2001/XMLSchema}double"/>
 *         <element name="lat" type="{http://www.w3.org/2001/XMLSchema}double"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SkyPos", propOrder = {
    "_long",
    "lat"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class SkyPos implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The sky position in the longitude (R.A.) direction
     * 
     */
    @XmlElement(name = "long")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected double _long;
    /**
     * The sky position in the latitude (Dec.) direction
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected double lat;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected transient SkyPos.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public SkyPos() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public SkyPos(final double _long, final double lat) {
        this._long = _long;
        this.lat = lat;
    }

    /**
     * The sky position in the longitude (R.A.) direction
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public double getLong() {
        return _long;
    }

    /**
     * Sets the value of the long property.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setLong(double value) {
        this._long = value;
    }

    /**
     * The sky position in the latitude (Dec.) direction
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public double getLat() {
        return lat;
    }

    /**
     * Sets the value of the lat property.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setLat(double value) {
        this.lat = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final SkyPos that = ((SkyPos) object);
        {
            double leftLong;
            leftLong = this.getLong();
            double rightLong;
            rightLong = that.getLong();
            if (Double.doubleToLongBits(leftLong)!= Double.doubleToLongBits(rightLong)) {
                return false;
            }
        }
        {
            double leftLat;
            leftLat = this.getLat();
            double rightLat;
            rightLat = that.getLat();
            if (Double.doubleToLongBits(leftLat)!= Double.doubleToLongBits(rightLat)) {
                return false;
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            double theLong;
            theLong = this.getLong();
            final long theLongBits = Double.doubleToLongBits(theLong);
            currentHashCode += ((int)(theLongBits^(theLongBits >>> 32)));
        }
        {
            currentHashCode = (currentHashCode* 31);
            double theLat;
            theLat = this.getLat();
            final long theLatBits = Double.doubleToLongBits(theLat);
            currentHashCode += ((int)(theLatBits^(theLatBits >>> 32)));
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            double theLong;
            theLong = this.getLong();
            strategy.appendField(locator, this, "_long", buffer, theLong, true);
        }
        {
            double theLat;
            theLat = this.getLat();
            strategy.appendField(locator, this, "lat", buffer, theLat, true);
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof SkyPos) {
            final SkyPos target = this;
            final SkyPos leftObject = ((SkyPos) left);
            final SkyPos rightObject = ((SkyPos) right);
            {
                Boolean _longShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, true, true);
                if (_longShouldBeMergedAndSet == Boolean.TRUE) {
                    double lhsLong;
                    lhsLong = leftObject.getLong();
                    double rhsLong;
                    rhsLong = rightObject.getLong();
                    double mergedLong = ((double) strategy.merge(LocatorUtils.property(leftLocator, "_long", lhsLong), LocatorUtils.property(rightLocator, "_long", rhsLong), lhsLong, rhsLong, true, true));
                    target.setLong(mergedLong);
                } else {
                    if (_longShouldBeMergedAndSet == Boolean.FALSE) {
                    }
                }
            }
            {
                Boolean latShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, true, true);
                if (latShouldBeMergedAndSet == Boolean.TRUE) {
                    double lhsLat;
                    lhsLat = leftObject.getLat();
                    double rhsLat;
                    rhsLat = rightObject.getLat();
                    double mergedLat = ((double) strategy.merge(LocatorUtils.property(leftLocator, "lat", lhsLat), LocatorUtils.property(rightLocator, "lat", rhsLat), lhsLat, rhsLat, true, true));
                    target.setLat(mergedLat);
                } else {
                    if (latShouldBeMergedAndSet == Boolean.FALSE) {
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new SkyPos();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SkyPos clone() {
        final SkyPos _newObject;
        try {
            _newObject = ((SkyPos) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SkyPos createCopy() {
        final SkyPos _newObject;
        try {
            _newObject = ((SkyPos) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject._long = this._long;
        _newObject.lat = this.lat;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SkyPos createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SkyPos _newObject;
        try {
            _newObject = ((SkyPos) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree _longPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("_long"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(_longPropertyTree!= null):((_longPropertyTree == null)||(!_longPropertyTree.isLeaf())))) {
            _newObject._long = this._long;
        }
        final PropertyTree latPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("lat"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(latPropertyTree!= null):((latPropertyTree == null)||(!latPropertyTree.isLeaf())))) {
            _newObject.lat = this.lat;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SkyPos copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SkyPos copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SkyPos.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new SkyPos.Modifier();
        }
        return ((SkyPos.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final SkyPos.Builder<_B> _other) {
        _other._long = this._long;
        _other.lat = this.lat;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >SkyPos.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new SkyPos.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SkyPos.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SkyPos.Builder<Void> builder() {
        return new SkyPos.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >SkyPos.Builder<_B> copyOf(final SkyPos _other) {
        final SkyPos.Builder<_B> _newBuilder = new SkyPos.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final SkyPos.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree _longPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("_long"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(_longPropertyTree!= null):((_longPropertyTree == null)||(!_longPropertyTree.isLeaf())))) {
            _other._long = this._long;
        }
        final PropertyTree latPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("lat"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(latPropertyTree!= null):((latPropertyTree == null)||(!latPropertyTree.isLeaf())))) {
            _other.lat = this.lat;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >SkyPos.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new SkyPos.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SkyPos.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >SkyPos.Builder<_B> copyOf(final SkyPos _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final SkyPos.Builder<_B> _newBuilder = new SkyPos.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SkyPos.Builder<Void> copyExcept(final SkyPos _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static SkyPos.Builder<Void> copyOnly(final SkyPos _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SkyPos visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(SkyPos.PropInfo.LONG, this));
        _visitor_.visit(new SingleProperty<>(SkyPos.PropInfo.LAT, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final SkyPos _storedValue;
        private double _long;
        private double lat;

        public Builder(final _B _parentBuilder, final SkyPos _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this._long = _other._long;
                    this.lat = _other.lat;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final SkyPos _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree _longPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("_long"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(_longPropertyTree!= null):((_longPropertyTree == null)||(!_longPropertyTree.isLeaf())))) {
                        this._long = _other._long;
                    }
                    final PropertyTree latPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("lat"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(latPropertyTree!= null):((latPropertyTree == null)||(!latPropertyTree.isLeaf())))) {
                        this.lat = _other.lat;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends SkyPos >_P init(final _P _product) {
            _product._long = this._long;
            _product.lat = this.lat;
            return _product;
        }

        /**
         * Sets the new value of "_long" (any previous value will be replaced)
         * 
         * @param _long
         *     New value of the "_long" property.
         */
        public SkyPos.Builder<_B> withLong(final double _long) {
            this._long = _long;
            return this;
        }

        /**
         * Sets the new value of "lat" (any previous value will be replaced)
         * 
         * @param lat
         *     New value of the "lat" property.
         */
        public SkyPos.Builder<_B> withLat(final double lat) {
            this.lat = lat;
            return this;
        }

        @Override
        public SkyPos build() {
            if (_storedValue == null) {
                return this.init(new SkyPos());
            } else {
                return ((SkyPos) _storedValue);
            }
        }

        public SkyPos.Builder<_B> copyOf(final SkyPos _other) {
            _other.copyTo(this);
            return this;
        }

        public SkyPos.Builder<_B> copyOf(final SkyPos.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setLong(final double _long) {
            SkyPos.this.setLong(_long);
        }

        public void setLat(final double lat) {
            SkyPos.this.setLat(lat);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<SkyPos, Double> LONG = new SinglePropertyInfo<SkyPos,Double>("_long", SkyPos.class, Double.class, false, null, new QName("", "long"), new QName("http://www.w3.org/2001/XMLSchema", "double"), false) {


            @Override
            public Double get(final SkyPos _instance_) {
                return ((_instance_ == null)?null:_instance_._long);
            }

            @Override
            public void set(final SkyPos _instance_, final Double _value_) {
                if (_instance_!= null) {
                    _instance_._long = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<SkyPos, Double> LAT = new SinglePropertyInfo<SkyPos,Double>("lat", SkyPos.class, Double.class, false, null, new QName("", "lat"), new QName("http://www.w3.org/2001/XMLSchema", "double"), false) {


            @Override
            public Double get(final SkyPos _instance_) {
                return ((_instance_ == null)?null:_instance_.lat);
            }

            @Override
            public void set(final SkyPos _instance_, final Double _value_) {
                if (_instance_!= null) {
                    _instance_.lat = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends SkyPos.Selector<SkyPos.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static SkyPos.Select _root() {
            return new SkyPos.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {


        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            return products;
        }

    }

}
