
package org.javastro.ivoa.entities.resource.ssap;

import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.EnumValue;


/**
 * The allowed values for indicating the level at which a 
 *             service instance complies with the SSA standard.
 * 
 * <p>Java class for ComplianceLevel</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * <pre>{@code
 * <simpleType name="ComplianceLevel">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}token">
 *     <enumeration value="query"/>
 *     <enumeration value="minimal"/>
 *     <enumeration value="full"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "ComplianceLevel")
@XmlEnum
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public enum ComplianceLevel implements EnumValue<String>
{


    /**
     * This level represents the lowest level of compliance.
     * 
     */
    @XmlEnumValue("query")
    QUERY("query"),

    /**
     * This level represents the middle level of compliance.
     * 
     */
    @XmlEnumValue("minimal")
    MINIMAL("minimal"),

    /**
     * This level represents the highest level of compliance.
     * 
     */
    @XmlEnumValue("full")
    FULL("full");
    private final String value;

    ComplianceLevel(String v) {
        value = v;
    }

    /**
     * Gets the value associated to the enum constant.
     * 
     * @return
     *     The value linked to the enum.
     */
    public String value() {
        return value;
    }

    /**
     * Gets the enum associated to the value passed as parameter.
     * 
     * @param v
     *     The value to get the enum from.
     * @return
     *     The enum which corresponds to the value, if it exists.
     * @throws IllegalArgumentException
     *     If no value matches in the enum declaration.
     */
    public static ComplianceLevel fromValue(String v) {
        for (ComplianceLevel c: ComplianceLevel.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    @Override
    public String enumValue() {
        return this.value();
    }

}
