
package org.javastro.ivoa.entities.resource.tap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Each language element can describe one or more versions
 *       of a language.  Either name alone or name-version can be
 *       used as values for the server's LANG parameter.
 * 
 * <p>Java class for Language complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="Language">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="name" type="{http://www.w3.org/2001/XMLSchema}NCName"/>
 *         <element name="version" type="{http://www.ivoa.net/xml/TAPRegExt/v1.0}Version" maxOccurs="unbounded"/>
 *         <element name="description" type="{http://www.w3.org/2001/XMLSchema}token" minOccurs="0"/>
 *         <element name="languageFeatures" type="{http://www.ivoa.net/xml/TAPRegExt/v1.0}LanguageFeatureList" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Language", propOrder = {
    "name",
    "versions",
    "description",
    "languageFeatures"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class Language implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The name of the language without a version suffix.
     * 
     */
    @XmlElement(required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "NCName")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String name;
    /**
     * A version of the language supported by the server.
     * 
     */
    @XmlElement(name = "version", required = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<Version> versions;
    /**
     * A short, human-readable description of the
     *           query language.
     * 
     */
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String description;
    /**
     * This includes listing user defined functions, geometry support,
     *         		or similar concepts.
     * 
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<LanguageFeatureList> languageFeatures;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected transient Language.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public Language() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public Language(final String name, final List<Version> versions, final String description, final List<LanguageFeatureList> languageFeatures) {
        this.name = name;
        this.versions = versions;
        this.description = description;
        this.languageFeatures = languageFeatures;
    }

    /**
     * The name of the language without a version suffix.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getName()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setName(String value) {
        this.name = value;
    }

    /**
     * A version of the language supported by the server.
     * 
     * Gets the value of the versions property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the versions property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getVersions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Version }
     * </p>
     * 
     * 
     * @return
     *     The value of the versions property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<Version> getVersions() {
        if (versions == null) {
            versions = new ArrayList<>();
        }
        return this.versions;
    }

    /**
     * A short, human-readable description of the
     *           query language.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getDescription() {
        return description;
    }

    /**
     * Sets the value of the description property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getDescription()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setDescription(String value) {
        this.description = value;
    }

    /**
     * This includes listing user defined functions, geometry support,
     *         		or similar concepts.
     * 
     * Gets the value of the languageFeatures property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the languageFeatures property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getLanguageFeatures().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LanguageFeatureList }
     * </p>
     * 
     * 
     * @return
     *     The value of the languageFeatures property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<LanguageFeatureList> getLanguageFeatures() {
        if (languageFeatures == null) {
            languageFeatures = new ArrayList<>();
        }
        return this.languageFeatures;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final Language that = ((Language) object);
        {
            String leftName;
            leftName = this.getName();
            String rightName;
            rightName = that.getName();
            if (this.name!= null) {
                if (that.name!= null) {
                    if (!leftName.equals(rightName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.name!= null) {
                    return false;
                }
            }
        }
        {
            List<Version> leftVersions;
            leftVersions = (((this.versions!= null)&&(!this.versions.isEmpty()))?this.getVersions():null);
            List<Version> rightVersions;
            rightVersions = (((that.versions!= null)&&(!that.versions.isEmpty()))?that.getVersions():null);
            if ((this.versions!= null)&&(!this.versions.isEmpty())) {
                if ((that.versions!= null)&&(!that.versions.isEmpty())) {
                    if (!leftVersions.equals(rightVersions)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.versions!= null)&&(!that.versions.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftDescription;
            leftDescription = this.getDescription();
            String rightDescription;
            rightDescription = that.getDescription();
            if (this.description!= null) {
                if (that.description!= null) {
                    if (!leftDescription.equals(rightDescription)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.description!= null) {
                    return false;
                }
            }
        }
        {
            List<LanguageFeatureList> leftLanguageFeatures;
            leftLanguageFeatures = (((this.languageFeatures!= null)&&(!this.languageFeatures.isEmpty()))?this.getLanguageFeatures():null);
            List<LanguageFeatureList> rightLanguageFeatures;
            rightLanguageFeatures = (((that.languageFeatures!= null)&&(!that.languageFeatures.isEmpty()))?that.getLanguageFeatures():null);
            if ((this.languageFeatures!= null)&&(!this.languageFeatures.isEmpty())) {
                if ((that.languageFeatures!= null)&&(!that.languageFeatures.isEmpty())) {
                    if (!leftLanguageFeatures.equals(rightLanguageFeatures)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.languageFeatures!= null)&&(!that.languageFeatures.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theName;
            theName = this.getName();
            if (this.name!= null) {
                currentHashCode += theName.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Version> theVersions;
            theVersions = (((this.versions!= null)&&(!this.versions.isEmpty()))?this.getVersions():null);
            if ((this.versions!= null)&&(!this.versions.isEmpty())) {
                currentHashCode += theVersions.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theDescription;
            theDescription = this.getDescription();
            if (this.description!= null) {
                currentHashCode += theDescription.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<LanguageFeatureList> theLanguageFeatures;
            theLanguageFeatures = (((this.languageFeatures!= null)&&(!this.languageFeatures.isEmpty()))?this.getLanguageFeatures():null);
            if ((this.languageFeatures!= null)&&(!this.languageFeatures.isEmpty())) {
                currentHashCode += theLanguageFeatures.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theName;
            theName = this.getName();
            strategy.appendField(locator, this, "name", buffer, theName, (this.name!= null));
        }
        {
            List<Version> theVersions;
            theVersions = (((this.versions!= null)&&(!this.versions.isEmpty()))?this.getVersions():null);
            strategy.appendField(locator, this, "versions", buffer, theVersions, ((this.versions!= null)&&(!this.versions.isEmpty())));
        }
        {
            String theDescription;
            theDescription = this.getDescription();
            strategy.appendField(locator, this, "description", buffer, theDescription, (this.description!= null));
        }
        {
            List<LanguageFeatureList> theLanguageFeatures;
            theLanguageFeatures = (((this.languageFeatures!= null)&&(!this.languageFeatures.isEmpty()))?this.getLanguageFeatures():null);
            strategy.appendField(locator, this, "languageFeatures", buffer, theLanguageFeatures, ((this.languageFeatures!= null)&&(!this.languageFeatures.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof Language) {
            final Language target = this;
            final Language leftObject = ((Language) left);
            final Language rightObject = ((Language) right);
            {
                Boolean nameShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.name!= null), (rightObject.name!= null));
                if (nameShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsName;
                    lhsName = leftObject.getName();
                    String rhsName;
                    rhsName = rightObject.getName();
                    String mergedName = ((String) strategy.merge(LocatorUtils.property(leftLocator, "name", lhsName), LocatorUtils.property(rightLocator, "name", rhsName), lhsName, rhsName, (leftObject.name!= null), (rightObject.name!= null)));
                    target.setName(mergedName);
                } else {
                    if (nameShouldBeMergedAndSet == Boolean.FALSE) {
                        target.name = null;
                    }
                }
            }
            {
                Boolean versionsShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.versions!= null)&&(!leftObject.versions.isEmpty())), ((rightObject.versions!= null)&&(!rightObject.versions.isEmpty())));
                if (versionsShouldBeMergedAndSet == Boolean.TRUE) {
                    List<Version> lhsVersions;
                    lhsVersions = (((leftObject.versions!= null)&&(!leftObject.versions.isEmpty()))?leftObject.getVersions():null);
                    List<Version> rhsVersions;
                    rhsVersions = (((rightObject.versions!= null)&&(!rightObject.versions.isEmpty()))?rightObject.getVersions():null);
                    List<Version> mergedVersions = ((List<Version> ) strategy.merge(LocatorUtils.property(leftLocator, "versions", lhsVersions), LocatorUtils.property(rightLocator, "versions", rhsVersions), lhsVersions, rhsVersions, ((leftObject.versions!= null)&&(!leftObject.versions.isEmpty())), ((rightObject.versions!= null)&&(!rightObject.versions.isEmpty()))));
                    target.versions = null;
                    if (mergedVersions!= null) {
                        List<Version> uniqueVersionsl = target.getVersions();
                        uniqueVersionsl.addAll(mergedVersions);
                    }
                } else {
                    if (versionsShouldBeMergedAndSet == Boolean.FALSE) {
                        target.versions = null;
                    }
                }
            }
            {
                Boolean descriptionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.description!= null), (rightObject.description!= null));
                if (descriptionShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsDescription;
                    lhsDescription = leftObject.getDescription();
                    String rhsDescription;
                    rhsDescription = rightObject.getDescription();
                    String mergedDescription = ((String) strategy.merge(LocatorUtils.property(leftLocator, "description", lhsDescription), LocatorUtils.property(rightLocator, "description", rhsDescription), lhsDescription, rhsDescription, (leftObject.description!= null), (rightObject.description!= null)));
                    target.setDescription(mergedDescription);
                } else {
                    if (descriptionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.description = null;
                    }
                }
            }
            {
                Boolean languageFeaturesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.languageFeatures!= null)&&(!leftObject.languageFeatures.isEmpty())), ((rightObject.languageFeatures!= null)&&(!rightObject.languageFeatures.isEmpty())));
                if (languageFeaturesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<LanguageFeatureList> lhsLanguageFeatures;
                    lhsLanguageFeatures = (((leftObject.languageFeatures!= null)&&(!leftObject.languageFeatures.isEmpty()))?leftObject.getLanguageFeatures():null);
                    List<LanguageFeatureList> rhsLanguageFeatures;
                    rhsLanguageFeatures = (((rightObject.languageFeatures!= null)&&(!rightObject.languageFeatures.isEmpty()))?rightObject.getLanguageFeatures():null);
                    List<LanguageFeatureList> mergedLanguageFeatures = ((List<LanguageFeatureList> ) strategy.merge(LocatorUtils.property(leftLocator, "languageFeatures", lhsLanguageFeatures), LocatorUtils.property(rightLocator, "languageFeatures", rhsLanguageFeatures), lhsLanguageFeatures, rhsLanguageFeatures, ((leftObject.languageFeatures!= null)&&(!leftObject.languageFeatures.isEmpty())), ((rightObject.languageFeatures!= null)&&(!rightObject.languageFeatures.isEmpty()))));
                    target.languageFeatures = null;
                    if (mergedLanguageFeatures!= null) {
                        List<LanguageFeatureList> uniqueLanguageFeaturesl = target.getLanguageFeatures();
                        uniqueLanguageFeaturesl.addAll(mergedLanguageFeatures);
                    }
                } else {
                    if (languageFeaturesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.languageFeatures = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new Language();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Language clone() {
        final Language _newObject;
        try {
            _newObject = ((Language) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.versions == null) {
            _newObject.versions = null;
        } else {
            _newObject.versions = new ArrayList<>();
            for (Version _item: this.versions) {
                _newObject.versions.add(((_item == null)?null:_item.clone()));
            }
        }
        if (this.languageFeatures == null) {
            _newObject.languageFeatures = null;
        } else {
            _newObject.languageFeatures = new ArrayList<>();
            for (LanguageFeatureList _item: this.languageFeatures) {
                _newObject.languageFeatures.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Language createCopy() {
        final Language _newObject;
        try {
            _newObject = ((Language) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.name = this.name;
        if (this.versions == null) {
            _newObject.versions = null;
        } else {
            _newObject.versions = new ArrayList<>();
            for (Version _item: this.versions) {
                _newObject.versions.add(((_item == null)?null:_item.createCopy()));
            }
        }
        _newObject.description = this.description;
        if (this.languageFeatures == null) {
            _newObject.languageFeatures = null;
        } else {
            _newObject.languageFeatures = new ArrayList<>();
            for (LanguageFeatureList _item: this.languageFeatures) {
                _newObject.languageFeatures.add(((_item == null)?null:_item.createCopy()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Language createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Language _newObject;
        try {
            _newObject = ((Language) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
            _newObject.name = this.name;
        }
        final PropertyTree versionsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("versions"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(versionsPropertyTree!= null):((versionsPropertyTree == null)||(!versionsPropertyTree.isLeaf())))) {
            if (this.versions == null) {
                _newObject.versions = null;
            } else {
                _newObject.versions = new ArrayList<>();
                for (Version _item: this.versions) {
                    _newObject.versions.add(((_item == null)?null:_item.createCopy(versionsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
            _newObject.description = this.description;
        }
        final PropertyTree languageFeaturesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("languageFeatures"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(languageFeaturesPropertyTree!= null):((languageFeaturesPropertyTree == null)||(!languageFeaturesPropertyTree.isLeaf())))) {
            if (this.languageFeatures == null) {
                _newObject.languageFeatures = null;
            } else {
                _newObject.languageFeatures = new ArrayList<>();
                for (LanguageFeatureList _item: this.languageFeatures) {
                    _newObject.languageFeatures.add(((_item == null)?null:_item.createCopy(languageFeaturesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Language copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Language copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Language.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new Language.Modifier();
        }
        return ((Language.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final Language.Builder<_B> _other) {
        _other.name = this.name;
        if (this.versions == null) {
            _other.versions = null;
        } else {
            _other.versions = new ArrayList<>();
            for (Version _item: this.versions) {
                _other.versions.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        _other.description = this.description;
        if (this.languageFeatures == null) {
            _other.languageFeatures = null;
        } else {
            _other.languageFeatures = new ArrayList<>();
            for (LanguageFeatureList _item: this.languageFeatures) {
                _other.languageFeatures.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >Language.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new Language.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Language.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Language.Builder<Void> builder() {
        return new Language.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Language.Builder<_B> copyOf(final Language _other) {
        final Language.Builder<_B> _newBuilder = new Language.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final Language.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
            _other.name = this.name;
        }
        final PropertyTree versionsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("versions"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(versionsPropertyTree!= null):((versionsPropertyTree == null)||(!versionsPropertyTree.isLeaf())))) {
            if (this.versions == null) {
                _other.versions = null;
            } else {
                _other.versions = new ArrayList<>();
                for (Version _item: this.versions) {
                    _other.versions.add(((_item == null)?null:_item.newCopyBuilder(_other, versionsPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
            _other.description = this.description;
        }
        final PropertyTree languageFeaturesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("languageFeatures"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(languageFeaturesPropertyTree!= null):((languageFeaturesPropertyTree == null)||(!languageFeaturesPropertyTree.isLeaf())))) {
            if (this.languageFeatures == null) {
                _other.languageFeatures = null;
            } else {
                _other.languageFeatures = new ArrayList<>();
                for (LanguageFeatureList _item: this.languageFeatures) {
                    _other.languageFeatures.add(((_item == null)?null:_item.newCopyBuilder(_other, languageFeaturesPropertyTree, _propertyTreeUse)));
                }
            }
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >Language.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new Language.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Language.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >Language.Builder<_B> copyOf(final Language _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final Language.Builder<_B> _newBuilder = new Language.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Language.Builder<Void> copyExcept(final Language _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static Language.Builder<Void> copyOnly(final Language _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Language visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(Language.PropInfo.NAME, this));
        if (_visitor_.visit(new CollectionProperty<>(Language.PropInfo.VERSIONS, this))&&(this.versions!= null)) {
            for (Version _item_: this.versions) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        _visitor_.visit(new SingleProperty<>(Language.PropInfo.DESCRIPTION, this));
        if (_visitor_.visit(new CollectionProperty<>(Language.PropInfo.LANGUAGE_FEATURES, this))&&(this.languageFeatures!= null)) {
            for (LanguageFeatureList _item_: this.languageFeatures) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final Language _storedValue;
        private String name;
        private List<Version.Builder<Language.Builder<_B>>> versions;
        private String description;
        private List<LanguageFeatureList.Builder<Language.Builder<_B>>> languageFeatures;

        public Builder(final _B _parentBuilder, final Language _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.name = _other.name;
                    if (_other.versions == null) {
                        this.versions = null;
                    } else {
                        this.versions = new ArrayList<>();
                        for (Version _item: _other.versions) {
                            this.versions.add(((_item == null)?null:_item.newCopyBuilder(this)));
                        }
                    }
                    this.description = _other.description;
                    if (_other.languageFeatures == null) {
                        this.languageFeatures = null;
                    } else {
                        this.languageFeatures = new ArrayList<>();
                        for (LanguageFeatureList _item: _other.languageFeatures) {
                            this.languageFeatures.add(((_item == null)?null:_item.newCopyBuilder(this)));
                        }
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final Language _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
                        this.name = _other.name;
                    }
                    final PropertyTree versionsPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("versions"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(versionsPropertyTree!= null):((versionsPropertyTree == null)||(!versionsPropertyTree.isLeaf())))) {
                        if (_other.versions == null) {
                            this.versions = null;
                        } else {
                            this.versions = new ArrayList<>();
                            for (Version _item: _other.versions) {
                                this.versions.add(((_item == null)?null:_item.newCopyBuilder(this, versionsPropertyTree, _propertyTreeUse)));
                            }
                        }
                    }
                    final PropertyTree descriptionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("description"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(descriptionPropertyTree!= null):((descriptionPropertyTree == null)||(!descriptionPropertyTree.isLeaf())))) {
                        this.description = _other.description;
                    }
                    final PropertyTree languageFeaturesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("languageFeatures"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(languageFeaturesPropertyTree!= null):((languageFeaturesPropertyTree == null)||(!languageFeaturesPropertyTree.isLeaf())))) {
                        if (_other.languageFeatures == null) {
                            this.languageFeatures = null;
                        } else {
                            this.languageFeatures = new ArrayList<>();
                            for (LanguageFeatureList _item: _other.languageFeatures) {
                                this.languageFeatures.add(((_item == null)?null:_item.newCopyBuilder(this, languageFeaturesPropertyTree, _propertyTreeUse)));
                            }
                        }
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends Language >_P init(final _P _product) {
            _product.name = this.name;
            if (this.versions!= null) {
                final List<Version> versions = new ArrayList<>(this.versions.size());
                for (Version.Builder<Language.Builder<_B>> _item: this.versions) {
                    versions.add(_item.build());
                }
                _product.versions = versions;
            }
            _product.description = this.description;
            if (this.languageFeatures!= null) {
                final List<LanguageFeatureList> languageFeatures = new ArrayList<>(this.languageFeatures.size());
                for (LanguageFeatureList.Builder<Language.Builder<_B>> _item: this.languageFeatures) {
                    languageFeatures.add(_item.build());
                }
                _product.languageFeatures = languageFeatures;
            }
            return _product;
        }

        /**
         * Sets the new value of "name" (any previous value will be replaced)
         * 
         * @param name
         *     New value of the "name" property.
         */
        public Language.Builder<_B> withName(final String name) {
            this.name = name;
            return this;
        }

        /**
         * Adds the given items to the value of "versions"
         * 
         * @param versions
         *     Items to add to the value of the "versions" property
         */
        public Language.Builder<_B> addVersions(final Iterable<? extends Version> versions) {
            if (versions!= null) {
                if (this.versions == null) {
                    this.versions = new ArrayList<>();
                }
                for (Version _item: versions) {
                    this.versions.add(new Version.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "versions" (any previous value will be replaced)
         * 
         * @param versions
         *     New value of the "versions" property.
         */
        public Language.Builder<_B> withVersions(final Iterable<? extends Version> versions) {
            if (this.versions!= null) {
                this.versions.clear();
            }
            return addVersions(versions);
        }

        /**
         * Adds the given items to the value of "versions"
         * 
         * @param versions
         *     Items to add to the value of the "versions" property
         */
        public Language.Builder<_B> addVersions(Version... versions) {
            addVersions(Arrays.asList(versions));
            return this;
        }

        /**
         * Sets the new value of "versions" (any previous value will be replaced)
         * 
         * @param versions
         *     New value of the "versions" property.
         */
        public Language.Builder<_B> withVersions(Version... versions) {
            withVersions(Arrays.asList(versions));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Versions" property.
         * Use {@link org.javastro.ivoa.entities.resource.tap.Version.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Versions" property.
         *     Use {@link org.javastro.ivoa.entities.resource.tap.Version.Builder#end()} to
         *     return to the current builder.
         */
        public Version.Builder<? extends Language.Builder<_B>> addVersions() {
            if (this.versions == null) {
                this.versions = new ArrayList<>();
            }
            final Version.Builder<Language.Builder<_B>> versions_Builder = new Version.Builder<>(this, null, false);
            this.versions.add(versions_Builder);
            return versions_Builder;
        }

        /**
         * Sets the new value of "description" (any previous value will be replaced)
         * 
         * @param description
         *     New value of the "description" property.
         */
        public Language.Builder<_B> withDescription(final String description) {
            this.description = description;
            return this;
        }

        /**
         * Adds the given items to the value of "languageFeatures"
         * 
         * @param languageFeatures
         *     Items to add to the value of the "languageFeatures" property
         */
        public Language.Builder<_B> addLanguageFeatures(final Iterable<? extends LanguageFeatureList> languageFeatures) {
            if (languageFeatures!= null) {
                if (this.languageFeatures == null) {
                    this.languageFeatures = new ArrayList<>();
                }
                for (LanguageFeatureList _item: languageFeatures) {
                    this.languageFeatures.add(new LanguageFeatureList.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "languageFeatures" (any previous value will be replaced)
         * 
         * @param languageFeatures
         *     New value of the "languageFeatures" property.
         */
        public Language.Builder<_B> withLanguageFeatures(final Iterable<? extends LanguageFeatureList> languageFeatures) {
            if (this.languageFeatures!= null) {
                this.languageFeatures.clear();
            }
            return addLanguageFeatures(languageFeatures);
        }

        /**
         * Adds the given items to the value of "languageFeatures"
         * 
         * @param languageFeatures
         *     Items to add to the value of the "languageFeatures" property
         */
        public Language.Builder<_B> addLanguageFeatures(LanguageFeatureList... languageFeatures) {
            addLanguageFeatures(Arrays.asList(languageFeatures));
            return this;
        }

        /**
         * Sets the new value of "languageFeatures" (any previous value will be replaced)
         * 
         * @param languageFeatures
         *     New value of the "languageFeatures" property.
         */
        public Language.Builder<_B> withLanguageFeatures(LanguageFeatureList... languageFeatures) {
            withLanguageFeatures(Arrays.asList(languageFeatures));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "LanguageFeatures"
         * property.
         * Use {@link
         * org.javastro.ivoa.entities.resource.tap.LanguageFeatureList.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "LanguageFeatures" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.resource.tap.LanguageFeatureList.Builder#end()} to
         *     return to the current builder.
         */
        public LanguageFeatureList.Builder<? extends Language.Builder<_B>> addLanguageFeatures() {
            if (this.languageFeatures == null) {
                this.languageFeatures = new ArrayList<>();
            }
            final LanguageFeatureList.Builder<Language.Builder<_B>> languageFeatures_Builder = new LanguageFeatureList.Builder<>(this, null, false);
            this.languageFeatures.add(languageFeatures_Builder);
            return languageFeatures_Builder;
        }

        @Override
        public Language build() {
            if (_storedValue == null) {
                return this.init(new Language());
            } else {
                return ((Language) _storedValue);
            }
        }

        public Language.Builder<_B> copyOf(final Language _other) {
            _other.copyTo(this);
            return this;
        }

        public Language.Builder<_B> copyOf(final Language.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setName(final String name) {
            Language.this.setName(name);
        }

        public List<Version> getVersions() {
            if (Language.this.versions == null) {
                Language.this.versions = new ArrayList<>();
            }
            return Language.this.versions;
        }

        public void setDescription(final String description) {
            Language.this.setDescription(description);
        }

        public List<LanguageFeatureList> getLanguageFeatures() {
            if (Language.this.languageFeatures == null) {
                Language.this.languageFeatures = new ArrayList<>();
            }
            return Language.this.languageFeatures;
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<Language, String> NAME = new SinglePropertyInfo<Language,String>("name", Language.class, String.class, false, null, new QName("", "name"), new QName("http://www.w3.org/2001/XMLSchema", "NCName"), false) {


            @Override
            public String get(final Language _instance_) {
                return ((_instance_ == null)?null:_instance_.name);
            }

            @Override
            public void set(final Language _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.name = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Language, Version> VERSIONS = new CollectionPropertyInfo<Language,Version>("versions", Language.class, Version.class, true, null, new QName("", "version"), new QName("http://www.ivoa.net/xml/TAPRegExt/v1.0", "Version"), false) {


            @Override
            public List<Version> get(final Language _instance_) {
                return ((_instance_ == null)?null:_instance_.versions);
            }

            @Override
            public void set(final Language _instance_, final List<Version> _value_) {
                if (_instance_!= null) {
                    _instance_.versions = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<Language, String> DESCRIPTION = new SinglePropertyInfo<Language,String>("description", Language.class, String.class, false, null, new QName("", "description"), new QName("http://www.w3.org/2001/XMLSchema", "token"), false) {


            @Override
            public String get(final Language _instance_) {
                return ((_instance_ == null)?null:_instance_.description);
            }

            @Override
            public void set(final Language _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.description = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<Language, LanguageFeatureList> LANGUAGE_FEATURES = new CollectionPropertyInfo<Language,LanguageFeatureList>("languageFeatures", Language.class, LanguageFeatureList.class, true, null, new QName("", "languageFeatures"), new QName("http://www.ivoa.net/xml/TAPRegExt/v1.0", "LanguageFeatureList"), false) {


            @Override
            public List<LanguageFeatureList> get(final Language _instance_) {
                return ((_instance_ == null)?null:_instance_.languageFeatures);
            }

            @Override
            public void set(final Language _instance_, final List<LanguageFeatureList> _value_) {
                if (_instance_!= null) {
                    _instance_.languageFeatures = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends Language.Selector<Language.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static Language.Select _root() {
            return new Language.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, Language.Selector<TRoot, TParent>> name = null;
        private Version.Selector<TRoot, Language.Selector<TRoot, TParent>> versions = null;
        private com.kscs.util.jaxb.Selector<TRoot, Language.Selector<TRoot, TParent>> description = null;
        private LanguageFeatureList.Selector<TRoot, Language.Selector<TRoot, TParent>> languageFeatures = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.name!= null) {
                products.put("name", this.name.init());
            }
            if (this.versions!= null) {
                products.put("versions", this.versions.init());
            }
            if (this.description!= null) {
                products.put("description", this.description.init());
            }
            if (this.languageFeatures!= null) {
                products.put("languageFeatures", this.languageFeatures.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, Language.Selector<TRoot, TParent>> name() {
            return ((this.name == null)?this.name = new com.kscs.util.jaxb.Selector<>(this._root, this, "name"):this.name);
        }

        public Version.Selector<TRoot, Language.Selector<TRoot, TParent>> versions() {
            return ((this.versions == null)?this.versions = new Version.Selector<>(this._root, this, "versions"):this.versions);
        }

        public com.kscs.util.jaxb.Selector<TRoot, Language.Selector<TRoot, TParent>> description() {
            return ((this.description == null)?this.description = new com.kscs.util.jaxb.Selector<>(this._root, this, "description"):this.description);
        }

        public LanguageFeatureList.Selector<TRoot, Language.Selector<TRoot, TParent>> languageFeatures() {
            return ((this.languageFeatures == null)?this.languageFeatures = new LanguageFeatureList.Selector<>(this._root, this, "languageFeatures"):this.languageFeatures);
        }

    }

}
