
package org.javastro.ivoa.entities.resource.tap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * A feature type is a language-dependent concept like 
 *     		"user defined function", "geometry support", or possibly 
 *     		"units supported".  A featureList gives all features of
 *     		a given type applicable for the service.  Multiple featureLists
 *     		are possible.
 * 
 *       	All feature in a given list are of the same type.  This type
 *       	is declared using the mandatory type attribute,
 *       	the value of which will typically be an IVORN.
 *       	To see values defined in TAPRegExt,
 * 				retrieve the ivo://ivoa.net/std/TAPRegExt
 *       	resource record and look for keys starting with "features-".
 * 
 * <p>Java class for LanguageFeatureList complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="LanguageFeatureList">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="feature" type="{http://www.ivoa.net/xml/TAPRegExt/v1.0}LanguageFeature" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="type" use="required" type="{http://www.w3.org/2001/XMLSchema}anyURI" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "LanguageFeatureList", propOrder = {
    "features"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class LanguageFeatureList implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * A language feature of the type given by this
     * 						element's type attribute.
     * 
     */
    @XmlElement(name = "feature")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<LanguageFeature> features;
    /**
     * This is in general an IVORN.  TAPRegExt itself gives
     * 					IVORNs for defining user defined functions and geometry
     * 					support.
     * 
     */
    @XmlAttribute(name = "type", required = true)
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String type;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected transient LanguageFeatureList.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public LanguageFeatureList() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public LanguageFeatureList(final List<LanguageFeature> features, final String type) {
        this.features = features;
        this.type = type;
    }

    /**
     * A language feature of the type given by this
     * 						element's type attribute.
     * 
     * Gets the value of the features property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the features property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFeatures().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LanguageFeature }
     * </p>
     * 
     * 
     * @return
     *     The value of the features property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<LanguageFeature> getFeatures() {
        if (features == null) {
            features = new ArrayList<>();
        }
        return this.features;
    }

    /**
     * This is in general an IVORN.  TAPRegExt itself gives
     * 					IVORNs for defining user defined functions and geometry
     * 					support.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getType() {
        return type;
    }

    /**
     * Sets the value of the type property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getType()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setType(String value) {
        this.type = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final LanguageFeatureList that = ((LanguageFeatureList) object);
        {
            List<LanguageFeature> leftFeatures;
            leftFeatures = (((this.features!= null)&&(!this.features.isEmpty()))?this.getFeatures():null);
            List<LanguageFeature> rightFeatures;
            rightFeatures = (((that.features!= null)&&(!that.features.isEmpty()))?that.getFeatures():null);
            if ((this.features!= null)&&(!this.features.isEmpty())) {
                if ((that.features!= null)&&(!that.features.isEmpty())) {
                    if (!leftFeatures.equals(rightFeatures)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.features!= null)&&(!that.features.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftType;
            leftType = this.getType();
            String rightType;
            rightType = that.getType();
            if (this.type!= null) {
                if (that.type!= null) {
                    if (!leftType.equals(rightType)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.type!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            List<LanguageFeature> theFeatures;
            theFeatures = (((this.features!= null)&&(!this.features.isEmpty()))?this.getFeatures():null);
            if ((this.features!= null)&&(!this.features.isEmpty())) {
                currentHashCode += theFeatures.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theType;
            theType = this.getType();
            if (this.type!= null) {
                currentHashCode += theType.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            List<LanguageFeature> theFeatures;
            theFeatures = (((this.features!= null)&&(!this.features.isEmpty()))?this.getFeatures():null);
            strategy.appendField(locator, this, "features", buffer, theFeatures, ((this.features!= null)&&(!this.features.isEmpty())));
        }
        {
            String theType;
            theType = this.getType();
            strategy.appendField(locator, this, "type", buffer, theType, (this.type!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof LanguageFeatureList) {
            final LanguageFeatureList target = this;
            final LanguageFeatureList leftObject = ((LanguageFeatureList) left);
            final LanguageFeatureList rightObject = ((LanguageFeatureList) right);
            {
                Boolean featuresShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.features!= null)&&(!leftObject.features.isEmpty())), ((rightObject.features!= null)&&(!rightObject.features.isEmpty())));
                if (featuresShouldBeMergedAndSet == Boolean.TRUE) {
                    List<LanguageFeature> lhsFeatures;
                    lhsFeatures = (((leftObject.features!= null)&&(!leftObject.features.isEmpty()))?leftObject.getFeatures():null);
                    List<LanguageFeature> rhsFeatures;
                    rhsFeatures = (((rightObject.features!= null)&&(!rightObject.features.isEmpty()))?rightObject.getFeatures():null);
                    List<LanguageFeature> mergedFeatures = ((List<LanguageFeature> ) strategy.merge(LocatorUtils.property(leftLocator, "features", lhsFeatures), LocatorUtils.property(rightLocator, "features", rhsFeatures), lhsFeatures, rhsFeatures, ((leftObject.features!= null)&&(!leftObject.features.isEmpty())), ((rightObject.features!= null)&&(!rightObject.features.isEmpty()))));
                    target.features = null;
                    if (mergedFeatures!= null) {
                        List<LanguageFeature> uniqueFeaturesl = target.getFeatures();
                        uniqueFeaturesl.addAll(mergedFeatures);
                    }
                } else {
                    if (featuresShouldBeMergedAndSet == Boolean.FALSE) {
                        target.features = null;
                    }
                }
            }
            {
                Boolean typeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.type!= null), (rightObject.type!= null));
                if (typeShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsType;
                    lhsType = leftObject.getType();
                    String rhsType;
                    rhsType = rightObject.getType();
                    String mergedType = ((String) strategy.merge(LocatorUtils.property(leftLocator, "type", lhsType), LocatorUtils.property(rightLocator, "type", rhsType), lhsType, rhsType, (leftObject.type!= null), (rightObject.type!= null)));
                    target.setType(mergedType);
                } else {
                    if (typeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.type = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new LanguageFeatureList();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public LanguageFeatureList clone() {
        final LanguageFeatureList _newObject;
        try {
            _newObject = ((LanguageFeatureList) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.features == null) {
            _newObject.features = null;
        } else {
            _newObject.features = new ArrayList<>();
            for (LanguageFeature _item: this.features) {
                _newObject.features.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public LanguageFeatureList createCopy() {
        final LanguageFeatureList _newObject;
        try {
            _newObject = ((LanguageFeatureList) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (this.features == null) {
            _newObject.features = null;
        } else {
            _newObject.features = new ArrayList<>();
            for (LanguageFeature _item: this.features) {
                _newObject.features.add(((_item == null)?null:_item.createCopy()));
            }
        }
        _newObject.type = this.type;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public LanguageFeatureList createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final LanguageFeatureList _newObject;
        try {
            _newObject = ((LanguageFeatureList) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree featuresPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("features"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(featuresPropertyTree!= null):((featuresPropertyTree == null)||(!featuresPropertyTree.isLeaf())))) {
            if (this.features == null) {
                _newObject.features = null;
            } else {
                _newObject.features = new ArrayList<>();
                for (LanguageFeature _item: this.features) {
                    _newObject.features.add(((_item == null)?null:_item.createCopy(featuresPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree typePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("type"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(typePropertyTree!= null):((typePropertyTree == null)||(!typePropertyTree.isLeaf())))) {
            _newObject.type = this.type;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public LanguageFeatureList copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public LanguageFeatureList copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public LanguageFeatureList.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new LanguageFeatureList.Modifier();
        }
        return ((LanguageFeatureList.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final LanguageFeatureList.Builder<_B> _other) {
        if (this.features == null) {
            _other.features = null;
        } else {
            _other.features = new ArrayList<>();
            for (LanguageFeature _item: this.features) {
                _other.features.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
        _other.type = this.type;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >LanguageFeatureList.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new LanguageFeatureList.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public LanguageFeatureList.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static LanguageFeatureList.Builder<Void> builder() {
        return new LanguageFeatureList.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >LanguageFeatureList.Builder<_B> copyOf(final LanguageFeatureList _other) {
        final LanguageFeatureList.Builder<_B> _newBuilder = new LanguageFeatureList.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final LanguageFeatureList.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree featuresPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("features"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(featuresPropertyTree!= null):((featuresPropertyTree == null)||(!featuresPropertyTree.isLeaf())))) {
            if (this.features == null) {
                _other.features = null;
            } else {
                _other.features = new ArrayList<>();
                for (LanguageFeature _item: this.features) {
                    _other.features.add(((_item == null)?null:_item.newCopyBuilder(_other, featuresPropertyTree, _propertyTreeUse)));
                }
            }
        }
        final PropertyTree typePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("type"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(typePropertyTree!= null):((typePropertyTree == null)||(!typePropertyTree.isLeaf())))) {
            _other.type = this.type;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >LanguageFeatureList.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new LanguageFeatureList.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public LanguageFeatureList.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >LanguageFeatureList.Builder<_B> copyOf(final LanguageFeatureList _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final LanguageFeatureList.Builder<_B> _newBuilder = new LanguageFeatureList.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static LanguageFeatureList.Builder<Void> copyExcept(final LanguageFeatureList _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static LanguageFeatureList.Builder<Void> copyOnly(final LanguageFeatureList _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public LanguageFeatureList visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        if (_visitor_.visit(new CollectionProperty<>(LanguageFeatureList.PropInfo.FEATURES, this))&&(this.features!= null)) {
            for (LanguageFeature _item_: this.features) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        _visitor_.visit(new SingleProperty<>(LanguageFeatureList.PropInfo.TYPE, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final LanguageFeatureList _storedValue;
        private List<LanguageFeature.Builder<LanguageFeatureList.Builder<_B>>> features;
        private String type;

        public Builder(final _B _parentBuilder, final LanguageFeatureList _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    if (_other.features == null) {
                        this.features = null;
                    } else {
                        this.features = new ArrayList<>();
                        for (LanguageFeature _item: _other.features) {
                            this.features.add(((_item == null)?null:_item.newCopyBuilder(this)));
                        }
                    }
                    this.type = _other.type;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final LanguageFeatureList _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree featuresPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("features"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(featuresPropertyTree!= null):((featuresPropertyTree == null)||(!featuresPropertyTree.isLeaf())))) {
                        if (_other.features == null) {
                            this.features = null;
                        } else {
                            this.features = new ArrayList<>();
                            for (LanguageFeature _item: _other.features) {
                                this.features.add(((_item == null)?null:_item.newCopyBuilder(this, featuresPropertyTree, _propertyTreeUse)));
                            }
                        }
                    }
                    final PropertyTree typePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("type"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(typePropertyTree!= null):((typePropertyTree == null)||(!typePropertyTree.isLeaf())))) {
                        this.type = _other.type;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends LanguageFeatureList >_P init(final _P _product) {
            if (this.features!= null) {
                final List<LanguageFeature> features = new ArrayList<>(this.features.size());
                for (LanguageFeature.Builder<LanguageFeatureList.Builder<_B>> _item: this.features) {
                    features.add(_item.build());
                }
                _product.features = features;
            }
            _product.type = this.type;
            return _product;
        }

        /**
         * Adds the given items to the value of "features"
         * 
         * @param features
         *     Items to add to the value of the "features" property
         */
        public LanguageFeatureList.Builder<_B> addFeatures(final Iterable<? extends LanguageFeature> features) {
            if (features!= null) {
                if (this.features == null) {
                    this.features = new ArrayList<>();
                }
                for (LanguageFeature _item: features) {
                    this.features.add(new LanguageFeature.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "features" (any previous value will be replaced)
         * 
         * @param features
         *     New value of the "features" property.
         */
        public LanguageFeatureList.Builder<_B> withFeatures(final Iterable<? extends LanguageFeature> features) {
            if (this.features!= null) {
                this.features.clear();
            }
            return addFeatures(features);
        }

        /**
         * Adds the given items to the value of "features"
         * 
         * @param features
         *     Items to add to the value of the "features" property
         */
        public LanguageFeatureList.Builder<_B> addFeatures(LanguageFeature... features) {
            addFeatures(Arrays.asList(features));
            return this;
        }

        /**
         * Sets the new value of "features" (any previous value will be replaced)
         * 
         * @param features
         *     New value of the "features" property.
         */
        public LanguageFeatureList.Builder<_B> withFeatures(LanguageFeature... features) {
            withFeatures(Arrays.asList(features));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "Features" property.
         * Use {@link
         * org.javastro.ivoa.entities.resource.tap.LanguageFeature.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "Features" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.resource.tap.LanguageFeature.Builder#end()} to return
         *     to the current builder.
         */
        public LanguageFeature.Builder<? extends LanguageFeatureList.Builder<_B>> addFeatures() {
            if (this.features == null) {
                this.features = new ArrayList<>();
            }
            final LanguageFeature.Builder<LanguageFeatureList.Builder<_B>> features_Builder = new LanguageFeature.Builder<>(this, null, false);
            this.features.add(features_Builder);
            return features_Builder;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        public LanguageFeatureList.Builder<_B> withType(final String type) {
            this.type = type;
            return this;
        }

        @Override
        public LanguageFeatureList build() {
            if (_storedValue == null) {
                return this.init(new LanguageFeatureList());
            } else {
                return ((LanguageFeatureList) _storedValue);
            }
        }

        public LanguageFeatureList.Builder<_B> copyOf(final LanguageFeatureList _other) {
            _other.copyTo(this);
            return this;
        }

        public LanguageFeatureList.Builder<_B> copyOf(final LanguageFeatureList.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public List<LanguageFeature> getFeatures() {
            if (LanguageFeatureList.this.features == null) {
                LanguageFeatureList.this.features = new ArrayList<>();
            }
            return LanguageFeatureList.this.features;
        }

        public void setType(final String type) {
            LanguageFeatureList.this.setType(type);
        }

    }

    public static class PropInfo {

        public static final transient CollectionPropertyInfo<LanguageFeatureList, LanguageFeature> FEATURES = new CollectionPropertyInfo<LanguageFeatureList,LanguageFeature>("features", LanguageFeatureList.class, LanguageFeature.class, true, null, new QName("", "feature"), new QName("http://www.ivoa.net/xml/TAPRegExt/v1.0", "LanguageFeature"), false) {


            @Override
            public List<LanguageFeature> get(final LanguageFeatureList _instance_) {
                return ((_instance_ == null)?null:_instance_.features);
            }

            @Override
            public void set(final LanguageFeatureList _instance_, final List<LanguageFeature> _value_) {
                if (_instance_!= null) {
                    _instance_.features = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<LanguageFeatureList, String> TYPE = new SinglePropertyInfo<LanguageFeatureList,String>("type", LanguageFeatureList.class, String.class, false, null, new QName("", "type"), new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), true) {


            @Override
            public String get(final LanguageFeatureList _instance_) {
                return ((_instance_ == null)?null:_instance_.type);
            }

            @Override
            public void set(final LanguageFeatureList _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.type = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends LanguageFeatureList.Selector<LanguageFeatureList.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static LanguageFeatureList.Select _root() {
            return new LanguageFeatureList.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private LanguageFeature.Selector<TRoot, LanguageFeatureList.Selector<TRoot, TParent>> features = null;
        private com.kscs.util.jaxb.Selector<TRoot, LanguageFeatureList.Selector<TRoot, TParent>> type = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.features!= null) {
                products.put("features", this.features.init());
            }
            if (this.type!= null) {
                products.put("type", this.type.init());
            }
            return products;
        }

        public LanguageFeature.Selector<TRoot, LanguageFeatureList.Selector<TRoot, TParent>> features() {
            return ((this.features == null)?this.features = new LanguageFeature.Selector<>(this._root, this, "features"):this.features);
        }

        public com.kscs.util.jaxb.Selector<TRoot, LanguageFeatureList.Selector<TRoot, TParent>> type() {
            return ((this.type == null)?this.type = new com.kscs.util.jaxb.Selector<>(this._root, this, "type"):this.type);
        }

    }

}
