
package org.javastro.ivoa.entities.resource.tap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * All TAP services must support VOTable output, preserving
 *       the MIME type of the input.  Other output formats are
 *       optional.
 * 
 *       The primary identifier for an output format is the MIME
 *       type.  If you want to register an output format, you must
 *       use a MIME type (or make one up using the x- syntax), although
 *       the concrete MIME syntax is not enforced by the schema.
 * 
 *       For more detailed specification, an IVORN may be used.
 * 
 * <p>Java class for OutputFormat complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="OutputFormat">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="mime" type="{http://www.w3.org/2001/XMLSchema}token"/>
 *         <element name="alias" type="{http://www.w3.org/2001/XMLSchema}token" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="ivo-id" type="{http://www.w3.org/2001/XMLSchema}anyURI" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "OutputFormat", propOrder = {
    "mime",
    "alias"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class OutputFormat implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The format of this string is specified by RFC 2045.
     *           The service has to accept this string as a 
     *           value of the FORMAT parameter.
     * 
     */
    @XmlElement(required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String mime;
    /**
     * Other values of FORMAT ("shorthands") that make the service return 
     *           documents with the MIME type.
     * 
     */
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "token")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<String> alias;
    /**
     * When the MIME type does not uniquely define the
     *         	format (or a generic MIME like application/octet-stream or
     *         	text/plain is given), the IVORN can point to a key
     *         	or StandardsRegExt document defining the format more
     *         	precisely.  To see values defined in TAPRegExt,
     * 					retrieve the ivo://ivoa.net/std/TAPRegExt
     *       		resource record and look for keys starting with "output-".
     * 
     */
    @XmlAttribute(name = "ivo-id")
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String ivoId;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected transient OutputFormat.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public OutputFormat() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public OutputFormat(final String mime, final List<String> alias, final String ivoId) {
        this.mime = mime;
        this.alias = alias;
        this.ivoId = ivoId;
    }

    /**
     * The format of this string is specified by RFC 2045.
     *           The service has to accept this string as a 
     *           value of the FORMAT parameter.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getMime() {
        return mime;
    }

    /**
     * Sets the value of the mime property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getMime()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setMime(String value) {
        this.mime = value;
    }

    /**
     * Other values of FORMAT ("shorthands") that make the service return 
     *           documents with the MIME type.
     * 
     * Gets the value of the alias property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the alias property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAlias().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * </p>
     * 
     * 
     * @return
     *     The value of the alias property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<String> getAlias() {
        if (alias == null) {
            alias = new ArrayList<>();
        }
        return this.alias;
    }

    /**
     * When the MIME type does not uniquely define the
     *         	format (or a generic MIME like application/octet-stream or
     *         	text/plain is given), the IVORN can point to a key
     *         	or StandardsRegExt document defining the format more
     *         	precisely.  To see values defined in TAPRegExt,
     * 					retrieve the ivo://ivoa.net/std/TAPRegExt
     *       		resource record and look for keys starting with "output-".
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getIvoId() {
        return ivoId;
    }

    /**
     * Sets the value of the ivoId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getIvoId()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setIvoId(String value) {
        this.ivoId = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final OutputFormat that = ((OutputFormat) object);
        {
            String leftMime;
            leftMime = this.getMime();
            String rightMime;
            rightMime = that.getMime();
            if (this.mime!= null) {
                if (that.mime!= null) {
                    if (!leftMime.equals(rightMime)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.mime!= null) {
                    return false;
                }
            }
        }
        {
            List<String> leftAlias;
            leftAlias = (((this.alias!= null)&&(!this.alias.isEmpty()))?this.getAlias():null);
            List<String> rightAlias;
            rightAlias = (((that.alias!= null)&&(!that.alias.isEmpty()))?that.getAlias():null);
            if ((this.alias!= null)&&(!this.alias.isEmpty())) {
                if ((that.alias!= null)&&(!that.alias.isEmpty())) {
                    if (!leftAlias.equals(rightAlias)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.alias!= null)&&(!that.alias.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftIvoId;
            leftIvoId = this.getIvoId();
            String rightIvoId;
            rightIvoId = that.getIvoId();
            if (this.ivoId!= null) {
                if (that.ivoId!= null) {
                    if (!leftIvoId.equals(rightIvoId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.ivoId!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theMime;
            theMime = this.getMime();
            if (this.mime!= null) {
                currentHashCode += theMime.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theAlias;
            theAlias = (((this.alias!= null)&&(!this.alias.isEmpty()))?this.getAlias():null);
            if ((this.alias!= null)&&(!this.alias.isEmpty())) {
                currentHashCode += theAlias.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theIvoId;
            theIvoId = this.getIvoId();
            if (this.ivoId!= null) {
                currentHashCode += theIvoId.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theMime;
            theMime = this.getMime();
            strategy.appendField(locator, this, "mime", buffer, theMime, (this.mime!= null));
        }
        {
            List<String> theAlias;
            theAlias = (((this.alias!= null)&&(!this.alias.isEmpty()))?this.getAlias():null);
            strategy.appendField(locator, this, "alias", buffer, theAlias, ((this.alias!= null)&&(!this.alias.isEmpty())));
        }
        {
            String theIvoId;
            theIvoId = this.getIvoId();
            strategy.appendField(locator, this, "ivoId", buffer, theIvoId, (this.ivoId!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof OutputFormat) {
            final OutputFormat target = this;
            final OutputFormat leftObject = ((OutputFormat) left);
            final OutputFormat rightObject = ((OutputFormat) right);
            {
                Boolean mimeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.mime!= null), (rightObject.mime!= null));
                if (mimeShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsMime;
                    lhsMime = leftObject.getMime();
                    String rhsMime;
                    rhsMime = rightObject.getMime();
                    String mergedMime = ((String) strategy.merge(LocatorUtils.property(leftLocator, "mime", lhsMime), LocatorUtils.property(rightLocator, "mime", rhsMime), lhsMime, rhsMime, (leftObject.mime!= null), (rightObject.mime!= null)));
                    target.setMime(mergedMime);
                } else {
                    if (mimeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.mime = null;
                    }
                }
            }
            {
                Boolean aliasShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.alias!= null)&&(!leftObject.alias.isEmpty())), ((rightObject.alias!= null)&&(!rightObject.alias.isEmpty())));
                if (aliasShouldBeMergedAndSet == Boolean.TRUE) {
                    List<String> lhsAlias;
                    lhsAlias = (((leftObject.alias!= null)&&(!leftObject.alias.isEmpty()))?leftObject.getAlias():null);
                    List<String> rhsAlias;
                    rhsAlias = (((rightObject.alias!= null)&&(!rightObject.alias.isEmpty()))?rightObject.getAlias():null);
                    List<String> mergedAlias = ((List<String> ) strategy.merge(LocatorUtils.property(leftLocator, "alias", lhsAlias), LocatorUtils.property(rightLocator, "alias", rhsAlias), lhsAlias, rhsAlias, ((leftObject.alias!= null)&&(!leftObject.alias.isEmpty())), ((rightObject.alias!= null)&&(!rightObject.alias.isEmpty()))));
                    target.alias = null;
                    if (mergedAlias!= null) {
                        List<String> uniqueAliasl = target.getAlias();
                        uniqueAliasl.addAll(mergedAlias);
                    }
                } else {
                    if (aliasShouldBeMergedAndSet == Boolean.FALSE) {
                        target.alias = null;
                    }
                }
            }
            {
                Boolean ivoIdShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.ivoId!= null), (rightObject.ivoId!= null));
                if (ivoIdShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsIvoId;
                    lhsIvoId = leftObject.getIvoId();
                    String rhsIvoId;
                    rhsIvoId = rightObject.getIvoId();
                    String mergedIvoId = ((String) strategy.merge(LocatorUtils.property(leftLocator, "ivoId", lhsIvoId), LocatorUtils.property(rightLocator, "ivoId", rhsIvoId), lhsIvoId, rhsIvoId, (leftObject.ivoId!= null), (rightObject.ivoId!= null)));
                    target.setIvoId(mergedIvoId);
                } else {
                    if (ivoIdShouldBeMergedAndSet == Boolean.FALSE) {
                        target.ivoId = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new OutputFormat();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public OutputFormat clone() {
        final OutputFormat _newObject;
        try {
            _newObject = ((OutputFormat) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.alias = ((this.alias == null)?null:new ArrayList<>(this.alias));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public OutputFormat createCopy() {
        final OutputFormat _newObject;
        try {
            _newObject = ((OutputFormat) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.mime = this.mime;
        _newObject.alias = ((this.alias == null)?null:new ArrayList<>(this.alias));
        _newObject.ivoId = this.ivoId;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public OutputFormat createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final OutputFormat _newObject;
        try {
            _newObject = ((OutputFormat) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree mimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("mime"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(mimePropertyTree!= null):((mimePropertyTree == null)||(!mimePropertyTree.isLeaf())))) {
            _newObject.mime = this.mime;
        }
        final PropertyTree aliasPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("alias"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(aliasPropertyTree!= null):((aliasPropertyTree == null)||(!aliasPropertyTree.isLeaf())))) {
            _newObject.alias = ((this.alias == null)?null:new ArrayList<>(this.alias));
        }
        final PropertyTree ivoIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ivoId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(ivoIdPropertyTree!= null):((ivoIdPropertyTree == null)||(!ivoIdPropertyTree.isLeaf())))) {
            _newObject.ivoId = this.ivoId;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public OutputFormat copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public OutputFormat copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public OutputFormat.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new OutputFormat.Modifier();
        }
        return ((OutputFormat.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final OutputFormat.Builder<_B> _other) {
        _other.mime = this.mime;
        if (this.alias == null) {
            _other.alias = null;
        } else {
            _other.alias = new ArrayList<>();
            for (String _item: this.alias) {
                _other.alias.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
        _other.ivoId = this.ivoId;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >OutputFormat.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new OutputFormat.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public OutputFormat.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static OutputFormat.Builder<Void> builder() {
        return new OutputFormat.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >OutputFormat.Builder<_B> copyOf(final OutputFormat _other) {
        final OutputFormat.Builder<_B> _newBuilder = new OutputFormat.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final OutputFormat.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree mimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("mime"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(mimePropertyTree!= null):((mimePropertyTree == null)||(!mimePropertyTree.isLeaf())))) {
            _other.mime = this.mime;
        }
        final PropertyTree aliasPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("alias"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(aliasPropertyTree!= null):((aliasPropertyTree == null)||(!aliasPropertyTree.isLeaf())))) {
            if (this.alias == null) {
                _other.alias = null;
            } else {
                _other.alias = new ArrayList<>();
                for (String _item: this.alias) {
                    _other.alias.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
        final PropertyTree ivoIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ivoId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(ivoIdPropertyTree!= null):((ivoIdPropertyTree == null)||(!ivoIdPropertyTree.isLeaf())))) {
            _other.ivoId = this.ivoId;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >OutputFormat.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new OutputFormat.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public OutputFormat.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >OutputFormat.Builder<_B> copyOf(final OutputFormat _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final OutputFormat.Builder<_B> _newBuilder = new OutputFormat.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static OutputFormat.Builder<Void> copyExcept(final OutputFormat _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static OutputFormat.Builder<Void> copyOnly(final OutputFormat _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public OutputFormat visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(OutputFormat.PropInfo.MIME, this));
        _visitor_.visit(new CollectionProperty<>(OutputFormat.PropInfo.ALIAS, this));
        _visitor_.visit(new SingleProperty<>(OutputFormat.PropInfo.IVO_ID, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final OutputFormat _storedValue;
        private String mime;
        private List<Buildable> alias;
        private String ivoId;

        public Builder(final _B _parentBuilder, final OutputFormat _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.mime = _other.mime;
                    if (_other.alias == null) {
                        this.alias = null;
                    } else {
                        this.alias = new ArrayList<>();
                        for (String _item: _other.alias) {
                            this.alias.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                    this.ivoId = _other.ivoId;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final OutputFormat _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree mimePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("mime"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(mimePropertyTree!= null):((mimePropertyTree == null)||(!mimePropertyTree.isLeaf())))) {
                        this.mime = _other.mime;
                    }
                    final PropertyTree aliasPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("alias"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(aliasPropertyTree!= null):((aliasPropertyTree == null)||(!aliasPropertyTree.isLeaf())))) {
                        if (_other.alias == null) {
                            this.alias = null;
                        } else {
                            this.alias = new ArrayList<>();
                            for (String _item: _other.alias) {
                                this.alias.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                            }
                        }
                    }
                    final PropertyTree ivoIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ivoId"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(ivoIdPropertyTree!= null):((ivoIdPropertyTree == null)||(!ivoIdPropertyTree.isLeaf())))) {
                        this.ivoId = _other.ivoId;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends OutputFormat >_P init(final _P _product) {
            _product.mime = this.mime;
            if (this.alias!= null) {
                final List<String> alias = new ArrayList<>(this.alias.size());
                for (Buildable _item: this.alias) {
                    alias.add(((String) _item.build()));
                }
                _product.alias = alias;
            }
            _product.ivoId = this.ivoId;
            return _product;
        }

        /**
         * Sets the new value of "mime" (any previous value will be replaced)
         * 
         * @param mime
         *     New value of the "mime" property.
         */
        public OutputFormat.Builder<_B> withMime(final String mime) {
            this.mime = mime;
            return this;
        }

        /**
         * Adds the given items to the value of "alias"
         * 
         * @param alias
         *     Items to add to the value of the "alias" property
         */
        public OutputFormat.Builder<_B> addAlias(final Iterable<? extends String> alias) {
            if (alias!= null) {
                if (this.alias == null) {
                    this.alias = new ArrayList<>();
                }
                for (String _item: alias) {
                    this.alias.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "alias" (any previous value will be replaced)
         * 
         * @param alias
         *     New value of the "alias" property.
         */
        public OutputFormat.Builder<_B> withAlias(final Iterable<? extends String> alias) {
            if (this.alias!= null) {
                this.alias.clear();
            }
            return addAlias(alias);
        }

        /**
         * Adds the given items to the value of "alias"
         * 
         * @param alias
         *     Items to add to the value of the "alias" property
         */
        public OutputFormat.Builder<_B> addAlias(String... alias) {
            addAlias(Arrays.asList(alias));
            return this;
        }

        /**
         * Sets the new value of "alias" (any previous value will be replaced)
         * 
         * @param alias
         *     New value of the "alias" property.
         */
        public OutputFormat.Builder<_B> withAlias(String... alias) {
            withAlias(Arrays.asList(alias));
            return this;
        }

        /**
         * Sets the new value of "ivoId" (any previous value will be replaced)
         * 
         * @param ivoId
         *     New value of the "ivoId" property.
         */
        public OutputFormat.Builder<_B> withIvoId(final String ivoId) {
            this.ivoId = ivoId;
            return this;
        }

        @Override
        public OutputFormat build() {
            if (_storedValue == null) {
                return this.init(new OutputFormat());
            } else {
                return ((OutputFormat) _storedValue);
            }
        }

        public OutputFormat.Builder<_B> copyOf(final OutputFormat _other) {
            _other.copyTo(this);
            return this;
        }

        public OutputFormat.Builder<_B> copyOf(final OutputFormat.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setMime(final String mime) {
            OutputFormat.this.setMime(mime);
        }

        public List<String> getAlias() {
            if (OutputFormat.this.alias == null) {
                OutputFormat.this.alias = new ArrayList<>();
            }
            return OutputFormat.this.alias;
        }

        public void setIvoId(final String ivoId) {
            OutputFormat.this.setIvoId(ivoId);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<OutputFormat, String> MIME = new SinglePropertyInfo<OutputFormat,String>("mime", OutputFormat.class, String.class, false, null, new QName("", "mime"), new QName("http://www.w3.org/2001/XMLSchema", "token"), false) {


            @Override
            public String get(final OutputFormat _instance_) {
                return ((_instance_ == null)?null:_instance_.mime);
            }

            @Override
            public void set(final OutputFormat _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.mime = _value_;
                }
            }

        }
        ;
        public static final transient CollectionPropertyInfo<OutputFormat, String> ALIAS = new CollectionPropertyInfo<OutputFormat,String>("alias", OutputFormat.class, String.class, true, null, new QName("", "alias"), new QName("http://www.w3.org/2001/XMLSchema", "token"), false) {


            @Override
            public List<String> get(final OutputFormat _instance_) {
                return ((_instance_ == null)?null:_instance_.alias);
            }

            @Override
            public void set(final OutputFormat _instance_, final List<String> _value_) {
                if (_instance_!= null) {
                    _instance_.alias = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<OutputFormat, String> IVO_ID = new SinglePropertyInfo<OutputFormat,String>("ivoId", OutputFormat.class, String.class, false, null, new QName("", "ivo-id"), new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), true) {


            @Override
            public String get(final OutputFormat _instance_) {
                return ((_instance_ == null)?null:_instance_.ivoId);
            }

            @Override
            public void set(final OutputFormat _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.ivoId = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends OutputFormat.Selector<OutputFormat.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static OutputFormat.Select _root() {
            return new OutputFormat.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, OutputFormat.Selector<TRoot, TParent>> mime = null;
        private com.kscs.util.jaxb.Selector<TRoot, OutputFormat.Selector<TRoot, TParent>> alias = null;
        private com.kscs.util.jaxb.Selector<TRoot, OutputFormat.Selector<TRoot, TParent>> ivoId = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.mime!= null) {
                products.put("mime", this.mime.init());
            }
            if (this.alias!= null) {
                products.put("alias", this.alias.init());
            }
            if (this.ivoId!= null) {
                products.put("ivoId", this.ivoId.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, OutputFormat.Selector<TRoot, TParent>> mime() {
            return ((this.mime == null)?this.mime = new com.kscs.util.jaxb.Selector<>(this._root, this, "mime"):this.mime);
        }

        public com.kscs.util.jaxb.Selector<TRoot, OutputFormat.Selector<TRoot, TParent>> alias() {
            return ((this.alias == null)?this.alias = new com.kscs.util.jaxb.Selector<>(this._root, this, "alias"):this.alias);
        }

        public com.kscs.util.jaxb.Selector<TRoot, OutputFormat.Selector<TRoot, TParent>> ivoId() {
            return ((this.ivoId == null)?this.ivoId = new com.kscs.util.jaxb.Selector<>(this._root, this, "ivoId"):this.ivoId);
        }

    }

}
