
package org.javastro.ivoa.entities.resource.tap;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Upload methods are always identified by an IVORN.  
 *       Descriptions can be obtained by dereferencing this
 *       IVORN.  To see values defined in TAPRegExt,
 * 			retrieve the ivo://ivoa.net/std/TAPRegExt
 *    		resource record and look for keys starting with "upload-".
 * 
 * 
 *       You can register custom upload methods, but you must use the
 *       standard IVORNs for the upload methods defined in the TAP
 *       specification.
 * 
 * <p>Java class for UploadMethod complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="UploadMethod">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="ivo-id" type="{http://www.w3.org/2001/XMLSchema}anyURI" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "UploadMethod")
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class UploadMethod implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The IVORN of the upload method.
     * 
     */
    @XmlAttribute(name = "ivo-id")
    @XmlSchemaType(name = "anyURI")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String ivoId;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected transient UploadMethod.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public UploadMethod() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public UploadMethod(final String ivoId) {
        this.ivoId = ivoId;
    }

    /**
     * The IVORN of the upload method.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getIvoId() {
        return ivoId;
    }

    /**
     * Sets the value of the ivoId property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getIvoId()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setIvoId(String value) {
        this.ivoId = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final UploadMethod that = ((UploadMethod) object);
        {
            String leftIvoId;
            leftIvoId = this.getIvoId();
            String rightIvoId;
            rightIvoId = that.getIvoId();
            if (this.ivoId!= null) {
                if (that.ivoId!= null) {
                    if (!leftIvoId.equals(rightIvoId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.ivoId!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theIvoId;
            theIvoId = this.getIvoId();
            if (this.ivoId!= null) {
                currentHashCode += theIvoId.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theIvoId;
            theIvoId = this.getIvoId();
            strategy.appendField(locator, this, "ivoId", buffer, theIvoId, (this.ivoId!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof UploadMethod) {
            final UploadMethod target = this;
            final UploadMethod leftObject = ((UploadMethod) left);
            final UploadMethod rightObject = ((UploadMethod) right);
            {
                Boolean ivoIdShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.ivoId!= null), (rightObject.ivoId!= null));
                if (ivoIdShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsIvoId;
                    lhsIvoId = leftObject.getIvoId();
                    String rhsIvoId;
                    rhsIvoId = rightObject.getIvoId();
                    String mergedIvoId = ((String) strategy.merge(LocatorUtils.property(leftLocator, "ivoId", lhsIvoId), LocatorUtils.property(rightLocator, "ivoId", rhsIvoId), lhsIvoId, rhsIvoId, (leftObject.ivoId!= null), (rightObject.ivoId!= null)));
                    target.setIvoId(mergedIvoId);
                } else {
                    if (ivoIdShouldBeMergedAndSet == Boolean.FALSE) {
                        target.ivoId = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new UploadMethod();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public UploadMethod clone() {
        final UploadMethod _newObject;
        try {
            _newObject = ((UploadMethod) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public UploadMethod createCopy() {
        final UploadMethod _newObject;
        try {
            _newObject = ((UploadMethod) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.ivoId = this.ivoId;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public UploadMethod createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final UploadMethod _newObject;
        try {
            _newObject = ((UploadMethod) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree ivoIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ivoId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(ivoIdPropertyTree!= null):((ivoIdPropertyTree == null)||(!ivoIdPropertyTree.isLeaf())))) {
            _newObject.ivoId = this.ivoId;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public UploadMethod copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public UploadMethod copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public UploadMethod.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new UploadMethod.Modifier();
        }
        return ((UploadMethod.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final UploadMethod.Builder<_B> _other) {
        _other.ivoId = this.ivoId;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >UploadMethod.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new UploadMethod.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public UploadMethod.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static UploadMethod.Builder<Void> builder() {
        return new UploadMethod.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >UploadMethod.Builder<_B> copyOf(final UploadMethod _other) {
        final UploadMethod.Builder<_B> _newBuilder = new UploadMethod.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final UploadMethod.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree ivoIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ivoId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(ivoIdPropertyTree!= null):((ivoIdPropertyTree == null)||(!ivoIdPropertyTree.isLeaf())))) {
            _other.ivoId = this.ivoId;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >UploadMethod.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new UploadMethod.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public UploadMethod.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >UploadMethod.Builder<_B> copyOf(final UploadMethod _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final UploadMethod.Builder<_B> _newBuilder = new UploadMethod.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static UploadMethod.Builder<Void> copyExcept(final UploadMethod _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static UploadMethod.Builder<Void> copyOnly(final UploadMethod _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public UploadMethod visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(UploadMethod.PropInfo.IVO_ID, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final UploadMethod _storedValue;
        private String ivoId;

        public Builder(final _B _parentBuilder, final UploadMethod _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.ivoId = _other.ivoId;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final UploadMethod _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree ivoIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("ivoId"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(ivoIdPropertyTree!= null):((ivoIdPropertyTree == null)||(!ivoIdPropertyTree.isLeaf())))) {
                        this.ivoId = _other.ivoId;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends UploadMethod >_P init(final _P _product) {
            _product.ivoId = this.ivoId;
            return _product;
        }

        /**
         * Sets the new value of "ivoId" (any previous value will be replaced)
         * 
         * @param ivoId
         *     New value of the "ivoId" property.
         */
        public UploadMethod.Builder<_B> withIvoId(final String ivoId) {
            this.ivoId = ivoId;
            return this;
        }

        @Override
        public UploadMethod build() {
            if (_storedValue == null) {
                return this.init(new UploadMethod());
            } else {
                return ((UploadMethod) _storedValue);
            }
        }

        public UploadMethod.Builder<_B> copyOf(final UploadMethod _other) {
            _other.copyTo(this);
            return this;
        }

        public UploadMethod.Builder<_B> copyOf(final UploadMethod.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setIvoId(final String ivoId) {
            UploadMethod.this.setIvoId(ivoId);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<UploadMethod, String> IVO_ID = new SinglePropertyInfo<UploadMethod,String>("ivoId", UploadMethod.class, String.class, false, null, new QName("", "ivo-id"), new QName("http://www.w3.org/2001/XMLSchema", "anyURI"), true) {


            @Override
            public String get(final UploadMethod _instance_) {
                return ((_instance_ == null)?null:_instance_.ivoId);
            }

            @Override
            public void set(final UploadMethod _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.ivoId = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends UploadMethod.Selector<UploadMethod.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static UploadMethod.Select _root() {
            return new UploadMethod.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, UploadMethod.Selector<TRoot, TParent>> ivoId = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.ivoId!= null) {
                products.put("ivoId", this.ivoId.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, UploadMethod.Selector<TRoot, TParent>> ivoId() {
            return ((this.ivoId == null)?this.ivoId = new com.kscs.util.jaxb.Selector<>(this._root, this, "ivoId"):this.ivoId);
        }

    }

}
