
package org.javastro.ivoa.entities.stc.v1;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * The astronomical coordinate system definition: spatial coordinate frame and reference position; time frame and reference position; the coordinate flavor; spectral frame and (optionally) Doppler frame; and the planetary ephemeris; an ID is required, since this is how coordinate elements are associated with their coordinate systems
 * 
 * <p>Java class for astroCoordSystemType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="astroCoordSystemType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}coordSysType">
 *       <sequence>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}TimeFrame" minOccurs="0"/>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}SpaceFrame" minOccurs="0"/>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}SpectralFrame" minOccurs="0"/>
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}RedshiftFrame" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "astroCoordSystemType", propOrder = {
    "timeFrame",
    "spaceFrame",
    "spectralFrame",
    "redshiftFrame"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class AstroCoordSystemType
    extends CoordSysType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * The time coordinate reference frame
     * 
     */
    @XmlElement(name = "TimeFrame", nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected TimeFrameType timeFrame;
    /**
     * The spatial coordinate reference frame
     * 
     */
    @XmlElement(name = "SpaceFrame", nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected SpaceFrameType spaceFrame;
    /**
     * The reference frame for the spectral coordinate; note presence of LSR
     * 
     */
    @XmlElement(name = "SpectralFrame", nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected SpectralFrameType spectralFrame;
    /**
     * Contains the Doppler definitions, including whether the values are velocity or redshift (value_type)
     * 
     */
    @XmlElement(name = "RedshiftFrame", nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected RedshiftFrameType redshiftFrame;

    /**
     * Default no-arg constructor
     * 
     */
    public AstroCoordSystemType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public AstroCoordSystemType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final List<GenericCoordFrameType> coordFrames, final TimeFrameType timeFrame, final SpaceFrameType spaceFrame, final SpectralFrameType spectralFrame, final RedshiftFrameType redshiftFrame) {
        super(id, idref, ucd, type, href, idType, idrefType, coordFrames);
        this.timeFrame = timeFrame;
        this.spaceFrame = spaceFrame;
        this.spectralFrame = spectralFrame;
        this.redshiftFrame = redshiftFrame;
    }

    /**
     * The time coordinate reference frame
     * 
     * @return
     *     possible object is
     *     {@link TimeFrameType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public TimeFrameType getTimeFrame() {
        return timeFrame;
    }

    /**
     * Sets the value of the timeFrame property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeFrameType }
     *     
     * @see #getTimeFrame()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setTimeFrame(TimeFrameType value) {
        this.timeFrame = value;
    }

    /**
     * The spatial coordinate reference frame
     * 
     * @return
     *     possible object is
     *     {@link SpaceFrameType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SpaceFrameType getSpaceFrame() {
        return spaceFrame;
    }

    /**
     * Sets the value of the spaceFrame property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpaceFrameType }
     *     
     * @see #getSpaceFrame()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setSpaceFrame(SpaceFrameType value) {
        this.spaceFrame = value;
    }

    /**
     * The reference frame for the spectral coordinate; note presence of LSR
     * 
     * @return
     *     possible object is
     *     {@link SpectralFrameType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public SpectralFrameType getSpectralFrame() {
        return spectralFrame;
    }

    /**
     * Sets the value of the spectralFrame property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpectralFrameType }
     *     
     * @see #getSpectralFrame()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setSpectralFrame(SpectralFrameType value) {
        this.spectralFrame = value;
    }

    /**
     * Contains the Doppler definitions, including whether the values are velocity or redshift (value_type)
     * 
     * @return
     *     possible object is
     *     {@link RedshiftFrameType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public RedshiftFrameType getRedshiftFrame() {
        return redshiftFrame;
    }

    /**
     * Sets the value of the redshiftFrame property.
     * 
     * @param value
     *     allowed object is
     *     {@link RedshiftFrameType }
     *     
     * @see #getRedshiftFrame()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setRedshiftFrame(RedshiftFrameType value) {
        this.redshiftFrame = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final AstroCoordSystemType that = ((AstroCoordSystemType) object);
        {
            TimeFrameType leftTimeFrame;
            leftTimeFrame = this.getTimeFrame();
            TimeFrameType rightTimeFrame;
            rightTimeFrame = that.getTimeFrame();
            if (this.timeFrame!= null) {
                if (that.timeFrame!= null) {
                    if (!leftTimeFrame.equals(rightTimeFrame)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.timeFrame!= null) {
                    return false;
                }
            }
        }
        {
            SpaceFrameType leftSpaceFrame;
            leftSpaceFrame = this.getSpaceFrame();
            SpaceFrameType rightSpaceFrame;
            rightSpaceFrame = that.getSpaceFrame();
            if (this.spaceFrame!= null) {
                if (that.spaceFrame!= null) {
                    if (!leftSpaceFrame.equals(rightSpaceFrame)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.spaceFrame!= null) {
                    return false;
                }
            }
        }
        {
            SpectralFrameType leftSpectralFrame;
            leftSpectralFrame = this.getSpectralFrame();
            SpectralFrameType rightSpectralFrame;
            rightSpectralFrame = that.getSpectralFrame();
            if (this.spectralFrame!= null) {
                if (that.spectralFrame!= null) {
                    if (!leftSpectralFrame.equals(rightSpectralFrame)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.spectralFrame!= null) {
                    return false;
                }
            }
        }
        {
            RedshiftFrameType leftRedshiftFrame;
            leftRedshiftFrame = this.getRedshiftFrame();
            RedshiftFrameType rightRedshiftFrame;
            rightRedshiftFrame = that.getRedshiftFrame();
            if (this.redshiftFrame!= null) {
                if (that.redshiftFrame!= null) {
                    if (!leftRedshiftFrame.equals(rightRedshiftFrame)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.redshiftFrame!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            TimeFrameType theTimeFrame;
            theTimeFrame = this.getTimeFrame();
            if (this.timeFrame!= null) {
                currentHashCode += theTimeFrame.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            SpaceFrameType theSpaceFrame;
            theSpaceFrame = this.getSpaceFrame();
            if (this.spaceFrame!= null) {
                currentHashCode += theSpaceFrame.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            SpectralFrameType theSpectralFrame;
            theSpectralFrame = this.getSpectralFrame();
            if (this.spectralFrame!= null) {
                currentHashCode += theSpectralFrame.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            RedshiftFrameType theRedshiftFrame;
            theRedshiftFrame = this.getRedshiftFrame();
            if (this.redshiftFrame!= null) {
                currentHashCode += theRedshiftFrame.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            TimeFrameType theTimeFrame;
            theTimeFrame = this.getTimeFrame();
            strategy.appendField(locator, this, "timeFrame", buffer, theTimeFrame, (this.timeFrame!= null));
        }
        {
            SpaceFrameType theSpaceFrame;
            theSpaceFrame = this.getSpaceFrame();
            strategy.appendField(locator, this, "spaceFrame", buffer, theSpaceFrame, (this.spaceFrame!= null));
        }
        {
            SpectralFrameType theSpectralFrame;
            theSpectralFrame = this.getSpectralFrame();
            strategy.appendField(locator, this, "spectralFrame", buffer, theSpectralFrame, (this.spectralFrame!= null));
        }
        {
            RedshiftFrameType theRedshiftFrame;
            theRedshiftFrame = this.getRedshiftFrame();
            strategy.appendField(locator, this, "redshiftFrame", buffer, theRedshiftFrame, (this.redshiftFrame!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof AstroCoordSystemType) {
            final AstroCoordSystemType target = this;
            final AstroCoordSystemType leftObject = ((AstroCoordSystemType) left);
            final AstroCoordSystemType rightObject = ((AstroCoordSystemType) right);
            {
                Boolean timeFrameShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.timeFrame!= null), (rightObject.timeFrame!= null));
                if (timeFrameShouldBeMergedAndSet == Boolean.TRUE) {
                    TimeFrameType lhsTimeFrame;
                    lhsTimeFrame = leftObject.getTimeFrame();
                    TimeFrameType rhsTimeFrame;
                    rhsTimeFrame = rightObject.getTimeFrame();
                    TimeFrameType mergedTimeFrame = ((TimeFrameType) strategy.merge(LocatorUtils.property(leftLocator, "timeFrame", lhsTimeFrame), LocatorUtils.property(rightLocator, "timeFrame", rhsTimeFrame), lhsTimeFrame, rhsTimeFrame, (leftObject.timeFrame!= null), (rightObject.timeFrame!= null)));
                    target.setTimeFrame(mergedTimeFrame);
                } else {
                    if (timeFrameShouldBeMergedAndSet == Boolean.FALSE) {
                        target.timeFrame = null;
                    }
                }
            }
            {
                Boolean spaceFrameShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.spaceFrame!= null), (rightObject.spaceFrame!= null));
                if (spaceFrameShouldBeMergedAndSet == Boolean.TRUE) {
                    SpaceFrameType lhsSpaceFrame;
                    lhsSpaceFrame = leftObject.getSpaceFrame();
                    SpaceFrameType rhsSpaceFrame;
                    rhsSpaceFrame = rightObject.getSpaceFrame();
                    SpaceFrameType mergedSpaceFrame = ((SpaceFrameType) strategy.merge(LocatorUtils.property(leftLocator, "spaceFrame", lhsSpaceFrame), LocatorUtils.property(rightLocator, "spaceFrame", rhsSpaceFrame), lhsSpaceFrame, rhsSpaceFrame, (leftObject.spaceFrame!= null), (rightObject.spaceFrame!= null)));
                    target.setSpaceFrame(mergedSpaceFrame);
                } else {
                    if (spaceFrameShouldBeMergedAndSet == Boolean.FALSE) {
                        target.spaceFrame = null;
                    }
                }
            }
            {
                Boolean spectralFrameShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.spectralFrame!= null), (rightObject.spectralFrame!= null));
                if (spectralFrameShouldBeMergedAndSet == Boolean.TRUE) {
                    SpectralFrameType lhsSpectralFrame;
                    lhsSpectralFrame = leftObject.getSpectralFrame();
                    SpectralFrameType rhsSpectralFrame;
                    rhsSpectralFrame = rightObject.getSpectralFrame();
                    SpectralFrameType mergedSpectralFrame = ((SpectralFrameType) strategy.merge(LocatorUtils.property(leftLocator, "spectralFrame", lhsSpectralFrame), LocatorUtils.property(rightLocator, "spectralFrame", rhsSpectralFrame), lhsSpectralFrame, rhsSpectralFrame, (leftObject.spectralFrame!= null), (rightObject.spectralFrame!= null)));
                    target.setSpectralFrame(mergedSpectralFrame);
                } else {
                    if (spectralFrameShouldBeMergedAndSet == Boolean.FALSE) {
                        target.spectralFrame = null;
                    }
                }
            }
            {
                Boolean redshiftFrameShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.redshiftFrame!= null), (rightObject.redshiftFrame!= null));
                if (redshiftFrameShouldBeMergedAndSet == Boolean.TRUE) {
                    RedshiftFrameType lhsRedshiftFrame;
                    lhsRedshiftFrame = leftObject.getRedshiftFrame();
                    RedshiftFrameType rhsRedshiftFrame;
                    rhsRedshiftFrame = rightObject.getRedshiftFrame();
                    RedshiftFrameType mergedRedshiftFrame = ((RedshiftFrameType) strategy.merge(LocatorUtils.property(leftLocator, "redshiftFrame", lhsRedshiftFrame), LocatorUtils.property(rightLocator, "redshiftFrame", rhsRedshiftFrame), lhsRedshiftFrame, rhsRedshiftFrame, (leftObject.redshiftFrame!= null), (rightObject.redshiftFrame!= null)));
                    target.setRedshiftFrame(mergedRedshiftFrame);
                } else {
                    if (redshiftFrameShouldBeMergedAndSet == Boolean.FALSE) {
                        target.redshiftFrame = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new AstroCoordSystemType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public AstroCoordSystemType clone() {
        final AstroCoordSystemType _newObject;
        _newObject = ((AstroCoordSystemType) super.clone());
        _newObject.timeFrame = ((this.timeFrame == null)?null:this.timeFrame.clone());
        _newObject.spaceFrame = ((this.spaceFrame == null)?null:this.spaceFrame.clone());
        _newObject.spectralFrame = ((this.spectralFrame == null)?null:this.spectralFrame.clone());
        _newObject.redshiftFrame = ((this.redshiftFrame == null)?null:this.redshiftFrame.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public AstroCoordSystemType createCopy() {
        final AstroCoordSystemType _newObject = ((AstroCoordSystemType) super.createCopy());
        _newObject.timeFrame = ((this.timeFrame == null)?null:this.timeFrame.createCopy());
        _newObject.spaceFrame = ((this.spaceFrame == null)?null:this.spaceFrame.createCopy());
        _newObject.spectralFrame = ((this.spectralFrame == null)?null:this.spectralFrame.createCopy());
        _newObject.redshiftFrame = ((this.redshiftFrame == null)?null:this.redshiftFrame.createCopy());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public AstroCoordSystemType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final AstroCoordSystemType _newObject = ((AstroCoordSystemType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree timeFramePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timeFrame"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timeFramePropertyTree!= null):((timeFramePropertyTree == null)||(!timeFramePropertyTree.isLeaf())))) {
            _newObject.timeFrame = ((this.timeFrame == null)?null:this.timeFrame.createCopy(timeFramePropertyTree, _propertyTreeUse));
        }
        final PropertyTree spaceFramePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spaceFrame"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spaceFramePropertyTree!= null):((spaceFramePropertyTree == null)||(!spaceFramePropertyTree.isLeaf())))) {
            _newObject.spaceFrame = ((this.spaceFrame == null)?null:this.spaceFrame.createCopy(spaceFramePropertyTree, _propertyTreeUse));
        }
        final PropertyTree spectralFramePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spectralFrame"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spectralFramePropertyTree!= null):((spectralFramePropertyTree == null)||(!spectralFramePropertyTree.isLeaf())))) {
            _newObject.spectralFrame = ((this.spectralFrame == null)?null:this.spectralFrame.createCopy(spectralFramePropertyTree, _propertyTreeUse));
        }
        final PropertyTree redshiftFramePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("redshiftFrame"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(redshiftFramePropertyTree!= null):((redshiftFramePropertyTree == null)||(!redshiftFramePropertyTree.isLeaf())))) {
            _newObject.redshiftFrame = ((this.redshiftFrame == null)?null:this.redshiftFrame.createCopy(redshiftFramePropertyTree, _propertyTreeUse));
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public AstroCoordSystemType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public AstroCoordSystemType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public AstroCoordSystemType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new AstroCoordSystemType.Modifier();
        }
        return ((AstroCoordSystemType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final AstroCoordSystemType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.timeFrame = ((this.timeFrame == null)?null:this.timeFrame.newCopyBuilder(_other));
        _other.spaceFrame = ((this.spaceFrame == null)?null:this.spaceFrame.newCopyBuilder(_other));
        _other.spectralFrame = ((this.spectralFrame == null)?null:this.spectralFrame.newCopyBuilder(_other));
        _other.redshiftFrame = ((this.redshiftFrame == null)?null:this.redshiftFrame.newCopyBuilder(_other));
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >AstroCoordSystemType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new AstroCoordSystemType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public AstroCoordSystemType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static AstroCoordSystemType.Builder<Void> builder() {
        return new AstroCoordSystemType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >AstroCoordSystemType.Builder<_B> copyOf(final StcBaseType _other) {
        final AstroCoordSystemType.Builder<_B> _newBuilder = new AstroCoordSystemType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >AstroCoordSystemType.Builder<_B> copyOf(final CoordSysType _other) {
        final AstroCoordSystemType.Builder<_B> _newBuilder = new AstroCoordSystemType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >AstroCoordSystemType.Builder<_B> copyOf(final AstroCoordSystemType _other) {
        final AstroCoordSystemType.Builder<_B> _newBuilder = new AstroCoordSystemType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final AstroCoordSystemType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree timeFramePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timeFrame"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timeFramePropertyTree!= null):((timeFramePropertyTree == null)||(!timeFramePropertyTree.isLeaf())))) {
            _other.timeFrame = ((this.timeFrame == null)?null:this.timeFrame.newCopyBuilder(_other, timeFramePropertyTree, _propertyTreeUse));
        }
        final PropertyTree spaceFramePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spaceFrame"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spaceFramePropertyTree!= null):((spaceFramePropertyTree == null)||(!spaceFramePropertyTree.isLeaf())))) {
            _other.spaceFrame = ((this.spaceFrame == null)?null:this.spaceFrame.newCopyBuilder(_other, spaceFramePropertyTree, _propertyTreeUse));
        }
        final PropertyTree spectralFramePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spectralFrame"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spectralFramePropertyTree!= null):((spectralFramePropertyTree == null)||(!spectralFramePropertyTree.isLeaf())))) {
            _other.spectralFrame = ((this.spectralFrame == null)?null:this.spectralFrame.newCopyBuilder(_other, spectralFramePropertyTree, _propertyTreeUse));
        }
        final PropertyTree redshiftFramePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("redshiftFrame"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(redshiftFramePropertyTree!= null):((redshiftFramePropertyTree == null)||(!redshiftFramePropertyTree.isLeaf())))) {
            _other.redshiftFrame = ((this.redshiftFrame == null)?null:this.redshiftFrame.newCopyBuilder(_other, redshiftFramePropertyTree, _propertyTreeUse));
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >AstroCoordSystemType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new AstroCoordSystemType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public AstroCoordSystemType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >AstroCoordSystemType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final AstroCoordSystemType.Builder<_B> _newBuilder = new AstroCoordSystemType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >AstroCoordSystemType.Builder<_B> copyOf(final CoordSysType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final AstroCoordSystemType.Builder<_B> _newBuilder = new AstroCoordSystemType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >AstroCoordSystemType.Builder<_B> copyOf(final AstroCoordSystemType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final AstroCoordSystemType.Builder<_B> _newBuilder = new AstroCoordSystemType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static AstroCoordSystemType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static AstroCoordSystemType.Builder<Void> copyExcept(final CoordSysType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static AstroCoordSystemType.Builder<Void> copyExcept(final AstroCoordSystemType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static AstroCoordSystemType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static AstroCoordSystemType.Builder<Void> copyOnly(final CoordSysType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static AstroCoordSystemType.Builder<Void> copyOnly(final AstroCoordSystemType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public AstroCoordSystemType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new SingleProperty<>(AstroCoordSystemType.PropInfo.TIME_FRAME, this))&&(this.timeFrame!= null)) {
            this.timeFrame.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(AstroCoordSystemType.PropInfo.SPACE_FRAME, this))&&(this.spaceFrame!= null)) {
            this.spaceFrame.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(AstroCoordSystemType.PropInfo.SPECTRAL_FRAME, this))&&(this.spectralFrame!= null)) {
            this.spectralFrame.visit(_visitor_);
        }
        if (_visitor_.visit(new SingleProperty<>(AstroCoordSystemType.PropInfo.REDSHIFT_FRAME, this))&&(this.redshiftFrame!= null)) {
            this.redshiftFrame.visit(_visitor_);
        }
        return this;
    }

    public static class Builder<_B >
        extends CoordSysType.Builder<_B>
        implements Buildable
    {

        private TimeFrameType.Builder<AstroCoordSystemType.Builder<_B>> timeFrame;
        private SpaceFrameType.Builder<AstroCoordSystemType.Builder<_B>> spaceFrame;
        private SpectralFrameType.Builder<AstroCoordSystemType.Builder<_B>> spectralFrame;
        private RedshiftFrameType.Builder<AstroCoordSystemType.Builder<_B>> redshiftFrame;

        public Builder(final _B _parentBuilder, final AstroCoordSystemType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.timeFrame = ((_other.timeFrame == null)?null:_other.timeFrame.newCopyBuilder(this));
                this.spaceFrame = ((_other.spaceFrame == null)?null:_other.spaceFrame.newCopyBuilder(this));
                this.spectralFrame = ((_other.spectralFrame == null)?null:_other.spectralFrame.newCopyBuilder(this));
                this.redshiftFrame = ((_other.redshiftFrame == null)?null:_other.redshiftFrame.newCopyBuilder(this));
            }
        }

        public Builder(final _B _parentBuilder, final AstroCoordSystemType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree timeFramePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("timeFrame"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(timeFramePropertyTree!= null):((timeFramePropertyTree == null)||(!timeFramePropertyTree.isLeaf())))) {
                    this.timeFrame = ((_other.timeFrame == null)?null:_other.timeFrame.newCopyBuilder(this, timeFramePropertyTree, _propertyTreeUse));
                }
                final PropertyTree spaceFramePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spaceFrame"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spaceFramePropertyTree!= null):((spaceFramePropertyTree == null)||(!spaceFramePropertyTree.isLeaf())))) {
                    this.spaceFrame = ((_other.spaceFrame == null)?null:_other.spaceFrame.newCopyBuilder(this, spaceFramePropertyTree, _propertyTreeUse));
                }
                final PropertyTree spectralFramePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("spectralFrame"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(spectralFramePropertyTree!= null):((spectralFramePropertyTree == null)||(!spectralFramePropertyTree.isLeaf())))) {
                    this.spectralFrame = ((_other.spectralFrame == null)?null:_other.spectralFrame.newCopyBuilder(this, spectralFramePropertyTree, _propertyTreeUse));
                }
                final PropertyTree redshiftFramePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("redshiftFrame"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(redshiftFramePropertyTree!= null):((redshiftFramePropertyTree == null)||(!redshiftFramePropertyTree.isLeaf())))) {
                    this.redshiftFrame = ((_other.redshiftFrame == null)?null:_other.redshiftFrame.newCopyBuilder(this, redshiftFramePropertyTree, _propertyTreeUse));
                }
            }
        }

        protected<_P extends AstroCoordSystemType >_P init(final _P _product) {
            _product.timeFrame = ((this.timeFrame == null)?null:this.timeFrame.build());
            _product.spaceFrame = ((this.spaceFrame == null)?null:this.spaceFrame.build());
            _product.spectralFrame = ((this.spectralFrame == null)?null:this.spectralFrame.build());
            _product.redshiftFrame = ((this.redshiftFrame == null)?null:this.redshiftFrame.build());
            return super.init(_product);
        }

        /**
         * Sets the new value of "timeFrame" (any previous value will be replaced)
         * 
         * @param timeFrame
         *     New value of the "timeFrame" property.
         */
        public AstroCoordSystemType.Builder<_B> withTimeFrame(final TimeFrameType timeFrame) {
            this.timeFrame = ((timeFrame == null)?null:new TimeFrameType.Builder<>(this, timeFrame, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "timeFrame" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.TimeFrameType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "timeFrame" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.TimeFrameType.Builder#end()} to
         *     return to the current builder.
         */
        public TimeFrameType.Builder<? extends AstroCoordSystemType.Builder<_B>> withTimeFrame() {
            if (this.timeFrame!= null) {
                return this.timeFrame;
            }
            return this.timeFrame = new TimeFrameType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "spaceFrame" (any previous value will be replaced)
         * 
         * @param spaceFrame
         *     New value of the "spaceFrame" property.
         */
        public AstroCoordSystemType.Builder<_B> withSpaceFrame(final SpaceFrameType spaceFrame) {
            this.spaceFrame = ((spaceFrame == null)?null:new SpaceFrameType.Builder<>(this, spaceFrame, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "spaceFrame" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.SpaceFrameType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "spaceFrame" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.SpaceFrameType.Builder#end()} to
         *     return to the current builder.
         */
        public SpaceFrameType.Builder<? extends AstroCoordSystemType.Builder<_B>> withSpaceFrame() {
            if (this.spaceFrame!= null) {
                return this.spaceFrame;
            }
            return this.spaceFrame = new SpaceFrameType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "spectralFrame" (any previous value will be replaced)
         * 
         * @param spectralFrame
         *     New value of the "spectralFrame" property.
         */
        public AstroCoordSystemType.Builder<_B> withSpectralFrame(final SpectralFrameType spectralFrame) {
            this.spectralFrame = ((spectralFrame == null)?null:new SpectralFrameType.Builder<>(this, spectralFrame, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "spectralFrame" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.SpectralFrameType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "spectralFrame" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.SpectralFrameType.Builder#end()} to
         *     return to the current builder.
         */
        public SpectralFrameType.Builder<? extends AstroCoordSystemType.Builder<_B>> withSpectralFrame() {
            if (this.spectralFrame!= null) {
                return this.spectralFrame;
            }
            return this.spectralFrame = new SpectralFrameType.Builder<>(this, null, false);
        }

        /**
         * Sets the new value of "redshiftFrame" (any previous value will be replaced)
         * 
         * @param redshiftFrame
         *     New value of the "redshiftFrame" property.
         */
        public AstroCoordSystemType.Builder<_B> withRedshiftFrame(final RedshiftFrameType redshiftFrame) {
            this.redshiftFrame = ((redshiftFrame == null)?null:new RedshiftFrameType.Builder<>(this, redshiftFrame, false));
            return this;
        }

        /**
         * Returns the existing builder or a new builder to build the value of the
         * "redshiftFrame" property.
         * Use {@link org.javastro.ivoa.entities.stc.v1.RedshiftFrameType.Builder#end()} to
         * return to the current builder.
         * 
         * @return
         *     A new builder to build the value of the "redshiftFrame" property.
         *     Use {@link org.javastro.ivoa.entities.stc.v1.RedshiftFrameType.Builder#end()} to
         *     return to the current builder.
         */
        public RedshiftFrameType.Builder<? extends AstroCoordSystemType.Builder<_B>> withRedshiftFrame() {
            if (this.redshiftFrame!= null) {
                return this.redshiftFrame;
            }
            return this.redshiftFrame = new RedshiftFrameType.Builder<>(this, null, false);
        }

        /**
         * Adds the given items to the value of "coordFrames"
         * 
         * @param coordFrames
         *     Items to add to the value of the "coordFrames" property
         */
        @Override
        public AstroCoordSystemType.Builder<_B> addCoordFrames(final Iterable<? extends GenericCoordFrameType> coordFrames) {
            super.addCoordFrames(coordFrames);
            return this;
        }

        /**
         * Adds the given items to the value of "coordFrames"
         * 
         * @param coordFrames
         *     Items to add to the value of the "coordFrames" property
         */
        @Override
        public AstroCoordSystemType.Builder<_B> addCoordFrames(GenericCoordFrameType... coordFrames) {
            super.addCoordFrames(coordFrames);
            return this;
        }

        /**
         * Sets the new value of "coordFrames" (any previous value will be replaced)
         * 
         * @param coordFrames
         *     New value of the "coordFrames" property.
         */
        @Override
        public AstroCoordSystemType.Builder<_B> withCoordFrames(final Iterable<? extends GenericCoordFrameType> coordFrames) {
            super.withCoordFrames(coordFrames);
            return this;
        }

        /**
         * Sets the new value of "coordFrames" (any previous value will be replaced)
         * 
         * @param coordFrames
         *     New value of the "coordFrames" property.
         */
        @Override
        public AstroCoordSystemType.Builder<_B> withCoordFrames(GenericCoordFrameType... coordFrames) {
            super.withCoordFrames(coordFrames);
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public AstroCoordSystemType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public AstroCoordSystemType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public AstroCoordSystemType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public AstroCoordSystemType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public AstroCoordSystemType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public AstroCoordSystemType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public AstroCoordSystemType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public AstroCoordSystemType build() {
            if (_storedValue == null) {
                return this.init(new AstroCoordSystemType());
            } else {
                return ((AstroCoordSystemType) _storedValue);
            }
        }

        public AstroCoordSystemType.Builder<_B> copyOf(final AstroCoordSystemType _other) {
            _other.copyTo(this);
            return this;
        }

        public AstroCoordSystemType.Builder<_B> copyOf(final AstroCoordSystemType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends CoordSysType.Modifier
    {


        public void setTimeFrame(final TimeFrameType timeFrame) {
            AstroCoordSystemType.this.setTimeFrame(timeFrame);
        }

        public void setSpaceFrame(final SpaceFrameType spaceFrame) {
            AstroCoordSystemType.this.setSpaceFrame(spaceFrame);
        }

        public void setSpectralFrame(final SpectralFrameType spectralFrame) {
            AstroCoordSystemType.this.setSpectralFrame(spectralFrame);
        }

        public void setRedshiftFrame(final RedshiftFrameType redshiftFrame) {
            AstroCoordSystemType.this.setRedshiftFrame(redshiftFrame);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<AstroCoordSystemType, TimeFrameType> TIME_FRAME = new SinglePropertyInfo<AstroCoordSystemType,TimeFrameType>("timeFrame", AstroCoordSystemType.class, TimeFrameType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "TimeFrame"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "timeFrameType"), false) {


            @Override
            public TimeFrameType get(final AstroCoordSystemType _instance_) {
                return ((_instance_ == null)?null:_instance_.timeFrame);
            }

            @Override
            public void set(final AstroCoordSystemType _instance_, final TimeFrameType _value_) {
                if (_instance_!= null) {
                    _instance_.timeFrame = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<AstroCoordSystemType, SpaceFrameType> SPACE_FRAME = new SinglePropertyInfo<AstroCoordSystemType,SpaceFrameType>("spaceFrame", AstroCoordSystemType.class, SpaceFrameType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "SpaceFrame"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "spaceFrameType"), false) {


            @Override
            public SpaceFrameType get(final AstroCoordSystemType _instance_) {
                return ((_instance_ == null)?null:_instance_.spaceFrame);
            }

            @Override
            public void set(final AstroCoordSystemType _instance_, final SpaceFrameType _value_) {
                if (_instance_!= null) {
                    _instance_.spaceFrame = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<AstroCoordSystemType, SpectralFrameType> SPECTRAL_FRAME = new SinglePropertyInfo<AstroCoordSystemType,SpectralFrameType>("spectralFrame", AstroCoordSystemType.class, SpectralFrameType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "SpectralFrame"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "spectralFrameType"), false) {


            @Override
            public SpectralFrameType get(final AstroCoordSystemType _instance_) {
                return ((_instance_ == null)?null:_instance_.spectralFrame);
            }

            @Override
            public void set(final AstroCoordSystemType _instance_, final SpectralFrameType _value_) {
                if (_instance_!= null) {
                    _instance_.spectralFrame = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<AstroCoordSystemType, RedshiftFrameType> REDSHIFT_FRAME = new SinglePropertyInfo<AstroCoordSystemType,RedshiftFrameType>("redshiftFrame", AstroCoordSystemType.class, RedshiftFrameType.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "RedshiftFrame"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "redshiftFrameType"), false) {


            @Override
            public RedshiftFrameType get(final AstroCoordSystemType _instance_) {
                return ((_instance_ == null)?null:_instance_.redshiftFrame);
            }

            @Override
            public void set(final AstroCoordSystemType _instance_, final RedshiftFrameType _value_) {
                if (_instance_!= null) {
                    _instance_.redshiftFrame = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends AstroCoordSystemType.Selector<AstroCoordSystemType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static AstroCoordSystemType.Select _root() {
            return new AstroCoordSystemType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends CoordSysType.Selector<TRoot, TParent>
    {

        private TimeFrameType.Selector<TRoot, AstroCoordSystemType.Selector<TRoot, TParent>> timeFrame = null;
        private SpaceFrameType.Selector<TRoot, AstroCoordSystemType.Selector<TRoot, TParent>> spaceFrame = null;
        private SpectralFrameType.Selector<TRoot, AstroCoordSystemType.Selector<TRoot, TParent>> spectralFrame = null;
        private RedshiftFrameType.Selector<TRoot, AstroCoordSystemType.Selector<TRoot, TParent>> redshiftFrame = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.timeFrame!= null) {
                products.put("timeFrame", this.timeFrame.init());
            }
            if (this.spaceFrame!= null) {
                products.put("spaceFrame", this.spaceFrame.init());
            }
            if (this.spectralFrame!= null) {
                products.put("spectralFrame", this.spectralFrame.init());
            }
            if (this.redshiftFrame!= null) {
                products.put("redshiftFrame", this.redshiftFrame.init());
            }
            return products;
        }

        public TimeFrameType.Selector<TRoot, AstroCoordSystemType.Selector<TRoot, TParent>> timeFrame() {
            return ((this.timeFrame == null)?this.timeFrame = new TimeFrameType.Selector<>(this._root, this, "timeFrame"):this.timeFrame);
        }

        public SpaceFrameType.Selector<TRoot, AstroCoordSystemType.Selector<TRoot, TParent>> spaceFrame() {
            return ((this.spaceFrame == null)?this.spaceFrame = new SpaceFrameType.Selector<>(this._root, this, "spaceFrame"):this.spaceFrame);
        }

        public SpectralFrameType.Selector<TRoot, AstroCoordSystemType.Selector<TRoot, TParent>> spectralFrame() {
            return ((this.spectralFrame == null)?this.spectralFrame = new SpectralFrameType.Selector<>(this._root, this, "spectralFrame"):this.spectralFrame);
        }

        public RedshiftFrameType.Selector<TRoot, AstroCoordSystemType.Selector<TRoot, TParent>> redshiftFrame() {
            return ((this.redshiftFrame == null)?this.redshiftFrame = new RedshiftFrameType.Selector<>(this._root, this, "redshiftFrame"):this.redshiftFrame);
        }

    }

}
