
package org.javastro.ivoa.entities.stc.v1;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Refers coordinate components to specific columns in the FITS file HDU
 * 
 * <p>Java class for coordFITSColumnsType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="coordFITSColumnsType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="Name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="Value" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="Error" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="Resolution" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="Size" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         <element name="PixSize" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "coordFITSColumnsType", propOrder = {
    "name",
    "value",
    "error",
    "resolution",
    "size",
    "pixSize"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class CoordFITSColumnsType implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlElement(name = "Name")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String name;
    /**
     * The column name for the coordinate value; comma-separated if multi-dimensional
     * 
     */
    @XmlElement(name = "Value")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String value;
    /**
     * The column name for the coordinate error; comma-separated if multi-dimensional
     * 
     */
    @XmlElement(name = "Error")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String error;
    /**
     * The column name for the coordinate resolution; comma-separated if multi-dimensional
     * 
     */
    @XmlElement(name = "Resolution")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String resolution;
    /**
     * The column name for the coordinate size; comma-separated if multi-dimensional
     * 
     */
    @XmlElement(name = "Size")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String size;
    /**
     * The column name for the coordinate pixel size; comma-separated if multi-dimensional
     * 
     */
    @XmlElement(name = "PixSize")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String pixSize;
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected transient CoordFITSColumnsType.Modifier __cachedModifier__;

    /**
     * Default no-arg constructor
     * 
     */
    public CoordFITSColumnsType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public CoordFITSColumnsType(final String name, final String value, final String error, final String resolution, final String size, final String pixSize) {
        this.name = name;
        this.value = value;
        this.error = error;
        this.resolution = resolution;
        this.size = size;
        this.pixSize = pixSize;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setName(String value) {
        this.name = value;
    }

    /**
     * The column name for the coordinate value; comma-separated if multi-dimensional
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getValue()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * The column name for the coordinate error; comma-separated if multi-dimensional
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getError() {
        return error;
    }

    /**
     * Sets the value of the error property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getError()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setError(String value) {
        this.error = value;
    }

    /**
     * The column name for the coordinate resolution; comma-separated if multi-dimensional
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getResolution() {
        return resolution;
    }

    /**
     * Sets the value of the resolution property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getResolution()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setResolution(String value) {
        this.resolution = value;
    }

    /**
     * The column name for the coordinate size; comma-separated if multi-dimensional
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getSize() {
        return size;
    }

    /**
     * Sets the value of the size property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getSize()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setSize(String value) {
        this.size = value;
    }

    /**
     * The column name for the coordinate pixel size; comma-separated if multi-dimensional
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getPixSize() {
        return pixSize;
    }

    /**
     * Sets the value of the pixSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getPixSize()
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setPixSize(String value) {
        this.pixSize = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        final CoordFITSColumnsType that = ((CoordFITSColumnsType) object);
        {
            String leftName;
            leftName = this.getName();
            String rightName;
            rightName = that.getName();
            if (this.name!= null) {
                if (that.name!= null) {
                    if (!leftName.equals(rightName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.name!= null) {
                    return false;
                }
            }
        }
        {
            String leftValue;
            leftValue = this.getValue();
            String rightValue;
            rightValue = that.getValue();
            if (this.value!= null) {
                if (that.value!= null) {
                    if (!leftValue.equals(rightValue)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.value!= null) {
                    return false;
                }
            }
        }
        {
            String leftError;
            leftError = this.getError();
            String rightError;
            rightError = that.getError();
            if (this.error!= null) {
                if (that.error!= null) {
                    if (!leftError.equals(rightError)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.error!= null) {
                    return false;
                }
            }
        }
        {
            String leftResolution;
            leftResolution = this.getResolution();
            String rightResolution;
            rightResolution = that.getResolution();
            if (this.resolution!= null) {
                if (that.resolution!= null) {
                    if (!leftResolution.equals(rightResolution)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.resolution!= null) {
                    return false;
                }
            }
        }
        {
            String leftSize;
            leftSize = this.getSize();
            String rightSize;
            rightSize = that.getSize();
            if (this.size!= null) {
                if (that.size!= null) {
                    if (!leftSize.equals(rightSize)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.size!= null) {
                    return false;
                }
            }
        }
        {
            String leftPixSize;
            leftPixSize = this.getPixSize();
            String rightPixSize;
            rightPixSize = that.getPixSize();
            if (this.pixSize!= null) {
                if (that.pixSize!= null) {
                    if (!leftPixSize.equals(rightPixSize)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.pixSize!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        {
            currentHashCode = (currentHashCode* 31);
            String theName;
            theName = this.getName();
            if (this.name!= null) {
                currentHashCode += theName.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theValue;
            theValue = this.getValue();
            if (this.value!= null) {
                currentHashCode += theValue.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theError;
            theError = this.getError();
            if (this.error!= null) {
                currentHashCode += theError.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theResolution;
            theResolution = this.getResolution();
            if (this.resolution!= null) {
                currentHashCode += theResolution.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theSize;
            theSize = this.getSize();
            if (this.size!= null) {
                currentHashCode += theSize.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String thePixSize;
            thePixSize = this.getPixSize();
            if (this.pixSize!= null) {
                currentHashCode += thePixSize.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        {
            String theName;
            theName = this.getName();
            strategy.appendField(locator, this, "name", buffer, theName, (this.name!= null));
        }
        {
            String theValue;
            theValue = this.getValue();
            strategy.appendField(locator, this, "value", buffer, theValue, (this.value!= null));
        }
        {
            String theError;
            theError = this.getError();
            strategy.appendField(locator, this, "error", buffer, theError, (this.error!= null));
        }
        {
            String theResolution;
            theResolution = this.getResolution();
            strategy.appendField(locator, this, "resolution", buffer, theResolution, (this.resolution!= null));
        }
        {
            String theSize;
            theSize = this.getSize();
            strategy.appendField(locator, this, "size", buffer, theSize, (this.size!= null));
        }
        {
            String thePixSize;
            thePixSize = this.getPixSize();
            strategy.appendField(locator, this, "pixSize", buffer, thePixSize, (this.pixSize!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        if (right instanceof CoordFITSColumnsType) {
            final CoordFITSColumnsType target = this;
            final CoordFITSColumnsType leftObject = ((CoordFITSColumnsType) left);
            final CoordFITSColumnsType rightObject = ((CoordFITSColumnsType) right);
            {
                Boolean nameShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.name!= null), (rightObject.name!= null));
                if (nameShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsName;
                    lhsName = leftObject.getName();
                    String rhsName;
                    rhsName = rightObject.getName();
                    String mergedName = ((String) strategy.merge(LocatorUtils.property(leftLocator, "name", lhsName), LocatorUtils.property(rightLocator, "name", rhsName), lhsName, rhsName, (leftObject.name!= null), (rightObject.name!= null)));
                    target.setName(mergedName);
                } else {
                    if (nameShouldBeMergedAndSet == Boolean.FALSE) {
                        target.name = null;
                    }
                }
            }
            {
                Boolean valueShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.value!= null), (rightObject.value!= null));
                if (valueShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsValue;
                    lhsValue = leftObject.getValue();
                    String rhsValue;
                    rhsValue = rightObject.getValue();
                    String mergedValue = ((String) strategy.merge(LocatorUtils.property(leftLocator, "value", lhsValue), LocatorUtils.property(rightLocator, "value", rhsValue), lhsValue, rhsValue, (leftObject.value!= null), (rightObject.value!= null)));
                    target.setValue(mergedValue);
                } else {
                    if (valueShouldBeMergedAndSet == Boolean.FALSE) {
                        target.value = null;
                    }
                }
            }
            {
                Boolean errorShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.error!= null), (rightObject.error!= null));
                if (errorShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsError;
                    lhsError = leftObject.getError();
                    String rhsError;
                    rhsError = rightObject.getError();
                    String mergedError = ((String) strategy.merge(LocatorUtils.property(leftLocator, "error", lhsError), LocatorUtils.property(rightLocator, "error", rhsError), lhsError, rhsError, (leftObject.error!= null), (rightObject.error!= null)));
                    target.setError(mergedError);
                } else {
                    if (errorShouldBeMergedAndSet == Boolean.FALSE) {
                        target.error = null;
                    }
                }
            }
            {
                Boolean resolutionShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.resolution!= null), (rightObject.resolution!= null));
                if (resolutionShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsResolution;
                    lhsResolution = leftObject.getResolution();
                    String rhsResolution;
                    rhsResolution = rightObject.getResolution();
                    String mergedResolution = ((String) strategy.merge(LocatorUtils.property(leftLocator, "resolution", lhsResolution), LocatorUtils.property(rightLocator, "resolution", rhsResolution), lhsResolution, rhsResolution, (leftObject.resolution!= null), (rightObject.resolution!= null)));
                    target.setResolution(mergedResolution);
                } else {
                    if (resolutionShouldBeMergedAndSet == Boolean.FALSE) {
                        target.resolution = null;
                    }
                }
            }
            {
                Boolean sizeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.size!= null), (rightObject.size!= null));
                if (sizeShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsSize;
                    lhsSize = leftObject.getSize();
                    String rhsSize;
                    rhsSize = rightObject.getSize();
                    String mergedSize = ((String) strategy.merge(LocatorUtils.property(leftLocator, "size", lhsSize), LocatorUtils.property(rightLocator, "size", rhsSize), lhsSize, rhsSize, (leftObject.size!= null), (rightObject.size!= null)));
                    target.setSize(mergedSize);
                } else {
                    if (sizeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.size = null;
                    }
                }
            }
            {
                Boolean pixSizeShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.pixSize!= null), (rightObject.pixSize!= null));
                if (pixSizeShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsPixSize;
                    lhsPixSize = leftObject.getPixSize();
                    String rhsPixSize;
                    rhsPixSize = rightObject.getPixSize();
                    String mergedPixSize = ((String) strategy.merge(LocatorUtils.property(leftLocator, "pixSize", lhsPixSize), LocatorUtils.property(rightLocator, "pixSize", rhsPixSize), lhsPixSize, rhsPixSize, (leftObject.pixSize!= null), (rightObject.pixSize!= null)));
                    target.setPixSize(mergedPixSize);
                } else {
                    if (pixSizeShouldBeMergedAndSet == Boolean.FALSE) {
                        target.pixSize = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new CoordFITSColumnsType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordFITSColumnsType clone() {
        final CoordFITSColumnsType _newObject;
        try {
            _newObject = ((CoordFITSColumnsType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordFITSColumnsType createCopy() {
        final CoordFITSColumnsType _newObject;
        try {
            _newObject = ((CoordFITSColumnsType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        _newObject.name = this.name;
        _newObject.value = this.value;
        _newObject.error = this.error;
        _newObject.resolution = this.resolution;
        _newObject.size = this.size;
        _newObject.pixSize = this.pixSize;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordFITSColumnsType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CoordFITSColumnsType _newObject;
        try {
            _newObject = ((CoordFITSColumnsType) super.clone());
        } catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
            _newObject.name = this.name;
        }
        final PropertyTree valuePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("value"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(valuePropertyTree!= null):((valuePropertyTree == null)||(!valuePropertyTree.isLeaf())))) {
            _newObject.value = this.value;
        }
        final PropertyTree errorPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("error"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(errorPropertyTree!= null):((errorPropertyTree == null)||(!errorPropertyTree.isLeaf())))) {
            _newObject.error = this.error;
        }
        final PropertyTree resolutionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("resolution"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(resolutionPropertyTree!= null):((resolutionPropertyTree == null)||(!resolutionPropertyTree.isLeaf())))) {
            _newObject.resolution = this.resolution;
        }
        final PropertyTree sizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("size"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(sizePropertyTree!= null):((sizePropertyTree == null)||(!sizePropertyTree.isLeaf())))) {
            _newObject.size = this.size;
        }
        final PropertyTree pixSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("pixSize"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(pixSizePropertyTree!= null):((pixSizePropertyTree == null)||(!pixSizePropertyTree.isLeaf())))) {
            _newObject.pixSize = this.pixSize;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordFITSColumnsType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordFITSColumnsType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordFITSColumnsType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new CoordFITSColumnsType.Modifier();
        }
        return ((CoordFITSColumnsType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final CoordFITSColumnsType.Builder<_B> _other) {
        _other.name = this.name;
        _other.value = this.value;
        _other.error = this.error;
        _other.resolution = this.resolution;
        _other.size = this.size;
        _other.pixSize = this.pixSize;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >CoordFITSColumnsType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new CoordFITSColumnsType.Builder<_B>(_parentBuilder, this, true);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordFITSColumnsType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static CoordFITSColumnsType.Builder<Void> builder() {
        return new CoordFITSColumnsType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >CoordFITSColumnsType.Builder<_B> copyOf(final CoordFITSColumnsType _other) {
        final CoordFITSColumnsType.Builder<_B> _newBuilder = new CoordFITSColumnsType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final CoordFITSColumnsType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
            _other.name = this.name;
        }
        final PropertyTree valuePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("value"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(valuePropertyTree!= null):((valuePropertyTree == null)||(!valuePropertyTree.isLeaf())))) {
            _other.value = this.value;
        }
        final PropertyTree errorPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("error"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(errorPropertyTree!= null):((errorPropertyTree == null)||(!errorPropertyTree.isLeaf())))) {
            _other.error = this.error;
        }
        final PropertyTree resolutionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("resolution"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(resolutionPropertyTree!= null):((resolutionPropertyTree == null)||(!resolutionPropertyTree.isLeaf())))) {
            _other.resolution = this.resolution;
        }
        final PropertyTree sizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("size"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(sizePropertyTree!= null):((sizePropertyTree == null)||(!sizePropertyTree.isLeaf())))) {
            _other.size = this.size;
        }
        final PropertyTree pixSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("pixSize"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(pixSizePropertyTree!= null):((pixSizePropertyTree == null)||(!pixSizePropertyTree.isLeaf())))) {
            _other.pixSize = this.pixSize;
        }
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >CoordFITSColumnsType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new CoordFITSColumnsType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordFITSColumnsType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >CoordFITSColumnsType.Builder<_B> copyOf(final CoordFITSColumnsType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CoordFITSColumnsType.Builder<_B> _newBuilder = new CoordFITSColumnsType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static CoordFITSColumnsType.Builder<Void> copyExcept(final CoordFITSColumnsType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static CoordFITSColumnsType.Builder<Void> copyOnly(final CoordFITSColumnsType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordFITSColumnsType visit(final PropertyVisitor _visitor_) {
        _visitor_.visit(this);
        _visitor_.visit(new SingleProperty<>(CoordFITSColumnsType.PropInfo.NAME, this));
        _visitor_.visit(new SingleProperty<>(CoordFITSColumnsType.PropInfo.VALUE, this));
        _visitor_.visit(new SingleProperty<>(CoordFITSColumnsType.PropInfo.ERROR, this));
        _visitor_.visit(new SingleProperty<>(CoordFITSColumnsType.PropInfo.RESOLUTION, this));
        _visitor_.visit(new SingleProperty<>(CoordFITSColumnsType.PropInfo.SIZE, this));
        _visitor_.visit(new SingleProperty<>(CoordFITSColumnsType.PropInfo.PIX_SIZE, this));
        return this;
    }

    public static class Builder<_B >implements Buildable
    {

        protected final _B _parentBuilder;
        protected final CoordFITSColumnsType _storedValue;
        private String name;
        private String value;
        private String error;
        private String resolution;
        private String size;
        private String pixSize;

        public Builder(final _B _parentBuilder, final CoordFITSColumnsType _other, final boolean _copy) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    this.name = _other.name;
                    this.value = _other.value;
                    this.error = _other.error;
                    this.resolution = _other.resolution;
                    this.size = _other.size;
                    this.pixSize = _other.pixSize;
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public Builder(final _B _parentBuilder, final CoordFITSColumnsType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            this._parentBuilder = _parentBuilder;
            if (_other!= null) {
                if (_copy) {
                    _storedValue = null;
                    final PropertyTree namePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("name"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(namePropertyTree!= null):((namePropertyTree == null)||(!namePropertyTree.isLeaf())))) {
                        this.name = _other.name;
                    }
                    final PropertyTree valuePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("value"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(valuePropertyTree!= null):((valuePropertyTree == null)||(!valuePropertyTree.isLeaf())))) {
                        this.value = _other.value;
                    }
                    final PropertyTree errorPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("error"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(errorPropertyTree!= null):((errorPropertyTree == null)||(!errorPropertyTree.isLeaf())))) {
                        this.error = _other.error;
                    }
                    final PropertyTree resolutionPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("resolution"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(resolutionPropertyTree!= null):((resolutionPropertyTree == null)||(!resolutionPropertyTree.isLeaf())))) {
                        this.resolution = _other.resolution;
                    }
                    final PropertyTree sizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("size"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(sizePropertyTree!= null):((sizePropertyTree == null)||(!sizePropertyTree.isLeaf())))) {
                        this.size = _other.size;
                    }
                    final PropertyTree pixSizePropertyTree = ((_propertyTree == null)?null:_propertyTree.get("pixSize"));
                    if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(pixSizePropertyTree!= null):((pixSizePropertyTree == null)||(!pixSizePropertyTree.isLeaf())))) {
                        this.pixSize = _other.pixSize;
                    }
                } else {
                    _storedValue = _other;
                }
            } else {
                _storedValue = null;
            }
        }

        public _B end() {
            return this._parentBuilder;
        }

        protected<_P extends CoordFITSColumnsType >_P init(final _P _product) {
            _product.name = this.name;
            _product.value = this.value;
            _product.error = this.error;
            _product.resolution = this.resolution;
            _product.size = this.size;
            _product.pixSize = this.pixSize;
            return _product;
        }

        /**
         * Sets the new value of "name" (any previous value will be replaced)
         * 
         * @param name
         *     New value of the "name" property.
         */
        public CoordFITSColumnsType.Builder<_B> withName(final String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the new value of "value" (any previous value will be replaced)
         * 
         * @param value
         *     New value of the "value" property.
         */
        public CoordFITSColumnsType.Builder<_B> withValue(final String value) {
            this.value = value;
            return this;
        }

        /**
         * Sets the new value of "error" (any previous value will be replaced)
         * 
         * @param error
         *     New value of the "error" property.
         */
        public CoordFITSColumnsType.Builder<_B> withError(final String error) {
            this.error = error;
            return this;
        }

        /**
         * Sets the new value of "resolution" (any previous value will be replaced)
         * 
         * @param resolution
         *     New value of the "resolution" property.
         */
        public CoordFITSColumnsType.Builder<_B> withResolution(final String resolution) {
            this.resolution = resolution;
            return this;
        }

        /**
         * Sets the new value of "size" (any previous value will be replaced)
         * 
         * @param size
         *     New value of the "size" property.
         */
        public CoordFITSColumnsType.Builder<_B> withSize(final String size) {
            this.size = size;
            return this;
        }

        /**
         * Sets the new value of "pixSize" (any previous value will be replaced)
         * 
         * @param pixSize
         *     New value of the "pixSize" property.
         */
        public CoordFITSColumnsType.Builder<_B> withPixSize(final String pixSize) {
            this.pixSize = pixSize;
            return this;
        }

        @Override
        public CoordFITSColumnsType build() {
            if (_storedValue == null) {
                return this.init(new CoordFITSColumnsType());
            } else {
                return ((CoordFITSColumnsType) _storedValue);
            }
        }

        public CoordFITSColumnsType.Builder<_B> copyOf(final CoordFITSColumnsType _other) {
            _other.copyTo(this);
            return this;
        }

        public CoordFITSColumnsType.Builder<_B> copyOf(final CoordFITSColumnsType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier {


        public void setName(final String name) {
            CoordFITSColumnsType.this.setName(name);
        }

        public void setValue(final String value) {
            CoordFITSColumnsType.this.setValue(value);
        }

        public void setError(final String error) {
            CoordFITSColumnsType.this.setError(error);
        }

        public void setResolution(final String resolution) {
            CoordFITSColumnsType.this.setResolution(resolution);
        }

        public void setSize(final String size) {
            CoordFITSColumnsType.this.setSize(size);
        }

        public void setPixSize(final String pixSize) {
            CoordFITSColumnsType.this.setPixSize(pixSize);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<CoordFITSColumnsType, String> NAME = new SinglePropertyInfo<CoordFITSColumnsType,String>("name", CoordFITSColumnsType.class, String.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Name"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final CoordFITSColumnsType _instance_) {
                return ((_instance_ == null)?null:_instance_.name);
            }

            @Override
            public void set(final CoordFITSColumnsType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.name = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<CoordFITSColumnsType, String> VALUE = new SinglePropertyInfo<CoordFITSColumnsType,String>("value", CoordFITSColumnsType.class, String.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Value"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final CoordFITSColumnsType _instance_) {
                return ((_instance_ == null)?null:_instance_.value);
            }

            @Override
            public void set(final CoordFITSColumnsType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.value = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<CoordFITSColumnsType, String> ERROR = new SinglePropertyInfo<CoordFITSColumnsType,String>("error", CoordFITSColumnsType.class, String.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Error"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final CoordFITSColumnsType _instance_) {
                return ((_instance_ == null)?null:_instance_.error);
            }

            @Override
            public void set(final CoordFITSColumnsType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.error = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<CoordFITSColumnsType, String> RESOLUTION = new SinglePropertyInfo<CoordFITSColumnsType,String>("resolution", CoordFITSColumnsType.class, String.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Resolution"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final CoordFITSColumnsType _instance_) {
                return ((_instance_ == null)?null:_instance_.resolution);
            }

            @Override
            public void set(final CoordFITSColumnsType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.resolution = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<CoordFITSColumnsType, String> SIZE = new SinglePropertyInfo<CoordFITSColumnsType,String>("size", CoordFITSColumnsType.class, String.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "Size"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final CoordFITSColumnsType _instance_) {
                return ((_instance_ == null)?null:_instance_.size);
            }

            @Override
            public void set(final CoordFITSColumnsType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.size = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<CoordFITSColumnsType, String> PIX_SIZE = new SinglePropertyInfo<CoordFITSColumnsType,String>("pixSize", CoordFITSColumnsType.class, String.class, false, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "PixSize"), new QName("http://www.w3.org/2001/XMLSchema", "string"), false) {


            @Override
            public String get(final CoordFITSColumnsType _instance_) {
                return ((_instance_ == null)?null:_instance_.pixSize);
            }

            @Override
            public void set(final CoordFITSColumnsType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.pixSize = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends CoordFITSColumnsType.Selector<CoordFITSColumnsType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static CoordFITSColumnsType.Select _root() {
            return new CoordFITSColumnsType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends com.kscs.util.jaxb.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, CoordFITSColumnsType.Selector<TRoot, TParent>> name = null;
        private com.kscs.util.jaxb.Selector<TRoot, CoordFITSColumnsType.Selector<TRoot, TParent>> value = null;
        private com.kscs.util.jaxb.Selector<TRoot, CoordFITSColumnsType.Selector<TRoot, TParent>> error = null;
        private com.kscs.util.jaxb.Selector<TRoot, CoordFITSColumnsType.Selector<TRoot, TParent>> resolution = null;
        private com.kscs.util.jaxb.Selector<TRoot, CoordFITSColumnsType.Selector<TRoot, TParent>> size = null;
        private com.kscs.util.jaxb.Selector<TRoot, CoordFITSColumnsType.Selector<TRoot, TParent>> pixSize = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.name!= null) {
                products.put("name", this.name.init());
            }
            if (this.value!= null) {
                products.put("value", this.value.init());
            }
            if (this.error!= null) {
                products.put("error", this.error.init());
            }
            if (this.resolution!= null) {
                products.put("resolution", this.resolution.init());
            }
            if (this.size!= null) {
                products.put("size", this.size.init());
            }
            if (this.pixSize!= null) {
                products.put("pixSize", this.pixSize.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, CoordFITSColumnsType.Selector<TRoot, TParent>> name() {
            return ((this.name == null)?this.name = new com.kscs.util.jaxb.Selector<>(this._root, this, "name"):this.name);
        }

        public com.kscs.util.jaxb.Selector<TRoot, CoordFITSColumnsType.Selector<TRoot, TParent>> value() {
            return ((this.value == null)?this.value = new com.kscs.util.jaxb.Selector<>(this._root, this, "value"):this.value);
        }

        public com.kscs.util.jaxb.Selector<TRoot, CoordFITSColumnsType.Selector<TRoot, TParent>> error() {
            return ((this.error == null)?this.error = new com.kscs.util.jaxb.Selector<>(this._root, this, "error"):this.error);
        }

        public com.kscs.util.jaxb.Selector<TRoot, CoordFITSColumnsType.Selector<TRoot, TParent>> resolution() {
            return ((this.resolution == null)?this.resolution = new com.kscs.util.jaxb.Selector<>(this._root, this, "resolution"):this.resolution);
        }

        public com.kscs.util.jaxb.Selector<TRoot, CoordFITSColumnsType.Selector<TRoot, TParent>> size() {
            return ((this.size == null)?this.size = new com.kscs.util.jaxb.Selector<>(this._root, this, "size"):this.size);
        }

        public com.kscs.util.jaxb.Selector<TRoot, CoordFITSColumnsType.Selector<TRoot, TParent>> pixSize() {
            return ((this.pixSize == null)?this.pixSize = new com.kscs.util.jaxb.Selector<>(this._root, this, "pixSize"):this.pixSize);
        }

    }

}
