
package org.javastro.ivoa.entities.stc.v1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.CollectionProperty;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.CollectionPropertyInfo;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * Coordinate system definition: a collection of coordinate frames
 * 
 * A CoordSys consists of at least one coordinate frames; unfortunately, schema inheritance and polymorphism doesn't allow us to specify this in the most genarl way
 * 
 * <p>Java class for coordSysType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="coordSysType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}stcBaseType">
 *       <sequence maxOccurs="unbounded" minOccurs="0">
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}CoordFrame" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "coordSysType", propOrder = {
    "coordFrames"
})
@XmlSeeAlso({
    AstroCoordSystemType.class,
    PixelCoordSystemType.class
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class CoordSysType
    extends StcBaseType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * CoordFrame substitution group head element
     * 
     */
    @XmlElement(name = "CoordFrame", nillable = true)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<GenericCoordFrameType> coordFrames;

    /**
     * Default no-arg constructor
     * 
     */
    public CoordSysType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public CoordSysType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final List<GenericCoordFrameType> coordFrames) {
        super(id, idref, ucd, type, href, idType, idrefType);
        this.coordFrames = coordFrames;
    }

    /**
     * CoordFrame substitution group head element
     * 
     * Gets the value of the coordFrames property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the coordFrames property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCoordFrames().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GenericCoordFrameType }
     * </p>
     * 
     * 
     * @return
     *     The value of the coordFrames property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<GenericCoordFrameType> getCoordFrames() {
        if (coordFrames == null) {
            coordFrames = new ArrayList<>();
        }
        return this.coordFrames;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final CoordSysType that = ((CoordSysType) object);
        {
            List<GenericCoordFrameType> leftCoordFrames;
            leftCoordFrames = (((this.coordFrames!= null)&&(!this.coordFrames.isEmpty()))?this.getCoordFrames():null);
            List<GenericCoordFrameType> rightCoordFrames;
            rightCoordFrames = (((that.coordFrames!= null)&&(!that.coordFrames.isEmpty()))?that.getCoordFrames():null);
            if ((this.coordFrames!= null)&&(!this.coordFrames.isEmpty())) {
                if ((that.coordFrames!= null)&&(!that.coordFrames.isEmpty())) {
                    if (!leftCoordFrames.equals(rightCoordFrames)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.coordFrames!= null)&&(!that.coordFrames.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<GenericCoordFrameType> theCoordFrames;
            theCoordFrames = (((this.coordFrames!= null)&&(!this.coordFrames.isEmpty()))?this.getCoordFrames():null);
            if ((this.coordFrames!= null)&&(!this.coordFrames.isEmpty())) {
                currentHashCode += theCoordFrames.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<GenericCoordFrameType> theCoordFrames;
            theCoordFrames = (((this.coordFrames!= null)&&(!this.coordFrames.isEmpty()))?this.getCoordFrames():null);
            strategy.appendField(locator, this, "coordFrames", buffer, theCoordFrames, ((this.coordFrames!= null)&&(!this.coordFrames.isEmpty())));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof CoordSysType) {
            final CoordSysType target = this;
            final CoordSysType leftObject = ((CoordSysType) left);
            final CoordSysType rightObject = ((CoordSysType) right);
            {
                Boolean coordFramesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.coordFrames!= null)&&(!leftObject.coordFrames.isEmpty())), ((rightObject.coordFrames!= null)&&(!rightObject.coordFrames.isEmpty())));
                if (coordFramesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<GenericCoordFrameType> lhsCoordFrames;
                    lhsCoordFrames = (((leftObject.coordFrames!= null)&&(!leftObject.coordFrames.isEmpty()))?leftObject.getCoordFrames():null);
                    List<GenericCoordFrameType> rhsCoordFrames;
                    rhsCoordFrames = (((rightObject.coordFrames!= null)&&(!rightObject.coordFrames.isEmpty()))?rightObject.getCoordFrames():null);
                    List<GenericCoordFrameType> mergedCoordFrames = ((List<GenericCoordFrameType> ) strategy.merge(LocatorUtils.property(leftLocator, "coordFrames", lhsCoordFrames), LocatorUtils.property(rightLocator, "coordFrames", rhsCoordFrames), lhsCoordFrames, rhsCoordFrames, ((leftObject.coordFrames!= null)&&(!leftObject.coordFrames.isEmpty())), ((rightObject.coordFrames!= null)&&(!rightObject.coordFrames.isEmpty()))));
                    target.coordFrames = null;
                    if (mergedCoordFrames!= null) {
                        List<GenericCoordFrameType> uniqueCoordFramesl = target.getCoordFrames();
                        uniqueCoordFramesl.addAll(mergedCoordFrames);
                    }
                } else {
                    if (coordFramesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.coordFrames = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new CoordSysType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordSysType clone() {
        final CoordSysType _newObject;
        _newObject = ((CoordSysType) super.clone());
        if (this.coordFrames == null) {
            _newObject.coordFrames = null;
        } else {
            _newObject.coordFrames = new ArrayList<>();
            for (GenericCoordFrameType _item: this.coordFrames) {
                _newObject.coordFrames.add(((_item == null)?null:_item.clone()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordSysType createCopy() {
        final CoordSysType _newObject = ((CoordSysType) super.createCopy());
        if (this.coordFrames == null) {
            _newObject.coordFrames = null;
        } else {
            _newObject.coordFrames = new ArrayList<>();
            for (GenericCoordFrameType _item: this.coordFrames) {
                _newObject.coordFrames.add(((_item == null)?null:_item.createCopy()));
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordSysType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CoordSysType _newObject = ((CoordSysType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree coordFramesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coordFrames"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coordFramesPropertyTree!= null):((coordFramesPropertyTree == null)||(!coordFramesPropertyTree.isLeaf())))) {
            if (this.coordFrames == null) {
                _newObject.coordFrames = null;
            } else {
                _newObject.coordFrames = new ArrayList<>();
                for (GenericCoordFrameType _item: this.coordFrames) {
                    _newObject.coordFrames.add(((_item == null)?null:_item.createCopy(coordFramesPropertyTree, _propertyTreeUse)));
                }
            }
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordSysType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordSysType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordSysType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new CoordSysType.Modifier();
        }
        return ((CoordSysType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final CoordSysType.Builder<_B> _other) {
        super.copyTo(_other);
        if (this.coordFrames == null) {
            _other.coordFrames = null;
        } else {
            _other.coordFrames = new ArrayList<>();
            for (GenericCoordFrameType _item: this.coordFrames) {
                _other.coordFrames.add(((_item == null)?null:_item.newCopyBuilder(_other)));
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >CoordSysType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new CoordSysType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordSysType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static CoordSysType.Builder<Void> builder() {
        return new CoordSysType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >CoordSysType.Builder<_B> copyOf(final StcBaseType _other) {
        final CoordSysType.Builder<_B> _newBuilder = new CoordSysType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >CoordSysType.Builder<_B> copyOf(final CoordSysType _other) {
        final CoordSysType.Builder<_B> _newBuilder = new CoordSysType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final CoordSysType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree coordFramesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coordFrames"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coordFramesPropertyTree!= null):((coordFramesPropertyTree == null)||(!coordFramesPropertyTree.isLeaf())))) {
            if (this.coordFrames == null) {
                _other.coordFrames = null;
            } else {
                _other.coordFrames = new ArrayList<>();
                for (GenericCoordFrameType _item: this.coordFrames) {
                    _other.coordFrames.add(((_item == null)?null:_item.newCopyBuilder(_other, coordFramesPropertyTree, _propertyTreeUse)));
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >CoordSysType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new CoordSysType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordSysType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >CoordSysType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CoordSysType.Builder<_B> _newBuilder = new CoordSysType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >CoordSysType.Builder<_B> copyOf(final CoordSysType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CoordSysType.Builder<_B> _newBuilder = new CoordSysType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static CoordSysType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static CoordSysType.Builder<Void> copyExcept(final CoordSysType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static CoordSysType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static CoordSysType.Builder<Void> copyOnly(final CoordSysType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordSysType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new CollectionProperty<>(CoordSysType.PropInfo.COORD_FRAMES, this))&&(this.coordFrames!= null)) {
            for (GenericCoordFrameType _item_: this.coordFrames) {
                if (_item_!= null) {
                    _item_.visit(_visitor_);
                }
            }
        }
        return this;
    }

    public static class Builder<_B >
        extends StcBaseType.Builder<_B>
        implements Buildable
    {

        private List<GenericCoordFrameType.Builder<CoordSysType.Builder<_B>>> coordFrames;

        public Builder(final _B _parentBuilder, final CoordSysType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                if (_other.coordFrames == null) {
                    this.coordFrames = null;
                } else {
                    this.coordFrames = new ArrayList<>();
                    for (GenericCoordFrameType _item: _other.coordFrames) {
                        this.coordFrames.add(((_item == null)?null:_item.newCopyBuilder(this)));
                    }
                }
            }
        }

        public Builder(final _B _parentBuilder, final CoordSysType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree coordFramesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coordFrames"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coordFramesPropertyTree!= null):((coordFramesPropertyTree == null)||(!coordFramesPropertyTree.isLeaf())))) {
                    if (_other.coordFrames == null) {
                        this.coordFrames = null;
                    } else {
                        this.coordFrames = new ArrayList<>();
                        for (GenericCoordFrameType _item: _other.coordFrames) {
                            this.coordFrames.add(((_item == null)?null:_item.newCopyBuilder(this, coordFramesPropertyTree, _propertyTreeUse)));
                        }
                    }
                }
            }
        }

        protected<_P extends CoordSysType >_P init(final _P _product) {
            if (this.coordFrames!= null) {
                final List<GenericCoordFrameType> coordFrames = new ArrayList<>(this.coordFrames.size());
                for (GenericCoordFrameType.Builder<CoordSysType.Builder<_B>> _item: this.coordFrames) {
                    coordFrames.add(_item.build());
                }
                _product.coordFrames = coordFrames;
            }
            return super.init(_product);
        }

        /**
         * Adds the given items to the value of "coordFrames"
         * 
         * @param coordFrames
         *     Items to add to the value of the "coordFrames" property
         */
        public CoordSysType.Builder<_B> addCoordFrames(final Iterable<? extends GenericCoordFrameType> coordFrames) {
            if (coordFrames!= null) {
                if (this.coordFrames == null) {
                    this.coordFrames = new ArrayList<>();
                }
                for (GenericCoordFrameType _item: coordFrames) {
                    this.coordFrames.add(new GenericCoordFrameType.Builder<>(this, _item, false));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "coordFrames" (any previous value will be replaced)
         * 
         * @param coordFrames
         *     New value of the "coordFrames" property.
         */
        public CoordSysType.Builder<_B> withCoordFrames(final Iterable<? extends GenericCoordFrameType> coordFrames) {
            if (this.coordFrames!= null) {
                this.coordFrames.clear();
            }
            return addCoordFrames(coordFrames);
        }

        /**
         * Adds the given items to the value of "coordFrames"
         * 
         * @param coordFrames
         *     Items to add to the value of the "coordFrames" property
         */
        public CoordSysType.Builder<_B> addCoordFrames(GenericCoordFrameType... coordFrames) {
            addCoordFrames(Arrays.asList(coordFrames));
            return this;
        }

        /**
         * Sets the new value of "coordFrames" (any previous value will be replaced)
         * 
         * @param coordFrames
         *     New value of the "coordFrames" property.
         */
        public CoordSysType.Builder<_B> withCoordFrames(GenericCoordFrameType... coordFrames) {
            withCoordFrames(Arrays.asList(coordFrames));
            return this;
        }

        /**
         * Returns a new builder to build an additional value of the "CoordFrames"
         * property.
         * Use {@link
         * org.javastro.ivoa.entities.stc.v1.GenericCoordFrameType.Builder#end()} to return
         * to the current builder.
         * 
         * @return
         *     a new builder to build an additional value of the "CoordFrames" property.
         *     Use {@link
         *     org.javastro.ivoa.entities.stc.v1.GenericCoordFrameType.Builder#end()} to return
         *     to the current builder.
         */
        public GenericCoordFrameType.Builder<? extends CoordSysType.Builder<_B>> addCoordFrames() {
            if (this.coordFrames == null) {
                this.coordFrames = new ArrayList<>();
            }
            final GenericCoordFrameType.Builder<CoordSysType.Builder<_B>> coordFrames_Builder = new GenericCoordFrameType.Builder<>(this, null, false);
            this.coordFrames.add(coordFrames_Builder);
            return coordFrames_Builder;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public CoordSysType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public CoordSysType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public CoordSysType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public CoordSysType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public CoordSysType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public CoordSysType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public CoordSysType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public CoordSysType build() {
            if (_storedValue == null) {
                return this.init(new CoordSysType());
            } else {
                return ((CoordSysType) _storedValue);
            }
        }

        public CoordSysType.Builder<_B> copyOf(final CoordSysType _other) {
            _other.copyTo(this);
            return this;
        }

        public CoordSysType.Builder<_B> copyOf(final CoordSysType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends StcBaseType.Modifier
    {


        public List<GenericCoordFrameType> getCoordFrames() {
            if (CoordSysType.this.coordFrames == null) {
                CoordSysType.this.coordFrames = new ArrayList<>();
            }
            return CoordSysType.this.coordFrames;
        }

    }

    public static class PropInfo {

        public static final transient CollectionPropertyInfo<CoordSysType, GenericCoordFrameType> COORD_FRAMES = new CollectionPropertyInfo<CoordSysType,GenericCoordFrameType>("coordFrames", CoordSysType.class, GenericCoordFrameType.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "CoordFrame"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "genericCoordFrameType"), false) {


            @Override
            public List<GenericCoordFrameType> get(final CoordSysType _instance_) {
                return ((_instance_ == null)?null:_instance_.coordFrames);
            }

            @Override
            public void set(final CoordSysType _instance_, final List<GenericCoordFrameType> _value_) {
                if (_instance_!= null) {
                    _instance_.coordFrames = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends CoordSysType.Selector<CoordSysType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static CoordSysType.Select _root() {
            return new CoordSysType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends StcBaseType.Selector<TRoot, TParent>
    {

        private GenericCoordFrameType.Selector<TRoot, CoordSysType.Selector<TRoot, TParent>> coordFrames = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.coordFrames!= null) {
                products.put("coordFrames", this.coordFrames.init());
            }
            return products;
        }

        public GenericCoordFrameType.Selector<TRoot, CoordSysType.Selector<TRoot, TParent>> coordFrames() {
            return ((this.coordFrames == null)?this.coordFrames = new GenericCoordFrameType.Selector<>(this._root, this, "coordFrames"):this.coordFrames);
        }

    }

}
