
package org.javastro.ivoa.entities.stc.v1;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.IndirectCollectionProperty;
import com.kscs.util.jaxb.IndirectCollectionPropertyInfo;
import com.kscs.util.jaxb.IndirectCollectionPropertyInfo;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * The generic coordsType
 * 
 * A CoordSys consists of at least one coordinate frames; unfortunately, schema inheritance and polymorphism doesn't allow us to specify this in the most genarl way
 * 
 * <p>Java class for coordsType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="coordsType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}stcBaseType">
 *       <sequence maxOccurs="unbounded" minOccurs="0">
 *         <element ref="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}GenCoordinate"/>
 *       </sequence>
 *       <attribute name="coord_system_id" use="required" type="{http://www.w3.org/2001/XMLSchema}IDREF" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "coordsType", propOrder = {
    "genCoordinates"
})
@XmlSeeAlso({
    AstroCoordsType.class,
    PixelCoordsType.class
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class CoordsType
    extends StcBaseType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    /**
     * Head element of Generic coordinate substitution group
     * 
     */
    @XmlElementRef(name = "GenCoordinate", namespace = "http://www.ivoa.net/xml/STC/stc-v1.30.xsd", type = JAXBElement.class, required = false)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected List<JAXBElement<? extends CoordinateType>> genCoordinates;
    @XmlAttribute(name = "coord_system_id", required = true)
    @XmlIDREF
    @XmlSchemaType(name = "IDREF")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected Object coordSystemId;

    /**
     * Default no-arg constructor
     * 
     */
    public CoordsType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public CoordsType(final String id, final Object idref, final String ucd, final String type, final String href, final String idType, final String idrefType, final List<JAXBElement<? extends CoordinateType>> genCoordinates, final Object coordSystemId) {
        super(id, idref, ucd, type, href, idType, idrefType);
        this.genCoordinates = genCoordinates;
        this.coordSystemId = coordSystemId;
    }

    /**
     * Head element of Generic coordinate substitution group
     * 
     * Gets the value of the genCoordinates property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the genCoordinates property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getGenCoordinates().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JAXBElement }{@code <}{@link CoordinateType }{@code >}
     * {@link JAXBElement }{@code <}{@link GenVector2CoordinateType }{@code >}
     * {@link JAXBElement }{@code <}{@link GenVector3CoordinateType }{@code >}
     * {@link JAXBElement }{@code <}{@link ScalarCoordinateType }{@code >}
     * {@link JAXBElement }{@code <}{@link StringCoordinateType }{@code >}
     * </p>
     * 
     * 
     * @return
     *     The value of the genCoordinates property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public List<JAXBElement<? extends CoordinateType>> getGenCoordinates() {
        if (genCoordinates == null) {
            genCoordinates = new ArrayList<>();
        }
        return this.genCoordinates;
    }

    /**
     * Gets the value of the coordSystemId property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object getCoordSystemId() {
        return coordSystemId;
    }

    /**
     * Sets the value of the coordSystemId property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setCoordSystemId(Object value) {
        this.coordSystemId = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final CoordsType that = ((CoordsType) object);
        {
            List<JAXBElement<? extends CoordinateType>> leftGenCoordinates;
            leftGenCoordinates = (((this.genCoordinates!= null)&&(!this.genCoordinates.isEmpty()))?this.getGenCoordinates():null);
            List<JAXBElement<? extends CoordinateType>> rightGenCoordinates;
            rightGenCoordinates = (((that.genCoordinates!= null)&&(!that.genCoordinates.isEmpty()))?that.getGenCoordinates():null);
            if ((this.genCoordinates!= null)&&(!this.genCoordinates.isEmpty())) {
                if ((that.genCoordinates!= null)&&(!that.genCoordinates.isEmpty())) {
                    final ListIterator<JAXBElement<? extends CoordinateType>> leftGenCoordinatesListIterator = leftGenCoordinates.listIterator();
                    final ListIterator<JAXBElement<? extends CoordinateType>> rightGenCoordinatesListIterator = rightGenCoordinates.listIterator();
                    while (rightGenCoordinatesListIterator.hasNext()&&leftGenCoordinatesListIterator.hasNext()) {
                        final JAXBElement<? extends CoordinateType> rightGenCoordinatesListIteratorElement = rightGenCoordinatesListIterator.next();
                        final JAXBElement<? extends CoordinateType> leftGenCoordinatesListIteratorElement = leftGenCoordinatesListIterator.next();
                        if (rightGenCoordinatesListIteratorElement!= null) {
                            if (leftGenCoordinatesListIteratorElement!= null) {
                                {
                                    final QName rightGenCoordinatesListIteratorElementName = rightGenCoordinatesListIteratorElement.getName();
                                    final QName leftGenCoordinatesListIteratorElementName = leftGenCoordinatesListIteratorElement.getName();
                                    if (rightGenCoordinatesListIteratorElementName!= null) {
                                        if (leftGenCoordinatesListIteratorElementName!= null) {
                                            if (!rightGenCoordinatesListIteratorElementName.equals(leftGenCoordinatesListIteratorElementName)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftGenCoordinatesListIteratorElementName!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final CoordinateType rightGenCoordinatesListIteratorElementValue = rightGenCoordinatesListIteratorElement.getValue();
                                    final CoordinateType leftGenCoordinatesListIteratorElementValue = leftGenCoordinatesListIteratorElement.getValue();
                                    if (rightGenCoordinatesListIteratorElementValue!= null) {
                                        if (leftGenCoordinatesListIteratorElementValue!= null) {
                                            if (!rightGenCoordinatesListIteratorElementValue.equals(leftGenCoordinatesListIteratorElementValue)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftGenCoordinatesListIteratorElementValue!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final Class<? extends CoordinateType> rightGenCoordinatesListIteratorElementDeclaredType = rightGenCoordinatesListIteratorElement.getDeclaredType();
                                    final Class<? extends CoordinateType> leftGenCoordinatesListIteratorElementDeclaredType = leftGenCoordinatesListIteratorElement.getDeclaredType();
                                    if (rightGenCoordinatesListIteratorElementDeclaredType!= null) {
                                        if (leftGenCoordinatesListIteratorElementDeclaredType!= null) {
                                            if (!rightGenCoordinatesListIteratorElementDeclaredType.equals(leftGenCoordinatesListIteratorElementDeclaredType)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftGenCoordinatesListIteratorElementDeclaredType!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final Class<?> rightGenCoordinatesListIteratorElementScope = rightGenCoordinatesListIteratorElement.getScope();
                                    final Class<?> leftGenCoordinatesListIteratorElementScope = leftGenCoordinatesListIteratorElement.getScope();
                                    if (rightGenCoordinatesListIteratorElementScope!= null) {
                                        if (leftGenCoordinatesListIteratorElementScope!= null) {
                                            if (!rightGenCoordinatesListIteratorElementScope.equals(leftGenCoordinatesListIteratorElementScope)) {
                                                return false;
                                            }
                                        } else {
                                            return false;
                                        }
                                    } else {
                                        if (leftGenCoordinatesListIteratorElementScope!= null) {
                                            return false;
                                        }
                                    }
                                }
                                {
                                    final boolean rightGenCoordinatesListIteratorElementNil = rightGenCoordinatesListIteratorElement.isNil();
                                    final boolean leftGenCoordinatesListIteratorElementNil = leftGenCoordinatesListIteratorElement.isNil();
                                    if (rightGenCoordinatesListIteratorElementNil!= leftGenCoordinatesListIteratorElementNil) {
                                        return false;
                                    }
                                }
                            } else {
                                return false;
                            }
                        } else {
                            if (leftGenCoordinatesListIteratorElement!= null) {
                                return false;
                            }
                        }
                    }
                    if (rightGenCoordinatesListIterator.hasNext()||leftGenCoordinatesListIterator.hasNext()) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.genCoordinates!= null)&&(!that.genCoordinates.isEmpty())) {
                    return false;
                }
            }
        }
        {
            Object leftCoordSystemId;
            leftCoordSystemId = this.getCoordSystemId();
            Object rightCoordSystemId;
            rightCoordSystemId = that.getCoordSystemId();
            if (this.coordSystemId!= null) {
                if (that.coordSystemId!= null) {
                    if (!leftCoordSystemId.equals(rightCoordSystemId)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.coordSystemId!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<JAXBElement<? extends CoordinateType>> theGenCoordinates;
            theGenCoordinates = (((this.genCoordinates!= null)&&(!this.genCoordinates.isEmpty()))?this.getGenCoordinates():null);
            if ((this.genCoordinates!= null)&&(!this.genCoordinates.isEmpty())) {
                final ListIterator<JAXBElement<? extends CoordinateType>> theGenCoordinatesListIterator = theGenCoordinates.listIterator();
                while (theGenCoordinatesListIterator.hasNext()) {
                    currentHashCode = (currentHashCode* 31);
                    final JAXBElement<? extends CoordinateType> theGenCoordinatesListIteratorElement = theGenCoordinatesListIterator.next();
                    if (theGenCoordinatesListIteratorElement!= null) {
                        {
                            currentHashCode = (currentHashCode* 31);
                            final QName theGenCoordinatesListIteratorElementName = theGenCoordinatesListIteratorElement.getName();
                            if (theGenCoordinatesListIteratorElementName!= null) {
                                currentHashCode += theGenCoordinatesListIteratorElementName.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final CoordinateType theGenCoordinatesListIteratorElementValue = theGenCoordinatesListIteratorElement.getValue();
                            if (theGenCoordinatesListIteratorElementValue!= null) {
                                currentHashCode += theGenCoordinatesListIteratorElementValue.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final Class<? extends CoordinateType> theGenCoordinatesListIteratorElementDeclaredType = theGenCoordinatesListIteratorElement.getDeclaredType();
                            if (theGenCoordinatesListIteratorElementDeclaredType!= null) {
                                currentHashCode += theGenCoordinatesListIteratorElementDeclaredType.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final Class<?> theGenCoordinatesListIteratorElementScope = theGenCoordinatesListIteratorElement.getScope();
                            if (theGenCoordinatesListIteratorElementScope!= null) {
                                currentHashCode += theGenCoordinatesListIteratorElementScope.hashCode();
                            }
                        }
                        {
                            currentHashCode = (currentHashCode* 31);
                            final boolean theGenCoordinatesListIteratorElementNil = theGenCoordinatesListIteratorElement.isNil();
                            currentHashCode += (theGenCoordinatesListIteratorElementNil? 1231 : 1237);
                        }
                    }
                }
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Object theCoordSystemId;
            theCoordSystemId = this.getCoordSystemId();
            if (this.coordSystemId!= null) {
                currentHashCode += theCoordSystemId.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            List<JAXBElement<? extends CoordinateType>> theGenCoordinates;
            theGenCoordinates = (((this.genCoordinates!= null)&&(!this.genCoordinates.isEmpty()))?this.getGenCoordinates():null);
            strategy.appendField(locator, this, "genCoordinates", buffer, theGenCoordinates, ((this.genCoordinates!= null)&&(!this.genCoordinates.isEmpty())));
        }
        {
            Object theCoordSystemId;
            theCoordSystemId = this.getCoordSystemId();
            strategy.appendField(locator, this, "coordSystemId", buffer, theCoordSystemId, (this.coordSystemId!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof CoordsType) {
            final CoordsType target = this;
            final CoordsType leftObject = ((CoordsType) left);
            final CoordsType rightObject = ((CoordsType) right);
            {
                Boolean genCoordinatesShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, ((leftObject.genCoordinates!= null)&&(!leftObject.genCoordinates.isEmpty())), ((rightObject.genCoordinates!= null)&&(!rightObject.genCoordinates.isEmpty())));
                if (genCoordinatesShouldBeMergedAndSet == Boolean.TRUE) {
                    List<JAXBElement<? extends CoordinateType>> lhsGenCoordinates;
                    lhsGenCoordinates = (((leftObject.genCoordinates!= null)&&(!leftObject.genCoordinates.isEmpty()))?leftObject.getGenCoordinates():null);
                    List<JAXBElement<? extends CoordinateType>> rhsGenCoordinates;
                    rhsGenCoordinates = (((rightObject.genCoordinates!= null)&&(!rightObject.genCoordinates.isEmpty()))?rightObject.getGenCoordinates():null);
                    List<JAXBElement<? extends CoordinateType>> mergedGenCoordinates = ((List<JAXBElement<? extends CoordinateType>> ) strategy.merge(LocatorUtils.property(leftLocator, "genCoordinates", lhsGenCoordinates), LocatorUtils.property(rightLocator, "genCoordinates", rhsGenCoordinates), lhsGenCoordinates, rhsGenCoordinates, ((leftObject.genCoordinates!= null)&&(!leftObject.genCoordinates.isEmpty())), ((rightObject.genCoordinates!= null)&&(!rightObject.genCoordinates.isEmpty()))));
                    target.genCoordinates = null;
                    if (mergedGenCoordinates!= null) {
                        List<JAXBElement<? extends CoordinateType>> uniqueGenCoordinatesl = target.getGenCoordinates();
                        uniqueGenCoordinatesl.addAll(mergedGenCoordinates);
                    }
                } else {
                    if (genCoordinatesShouldBeMergedAndSet == Boolean.FALSE) {
                        target.genCoordinates = null;
                    }
                }
            }
            {
                Boolean coordSystemIdShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.coordSystemId!= null), (rightObject.coordSystemId!= null));
                if (coordSystemIdShouldBeMergedAndSet == Boolean.TRUE) {
                    Object lhsCoordSystemId;
                    lhsCoordSystemId = leftObject.getCoordSystemId();
                    Object rhsCoordSystemId;
                    rhsCoordSystemId = rightObject.getCoordSystemId();
                    Object mergedCoordSystemId = ((Object) strategy.merge(LocatorUtils.property(leftLocator, "coordSystemId", lhsCoordSystemId), LocatorUtils.property(rightLocator, "coordSystemId", rhsCoordSystemId), lhsCoordSystemId, rhsCoordSystemId, (leftObject.coordSystemId!= null), (rightObject.coordSystemId!= null)));
                    target.setCoordSystemId(mergedCoordSystemId);
                } else {
                    if (coordSystemIdShouldBeMergedAndSet == Boolean.FALSE) {
                        target.coordSystemId = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new CoordsType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordsType clone() {
        final CoordsType _newObject;
        _newObject = ((CoordsType) super.clone());
        _newObject.genCoordinates = ((this.genCoordinates == null)?null:new ArrayList<>(this.genCoordinates));
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordsType createCopy() {
        final CoordsType _newObject = ((CoordsType) super.createCopy());
        _newObject.genCoordinates = ((this.genCoordinates == null)?null:new ArrayList<>(this.genCoordinates));
        _newObject.coordSystemId = this.coordSystemId;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordsType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CoordsType _newObject = ((CoordsType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree genCoordinatesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("genCoordinates"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(genCoordinatesPropertyTree!= null):((genCoordinatesPropertyTree == null)||(!genCoordinatesPropertyTree.isLeaf())))) {
            _newObject.genCoordinates = ((this.genCoordinates == null)?null:new ArrayList<>(this.genCoordinates));
        }
        final PropertyTree coordSystemIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coordSystemId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coordSystemIdPropertyTree!= null):((coordSystemIdPropertyTree == null)||(!coordSystemIdPropertyTree.isLeaf())))) {
            _newObject.coordSystemId = this.coordSystemId;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordsType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordsType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordsType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new CoordsType.Modifier();
        }
        return ((CoordsType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final CoordsType.Builder<_B> _other) {
        super.copyTo(_other);
        if (this.genCoordinates == null) {
            _other.genCoordinates = null;
        } else {
            _other.genCoordinates = new ArrayList<>();
            for (JAXBElement<? extends CoordinateType> _item: this.genCoordinates) {
                _other.genCoordinates.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
            }
        }
        _other.coordSystemId = this.coordSystemId;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >CoordsType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new CoordsType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordsType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static CoordsType.Builder<Void> builder() {
        return new CoordsType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >CoordsType.Builder<_B> copyOf(final StcBaseType _other) {
        final CoordsType.Builder<_B> _newBuilder = new CoordsType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >CoordsType.Builder<_B> copyOf(final CoordsType _other) {
        final CoordsType.Builder<_B> _newBuilder = new CoordsType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final CoordsType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree genCoordinatesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("genCoordinates"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(genCoordinatesPropertyTree!= null):((genCoordinatesPropertyTree == null)||(!genCoordinatesPropertyTree.isLeaf())))) {
            if (this.genCoordinates == null) {
                _other.genCoordinates = null;
            } else {
                _other.genCoordinates = new ArrayList<>();
                for (JAXBElement<? extends CoordinateType> _item: this.genCoordinates) {
                    _other.genCoordinates.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                }
            }
        }
        final PropertyTree coordSystemIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coordSystemId"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coordSystemIdPropertyTree!= null):((coordSystemIdPropertyTree == null)||(!coordSystemIdPropertyTree.isLeaf())))) {
            _other.coordSystemId = this.coordSystemId;
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >CoordsType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new CoordsType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordsType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >CoordsType.Builder<_B> copyOf(final StcBaseType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CoordsType.Builder<_B> _newBuilder = new CoordsType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >CoordsType.Builder<_B> copyOf(final CoordsType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final CoordsType.Builder<_B> _newBuilder = new CoordsType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static CoordsType.Builder<Void> copyExcept(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static CoordsType.Builder<Void> copyExcept(final CoordsType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static CoordsType.Builder<Void> copyOnly(final StcBaseType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static CoordsType.Builder<Void> copyOnly(final CoordsType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public CoordsType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        if (_visitor_.visit(new IndirectCollectionProperty<>(CoordsType.PropInfo.GEN_COORDINATES, this))&&(this.genCoordinates!= null)) {
            for (JAXBElement<? extends CoordinateType> _item_: this.genCoordinates) {
                if (_item_!= null) {
                    _item_.getValue().visit(_visitor_);
                }
            }
        }
        _visitor_.visit(new SingleProperty<>(CoordsType.PropInfo.COORD_SYSTEM_ID, this));
        return this;
    }

    public static class Builder<_B >
        extends StcBaseType.Builder<_B>
        implements Buildable
    {

        private List<Buildable> genCoordinates;
        private Object coordSystemId;

        public Builder(final _B _parentBuilder, final CoordsType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                if (_other.genCoordinates == null) {
                    this.genCoordinates = null;
                } else {
                    this.genCoordinates = new ArrayList<>();
                    for (JAXBElement<? extends CoordinateType> _item: _other.genCoordinates) {
                        this.genCoordinates.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                    }
                }
                this.coordSystemId = _other.coordSystemId;
            }
        }

        public Builder(final _B _parentBuilder, final CoordsType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree genCoordinatesPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("genCoordinates"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(genCoordinatesPropertyTree!= null):((genCoordinatesPropertyTree == null)||(!genCoordinatesPropertyTree.isLeaf())))) {
                    if (_other.genCoordinates == null) {
                        this.genCoordinates = null;
                    } else {
                        this.genCoordinates = new ArrayList<>();
                        for (JAXBElement<? extends CoordinateType> _item: _other.genCoordinates) {
                            this.genCoordinates.add(((_item == null)?null:new Buildable.PrimitiveBuildable(_item)));
                        }
                    }
                }
                final PropertyTree coordSystemIdPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("coordSystemId"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(coordSystemIdPropertyTree!= null):((coordSystemIdPropertyTree == null)||(!coordSystemIdPropertyTree.isLeaf())))) {
                    this.coordSystemId = _other.coordSystemId;
                }
            }
        }

        protected<_P extends CoordsType >_P init(final _P _product) {
            if (this.genCoordinates!= null) {
                final List<JAXBElement<? extends CoordinateType>> genCoordinates = new ArrayList<>(this.genCoordinates.size());
                for (Buildable _item: this.genCoordinates) {
                    genCoordinates.add(((JAXBElement<? extends CoordinateType> ) _item.build()));
                }
                _product.genCoordinates = genCoordinates;
            }
            _product.coordSystemId = this.coordSystemId;
            return super.init(_product);
        }

        /**
         * Adds the given items to the value of "genCoordinates"
         * 
         * @param genCoordinates
         *     Items to add to the value of the "genCoordinates" property
         */
        public CoordsType.Builder<_B> addGenCoordinates(final Iterable<? extends JAXBElement<? extends CoordinateType>> genCoordinates) {
            if (genCoordinates!= null) {
                if (this.genCoordinates == null) {
                    this.genCoordinates = new ArrayList<>();
                }
                for (JAXBElement<? extends CoordinateType> _item: genCoordinates) {
                    this.genCoordinates.add(new Buildable.PrimitiveBuildable(_item));
                }
            }
            return this;
        }

        /**
         * Sets the new value of "genCoordinates" (any previous value will be replaced)
         * 
         * @param genCoordinates
         *     New value of the "genCoordinates" property.
         */
        public CoordsType.Builder<_B> withGenCoordinates(final Iterable<? extends JAXBElement<? extends CoordinateType>> genCoordinates) {
            if (this.genCoordinates!= null) {
                this.genCoordinates.clear();
            }
            return addGenCoordinates(genCoordinates);
        }

        /**
         * Adds the given items to the value of "genCoordinates"
         * 
         * @param genCoordinates
         *     Items to add to the value of the "genCoordinates" property
         */
        public CoordsType.Builder<_B> addGenCoordinates(JAXBElement<? extends CoordinateType> ... genCoordinates) {
            addGenCoordinates(Arrays.asList(genCoordinates));
            return this;
        }

        /**
         * Sets the new value of "genCoordinates" (any previous value will be replaced)
         * 
         * @param genCoordinates
         *     New value of the "genCoordinates" property.
         */
        public CoordsType.Builder<_B> withGenCoordinates(JAXBElement<? extends CoordinateType> ... genCoordinates) {
            withGenCoordinates(Arrays.asList(genCoordinates));
            return this;
        }

        /**
         * Sets the new value of "coordSystemId" (any previous value will be replaced)
         * 
         * @param coordSystemId
         *     New value of the "coordSystemId" property.
         */
        public CoordsType.Builder<_B> withCoordSystemId(final Object coordSystemId) {
            this.coordSystemId = coordSystemId;
            return this;
        }

        /**
         * Sets the new value of "id" (any previous value will be replaced)
         * 
         * @param id
         *     New value of the "id" property.
         */
        @Override
        public CoordsType.Builder<_B> withId(final String id) {
            super.withId(id);
            return this;
        }

        /**
         * Sets the new value of "idref" (any previous value will be replaced)
         * 
         * @param idref
         *     New value of the "idref" property.
         */
        @Override
        public CoordsType.Builder<_B> withIdref(final Object idref) {
            super.withIdref(idref);
            return this;
        }

        /**
         * Sets the new value of "ucd" (any previous value will be replaced)
         * 
         * @param ucd
         *     New value of the "ucd" property.
         */
        @Override
        public CoordsType.Builder<_B> withUcd(final String ucd) {
            super.withUcd(ucd);
            return this;
        }

        /**
         * Sets the new value of "type" (any previous value will be replaced)
         * 
         * @param type
         *     New value of the "type" property.
         */
        @Override
        public CoordsType.Builder<_B> withType(final String type) {
            super.withType(type);
            return this;
        }

        /**
         * Sets the new value of "href" (any previous value will be replaced)
         * 
         * @param href
         *     New value of the "href" property.
         */
        @Override
        public CoordsType.Builder<_B> withHref(final String href) {
            super.withHref(href);
            return this;
        }

        /**
         * Sets the new value of "idType" (any previous value will be replaced)
         * 
         * @param idType
         *     New value of the "idType" property.
         */
        @Override
        public CoordsType.Builder<_B> withIDType(final String idType) {
            super.withIDType(idType);
            return this;
        }

        /**
         * Sets the new value of "idrefType" (any previous value will be replaced)
         * 
         * @param idrefType
         *     New value of the "idrefType" property.
         */
        @Override
        public CoordsType.Builder<_B> withIDREFType(final String idrefType) {
            super.withIDREFType(idrefType);
            return this;
        }

        @Override
        public CoordsType build() {
            if (_storedValue == null) {
                return this.init(new CoordsType());
            } else {
                return ((CoordsType) _storedValue);
            }
        }

        public CoordsType.Builder<_B> copyOf(final CoordsType _other) {
            _other.copyTo(this);
            return this;
        }

        public CoordsType.Builder<_B> copyOf(final CoordsType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends StcBaseType.Modifier
    {


        public List<JAXBElement<? extends CoordinateType>> getGenCoordinates() {
            if (CoordsType.this.genCoordinates == null) {
                CoordsType.this.genCoordinates = new ArrayList<>();
            }
            return CoordsType.this.genCoordinates;
        }

        public void setCoordSystemId(final Object coordSystemId) {
            CoordsType.this.setCoordSystemId(coordSystemId);
        }

    }

    public static class PropInfo {

        public static final transient IndirectCollectionPropertyInfo<CoordsType, CoordinateType> GEN_COORDINATES = new IndirectCollectionPropertyInfo<CoordsType,CoordinateType>("genCoordinates", CoordsType.class, CoordinateType.class, true, null, new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "GenCoordinate"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "coordinateType"), false) {


            @Override
            public List<JAXBElement<? extends CoordinateType>> get(final CoordsType _instance_) {
                return ((_instance_ == null)?null:_instance_.genCoordinates);
            }

            @Override
            public void set(final CoordsType _instance_, final List<JAXBElement<? extends CoordinateType>> _value_) {
                if (_instance_!= null) {
                    _instance_.genCoordinates = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<CoordsType, Object> COORD_SYSTEM_ID = new SinglePropertyInfo<CoordsType,Object>("coordSystemId", CoordsType.class, Object.class, false, null, new QName("", "coord_system_id"), new QName("http://www.w3.org/2001/XMLSchema", "IDREF"), true) {


            @Override
            public Object get(final CoordsType _instance_) {
                return ((_instance_ == null)?null:_instance_.coordSystemId);
            }

            @Override
            public void set(final CoordsType _instance_, final Object _value_) {
                if (_instance_!= null) {
                    _instance_.coordSystemId = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends CoordsType.Selector<CoordsType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static CoordsType.Select _root() {
            return new CoordsType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends StcBaseType.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, CoordsType.Selector<TRoot, TParent>> genCoordinates = null;
        private com.kscs.util.jaxb.Selector<TRoot, CoordsType.Selector<TRoot, TParent>> coordSystemId = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.genCoordinates!= null) {
                products.put("genCoordinates", this.genCoordinates.init());
            }
            if (this.coordSystemId!= null) {
                products.put("coordSystemId", this.coordSystemId.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, CoordsType.Selector<TRoot, TParent>> genCoordinates() {
            return ((this.genCoordinates == null)?this.genCoordinates = new com.kscs.util.jaxb.Selector<>(this._root, this, "genCoordinates"):this.genCoordinates);
        }

        public com.kscs.util.jaxb.Selector<TRoot, CoordsType.Selector<TRoot, TParent>> coordSystemId() {
            return ((this.coordSystemId == null)?this.coordSystemId = new com.kscs.util.jaxb.Selector<>(this._root, this, "coordSystemId"):this.coordSystemId);
        }

    }

}
