
package org.javastro.ivoa.entities.stc.v1;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import com.kscs.util.jaxb.Buildable;
import com.kscs.util.jaxb.Copyable;
import com.kscs.util.jaxb.PartialCopyable;
import com.kscs.util.jaxb.PropertyTree;
import com.kscs.util.jaxb.PropertyTreeUse;
import com.kscs.util.jaxb.PropertyVisitor;
import com.kscs.util.jaxb.SingleProperty;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import com.kscs.util.jaxb.SinglePropertyInfo;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import org.jvnet.jaxb.lang.JAXBMergeStrategy;
import org.jvnet.jaxb.lang.JAXBToStringStrategy;
import org.jvnet.jaxb.lang.MergeFrom;
import org.jvnet.jaxb.lang.MergeStrategy;
import org.jvnet.jaxb.lang.ToString;
import org.jvnet.jaxb.lang.ToStringStrategy;
import org.jvnet.jaxb.locator.ObjectLocator;
import org.jvnet.jaxb.locator.util.LocatorUtils;


/**
 * The Geodetic reference frame; semi-major axis and inverse flattening may be provided to define the reference spheroid; the default is the IAU 1976 reference spheroid
 * 
 * <p>Java class for geodType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="geodType">
 *   <complexContent>
 *     <extension base="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}icrsType">
 *       <attribute name="radius" type="{http://www.w3.org/2001/XMLSchema}double" default="6378140" />
 *       <attribute name="inv_flattening" type="{http://www.w3.org/2001/XMLSchema}double" default="298.257" />
 *       <attribute name="unit" type="{http://www.ivoa.net/xml/STC/stc-v1.30.xsd}posUnitType" default="m" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "geodType")
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
public class GeodType
    extends IcrsType
    implements Cloneable, Copyable, PartialCopyable, MergeFrom, ToString
{

    @XmlAttribute(name = "radius")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected Double radius;
    @XmlAttribute(name = "inv_flattening")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected Double invFlattening;
    @XmlAttribute(name = "unit")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    protected String unit;

    /**
     * Default no-arg constructor
     * 
     */
    public GeodType() {
        super();
    }

    /**
     * Fully-initialising value constructor
     * 
     */
    public GeodType(final String name, final Object refFrameId, final Double radius, final Double invFlattening, final String unit) {
        super(name, refFrameId);
        this.radius = radius;
        this.invFlattening = invFlattening;
        this.unit = unit;
    }

    /**
     * Gets the value of the radius property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public double getRadius() {
        if (radius == null) {
            return  6378140.0D;
        } else {
            return radius;
        }
    }

    /**
     * Sets the value of the radius property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setRadius(Double value) {
        this.radius = value;
    }

    /**
     * Gets the value of the invFlattening property.
     * 
     * @return
     *     possible object is
     *     {@link Double }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public double getInvFlattening() {
        if (invFlattening == null) {
            return  298.257D;
        } else {
            return invFlattening;
        }
    }

    /**
     * Sets the value of the invFlattening property.
     * 
     * @param value
     *     allowed object is
     *     {@link Double }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setInvFlattening(Double value) {
        this.invFlattening = value;
    }

    /**
     * Gets the value of the unit property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String getUnit() {
        if (unit == null) {
            return "m";
        } else {
            return unit;
        }
    }

    /**
     * Sets the value of the unit property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void setUnit(String value) {
        this.unit = value;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final GeodType that = ((GeodType) object);
        {
            double leftRadius;
            leftRadius = ((this.radius!= null)?this.getRadius(): 6378140.0D);
            double rightRadius;
            rightRadius = ((that.radius!= null)?that.getRadius(): 6378140.0D);
            if (this.radius!= null) {
                if (that.radius!= null) {
                    if (Double.doubleToLongBits(leftRadius)!= Double.doubleToLongBits(rightRadius)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.radius!= null) {
                    return false;
                }
            }
        }
        {
            double leftInvFlattening;
            leftInvFlattening = ((this.invFlattening!= null)?this.getInvFlattening(): 298.257D);
            double rightInvFlattening;
            rightInvFlattening = ((that.invFlattening!= null)?that.getInvFlattening(): 298.257D);
            if (this.invFlattening!= null) {
                if (that.invFlattening!= null) {
                    if (Double.doubleToLongBits(leftInvFlattening)!= Double.doubleToLongBits(rightInvFlattening)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.invFlattening!= null) {
                    return false;
                }
            }
        }
        {
            String leftUnit;
            leftUnit = this.getUnit();
            String rightUnit;
            rightUnit = that.getUnit();
            if (this.unit!= null) {
                if (that.unit!= null) {
                    if (!leftUnit.equals(rightUnit)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.unit!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            double theRadius;
            theRadius = ((this.radius!= null)?this.getRadius(): 6378140.0D);
            final long theRadiusBits = Double.doubleToLongBits(theRadius);
            if (this.radius!= null) {
                currentHashCode += ((int)(theRadiusBits^(theRadiusBits >>> 32)));
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            double theInvFlattening;
            theInvFlattening = ((this.invFlattening!= null)?this.getInvFlattening(): 298.257D);
            final long theInvFlatteningBits = Double.doubleToLongBits(theInvFlattening);
            if (this.invFlattening!= null) {
                currentHashCode += ((int)(theInvFlatteningBits^(theInvFlatteningBits >>> 32)));
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theUnit;
            theUnit = this.getUnit();
            if (this.unit!= null) {
                currentHashCode += theUnit.hashCode();
            }
        }
        return currentHashCode;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public String toString() {
        final ToStringStrategy strategy = JAXBToStringStrategy.getInstance();
        final StringBuilder buffer = new StringBuilder();
        append(null, buffer, strategy);
        return buffer.toString();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder append(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        strategy.appendStart(locator, this, buffer);
        appendFields(locator, buffer, strategy);
        strategy.appendEnd(locator, this, buffer);
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public StringBuilder appendFields(ObjectLocator locator, StringBuilder buffer, ToStringStrategy strategy) {
        super.appendFields(locator, buffer, strategy);
        {
            double theRadius;
            theRadius = ((this.radius!= null)?this.getRadius(): 6378140.0D);
            strategy.appendField(locator, this, "radius", buffer, theRadius, (this.radius!= null));
        }
        {
            double theInvFlattening;
            theInvFlattening = ((this.invFlattening!= null)?this.getInvFlattening(): 298.257D);
            strategy.appendField(locator, this, "invFlattening", buffer, theInvFlattening, (this.invFlattening!= null));
        }
        {
            String theUnit;
            theUnit = this.getUnit();
            strategy.appendField(locator, this, "unit", buffer, theUnit, (this.unit!= null));
        }
        return buffer;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(Object left, Object right) {
        final MergeStrategy strategy = JAXBMergeStrategy.getInstance();
        mergeFrom(null, null, left, right, strategy);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public void mergeFrom(ObjectLocator leftLocator, ObjectLocator rightLocator, Object left, Object right, MergeStrategy strategy) {
        super.mergeFrom(leftLocator, rightLocator, left, right, strategy);
        if (right instanceof GeodType) {
            final GeodType target = this;
            final GeodType leftObject = ((GeodType) left);
            final GeodType rightObject = ((GeodType) right);
            {
                Boolean radiusShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.radius!= null), (rightObject.radius!= null));
                if (radiusShouldBeMergedAndSet == Boolean.TRUE) {
                    double lhsRadius;
                    lhsRadius = ((leftObject.radius!= null)?leftObject.getRadius(): 6378140.0D);
                    double rhsRadius;
                    rhsRadius = ((rightObject.radius!= null)?rightObject.getRadius(): 6378140.0D);
                    double mergedRadius = ((double) strategy.merge(LocatorUtils.property(leftLocator, "radius", lhsRadius), LocatorUtils.property(rightLocator, "radius", rhsRadius), lhsRadius, rhsRadius, (leftObject.radius!= null), (rightObject.radius!= null)));
                    target.setRadius(mergedRadius);
                } else {
                    if (radiusShouldBeMergedAndSet == Boolean.FALSE) {
                        target.radius = null;
                    }
                }
            }
            {
                Boolean invFlatteningShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.invFlattening!= null), (rightObject.invFlattening!= null));
                if (invFlatteningShouldBeMergedAndSet == Boolean.TRUE) {
                    double lhsInvFlattening;
                    lhsInvFlattening = ((leftObject.invFlattening!= null)?leftObject.getInvFlattening(): 298.257D);
                    double rhsInvFlattening;
                    rhsInvFlattening = ((rightObject.invFlattening!= null)?rightObject.getInvFlattening(): 298.257D);
                    double mergedInvFlattening = ((double) strategy.merge(LocatorUtils.property(leftLocator, "invFlattening", lhsInvFlattening), LocatorUtils.property(rightLocator, "invFlattening", rhsInvFlattening), lhsInvFlattening, rhsInvFlattening, (leftObject.invFlattening!= null), (rightObject.invFlattening!= null)));
                    target.setInvFlattening(mergedInvFlattening);
                } else {
                    if (invFlatteningShouldBeMergedAndSet == Boolean.FALSE) {
                        target.invFlattening = null;
                    }
                }
            }
            {
                Boolean unitShouldBeMergedAndSet = strategy.shouldBeMergedAndSet(leftLocator, rightLocator, (leftObject.unit!= null), (rightObject.unit!= null));
                if (unitShouldBeMergedAndSet == Boolean.TRUE) {
                    String lhsUnit;
                    lhsUnit = leftObject.getUnit();
                    String rhsUnit;
                    rhsUnit = rightObject.getUnit();
                    String mergedUnit = ((String) strategy.merge(LocatorUtils.property(leftLocator, "unit", lhsUnit), LocatorUtils.property(rightLocator, "unit", rhsUnit), lhsUnit, rhsUnit, (leftObject.unit!= null), (rightObject.unit!= null)));
                    target.setUnit(mergedUnit);
                } else {
                    if (unitShouldBeMergedAndSet == Boolean.FALSE) {
                        target.unit = null;
                    }
                }
            }
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public Object createNewInstance() {
        return new GeodType();
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public GeodType clone() {
        final GeodType _newObject;
        _newObject = ((GeodType) super.clone());
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public GeodType createCopy() {
        final GeodType _newObject = ((GeodType) super.createCopy());
        _newObject.radius = this.radius;
        _newObject.invFlattening = this.invFlattening;
        _newObject.unit = this.unit;
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public GeodType createCopy(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final GeodType _newObject = ((GeodType) super.createCopy(_propertyTree, _propertyTreeUse));
        final PropertyTree radiusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("radius"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(radiusPropertyTree!= null):((radiusPropertyTree == null)||(!radiusPropertyTree.isLeaf())))) {
            _newObject.radius = this.radius;
        }
        final PropertyTree invFlatteningPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("invFlattening"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(invFlatteningPropertyTree!= null):((invFlatteningPropertyTree == null)||(!invFlatteningPropertyTree.isLeaf())))) {
            _newObject.invFlattening = this.invFlattening;
        }
        final PropertyTree unitPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("unit"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(unitPropertyTree!= null):((unitPropertyTree == null)||(!unitPropertyTree.isLeaf())))) {
            _newObject.unit = this.unit;
        }
        return _newObject;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public GeodType copyExcept(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public GeodType copyOnly(final PropertyTree _propertyTree) {
        return createCopy(_propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public GeodType.Modifier modifier() {
        if (null == this.__cachedModifier__) {
            this.__cachedModifier__ = new GeodType.Modifier();
        }
        return ((GeodType.Modifier) this.__cachedModifier__);
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final GeodType.Builder<_B> _other) {
        super.copyTo(_other);
        _other.radius = this.radius;
        _other.invFlattening = this.invFlattening;
        _other.unit = this.unit;
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >GeodType.Builder<_B> newCopyBuilder(final _B _parentBuilder) {
        return new GeodType.Builder<_B>(_parentBuilder, this, true);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public GeodType.Builder<Void> newCopyBuilder() {
        return newCopyBuilder(null);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static GeodType.Builder<Void> builder() {
        return new GeodType.Builder<>(null, null, false);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >GeodType.Builder<_B> copyOf(final CoordRefFrameType _other) {
        final GeodType.Builder<_B> _newBuilder = new GeodType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >GeodType.Builder<_B> copyOf(final SpaceRefFrameType _other) {
        final GeodType.Builder<_B> _newBuilder = new GeodType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >GeodType.Builder<_B> copyOf(final IcrsType _other) {
        final GeodType.Builder<_B> _newBuilder = new GeodType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >GeodType.Builder<_B> copyOf(final GeodType _other) {
        final GeodType.Builder<_B> _newBuilder = new GeodType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder);
        return _newBuilder;
    }

    /**
     * Copies all state of this object to a builder. This method is used by the copyOf
     * method and should not be called directly by client code.
     * 
     * @param _other
     *     A builder instance to which the state of this object will be copied.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >void copyTo(final GeodType.Builder<_B> _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        super.copyTo(_other, _propertyTree, _propertyTreeUse);
        final PropertyTree radiusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("radius"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(radiusPropertyTree!= null):((radiusPropertyTree == null)||(!radiusPropertyTree.isLeaf())))) {
            _other.radius = this.radius;
        }
        final PropertyTree invFlatteningPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("invFlattening"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(invFlatteningPropertyTree!= null):((invFlatteningPropertyTree == null)||(!invFlatteningPropertyTree.isLeaf())))) {
            _other.invFlattening = this.invFlattening;
        }
        final PropertyTree unitPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("unit"));
        if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(unitPropertyTree!= null):((unitPropertyTree == null)||(!unitPropertyTree.isLeaf())))) {
            _other.unit = this.unit;
        }
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public<_B >GeodType.Builder<_B> newCopyBuilder(final _B _parentBuilder, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return new GeodType.Builder<_B>(_parentBuilder, this, true, _propertyTree, _propertyTreeUse);
    }

    @Override
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public GeodType.Builder<Void> newCopyBuilder(final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        return newCopyBuilder(null, _propertyTree, _propertyTreeUse);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >GeodType.Builder<_B> copyOf(final CoordRefFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final GeodType.Builder<_B> _newBuilder = new GeodType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >GeodType.Builder<_B> copyOf(final SpaceRefFrameType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final GeodType.Builder<_B> _newBuilder = new GeodType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >GeodType.Builder<_B> copyOf(final IcrsType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final GeodType.Builder<_B> _newBuilder = new GeodType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static<_B >GeodType.Builder<_B> copyOf(final GeodType _other, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
        final GeodType.Builder<_B> _newBuilder = new GeodType.Builder<>(null, null, false);
        _other.copyTo(_newBuilder, _propertyTree, _propertyTreeUse);
        return _newBuilder;
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static GeodType.Builder<Void> copyExcept(final CoordRefFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static GeodType.Builder<Void> copyExcept(final SpaceRefFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static GeodType.Builder<Void> copyExcept(final IcrsType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static GeodType.Builder<Void> copyExcept(final GeodType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.EXCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static GeodType.Builder<Void> copyOnly(final CoordRefFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static GeodType.Builder<Void> copyOnly(final SpaceRefFrameType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static GeodType.Builder<Void> copyOnly(final IcrsType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public static GeodType.Builder<Void> copyOnly(final GeodType _other, final PropertyTree _propertyTree) {
        return copyOf(_other, _propertyTree, PropertyTreeUse.INCLUDE);
    }

    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.4", date = "2025-06-24T19:08:06+01:00")
    public GeodType visit(final PropertyVisitor _visitor_) {
        super.visit(_visitor_);
        _visitor_.visit(new SingleProperty<>(GeodType.PropInfo.RADIUS, this));
        _visitor_.visit(new SingleProperty<>(GeodType.PropInfo.INV_FLATTENING, this));
        _visitor_.visit(new SingleProperty<>(GeodType.PropInfo.UNIT, this));
        return this;
    }

    public static class Builder<_B >
        extends IcrsType.Builder<_B>
        implements Buildable
    {

        private Double radius = 6378140.0D;
        private Double invFlattening = 298.257D;
        private String unit = "m";

        public Builder(final _B _parentBuilder, final GeodType _other, final boolean _copy) {
            super(_parentBuilder, _other, _copy);
            if (_other!= null) {
                this.radius = _other.radius;
                this.invFlattening = _other.invFlattening;
                this.unit = _other.unit;
            }
        }

        public Builder(final _B _parentBuilder, final GeodType _other, final boolean _copy, final PropertyTree _propertyTree, final PropertyTreeUse _propertyTreeUse) {
            super(_parentBuilder, _other, _copy, _propertyTree, _propertyTreeUse);
            if (_other!= null) {
                final PropertyTree radiusPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("radius"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(radiusPropertyTree!= null):((radiusPropertyTree == null)||(!radiusPropertyTree.isLeaf())))) {
                    this.radius = _other.radius;
                }
                final PropertyTree invFlatteningPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("invFlattening"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(invFlatteningPropertyTree!= null):((invFlatteningPropertyTree == null)||(!invFlatteningPropertyTree.isLeaf())))) {
                    this.invFlattening = _other.invFlattening;
                }
                final PropertyTree unitPropertyTree = ((_propertyTree == null)?null:_propertyTree.get("unit"));
                if (((_propertyTreeUse == PropertyTreeUse.INCLUDE)?(unitPropertyTree!= null):((unitPropertyTree == null)||(!unitPropertyTree.isLeaf())))) {
                    this.unit = _other.unit;
                }
            }
        }

        protected<_P extends GeodType >_P init(final _P _product) {
            _product.radius = this.radius;
            _product.invFlattening = this.invFlattening;
            _product.unit = this.unit;
            return super.init(_product);
        }

        /**
         * Sets the new value of "radius" (any previous value will be replaced)
         * 
         * @param radius
         *     New value of the "radius" property.
         */
        public GeodType.Builder<_B> withRadius(final Double radius) {
            this.radius = radius;
            return this;
        }

        /**
         * Sets the new value of "invFlattening" (any previous value will be replaced)
         * 
         * @param invFlattening
         *     New value of the "invFlattening" property.
         */
        public GeodType.Builder<_B> withInvFlattening(final Double invFlattening) {
            this.invFlattening = invFlattening;
            return this;
        }

        /**
         * Sets the new value of "unit" (any previous value will be replaced)
         * 
         * @param unit
         *     New value of the "unit" property.
         */
        public GeodType.Builder<_B> withUnit(final String unit) {
            this.unit = unit;
            return this;
        }

        /**
         * Sets the new value of "name" (any previous value will be replaced)
         * 
         * @param name
         *     New value of the "name" property.
         */
        @Override
        public GeodType.Builder<_B> withName(final String name) {
            super.withName(name);
            return this;
        }

        /**
         * Sets the new value of "refFrameId" (any previous value will be replaced)
         * 
         * @param refFrameId
         *     New value of the "refFrameId" property.
         */
        @Override
        public GeodType.Builder<_B> withRefFrameId(final Object refFrameId) {
            super.withRefFrameId(refFrameId);
            return this;
        }

        @Override
        public GeodType build() {
            if (_storedValue == null) {
                return this.init(new GeodType());
            } else {
                return ((GeodType) _storedValue);
            }
        }

        public GeodType.Builder<_B> copyOf(final GeodType _other) {
            _other.copyTo(this);
            return this;
        }

        public GeodType.Builder<_B> copyOf(final GeodType.Builder _other) {
            return copyOf(_other.build());
        }

    }

    public class Modifier
        extends IcrsType.Modifier
    {


        public void setRadius(final Double radius) {
            GeodType.this.setRadius(radius);
        }

        public void setInvFlattening(final Double invFlattening) {
            GeodType.this.setInvFlattening(invFlattening);
        }

        public void setUnit(final String unit) {
            GeodType.this.setUnit(unit);
        }

    }

    public static class PropInfo {

        public static final transient SinglePropertyInfo<GeodType, Double> RADIUS = new SinglePropertyInfo<GeodType,Double>("radius", GeodType.class, Double.class, false, 6378140.0D, new QName("", "radius"), new QName("http://www.w3.org/2001/XMLSchema", "double"), true) {


            @Override
            public Double get(final GeodType _instance_) {
                return ((_instance_ == null)?null:_instance_.radius);
            }

            @Override
            public void set(final GeodType _instance_, final Double _value_) {
                if (_instance_!= null) {
                    _instance_.radius = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<GeodType, Double> INV_FLATTENING = new SinglePropertyInfo<GeodType,Double>("invFlattening", GeodType.class, Double.class, false, 298.257D, new QName("", "inv_flattening"), new QName("http://www.w3.org/2001/XMLSchema", "double"), true) {


            @Override
            public Double get(final GeodType _instance_) {
                return ((_instance_ == null)?null:_instance_.invFlattening);
            }

            @Override
            public void set(final GeodType _instance_, final Double _value_) {
                if (_instance_!= null) {
                    _instance_.invFlattening = _value_;
                }
            }

        }
        ;
        public static final transient SinglePropertyInfo<GeodType, String> UNIT = new SinglePropertyInfo<GeodType,String>("unit", GeodType.class, String.class, false, "m", new QName("", "unit"), new QName("http://www.ivoa.net/xml/STC/stc-v1.30.xsd", "posUnitType"), true) {


            @Override
            public String get(final GeodType _instance_) {
                return ((_instance_ == null)?null:_instance_.unit);
            }

            @Override
            public void set(final GeodType _instance_, final String _value_) {
                if (_instance_!= null) {
                    _instance_.unit = _value_;
                }
            }

        }
        ;

    }

    public static class Select
        extends GeodType.Selector<GeodType.Select, Void>
    {


        Select() {
            super(null, null, null);
        }

        public static GeodType.Select _root() {
            return new GeodType.Select();
        }

    }

    public static class Selector<TRoot extends com.kscs.util.jaxb.Selector<TRoot, ?> , TParent >
        extends IcrsType.Selector<TRoot, TParent>
    {

        private com.kscs.util.jaxb.Selector<TRoot, GeodType.Selector<TRoot, TParent>> radius = null;
        private com.kscs.util.jaxb.Selector<TRoot, GeodType.Selector<TRoot, TParent>> invFlattening = null;
        private com.kscs.util.jaxb.Selector<TRoot, GeodType.Selector<TRoot, TParent>> unit = null;

        public Selector(final TRoot root, final TParent parent, final String propertyName) {
            super(root, parent, propertyName);
        }

        @Override
        public Map<String, PropertyTree> buildChildren() {
            final Map<String, PropertyTree> products = new HashMap<>();
            products.putAll(super.buildChildren());
            if (this.radius!= null) {
                products.put("radius", this.radius.init());
            }
            if (this.invFlattening!= null) {
                products.put("invFlattening", this.invFlattening.init());
            }
            if (this.unit!= null) {
                products.put("unit", this.unit.init());
            }
            return products;
        }

        public com.kscs.util.jaxb.Selector<TRoot, GeodType.Selector<TRoot, TParent>> radius() {
            return ((this.radius == null)?this.radius = new com.kscs.util.jaxb.Selector<>(this._root, this, "radius"):this.radius);
        }

        public com.kscs.util.jaxb.Selector<TRoot, GeodType.Selector<TRoot, TParent>> invFlattening() {
            return ((this.invFlattening == null)?this.invFlattening = new com.kscs.util.jaxb.Selector<>(this._root, this, "invFlattening"):this.invFlattening);
        }

        public com.kscs.util.jaxb.Selector<TRoot, GeodType.Selector<TRoot, TParent>> unit() {
            return ((this.unit == null)?this.unit = new com.kscs.util.jaxb.Selector<>(this._root, this, "unit"):this.unit);
        }

    }

}
